#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <misc.h>
#include <dialog.h>
#include "internal.h"
#include "userconf.h"
#include "../paths.h"
#include "userconf.m"
#include <subsys.h>
#include <translat.h>

extern USERCONF_HELP_FILE help_password;

const char subsys_policies[]="policies";
static LINUXCONF_SUBSYS subb (subsys_policies
	,P_MSG_R(M_POLICIES));


static const char PASSWD[] = "passwd";
static const char MINLEN[] = "minlen";
static const char MINNONALPHA[] = "minnonalpha";
static const char DEFHOME[] = "defhome";
static const char CREATECMD[] = "createcmd";
static const char DELETECMD[] = "deletecmd";
static const char ARCHIVECMD[] = "archivecmd";
static const char POSTDELETECMD[] = "postdeletecmd";
static const char PRIVGROUP[] = "privgroup";
static const char CREATEPERM[]="createperm";
static const char SHOWSHADOW[]="showshadow";
static const char MAYEDITHOME[]="mayedithome";
static const char MAYEDITSHELL[]="mayeditshell";
static const char MAYEDITTASKS[]="mayedittasks";
static const char MAYEDITQUOTA[]="mayeditquota";

static const char def_archive[]= USR_LIB_LINUXCONF "/lib/accountarchive.sh";
static const char def_delete[]=USR_LIB_LINUXCONF "/lib/accountdelete.sh";


static int passwd_valid_getval(const char *key, int defval)
{
	const char *pt = linuxconf_getval(PASSWD,key);
	if (pt != NULL) defval = atoi(pt);
	return defval;
}

PUBLIC void PASSWD_VALID::write()
{
	linuxconf_setcursys (subsys_policies);
	linuxconf_replace (PASSWD,MINLEN,minlen);
	linuxconf_replace (PASSWD,MINNONALPHA,minnonalpha);
	linuxconf_replace (PASSWD,DEFHOME,defhome);
	linuxconf_replace (PASSWD,CREATECMD,createcmd);
	linuxconf_replace (PASSWD,DELETECMD,deletecmd);
	linuxconf_replace (PASSWD,POSTDELETECMD,postdeletecmd);
	linuxconf_replace (PASSWD,ARCHIVECMD,archivecmd);
	linuxconf_replace (PASSWD,PRIVGROUP,privgroup);
	linuxconf_replace (PASSWD,CREATEPERM,createperm);
	linuxconf_replace (PASSWD,SHOWSHADOW,showshadow);
	linuxconf_replace (PASSWD,MAYEDITHOME,mayedithome);
	linuxconf_replace (PASSWD,MAYEDITSHELL,mayeditshell);
	linuxconf_replace (PASSWD,MAYEDITTASKS,mayedittasks);
	linuxconf_replace (PASSWD,MAYEDITQUOTA,mayeditquota);
	linuxconf_save();
}

/*
	Return the default base path for the HOME directories
	By default, it is /home.
*/
const char *policies_getdefhome()
{
	return linuxconf_getval (PASSWD,DEFHOME,"/home");
}
/*
	Return the default create mode the HOME directories
*/
int policies_getcreateperm()
{
	return linuxconf_getvalnum (PASSWD,CREATEPERM,0700);
}

/*
	Return the command to run after a user account has been created
	Return NULL is none.
*/
const char *policies_getcreatecmd()
{
	return linuxconf_getval (PASSWD,CREATECMD);
}

/*
	Do we create a private group for each user (redhat default)
*/
bool policies_privgroup()
{
	int defval = distrib_getvalnum(PRIVGROUP,0);
	return linuxconf_getvalnum (PASSWD,PRIVGROUP,defval) != 0;
}
/*
	Return the command to run after a user account has been deleted
	Return NULL is none.
*/
const char *policies_getpostdeletecmd()
{
	const char *ret = linuxconf_getval (PASSWD,POSTDELETECMD);
	if (ret != NULL && ret[0] == '\0') ret = NULL;
	return ret;
}

/*
	Return the command to run to delete user account data.
	Return NULL if none
*/
const char *policies_getdeletecmd()
{
	const char *ret = linuxconf_getval (PASSWD,DELETECMD,def_delete);
	if (ret[0] == '\0') ret = NULL;
	return ret;
}
/*
	Return the command to run to archive user account data.
	Return NULL if none
*/
const char *policies_getarchivecmd()
{
	const char *ret = linuxconf_getval (PASSWD,ARCHIVECMD,def_archive);
	if (ret[0] == '\0') ret = NULL;
	return ret;
}

/*
	Return true if the HOME directory is editable/visible in the user accounts
*/
bool policies_mayedithome()
{
	return linuxconf_getvalnum (PASSWD,MAYEDITHOME,1) != 0;
}
/*
	Return true if the shell is editable/visible in the user accounts
*/
bool policies_mayeditshell()
{
	return linuxconf_getvalnum (PASSWD,MAYEDITSHELL,1) != 0;
}
/*
	Return true if the quota is editable/visible in the user accounts
*/
bool policies_mayeditquota()
{
	return linuxconf_getvalnum (PASSWD,MAYEDITQUOTA,1) != 0;
}
/*
	Return true if the tasks (crontab) is editable/visible in the user accounts
*/
bool policies_mayedittasks()
{
	return linuxconf_getvalnum (PASSWD,MAYEDITTASKS,1) != 0;
}
/*
	Return true if the shadow parameters are visible in the user accounts
*/
bool policies_mayshowshadow()
{
	return linuxconf_getvalnum (PASSWD,SHOWSHADOW,1) != 0;
}

PUBLIC PASSWD_VALID::PASSWD_VALID()
{
	minlen = passwd_valid_getval(MINLEN,6);
	minnonalpha = passwd_valid_getval(MINNONALPHA,0);
	defhome.setfrom (policies_getdefhome());
	createcmd.setfrom (policies_getcreatecmd());
	postdeletecmd.setfrom (policies_getpostdeletecmd());
	deletecmd.setfrom (policies_getdeletecmd());
	archivecmd.setfrom (policies_getarchivecmd());
	privgroup = policies_privgroup() ? 1 : 0;
	createperm = policies_getcreateperm();
	showshadow = policies_mayshowshadow() ? 1 : 0;
	mayedithome = policies_mayedithome() ? 1 : 0;
	mayeditshell = policies_mayeditshell() ? 1 : 0;
	mayeditquota = policies_mayeditquota() ? 1 : 0;
	mayedittasks = policies_mayedittasks() ? 1 : 0;
}

/*
	Edit the password setting policies
*/
PUBLIC void PASSWD_VALID::edit()
{
	if(perm_rootaccess(MSG_U(P_PASSPOLICIES
		,"set the password and account policies"))){
		DIALOG dia;
		dia.newf_title (MSG_R(T_POLICIES),1,"",MSG_R(T_POLICIES));
		dia.newf_num (MSG_U(F_MINLEN,"Minimum length"),minlen);
		dia.newf_num (MSG_U(F_MINCHARS,"Minimum amount of non alpha char")
			,minnonalpha);
		dia.newf_chk (MSG_U(F_PRIVGROUP,"Private group"),privgroup
			,MSG_U(I_PRIVGROUP,"One group per user"));
		dia.newf_str (MSG_U(F_DEFHOME,"Default base dir for homes"),defhome);
		dia.newf_octnum (MSG_R(F_CREATEPERM),createperm);
		dia.newf_chk ("",showshadow,MSG_U(I_SHOWSHADOW,"Show the shadow parameters"));
		dia.newf_chk ("",mayedithome,MSG_U(I_EDITHOME,"May change the HOME directory path"));
		dia.newf_chk ("",mayeditshell,MSG_U(I_EDITSHELL,"May change the login shell"));
		dia.newf_chk ("",mayeditquota,MSG_U(I_EDITQUOTA,"May edit the disk quotas"));
		dia.newf_chk ("",mayedittasks,MSG_U(I_EDITTASKS,"May edit the scheduled tasks"));
		SHADOW sha;
		if (shadow_exist()){
			sha.setdialog (dia);
		}
		dia.newf_title (MSG_U(T_SCRIPTS,"Scripts"),1,"",MSG_R(T_SCRIPTS));
		FIELD_COMBO *comb = dia.newf_combo (MSG_U(F_DELETECMD
			,"Delete account command"),deletecmd);
		comb->addopt (def_delete);
		comb = dia.newf_combo (MSG_U(F_ARCHIVECMD,"Archive account command")
			,archivecmd);
		comb->addopt (def_archive);
		dia.newf_str (MSG_U(F_NEWUSERCMD,"Post-create command"),createcmd);
		dia.newf_str (MSG_U(F_POSTDELCMD,"Pre-delete command")
			,postdeletecmd);
		if (dia.edit (
			MSG_U(T_PASSPOLICIES,"Password/Account setting policies")
			,MSG_U(I_PASSPOLICIES
			 ,"You must enter here the validation rules\n"
			  "for password. Once setup, a user (or you) won't\n"
			  "be able to change a password to one that does not\n"
			  "fullfill this requirements\n")
			,help_password)==MENU_ACCEPT){
			write();
			if (shadow_exist()) sha.writedef();
		}
	}			
}

