#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif

class USERCONF_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ USERCONF_HELP_FILE */
public:
	USERCONF_HELP_FILE (const char *fname);
	/*~PROTOEND~ USERCONF_HELP_FILE */
};

class PASSWD_VALID{
public:
	char privgroup;		// Allocate one group per user
	int minlen;
	int minnonalpha;
	int createperm;
	SSTRING defhome;
	SSTRING createcmd;
	SSTRING deletecmd;
	SSTRING archivecmd;
	SSTRING postdeletecmd;
	char showshadow;
	char mayedithome;
	char mayeditshell;
	char mayeditquota;
	char mayedittasks;
	/*~PROTOBEG~ PASSWD_VALID */
public:
	PASSWD_VALID (void);
	void edit (void);
	void write (void);
	/*~PROTOEND~ PASSWD_VALID */
};

class SHADOW: public ARRAY_OBJ{
	friend class SHADOWS;
	friend class USER;
	friend class USERS;
	SSTRING name;
	SSTRING passwd;
	int last;
	int may;
	int must;
	int warn;
	int expire;
	int disable;
	SSTRING reserved;
	/*~PROTOBEG~ SHADOW */
public:
	SHADOW (const char *line);
	SHADOW (void);
	int getdisable (void)const;
	int getexpire (void)const;
	int getmaychange (void)const;
	int getmustchange (void)const;
	const char *getpwd (void)const;
	int getwarn (void)const;
private:
	void initdef (void);
public:
	void setdialog (DIALOG&dia);
	void write (FILE *fout);
	int writedef (void);
	/*~PROTOEND~ SHADOW */
};

class SHADOWS: public ARRAY{
	CONFIG_FILE *configf;
	/*~PROTOBEG~ SHADOWS */
public:
	SHADOWS (CONFIG_FILE&_configf);
	SHADOWS (void);
	SHADOW *getitem (const char *name);
	SHADOW *getitem (int no);
private:
	void readusers (void);
public:
	void reload (void);
	int write (PRIVILEGE *priv);
	/*~PROTOEND~ SHADOWS */
};

extern const char subsys_useraccounts[];
extern const char subsys_policies[];
extern int (*perm_fct_change) (const char *user, bool pre_authenticated);


#endif


