#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "misc.h"

void str6_required(){}
/*
	Expand TABs in a string and convert to a bunch of spaces.
	Return the number of char written in dst.

	src may contain some '\n'. This is properly understood as a carriage
	return.
*/
int str_exptab (
	const char *src,
	int step,		// Number of spaces per tab
	char *dst)		// Will receive the result. dst may be the same as
					// src
{
	int offset = 0;
	char tmp[200];
	char *tmpalloc = NULL;
	if (dst == src){
		unsigned lensrc = strlen(src);
		if (lensrc >= sizeof(tmp)){
			tmpalloc = (char*) malloc (lensrc+1);
			strcpy (tmpalloc,src);
			src = (const char*) tmpalloc;
		}else{
			strcpy (tmp,src);
			src = (const char*) tmp;
		}
	}
	while (*src != '\0'){
		if (*src == '\t'){
			offset++;
			src++;
			*dst++ = ' ';
			while ((offset % step) != 0){
				*dst++ = ' ';
				offset++;
			}
		}else if (*src == '\n'){
			offset = 0;
			*dst++ = *src++;
		}else{
			offset++;
			*dst++ = *src++;
		}
	}	
	*dst = '\0';
	if (tmpalloc != NULL) free (tmpalloc);
	return offset;
}

