/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "tabledata.h"

/* simple linked-list implementation */

/* added in 0.3.3 to help taking flickering out */
/* messed in 0.3.4 to sort the list offline */

tabledata::tabledata() {
  int i;
  next=NULL;
  selflag=FALSE;
  for(i=0;i<MAXTDATA;i++)
    pointers[i]=NULL;
}

tabledata::~tabledata() {
  int i;
  if (next!=NULL)
    delete next;
  for(i=0;i<MAXTDATA;i++)
    if (pointers[i]!=NULL)
      free(pointers[i]);
}

tabledata * tabledata::getNext() {
  return(next);
}

void tabledata::setNext(tabledata *x) {
  next=x;
}

int tabledata::count() {
  if (next==NULL)
    return 1;
  return(1+next->count());
}

void tabledata::setv(int i,char *a) {
  if (pointers[i]!=NULL)
    free(pointers[i]);
  pointers[i]=(char *)malloc(strlen(a)+1);
  strcpy(pointers[i],a);
}

char * tabledata::getv(int i) {
  return(pointers[i]);
}

void tabledata::add(tabledata *td) {
  if (next==NULL)
    next=td;
  else
    next->add(td);
}

void tabledata::select_item() {
  selflag=TRUE;
}

gboolean tabledata::selected() {
  return(selflag);
}
