/* (C) 1999 Felipe Paulo Guazzi Bergo -- bergo@seul.org */

/* 

   This module is built up of the following files:
   
   msgbox.h
   msgbox.cc
   question.xpm
   bong.xpm
   exclamation.xpm
   info.xpm

*/

/* return values */

#define MSG_NO      0
#define MSG_YES     1
#define MSG_CANCEL  2

typedef enum
{
  MSGBOX_ICON_NONE,
  MSGBOX_ICON_ERROR,
  MSGBOX_ICON_INFO,
  MSGBOX_ICON_EXCLAMATION,
  MSGBOX_ICON_QUESTION
} MsgBoxIcon;

/* prototypes */

/* 
   use these functions to pop a message box.
   Use one of these enums in the icon argument:

   MSGBOX_ICON_NONE          No icon.

   MSGBOX_ICON_ERROR         Should be used on errors, i.e.,
                             something wrong really happened.
                             Currently included icon is a white
                             cross in a red circle. "bong.xpm"

   MSGBOX_ICON_QUESTION      Should be used on any questions, like
                             confirmations. Currently included
                             icon is a white question mark in a 
                             green circle. "question.xpm"

   MSGBOX_ICON_EXCLAMATION   Should be used on warnings, like when
                             your code tries to allocate a resource
                             and it is busy (and being busy is "normal").
                             Currently included icon is a black exclamation
                             mark in an yellow triangle.

   MSGBOX_ICON_INFO          Sould be used on general informative
                             messages, like "Operation Finished",
                             "Scan finished: 999999 blocks,
                              999998 bad, 1 good.", and the like.
                             Currently included icon is a white "i"
                             in a blue square.

   The return value is MSG_NO,MSG_YES or MSG_CANCEL.
*/

gint message_box_ok(char *txt,char *title,MsgBoxIcon icon);
gint message_box_yesno(char *txt,char *title,MsgBoxIcon icon);
gint message_box_yesnocancel(char *txt,char *title,MsgBoxIcon icon);

/* 
   private functions, external modules should not call these
   directly 
*/

void message_box_ok_ok(GtkWidget *widget,gpointer data);
void message_box_yesnocancel_yes(GtkWidget *widget,gpointer data);
void message_box_yesnocancel_no(GtkWidget *widget,gpointer data);
void message_box_yesnocancel_cancel(GtkWidget *widget,gpointer data);
gint immortal(GtkWidget *widget,GdkEvent *event,gpointer data);


/* structures */

struct yesnocancel_data {
  gint answer_available;
  gint answer; // 0=no, 1=yes, 2=cancel
};

struct ok_data {
  gint answer_available;
};
