/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <time.h>
#include <pwd.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/resource.h>
#include <signal.h>
#include <asm/page.h>
#include <gtk/gtk.h>
#include "details.h"

#include "dtitle1.xpm"
#include "dtitle2.xpm"
#include "dtitle3.xpm"
#include "dtitle4.xpm"

GtkWidget *pdlg;
gint cur_prop=-1;
extern time_t btime;

GList *sdevs=NULL;

/* POSIX only for now, maybe add Linux specific later */

#define COUNTSIG 19

static char *signames[]={"SIGHUP", "SIGINT", "SIGQUIT","SIGILL", "SIGABRT","SIGFPE",
                  "SIGKILL","SIGSEGV","SIGPIPE","SIGALRM","SIGTERM","SIGUSR1",
		  "SIGUSR2","SIGCHLD","SIGCONT","SIGSTOP","SIGTSTP","SIGTTIN",
		  "SIGTTOU"};

static gint sigvalues[]={SIGHUP,SIGINT,SIGQUIT,SIGILL,SIGABRT,SIGFPE,
                  SIGKILL,SIGSEGV,SIGPIPE,SIGALRM,SIGTERM,SIGUSR1,
                  SIGUSR2,SIGCHLD,SIGCONT,SIGSTOP,SIGTSTP,SIGTTIN,
                  SIGTTOU};

void open_details(gint thepid) {
  GtkWidget *v1,*h1,*hs,*dis,*tbl;

  pdlg=gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_widget_realize(pdlg);
  gtk_window_set_policy(GTK_WINDOW(pdlg),TRUE,TRUE,TRUE); /* 0.3.6 */
  //  gtk_widget_set_usize(pdlg,650,405);
  gtk_window_set_title(GTK_WINDOW(pdlg),"Details");
  gtk_container_set_border_width(GTK_CONTAINER(pdlg),4);
  
  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(pdlg),v1);

  tbl=gtk_table_new(32,5,FALSE);
  gtk_box_pack_start(GTK_BOX(v1),tbl,TRUE,TRUE,2);
  fill_table(thepid,GTK_TABLE(tbl));

  hs=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),hs,FALSE,FALSE,4);
  h1=gtk_hbox_new(FALSE,2);
  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,TRUE,2);

  dis=gtk_button_new_with_label("   Dismiss   ");
  gtk_box_pack_end(GTK_BOX(h1),dis,FALSE,FALSE,2);

  gtk_signal_connect(GTK_OBJECT(dis),"clicked",
		     GTK_SIGNAL_FUNC(dismiss_details),NULL);

  GTK_WIDGET_SET_FLAGS(dis,GTK_CAN_DEFAULT);
  gtk_widget_grab_default(dis);

  gtk_widget_show(v1);
  gtk_widget_show(h1);
  gtk_widget_show(hs);
  gtk_widget_show(dis);
  gtk_widget_show(tbl);
  gtk_widget_show(pdlg);
  gtk_grab_add(pdlg);

  cur_prop=thepid;
  gtk_grab_add(pdlg);
}

void dismiss_details(GtkWidget *wid,gpointer data) {
  gtk_grab_remove(pdlg);
  gtk_widget_destroy(pdlg);
}

void fill_table(gint p,GtkTable *tbl) {
  GtkWidget *l1,*l2,*sw,*cl,*fl,*fw;
  gint i,j;
  char buffer[1024],buffercopy[1024],b2[128],b3[512];
  char *sp,*p1,*p2;
  gchar *tpo[2];
  FILE *f;
  unsigned long rtime,la,rssi;
  time_t ptime;
  struct passwd *ident;
  
  gtk_table_set_col_spacings(tbl,4);

  // <vr>
  l1=gtk_vseparator_new();
  gtk_table_attach(tbl,l1,2,3,0,30,GTK_FILL,GTK_FILL,4,0);
  gtk_widget_show(l1);

  mk_cell_pic(tbl,dtitle1_xpm,0,0);
  mk_cell_pic(tbl,dtitle2_xpm,3,0);
  mk_cell_pic(tbl,dtitle3_xpm,3,9);
  mk_cell_pic(tbl,dtitle4_xpm,0,12); /* 0.3.6 */

  /* the left column's top clist */

  fw=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(fw),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_NEVER);  

  fl=gtk_clist_new(2);
  gtk_clist_set_shadow_type(GTK_CLIST(fl),GTK_SHADOW_ETCHED_IN);
  gtk_clist_set_selection_mode(GTK_CLIST(fl),GTK_SELECTION_BROWSE);
  gtk_clist_set_column_title(GTK_CLIST(fl),0,"What");
  gtk_clist_set_column_title(GTK_CLIST(fl),1,"Who");
  gtk_clist_column_titles_passive(GTK_CLIST(fl));
  gtk_clist_column_titles_hide(GTK_CLIST(fl));
  gtk_clist_set_column_width(GTK_CLIST(fl),0,60);
  gtk_clist_set_column_width(GTK_CLIST(fl),1,100);
  /*  gtk_clist_set_column_auto_resize(GTK_CLIST(fl),0,TRUE);
      gtk_clist_set_column_auto_resize(GTK_CLIST(fl),1,TRUE);*/

  gtk_container_add(GTK_CONTAINER(fw),fl);
  gtk_table_attach_defaults(tbl,fw,0,2,1,12);

  strcpy(b2," ");
  tpo[0]=b2;
  tpo[1]=b2;
  for(i=0;i<10;i++)
    gtk_clist_append(GTK_CLIST(fl),(gchar **)tpo);

  /* clist ends */

  sprintf(buffer,"/proc/%d/stat",p);
  f=fopen(buffer,"r");
  if (f==NULL)
    return;
  fgets(buffer,1024,f);
  strcpy(buffercopy,buffer);
  fclose(f);

  // user
  sprintf(b2,"/proc/%d/status",p);
  f=fopen(b2,"r");
  if (f!=NULL) {
    while(1) {
      fgets(b3,512,f);
      if (strstr(b3,"Uid:")!=NULL)
	break;
    }
    fclose(f);
    strtok(b3," \t\n");
    i=atoi(strtok(NULL," \t\n"));
    ident=getpwuid(i);
    setitemvalue(GTK_CLIST(fl),ident->pw_name,1,2,4,5);
  }

  // cmdline
  sprintf(b2,"/proc/%d/cmdline",p);
  f=fopen(b2,"r");
  if (f!=NULL) {
    memset(b3,0,512);
    i=fread(b3,1,512,f);
    fclose(f);
    for(j=0;j<(i-1);j++)
      if (b3[j]==0)
	b3[j]=0x20;
    setitemvalue(GTK_CLIST(fl),strtok(b3,"\n\t"),1,2,3,4);
  }

  // parse f into fields
  strtok(buffer," \t\n"); // PID (#1)

  // pid
  setitemvalue(GTK_CLIST(fl),"PID",0,1,1,2);
  sprintf(b2,"%d",p);
  setitemvalue(GTK_CLIST(fl),b2,1,2,1,2);

  // name (now fixed to get weird characters without mess)
  p1=strchr(buffercopy,'(');
  p2=strrchr(buffercopy,')'); /* pattern matching, the hard way */

  memset(b2,0,128);
  memcpy(b2,p1+1,(p2-p1)-1);
  strcpy(b3,b2);

  strcpy(buffer,p2+1);

  setitemvalue(GTK_CLIST(fl),"Name",0,1,2,3);
  setitemvalue(GTK_CLIST(fl),b3,1,2,2,3);

  // state
  setleftlabel(tbl,"State",3,4,16,17);
  strcpy(b2,strtok(buffer," \t\n")); // State (#3)
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,16,17);
  gtk_widget_show(l2);

  setitemvalue(GTK_CLIST(fl),"Commmand Line",0,1,3,4);
  setitemvalue(GTK_CLIST(fl),"Owner",0,1,4,5);

  // ppid
  setitemvalue(GTK_CLIST(fl),"PPID (Parent PID)",0,1,5,6);
  strcpy(b2,strtok(NULL," \t\n")); // PPID (#4)
  setitemvalue(GTK_CLIST(fl),b2,1,2,5,6);

  // pgid
  setitemvalue(GTK_CLIST(fl),"PGID (Process Group ID)",0,1,6,7);
  strcpy(b2,strtok(NULL," \t\n")); // PGID (#5)
  setitemvalue(GTK_CLIST(fl),b2,1,2,6,7);

  // sid
  setitemvalue(GTK_CLIST(fl),"SID (Session ID)",0,1,7,8);
  strcpy(b2,strtok(NULL," \t\n")); // SID (#6)
  setitemvalue(GTK_CLIST(fl),b2,1,2,7,8);

  // tty
  setitemvalue(GTK_CLIST(fl),"TTY",0,1,8,9);
  strcpy(b2,strtok(NULL," \t\n")); // TTY (#7)
  i=atoi(b2);
  get_tty_description(i,b3);
  setitemvalue(GTK_CLIST(fl),b3,1,2,8,9);

  // tpgid
  setitemvalue(GTK_CLIST(fl),"TPGID (TTY owner's PGID)",0,1,9,10);
  strcpy(b2,strtok(NULL," \t\n")); // TPGID (#8)
  setitemvalue(GTK_CLIST(fl),b2,1,2,9,10);

  // flags
  setitemvalue(GTK_CLIST(fl),"Flags",0,1,10,11);
  strcpy(b2,strtok(NULL," \t\n")); // FLAGS (#9)
  la=atol(b2);
  parse_process_flags(la,b3);
  setitemvalue(GTK_CLIST(fl),b3,1,2,10,11);

  // minflt
  setleftlabel(tbl,"Process Minor (page) faults",3,4,4,5);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,4,5);
  gtk_widget_show(l2);

  // cminflt
  setleftlabel(tbl,"Children Minor faults",3,4,5,6);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,5,6);
  gtk_widget_show(l2);

  // maxflt
  setleftlabel(tbl,"Process Major faults",3,4,6,7);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,6,7);
  gtk_widget_show(l2);

  // cmaxflt
  setleftlabel(tbl,"Children Major faults",3,4,7,8);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,7,8);
  gtk_widget_show(l2);

  // utime
  setleftlabel(tbl,"Jiffies in user mode",3,4,10,11);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,10,11);
  gtk_widget_show(l2);

  // stime
  setleftlabel(tbl,"Jiffies in kernel mode",3,4,11,12);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,11,12);
  gtk_widget_show(l2);

  // cutime
  setleftlabel(tbl,"Children jiffies in user mode",3,4,12,13);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,12,13);
  gtk_widget_show(l2);

  // cstime
  setleftlabel(tbl,"Children jiffies in kernel mode",3,4,13,14);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,13,14);
  gtk_widget_show(l2);

  // counter
  setleftlabel(tbl,"Maximum jiffies in next timeslice",3,4,14,15);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,14,15);
  gtk_widget_show(l2);

  // nicety
  setleftlabel(tbl,"Nicety",3,4,15,16);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,15,16);
  gtk_widget_show(l2);

  strtok(NULL," \t\n"); // timeout
  strtok(NULL," \t\n"); // itrealvalue

  // start time
  setitemvalue(GTK_CLIST(fl),"Start time",0,1,11,12);
  strcpy(b2,strtok(NULL," \t\n"));
  rtime=(unsigned long)atol(b2);
  ptime=btime+(time_t)(rtime/100UL);
  strcpy(b3,ctime(&ptime));
  if (b3[strlen(b3)-1]=='\n')
    b3[strlen(b3)-1]=0;
  setitemvalue(GTK_CLIST(fl),b3,1,2,11,12);

  // vsize
  setleftlabel(tbl,"SIZE (bytes)",3,4,1,2);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,1,2);
  gtk_widget_show(l2);

  // RSS
  setleftlabel(tbl,"RSS (bytes)",3,4,2,3);
  strcpy(b2,strtok(NULL," \t\n"));
  rssi=atol(b2);
  rssi<<=PAGE_SHIFT;
  sprintf(b2,"%lu",rssi);
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,2,3);
  gtk_widget_show(l2);

  // RLIM
  setleftlabel(tbl,"RSS Limit (bytes)",3,4,3,4);
  strcpy(b2,strtok(NULL," \t\n"));
  l2=gtk_label_new(b2);
  lable_attach(tbl,l2,4,5,3,4);
  gtk_widget_show(l2);

  // signals
  for(i=0;i<5;i++)
    strtok(NULL," \t\n");

  sw=gtk_scrolled_window_new(NULL,NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_NEVER);  

  cl=gtk_clist_new(2);
  gtk_clist_set_shadow_type(GTK_CLIST(cl),GTK_SHADOW_ETCHED_IN);
  gtk_clist_set_selection_mode(GTK_CLIST(cl),GTK_SELECTION_BROWSE);
  gtk_clist_set_column_title(GTK_CLIST(cl),0,"What");
  gtk_clist_set_column_title(GTK_CLIST(cl),1,"Signals");
  gtk_clist_column_titles_passive(GTK_CLIST(cl));
  gtk_clist_column_titles_hide(GTK_CLIST(cl));
  gtk_clist_set_column_width(GTK_CLIST(cl),0,60);
  gtk_clist_set_column_width(GTK_CLIST(cl),1,100);
  gtk_clist_set_column_auto_resize(GTK_CLIST(cl),1,TRUE);
  gtk_container_add(GTK_CONTAINER(sw),cl);
  gtk_table_attach_defaults(tbl,sw,0,2,13,30);

  tpo[0]=b2;
  tpo[1]=b3;

  // pending signals
  strcpy(b2,strtok(NULL," \t\n"));
  strcpy(b3,get_signal_string(atol(b2)));
  strcpy(b2,"Pending");
  gtk_clist_append(GTK_CLIST(cl),(gchar **)tpo);

  // blocked signals
  strcpy(b2,strtok(NULL," \t\n"));
  strcpy(b3,get_signal_string(atol(b2)));
  strcpy(b2,"Blocked");
  gtk_clist_append(GTK_CLIST(cl),(gchar **)tpo);

  // ignored signals
  strcpy(b2,strtok(NULL," \t\n"));
  strcpy(b3,get_signal_string(atol(b2)));
  strcpy(b2,"Ignored");
  gtk_clist_append(GTK_CLIST(cl),(gchar **)tpo);

  // caught signals
  strcpy(b2,strtok(NULL," \t\n"));
  strcpy(b3,get_signal_string(atol(b2)));
  strcpy(b2,"Caught");
  gtk_clist_append(GTK_CLIST(cl),(gchar **)tpo);

  gtk_clist_columns_autosize(GTK_CLIST(fl));
  gtk_widget_show(fl);
  gtk_widget_show(fw); // top clist

  gtk_widget_set_usize(fw,360,-1);

  gtk_widget_show(cl);
  gtk_widget_show(sw); // signal clist
}

void lable_attach(GtkTable *t,GtkWidget *w,gint l,gint r,gint u,gint d) {
  GtkWidget *f;
  if ((l==0)||(l==3)) {
    f=gtk_hbox_new(FALSE,0);
    gtk_box_pack_start(GTK_BOX(f),w,FALSE,FALSE,0);
  } else {
    f=gtk_hbox_new(FALSE,0);
    gtk_box_pack_end(GTK_BOX(f),w,FALSE,FALSE,0);
  }
  gtk_table_attach_defaults(t,f,l,r,u,d);
  gtk_widget_show(f);
}

void setitemvalue(GtkCList *cl,char *text,gint l,gint r,gint u,gint d) {
  if (text==NULL)
    text=" ";
   gtk_clist_set_text(cl,u-1,l,text);
}


void setleftlabel(GtkTable *t,char *text,gint l,gint r,gint u,gint d) {
  GtkWidget *f,*la;

  f=gtk_hbox_new(FALSE,0);
  la=gtk_label_new(text);
  gtk_box_pack_start(GTK_BOX(f),la,FALSE,FALSE,0);
  gtk_table_attach_defaults(t,f,l,r,u,d);
  gtk_widget_show(la);
  gtk_widget_show(f);
}

void parse_process_flags(unsigned long flags,char *dest) {
  /* these macros taken from linux/sched.h of kernel 2.2.3 */
  gint i=0;
  dest[0]=0;

  if (flags&PF_ALIGNWARN) { strcat(dest,"ALIGNWARN"); ++i; }
  if (flags&PF_STARTING)  { if (i) strcat(dest,",");
                            strcat(dest,"STARTING"); ++i; }
  if (flags&PF_EXITING)   { if (i) strcat(dest,",");
                            strcat(dest,"EXITING"); ++i; }
  if (flags&PF_PTRACED)   { if (i) strcat(dest,",");
                            strcat(dest,"PTRACED"); ++i; }
  if (flags&PF_TRACESYS)  { if (i) strcat(dest,",");
                            strcat(dest,"TRACESYS"); ++i; }
  if (flags&PF_FORKNOEXEC){ if (i) strcat(dest,",");
                            strcat(dest,"FORKNOEXEC"); ++i; }
  if (flags&PF_SUPERPRIV) { if (i) strcat(dest,",");
                            strcat(dest,"SUPERPRIV"); ++i; }
  if (flags&PF_DUMPCORE)  { if (i) strcat(dest,",");
                            strcat(dest,"DUMPCORE"); ++i; }
  if (flags&PF_SIGNALED)  { if (i) strcat(dest,",");
                            strcat(dest,"SIGNALED"); ++i; }
  if (flags&PF_MEMALLOC)  { if (i) strcat(dest,",");
                            strcat(dest,"MEMALLOC"); ++i; }
  if (flags&PF_VFORK)     { if (i) strcat(dest,",");
                            strcat(dest,"VFORK"); ++i; }
  if (flags&PF_USEDFPU)   { if (i) strcat(dest,",");
                            strcat(dest,"USEDFPU"); ++i; }
  if (flags&PF_DTRACE)    { if (i) strcat(dest,",");
                            strcat(dest,"DTRACE"); ++i; }
  if (!i)
    strcpy(dest,"(no flags set)");
}

void mk_cell_pic(GtkTable *t,char **xpm,gint l,gint u) {
  GtkStyle *style;
  GtkWidget *h,*p;
  GdkBitmap *mask;
  GdkPixmap *dp;
  style=gtk_widget_get_style(pdlg);
  dp=gdk_pixmap_create_from_xpm_d(pdlg->window,&mask,
				  &style->bg[GTK_STATE_NORMAL],
				  (gchar **)xpm);
  p=gtk_pixmap_new(dp,mask);
  h=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(h),p,FALSE,FALSE,0);
  gtk_table_attach_defaults(t,h,l,l+1,u,u+1);
  gtk_widget_show(p);
  gtk_widget_show(h);
}

char *get_signal_string(unsigned long sigs) {
  gint i,j,k,m;
  unsigned long cs;
  static char buffer[512];

  buffer[0]=0;
  k=sizeof(sigs)*8;
  cs=sigs;
  j=0;
  for(i=0;i<k;i++) {
    if (cs&0x01) {
      m=sigindex(i+1);
      if (m!=-1) {
	if (j>0)
	  strcat(buffer,",");
	strcat(buffer,signames[m]);
	j++;
      }
    }
    cs>>=1;
  }
  if (!j)
    strcpy(buffer,"(none)");
  return buffer;
}

gint sigindex(gint val) {
  gint i;
  for(i=0;i<COUNTSIG;i++)
    if (sigvalues[i]==val)
      return i;
  return(-1);
}

void create_device_list() {
  FILE *f;
  char *a,*b;
  gint i,gotcd;
  dpair *d;

  sdevs=NULL;

  f=fopen("/proc/devices","r");
  if (f==NULL) {
    g_warning("Unable to read /proc/devices. tty information will not be shown.\n");
    return;
  }

  a=(char *)g_malloc0(1024);
  gotcd=FALSE;
  while(1) {
    if (fgets(a,1024,f)==NULL)
      break;
    
    if (!gotcd)
      if (strstr(a,"haracter")==NULL)
	continue;
    gotcd=TRUE;

    b=strtok(a," \t\n");
    if ((b==NULL)||(strlen(b)==0))
      break;
    if ((i=atoi(b))<=0)
      continue;
    d=new dpair();
    d->number=i;
    b=strtok(NULL," \t\n");
    strcpy(d->name,b);
    sdevs=g_list_prepend(sdevs,(gpointer)d);
  }

  g_free(a);
  fclose(f);
}

void get_tty_description(gint x,char *s) {
  dpair *p;
  GList *sp;
  gint maj,min;

  if (x<=0) {
    strcpy(s,"none");
    return;
  }

  strcpy(s,"no tty info");
  if (sdevs==NULL)
    return;

  min=x&0xff;
  maj=x>>8;

  for(sp=sdevs;sp!=NULL;sp=g_list_next(sp)) {
    p=(dpair *)(sp->data);
    if (p->number==maj) {
      sprintf(s,"%s%d",p->name,min);
      break;
    }
  }
}
