/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *   Gnome Apt frontend
 *
 *   Copyright (C) 1998 Havoc Pennington <hp@pobox.com>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GNOME_APT_PKGUTIL_H
#define GNOME_APT_PKGUTIL_H

#include "cache.h"

class GAptPkgTree;

class Util {
public:
  typedef enum {
      StatusNowBroken,
      StatusInstBroken,
      
      StatusNewInstall,
      StatusUpgrade,
      StatusDowngrade,
      StatusDelete,
      StatusInstall,
      
      StatusNotInstalled,
      
      StatusKept,
      StatusHeld,
      
      StatusTypeEnd
  } StatusType;
  

  static StatusType 
  status_type(pkgCache::PkgIterator & i, GAptCache* cache);
  

  static const char* 
  status_string(StatusType st);

  // the last arg can be NULL, but if not we fill
  //  it with the priority enum or a big number if there's
  //  no version available.
  // this is sort of a mess.

  static const char* 
  priority_string(pkgCache::PkgIterator & i, 
                  GAptCache* cache,
                  pkgCache::State::VerPriority* p);

  // Return depends that are listed in the tree - i.e. depends
  //  of the version to be installed.
  static pkgCache::DepIterator depends(pkgCache::PkgIterator & i,
                                       GAptCache* cache);

  // Returns a parser for display_version
  static pkgRecords::Parser* pkg_parser(pkgCache::PkgIterator & i,
                                        GAptCache* cache);

  // return iterator for the version we want to display the
  // description of, etc. Kind of arbitarily decided.
  static pkgCache::VerIterator display_version(pkgCache::PkgIterator & i,
                                               GAptCache* cache);

  // Operations on packages: these wrap apt-pkg routines,
  //  but also notify any parts of the GUI that need to react,
  //  and maybe throw up dialogs to ask the user questions.

  // change state

  static void remove(pkgCache::Package* p, GAptPkgTree* tree);

  static void remove(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static void keep(pkgCache::Package* p, GAptPkgTree* tree);

  static void keep(pkgCache::PkgIterator& i, GAptPkgTree* tree);
  
  static void install(pkgCache::Package* p, GAptPkgTree* tree);

  static void install(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static void unremove(pkgCache::Package* p, GAptPkgTree* tree);

  static void unremove(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static void unkeep(pkgCache::Package* p, GAptPkgTree* tree);

  static void unkeep(pkgCache::PkgIterator& i, GAptPkgTree* tree);
  
  static void uninstall(pkgCache::Package* p, GAptPkgTree* tree);

  static void uninstall(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  // current state 

  static bool installed(pkgCache::Package* p, GAptPkgTree* tree);

  static bool installed(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static bool removed(pkgCache::Package* p, GAptPkgTree* tree);

  static bool removed(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static bool kept(pkgCache::Package* p, GAptPkgTree* tree);

  static bool kept(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  // whether to give user the option of toggling state

  static bool can_change_install(pkgCache::Package* p, GAptPkgTree* tree);

  static bool can_change_install(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static bool can_change_remove(pkgCache::Package* p, GAptPkgTree* tree);

  static bool can_change_remove(pkgCache::PkgIterator& i, GAptPkgTree* tree);

  static bool can_change_keep(pkgCache::Package* p, GAptPkgTree* tree);

  static bool can_change_keep(pkgCache::PkgIterator& i, GAptPkgTree* tree);

private:


};

#endif
