/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "gqmpeg.h"

static GtkWidget *preset_menu = NULL;

static void load_preset_from_menu(GtkWidget *widget, gpointer data)
{
	gint n = GPOINTER_TO_INT(data);

	load_preset(n);
}

void create_preset_menu()
{
	GtkWidget *menu;
	GtkWidget *item;
	gint i;
        menu = gtk_menu_new();
        for (i=0; i<10; i++)
                {
		gchar s[48];

                if (preset_name[i] && preset_file[i])
                        {
			sprintf(s,"%d - %s", i + 1, preset_name[i]);
			item = gtk_menu_item_new_with_label(s);
			gtk_signal_connect (GTK_OBJECT (item), "activate",
				(GtkSignalFunc) load_preset_from_menu, GINT_TO_POINTER(i));
			}
		else
			{
			sprintf(s, _("%d - (empty)"), i + 1);
			item = gtk_menu_item_new_with_label(s);
			}
		gtk_menu_append(GTK_MENU(menu),item);
		gtk_widget_show(item);
                }

	item = gtk_menu_item_new();
	gtk_menu_append(GTK_MENU(menu),item);
	gtk_widget_show(item);

	item = gtk_menu_item_new_with_label(_("Set preset to playlist..."));
	gtk_signal_connect (GTK_OBJECT (item), "activate",
				(GtkSignalFunc) set_preset_to_playlist, preset_file[i]);
	gtk_menu_append(GTK_MENU(menu),item);
	gtk_widget_show(item);

	item = gtk_menu_item_new_with_label(_("Set preset to song..."));
	gtk_signal_connect (GTK_OBJECT (item), "activate",
				(GtkSignalFunc) set_preset_to_song, preset_file[i]);
	gtk_menu_append(GTK_MENU(menu),item);
	gtk_widget_show(item);

        gtk_menu_item_set_submenu(GTK_MENU_ITEM(preset_menu),menu);
}

GtkWidget *create_main_menu()
{
	GtkWidget *menu;
	GtkWidget *submenu;
	GtkWidget *load_menu;
	GtkWidget *toggle_menu;
	GtkWidget *song_menu;
	GtkWidget *button;

	menu = gtk_menu_new();

	button = gtk_menu_item_new_with_label(_("Play"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_play_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu), button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Pause"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_pause_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Stop"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_stop_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Playlist..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) playlist_window_show, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	preset_menu = gtk_menu_item_new_with_label(_("Presets"));
	gtk_menu_append(GTK_MENU(menu),preset_menu);
	gtk_widget_show(preset_menu);

	load_menu = gtk_menu_item_new_with_label(_("Open"));
	gtk_menu_append(GTK_MENU(menu),load_menu);
	gtk_widget_show(load_menu);

	submenu = gtk_menu_new();

	button = gtk_menu_item_new_with_label(_("Playlist..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_load_playlist_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("File..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_load_file_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Custom..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_load_custom_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

        gtk_menu_item_set_submenu(GTK_MENU_ITEM(load_menu),submenu);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	toggle_menu = gtk_menu_item_new_with_label(_("Toggle"));
	gtk_menu_append(GTK_MENU(menu),toggle_menu);
	gtk_widget_show(toggle_menu);

	submenu = gtk_menu_new();

	button = gtk_menu_item_new_with_label(_("Shuffle"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_shuffle_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Repeat"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_repeat_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Time Display"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) time_toggle_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Time Remaining"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) time_remaining_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

        gtk_menu_item_set_submenu(GTK_MENU_ITEM(toggle_menu),submenu);

	button = gtk_menu_item_new_with_label(_("Preferences..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) show_configuration_window, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	song_menu = gtk_menu_item_new_with_label(_("Current song"));
	gtk_menu_append(GTK_MENU(menu),song_menu);
	gtk_widget_show(song_menu);

	submenu = gtk_menu_new();

	button = gtk_menu_item_new_with_label(_("Song Info..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) current_song_info_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Add to playlist"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) current_song_pl_add_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Remove from playlist"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) current_song_pl_rem_pressed, NULL);
	gtk_menu_append(GTK_MENU(submenu),button);
	gtk_widget_show(button);

        gtk_menu_item_set_submenu(GTK_MENU_ITEM(song_menu), submenu);

	button = gtk_menu_item_new_with_label(_("Run mixer..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_mixer_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("About..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) show_about_info, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Iconify"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) btn_iconify_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Exit"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) gqmpeg_exit, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	create_preset_menu();

	return menu;
}

GtkWidget *create_dir_menu()
{
	GtkWidget *menu;
	GtkWidget *button;

	menu = gtk_menu_new();

	button = gtk_menu_item_new_with_label(_("Add"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_add_dir_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Add Recursive"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_add_dir_recursive_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	return menu;
}

GtkWidget *create_file_menu()
{
	GtkWidget *menu;
	GtkWidget *button;

	menu = gtk_menu_new();

	button = gtk_menu_item_new_with_label(_("Add"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_add_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Insert"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_insert_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Play"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_play_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Add and Play"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_add_play_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Song Info..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_songinfo_pressed, NULL); 
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Copy"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_copy_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Move"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_move_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Rename"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_rename_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Delete"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_delete_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	return menu;
}

GtkWidget *create_file_menu_list()
{
	GtkWidget *menu;
	GtkWidget *button;

	menu = gtk_menu_new();

	button = gtk_menu_item_new_with_label(_("Load"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_load_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Append"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_append_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Copy"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_copy_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Move"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_move_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Rename"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_rename_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Delete"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_filelist_delete_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	return menu;
}

static void playlist_menu_add_defaults(GtkWidget *menu)
{
	GtkWidget *button;

	button = gtk_menu_item_new_with_label(_("Play"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_playlist_play_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Remove"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_playlist_remove_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Song Info..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_playlist_songinfo_pressed, NULL); 
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

        button = gtk_menu_item_new();
        gtk_menu_append(GTK_MENU(menu),button);
        gtk_widget_show(button);
}

GtkWidget *create_playlist_menu()
{
	GtkWidget *menu;
	GtkWidget *button;

	menu = gtk_menu_new();
	playlist_menu_add_defaults(menu);

	button = gtk_menu_item_new_with_label(_("Copy"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_playlist_copy_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Move"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_playlist_move_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Rename"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_playlist_rename_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	button = gtk_menu_item_new_with_label(_("Delete"));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_playlist_delete_pressed, NULL);
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	return menu;
}

GtkWidget *create_playlist_menu_custom()
{
	GtkWidget *menu;
	GtkWidget *button;

	menu = gtk_menu_new();
	playlist_menu_add_defaults(menu);

	button = gtk_menu_item_new_with_label(_("Edit..."));
	gtk_signal_connect (GTK_OBJECT (button), "activate",(GtkSignalFunc) plw_playlist_edit_pressed, NULL); 
	gtk_menu_append(GTK_MENU(menu),button);
	gtk_widget_show(button);

	return menu;
}

