/*
 * GQmpeg
 * (C)1998, 1999 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License.
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */

#include "io_mikmod.h"

static GtkWidget     *mikmod_vbox = NULL;
static GtkWidget     *mikmod_device_entry;
static GtkAdjustment *mikmod_buffer_adjustment;
static GtkWidget     *mikmod_buffer_spinbutton;
static GtkAdjustment *mikmod_sample_adjustment;
static GtkWidget     *mikmod_sample_spinbutton;

static gint c_mikmod_buffer_enable;
static gint c_mikmod_buffer;
static gint c_mikmod_downsample;
static gint c_mikmod_custom_sample_size;
static gint c_mikmod_mono;
static gint c_mikmod_8bit;
static gint c_mikmod_device_enable;

static void buffer_enable_clicked(GtkWidget *w, gpointer data);
static void downsample_auto_selected(GtkWidget *w, gpointer data);
static void downsample_22_selected(GtkWidget *w, gpointer data);
static void downsample_11_selected(GtkWidget *w, gpointer data);
static void downsample_custom_selected(GtkWidget *w, gpointer data);
static void mono_enable_clicked(GtkWidget *w, gpointer data);
static void enable_8bit_clicked(GtkWidget *w, gpointer data);
static void device_enable_clicked(GtkWidget *w, gpointer data);
static void aggressive_clicked(GtkWidget *w, gpointer data);
static void freeamp_clicked(GtkWidget *w, gpointer data);

/*
 *----------------------------------------------------------------------------
 * load / save routines
 *----------------------------------------------------------------------------
 */

void mikmod_config_load(FILE *f, gchar *option, gchar *value, gchar *value_all)
{
	mikmod_buffer_enable = read_bool_option(f, option,
		"mikmod_enable_buffer", value, mikmod_buffer_enable);
	mikmod_buffer = read_int_option(f, option,
		"mikmod_buffer_size", value, mikmod_buffer);

	mikmod_mono = read_bool_option(f, option,
		"mikmod_enable_mono", value, mikmod_mono);
	mikmod_8bit = read_bool_option(f, option,
		"mikmod_enable_8bit", value, mikmod_8bit);

	mikmod_device_enable = read_bool_option(f, option,
		"mikmod_enable_specific_device", value, mikmod_device_enable);
	mikmod_device = read_char_option(f, option,
		"mikmod_specific_device", value_all, mikmod_device);
}

void mikmod_config_save(FILE *f)
{
	fprintf(f,"\n##### MIKMOD Output Options #####\n\n");

	write_bool_option(f, "mikmod_enable_buffer", mikmod_buffer_enable);
	write_int_option(f, "mikmod_buffer_size", mikmod_buffer);
	fprintf(f,"\n");
	write_bool_option(f, "mikmod_enable_mono", mikmod_mono);
	write_bool_option(f, "mikmod_enable_8bit", mikmod_8bit);
	fprintf(f,"\n");
	write_bool_option(f, "mikmod_enable_specific_device", mikmod_device_enable);
	write_char_option(f, "mikmod_specific_device", mikmod_device);
}

/*
 *----------------------------------------------------------------------------
 * config window routines
 *----------------------------------------------------------------------------
 */

static void buffer_enable_clicked(GtkWidget *w, gpointer data)
{
	c_mikmod_buffer_enable = GTK_TOGGLE_BUTTON (w)->active;
}

static void mono_enable_clicked(GtkWidget *w, gpointer data)
{
	c_mikmod_mono = GTK_TOGGLE_BUTTON (w)->active;
}

static void enable_8bit_clicked(GtkWidget *w, gpointer data)
{
	c_mikmod_8bit = GTK_TOGGLE_BUTTON (w)->active;
}

static void device_enable_clicked(GtkWidget *w, gpointer data)
{
	c_mikmod_device_enable = GTK_TOGGLE_BUTTON (w)->active;
}

void mikmod_config_apply()
{
	gchar *buf;

	if (!mikmod_vbox) return;

#if 0
	mikmod_buffer_enable = c_mikmod_buffer_enable;
	mikmod_buffer = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(mikmod_buffer_spinbutton));
	mikmod_mono = c_mikmod_mono;
	mikmod_8bit = c_mikmod_8bit;
	mikmod_device_enable = c_mikmod_device_enable;

	if (mikmod_device)
		{
		g_free(mikmod_device);
		mikmod_device = NULL;
		}
	buf = gtk_entry_get_text(GTK_ENTRY(mikmod_device_entry));
	if (buf && strlen(buf) > 0) mikmod_device = g_strdup(buf);

#endif
}

void mikmod_config_close()
{
	mikmod_vbox = NULL;
}

GtkWidget *mikmod_config_init()
{
	GtkWidget *vbox1;
	GtkWidget *hbox;
	GtkWidget *button;
	GtkWidget *radiobutton;
	GtkWidget *label;
	GtkWidget *frame;

	mikmod_vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_border_width (GTK_CONTAINER (mikmod_vbox), 5);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mikmod_vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	label = gtk_label_new("Configuration not implemented yet.\nAlso note that mod support is preliminary.\nLack of player responsiveness and mod sound skipping WILL happen.");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

#if 0
	c_mikmod_buffer_enable = mikmod_buffer_enable;
	button = gtk_check_button_new_with_label (_("Enable output buffer of size(Kbytes):"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mikmod_buffer_enable);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) buffer_enable_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_mikmod_buffer = mikmod_buffer;
	mikmod_buffer_adjustment = (GtkAdjustment *)gtk_adjustment_new ((float)c_mikmod_buffer,0.0,8192.0,8.0,8.0,8.0);
	mikmod_buffer_spinbutton = gtk_spin_button_new (mikmod_buffer_adjustment, (float)8, 0);
	gtk_widget_set_usize(mikmod_buffer_spinbutton,60,-1);
	gtk_box_pack_start(GTK_BOX(hbox), mikmod_buffer_spinbutton, FALSE, FALSE, 0);
	gtk_widget_show(mikmod_buffer_spinbutton);

	c_mikmod_mono = mikmod_mono;
	button = gtk_check_button_new_with_label (_("Mix both channels into mono output"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mikmod_mono);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) mono_enable_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(mikmod_vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	c_mikmod_8bit = mikmod_8bit;
	button = gtk_check_button_new_with_label (_("8-bit output"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mikmod_8bit);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) enable_8bit_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(mikmod_vbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start(GTK_BOX(mikmod_vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show(hbox);

	c_mikmod_device_enable = mikmod_device_enable;
	button = gtk_check_button_new_with_label (_("Specific output device:"));
	gtk_toggle_button_set_state (GTK_TOGGLE_BUTTON(button), c_mikmod_device_enable);
	gtk_signal_connect (GTK_OBJECT(button),"clicked",(GtkSignalFunc) device_enable_clicked, NULL);
	gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 0);
	gtk_widget_show(button);

	mikmod_device_entry = gtk_entry_new_with_max_length(128);
	if (mikmod_device)
		{
		gtk_entry_set_text(GTK_ENTRY(mikmod_device_entry), mikmod_device);
		}
	gtk_box_pack_start(GTK_BOX(hbox), mikmod_device_entry,TRUE,FALSE,0);
	gtk_widget_show(mikmod_device_entry);

	#endif

	return mikmod_vbox;
}

