/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef SLP_H_
#define SLP_H_

#include "ErrorHandling.h"		// ErrCode

class CSocket;

class SLP
{
	public:
								SLP 			(void);
								SLP 			(CSocket*);
								SLP 			(const SLP&);
								~SLP			(void);

		static void 			EventCallback	(CSocket* s, int event);
		ErrCode 				HandleDataReceived	(void);

		ErrCode 				HandleNewPacket (void);
		ErrCode 				SendPacket		(const void* body, long size);

		Bool					HavePacket		(void) const;
		long					GetPacketSize	(void) const;
		SlkPktHeaderType&		Header			(void) const;
		SysPktBodyType&			Body			(void) const;
		SlkPktFooterType&		Footer			(void) const;

		void					DeferReply		(Bool);

	private:
		SlkPktHeaderChecksum	CalcHdrChecksum (SlkPktHeaderChecksum start,
												 BytePtr bufP, Long count);

		Bool					LogData 		(void);
		Bool					LogFlow 		(void);

	private:
		CSocket*				fSocket;

//		void*					fPacket;
#define kMaxSLPPacketSize (sizeof(SlkPktHeaderType) + sysPktMaxBodySize + sizeof(SlkPktFooterType))
		char					fPacket[kMaxSLPPacketSize];
		Bool					fHavePacket;

		Bool					fSendReply;
};


#endif	// SPL_H_
