/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _MISCELLANEOUS_H_
#define _MISCELLANEOUS_H_

#include "Byteswapping.h"		// Canonical
#include "EmulatorTypes.h"


void CommonStartup (void);
void CommonShutdown (void);


class StMemory
{
	public:
		StMemory		(	char*	inPtr = NULL);

		StMemory		(	long	inSize,
							Bool	inClearBytes = false);

		~StMemory		();

		operator char*	()			{ return mPtr; }

		char*	Get		() const	{ return mPtr; }
		Bool	IsOwner	() const	{ return mIsOwner; }
		Bool	IsValid	() const	{ return (mPtr != NULL); }

		void	Adopt	(	char*	inPtr);
		char*	Release	() const;
		void	Dispose	();

	protected:
		char*			mPtr;
		mutable Bool	mIsOwner;

	private:
		StMemory	( const StMemory &inPointerBlock);
		StMemory&	operator = (const StMemory &inPointerBlock);
};


class StMemoryMapper
{
	public:
		StMemoryMapper	(const void* memory, long size);
		~StMemoryMapper	(void);

	private:
		const void*	fMemory;
};

template <class T>
class StCanonical
{
	public:
		StCanonical (T& obj) :
			fObject (obj)
		{
			Canonical (fObject);
		}

		~StCanonical ()
		{
			Canonical (fObject);
		}

	private:
		T&	fObject;
};

class StWordSwapper
{
	public:
		StWordSwapper (void* memory, long length) :
			fMemory (memory),
			fLength (length)
		{
			::ByteswapWords (fMemory, fLength);
		}

		~StWordSwapper ()
		{
			::ByteswapWords (fMemory, fLength);
		}

	private:
		void*	fMemory;
		long	fLength;
};

void LoadAnyFiles (const FileRefList& fileList);

void CollectOKObjects(FormPtr frm, vector<Word>& okObjects, Bool reportErrors);

Bool PinRectInRect (AbsRectType& inner, const AbsRectType& outer);

// Inline function to turn a trap word (0xA###) into an index into the
// trap table.  The method used here (masking off the uppermost nybble
// instead of, say, subtracting sysTrapBase) matches the ROM.

inline uae_u16 SysTrapIndex (uae_u16 trapWord)
{
	return (uae_u16) (trapWord & ~0xF000);
}

inline uae_u16 LibTrapIndex (uae_u16 trapWord)
{
	return (uae_u16) (SysTrapIndex (trapWord) - SysTrapIndex (sysLibTrapBase));
}

inline Bool IsSystemTrap (uae_u16 trapWord)
{
	return SysTrapIndex (trapWord) < SysTrapIndex (sysLibTrapBase);
}

inline Bool IsLibraryTrap (uae_u16 trapWord)
{
	return !IsSystemTrap (trapWord);
}

Bool	StartsWith				(const char* s, const char* pattern);
Bool	EndsWith				(const char* s, const char* pattern);

string	GetIndCommPort			(int index);

const Bool	kAllDatabases = false;
const Bool	kApplicationsOnly = true;

void	GetDatabases			(DatabaseInfoList& appList, Bool applicationsOnly);

Bool	IsExecutable			(DWord dbType, DWord dbCreator, Word dbAttrs);
Bool	IsVisible				(DWord dbType, DWord dbCreator, Word dbAttrs);

void	InstallCalibrationInfo	(void);
void	ResetCalibrationInfo	(void);
void	SetHotSyncUserName		(const char*);

void	SeperateList			(StringList& stringList, string str, char delimiter);

void	RunLengthEncode			(void** srcPP, void** dstPP, long srcBytes, long dstBytes);
void	RunLengthDecode			(void** srcPP, void** dstPP, long srcBytes, long dstBytes);
long	RunLengthWorstSize		(long);

void	GzipEncode				(void** srcPP, void** dstPP, long srcBytes, long dstBytes);
void	GzipDecode				(void** srcPP, void** dstPP, long srcBytes, long dstBytes);
long	GzipWorstSize			(long);

int		CountBits				(uae_u32 v);
inline int		CountBits				(uae_u16 v) { return CountBits ((uae_u32) (uae_u16) v); }
inline int		CountBits				(uae_u8 v) { return CountBits ((uae_u32) (uae_u8) v); }

inline int		CountBits				(uae_s32 v) { return CountBits ((uae_u32) (uae_u32) v); }
inline int		CountBits				(uae_s16 v) { return CountBits ((uae_u32) (uae_u16) v); }
inline int		CountBits				(uae_s8 v) { return CountBits ((uae_u32) (uae_u8) v); }


uae_u32	NextPowerOf2			(uae_u32 x);
uae_u32	DateToDays				(uae_u32 year, uae_u32 month, uae_u32 day);

string	GetLibraryName			(uae_u16 refNum);

uaecptr GetFunctionAddress		(uae_u16 trapWord, uae_u32 extra = sysInvalidRefNum, Bool digDeep = false);
uaecptr GetLibFunctionAddress	(uae_u16 trapWord, Word refNum, Bool digDeep);
uaecptr GetSysFunctionAddress	(uae_u16 trapWord, uae_u32 extra, Bool digDeep);
uaecptr GetStdDispatchAddress	(uaecptr entryPt, uae_u32 regD2);
uaecptr GetFlpEmDispatchAddress	(uaecptr entryPt, uae_u32 regD2);

extern uae_u32	gLibErrorBase;

char*	GetTrapName				(const SystemCallContext&, Bool digDeep = false);
char*	GetTrapName				(uae_u16 trapWord, uae_u32 extra = sysInvalidRefNum, Bool digDeep = false);
void	FindTrapName			(uae_u16 trapWord, char* nameP, uae_u32 extra = sysInvalidRefNum, Bool digDeep = false);

// Llamagraphics, Inc:  Added nameCapacity argument so that callers
// can retrieve more than 31 character function names.  The default
// capacity is 32, so callers that don't provide the extra argument
// will get the same result as before.

void	FindFunctionName		(uaecptr addr,
								 char* nameP,
								 uaecptr* startAddrP = NULL,
								 uaecptr* endAddrP = NULL,
								 long nameCapacity = 32);
uaecptr	FindFunctionStart		(uaecptr addr);
uaecptr	FindFunctionEnd			(uaecptr addr);

// Llamagraphics, Inc:  Added nameCapacity argument so that callers
// can retrieve more than 31 character function names.  The default
// capacity is 32, so callers that don't provide the extra argument
// will get the same result as before.

void	CopyMacsbugName			(uaecptr eof, char* name, long nameCapacity = 32);
Bool	EndOfFunctionSequence	(uaecptr addr);
uae_u8	MacsbugNameLength		(uaecptr& addr, Bool* isFixed);
Bool	ValidMacsbugChar		(uae_u8 ch);

Bool	GetSystemCallContext	(uaecptr, SystemCallContext&);

void	GetHostTime				(long* hour, long* min, long* sec);
void	GetHostDate				(long* year, long* month, long* day);

const char*	LaunchCmdToString	(Word cmd);

typedef pair <DeviceType, string>	DeviceText;
typedef pair <RAMSizeType, string>	MemoryText;
typedef vector <DeviceText>			DeviceTextList;
typedef vector <MemoryText>			MemoryTextList;
void GetDeviceTextList (DeviceTextList& deviceList);
void GetMemoryTextList (MemoryTextList& memoryList);


#endif	// _MISCELLANEOUS_H_
