/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#include "EmulatorCommon.h"
#include "EmMapFile.h"
#include "Platform_Files.h"


Bool
EmMapFile::Read(const FileReference& f, StringStringMap& mapData)
{
	StringStringMap	theData;

	FILE* pFile = f.OpenAsFILE ("r");	// for read, fail on fnf

	if (pFile == NULL)
		return false;

	string	line;
	int 	ch;

	do {
		ch = fgetc (pFile);

		if (ch == '\n' || ch == EOF)
		{
			// Skip leading WS
			while ((line[0] == ' ') || (line[0] == '\t'))
			{
				line.erase (0, 1);
			}

			// Skip comment and empty lines
			if ((line[0] == ';' ) || (line[0] == '#' ) || (line[0] == '\0'))
			{
				line.erase ();
				continue;
			}

			// Everything else is data
			string::size_type	p = line.find ('=');
			if (p == string::npos)
			{
				line.erase ();
				continue;
			}

			// Split up the line into key/value sections and
			// add it to our hash table.
			string	key (line, 0, p);
			string	value (line, p + 1, line.size ());

			theData[key] = value;
			
			line.erase ();
		}
		else
		{
			line += ch;
		}
	}
	while (ch != EOF);

	fclose (pFile);

	mapData = theData;

	return true;
}



Bool
EmMapFile::Write(const FileReference& f, const StringStringMap& mapData)
{
	FILE *pFile = f.OpenAsFILE("w");

	if (pFile == NULL)
		return false;

	StringStringMap::const_iterator	iter;

	for (iter = mapData.begin(); iter != mapData.end(); ++iter)
	{
		fprintf (pFile, "%s=%s\n", iter->first.c_str(), iter->second.c_str());
	}

	fclose(pFile);

	return true;
}
