/* -*- mode: C++; tab-width: 4 -*- */
/* ================================================================================== */
/* Copyright (c) 1998-1999 3Com Corporation or its subsidiaries. All rights reserved. */
/* ================================================================================== */

#ifndef _BANK_DUMMY_H_
#define _BANK_DUMMY_H_


class SessionFile;

class DummyBank
{
	public:
		static void				Initialize		(void);
		static void				Reset			(void);
		static void				Save			(SessionFile&);
		static void				Load			(SessionFile&);
		static void				Dispose			(void);

		static uae_u32			GetLong			(uaecptr iAddress);
		static uae_u32			GetWord			(uaecptr iAddress);
		static uae_u32			GetByte			(uaecptr iAddress);
		static void				SetLong			(uaecptr iAddress, uae_u32 iLongValue);
		static void				SetWord			(uaecptr iAddress, uae_u32 iWordValue);
		static void				SetByte			(uaecptr iAddress, uae_u32 iByteValue);
		static int				ValidAddress	(uaecptr iAddress, uae_u32 iSize);
		static uae_u8*			GetRealAddress	(uaecptr iAddress);
		static uae_u8*			GetMetaAddress	(uaecptr iAddress);
		static void				AddOpcodeCycles	(void);

		static void				MapPhysicalMemory	(const void*, uae_u32);
		static void				UnmapPhysicalMemory	(const void*);
		static void				GetMappingInfo		(const void*, void**, uae_u32*);

	private:
		static void				InvalidAccess	(uaecptr iAddress, long size, Bool forRead);
};


#endif /* _BANK_DUMMY_H_ */

