# -*- mode: Perl; tab-width: 4 -*-

$started = 0;
$catenating = 0;
$id = "";
$text = "";
$language = "ENGLISH";

$rez_resource = 0;
$vcpp_resource = 0;
$cpp_source = 0;
$translate_high_ascii = 0;

$format = $ARGV[0];

if ($format eq "-format=rez_resource")
{
	$rez_resource = 1;
}

if ($format eq "-format=vcpp_resource")
{
	$vcpp_resource = 1;
	$translate_high_ascii = 1
}

if ($format eq "-format=cpp_source")
{
	$cpp_source = 1;
	$translate_high_ascii = 1
}


$stridx = 0;
$maxidx = 0;
%strkeys = ();
keys( %strkeys ) = 2000;

sub escape_quotes
{	
	if ($rez_resource or $cpp_source)
	{
		$text =~ s/\"/\\\"/g;		# Turn a " into \"
	}

	if ($vcpp_resource)
	{
		$text =~ s/\"/\"\"/g;		# Turn a " into ""
	}
}

sub translate_high_ascii
{
	if ($translate_high_ascii)
	{
		$text =~ s//\"/g;			# Turn  into "
		$text =~ s//\"/g;			# Turn  into "
		$text =~ s//\'/g;			# Turn  into '
		$text =~ s//\'/g;			# Turn  into '
		$text =~ s//\.\.\./g;		# Turn  into ...
		$text =~ s//\(TM)/g;		# Turn  into (TM)
	}
}

sub dump_if_catenating
{
	if ($catenating eq 1)
	{
		translate_high_ascii ();
		escape_quotes ();

		if ($rez_resource)
		{
			print "\t$id, \"$text\";";
		}

		if ($vcpp_resource)
		{
			print "\t$id\t\"$text\"";
		}

		if ($cpp_source)
		{
			print "\t\"$text\",";
			$strkeys{$id} = $stridx++;
		}

		$catenating = 0;
	}
}


while (chomp ($line = <STDIN>) )
{
	if ($line eq "START")
	{
		$started = 1;

		if ($rez_resource)
		{
			printf "type \'STRA\' {\n";
			printf "	integer = \$\$CountOf(SomeArray);\n";
			printf "	wide array SomeArray {\n";
			printf "		integer;\n";
			printf "		wstring;\n";
			printf "	};\n";
			printf "};\n";
			printf "\n";
			printf "resource \'STRA\' (1000) {{\n";
		}

		if ($vcpp_resource)
		{
			print "STRINGTABLE DISCARDABLE\n";
			print "BEGIN\n";
		}

		if ($cpp_source)
		{
			print "#include <map>\n";
			print "static map<int, const char*> _ResStrMap;\n";
			print "static const char* _ResStrTable[] = {\n";
		}
	}
	elsif ($line eq "END")
	{
		$started = 0;

		if ($rez_resource)
		{
			print "}};\n\n";
		}

		if ($vcpp_resource)
		{
			print "END\n\n";
		}

		if ($cpp_source)
		{
			print "\t0\n};\n\n";
			print "static void _AddOneString (long id, long index)\n";
			print "{\n";
			print "\t_ResStrMap[id] = _ResStrTable[index];\n";
			print "}\n";
			print "\n";
			print "static void _ResStrTableInit (void)\n";
			print "{\n";
			foreach $k (sort keys %strkeys)
			{
				print "\t_AddOneString ($k, $strkeys{$k});\n";
			}
			print "}\n";
			print "\n";
			print "const char* _ResGetString(int idx)\n";
			print "{\n";
			print "\tstatic int inited;\n";
			print "\tif (!inited)\n";
			print "\t{\n";
			print "\t\tinited = 1;\n";
			print "\t\t_ResStrTableInit();\n";
			print "\t}\n";
			print "\n";
			print "\treturn _ResStrMap[idx];\n";
			print "}\n";
		}
	}
	elsif ($started && $line =~ /^([A-Z]+)=(.+)/)
	{
		dump_if_catenating ();

		if ($1 eq "ID")
		{
			$id = $2;
		}
		elsif ($1 eq $language)
		{
			$text = $2;
			$catenating = 1;
		}
	}
	else
	{
		if ($catenating && substr ($line, 0, 1) eq "\t")
		{
			$text .= substr ($line, 1);
		}
		else
		{
			dump_if_catenating ();

			print "$line\n";
		}
	}
}
