.TH SETIATHOME 1 "August 23, 1999"
.\" Author: Gopal Narayanan <gopal@debian.org>
.\" Based on the README file that accompanies the seti@home
.\" client tar file
.SH NAME
setiathome \- the SETI@home client program
.SH SYNOPSIS
.B setiathome 
[\c
.BI options\fR\c
]

.SH DESCRIPTION
.LP
.B setiathome 
is the UNIX version of the SETI@home client. It
downloads radio telescope data from a network server, analyzes 
the data looking for signals of extraterrestrial origin, and 
uploads results to the server, repeating this cycle indefinitely.
See http://setiathome.ssl.berkeley.edu for more information.
.LP
It is suggested that
the user create a new directory, say, 
.I \&$HOME/setiathome
(henceforth referred to as SETIDIR)
and then cd into SETIDIR, before running 
.B setiathome 
for the first time. The first time you run 
.B setiathome 
it will interactively
ask you for email address, name, country etc. 
This info is stored 
in a file and no interaction is needed when you run the program 
subsequently.
.LP
After this you can run 
.B setiathome 
in the background, and direct its output to /dev/null if you like.
.LP
.B setiathome 
can be freely aborted and restarted. It saves its state in files, 
and will pick up where it left off.
.LP
If you wish 
.B setiathome 
to be started automatically, you may wish to setup a cron job. 
If you add the following line to your crontab:
.LP
.nf
0 * * * * cd SETIDIR; setiathome -nice 19 > /dev/null 2> /dev/null
.fi
.LP
(where SETIDIR is the directory chosen above  - where you normally run
the client program from),
this cron job will attempt to start the client
at the top of every hour.  If it is already running, the next
invocation will do nothing.  If the client is not running, it will
be started.  For more information on cron jobs see the 
.BR crontab(1)
manual page.
.LP
If the environment variable HTTP_PROXY is defined, setiathome will
connect through a proxy server, specified as hostname or hostname:port.

.ne 5
.SH OPTIONS
.TP
.B \-login
Login or create new account.
.ne 3
.TP
.B \-countries
Show list of country codes.
.ne 3
.TP    
.B \-version
show software version
.ne 3
.TP        
.B \-nice  \ N
set "nice" priority to N (default 1);
.ne 3
.TP    
.B \-email
Send email (to login email address) on errors.
Useful if you run in background directed to /dev/null.
.ne 3
.TP    
.B \-proxy \ hostname:port
Connect to SETI@home server via specified proxy server and port.
.ne 3
.TP    
.B \-stop_after_process
stop after processing current work unit.
Do not send result.
.ne 3
.TP    
.B \-stop_after_xfer
stop after current work unit has been sent to the SETI
server and a new work unit has been obtained.
(see also: stop_after_send.txt mentioned in FILES below)

.SH FILES
.LP
The program generates several files with .txt extension
in the directory from which it's run. These should not be modified.
.LP
If you want to run multiple instances of setiathome
(on a multiprocessor machine, or on multiple machines
that share a filesystem) each one must be run
in a different directory.
.LP
.B setiathome 
uses a lock file (lock.txt) to prevent
multiple instances from running in the same directory.
.LP
To finish up your current work unit, return your result, and not
download a new work unit, while the client is running, touch
a file named "stop_after_send.txt" in the client directory.
When the processing is finished, and the result sent, the
client will stop.
.SH AUTHOR
This manual page was written by Gopal Narayanan
<gopal@debian.org>,
for the Debian GNU/Linux system (but may be used by others). This
manual page is mostly derived from the README file that accompanies the 
.B setiathome
client program.





