#include "forms.h"
#include "matpt.h"
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <ctype.h>
#ifndef MAIN
#include "seaview.h"
#else

#define MAX_GAP_SITES 200

typedef struct {
	int pos;
	int l[2];
	} gap_site;

void my_watch_cursor(Window win)
{
fl_set_cursor(win, XC_watch); 
XFlush(fl_get_display());
}
	
#endif

#define MAXSEQLENGTH 10000 /* pas utilise pour interface avec seaview */
#define MAXSEGMENTS 20000
#define segment_x_ou_y(num, offset) \
			(*(int *)(((char *)(segments + num)) + offset))
/* globals */
struct segment {
	int x, y, longueur;
	};
static struct segment segments[MAXSEGMENTS+1];
gap_site gap_sites[MAX_GAP_SITES];

/* prototypes */
FD_matpt *create_form_matpt(int);
static void err_message(char *text);
static char *check_alloc(int nbrelt, int sizelt);
void log_to_phys(int lx, int ly, int *px, int *py, FD_matpt *matpt);
void phys_to_log(int px, int py, int *lx, int *ly, FD_matpt *matpt);
void reset_mat_data(FD_matpt *matpt);
void reset_sliders_data(FD_matpt * matpt);
void init_mat_data(FD_matpt * matpt, int seqlong1, int seqlong2,
	char *seqname1, char *seqname2, char *seq1, char *seq2, char *name,
	int maxseqlength);
void set_size_data(FD_matpt *matpt);
void compute_region_text(FD_matpt *matpt);
void draw_rect(FD_matpt *matpt, int has_old);
int mat_handle_proc(FL_OBJECT *ob, int event, FL_Coord x, FL_Coord y,
	int key, void *xevent);
void center_view_on_hit(FD_matpt *matpt);
void magnify_reduce_proc(FL_OBJECT *ob, long data);
void change_comput_params(FL_OBJECT *ob, long data);
void compute_proc(FL_OBJECT *ob, long data);
void interrupt_callback(FL_OBJECT *ob, long data);
void ps_draw_line(int x1, int y1, int x2, int y2, FD_matpt *matpt,
	FILE *plotfile);
void ps_set_mat_data(FD_matpt *matpt);
void plot_button_proc(FL_OBJECT *ob, long data);
int really_close(FD_matpt *matpt);
void exit_button_proc(FL_OBJECT *ob, long data);
int dotplot_close_callback(FL_FORM *form, void *data);
void move_mat_proc(FL_OBJECT *ob, long data);
void move_box_step(FL_OBJECT *ob, long data);
void region_size_proc(FL_OBJECT *ob, long data);
char *readseq(FILE *infile, int *slong, char **seqname);
char *readseqfile(char *fname, int *seqlong1, int *seqlong2,
	char **name1, char **name2, char **seq1, char **seq2);
int compute_diags(FD_matpt *matpt, int *erreur, char **errmess);
void compute_title(FD_matpt *matpt);
int find_next_gap_site(int pos, gap_site *gap_sites, int tot_gap_sites);
void new_gap_site(int pos, int l, gap_site *gap_sites, int *p_tot_gap_sites,
	int seqrank);
int delete_gaps_bef_pos(char *seq, int pos, int number, int length, 
	int totsegments, int offset);
int insert_gaps_bef_pos(char *seq, int pos, int number, int length, 
	int totsegments, int offset, int maxlen);
int dispatch_gaps_bef(int pos, int number, char *seq, gap_site * gap_sites, 
	int *p_tot_gap_sites, int offset, int seqlen, int totsegments,
	int seqrank, char *other_seq, int *other_seqlen, int other_offset,
	int maxlen);
#ifndef MAIN
void align_callback(FL_OBJECT *ob, long data);
void choice_ref_seq_callback(FL_OBJECT *ob, long data);
void record_alignment_callback(FL_OBJECT *ob, long data);
extern int insert_gaps_at(SEA_VIEW *view, int seq, int site, int total);
extern void update_current_seq_length(int newlength, SEA_VIEW *view);
#endif

/* external prototypes */


#ifdef MAIN
int main(int argc, char *argv[])
{
   FD_matpt *matpt;
   int seqlong1, seqlong2;
   char *seqname1, *seqname2;
   char *seq1, *seq2, *fname, *mess;

   fl_initialize(&argc, argv, 0, 0, 0);
   if( argc == 1) {
	fname = (char *)fl_show_fselector(
		"Choisir un fichier de seqs format acnuc", "", "", "");
	if(fname == NULL) exit(0);
	}
   else	fname = argv[1];
   matpt = create_form_matpt(FALSE);
	matpt->totsegments = -1;
	matpt->need_compute = FALSE;
	mess = readseqfile(fname, &seqlong1, &seqlong2, &seqname1, &seqname2,
		&seq1, &seq2);
	if(mess != NULL) {
		fl_show_alert(mess, "", "", TRUE);
		exit(0);
		}
	init_mat_data(matpt, seqlong1, seqlong2, seqname1, seqname2,
		seq1, seq2, fname, 0);
	set_size_data(matpt);
   /* show the first form */
   fl_show_form(matpt->form, FL_PLACE_FREE_CENTER, FL_FULLBORDER, "matpt");
	compute_title(matpt);
	fl_call_object_callback(matpt->compute_butt);
   fl_do_forms();
   return 0;
}

#else

void show_dot_plot(char *seq1, char *seq2, char *seqname1, char *seqname2,
	int l1, int l2, int maxseqlength, void *seaview_data)
{
static int first = TRUE;
static FD_matpt *matpt;
char *new_seq1, *new_seq2;
static char *old_seq1, *old_seq2;
SEA_VIEW *view = (SEA_VIEW *)seaview_data;
if(first) {
	first = FALSE;
   	matpt = create_form_matpt(view->reducefonts);
	fl_set_form_atclose(matpt->form, dotplot_close_callback, matpt);
	matpt->seq1 = matpt->seq2 = NULL;
	matpt->seaview_data = seaview_data;
	old_seq1 = NULL; old_seq2 = NULL;
	if(view->protein) {
		fl_set_input(matpt->win_size_type_box, "10");
		fl_set_input(matpt->ident_type_box, "5");
		}
	}
if(matpt->seq1 == NULL || seq1 != old_seq1 || seq2 != old_seq2) {
	if(matpt->seq1 != NULL) {
		free(matpt->seq1+1);
		free(matpt->seq2+1);
		}
	new_seq1 = (char *)malloc(maxseqlength+1); memcpy(new_seq1, seq1, l1+1);
	new_seq2 = (char *)malloc(maxseqlength+1); memcpy(new_seq2, seq2, l2+1);
	init_mat_data(matpt, l1, l2, seqname1, seqname2, 
		new_seq1 - 1, new_seq2 - 1, view->masename, maxseqlength);
	set_size_data(matpt);
	old_seq1 = seq1; old_seq2 = seq2;
	}
compute_region_text(matpt);
if(matpt->form->visible) {
	my_open_and_raise_form(matpt->form);
	}
else	 
	fl_show_form(matpt->form, FL_PLACE_FREE, FL_FULLBORDER, "Dot Plot");
compute_title(matpt);
}

#endif

FD_matpt *create_form_matpt(int reducefonts)
{
  FL_OBJECT *obj;
  FD_matpt *fdui = (FD_matpt *) fl_calloc(1, sizeof(*fdui));
  static char def_title[] = "Dot Plot";

  fdui->form = fl_bgn_form(FL_NO_BOX, 680, 815);
  obj = fl_add_box(FL_UP_BOX,0,0,680,820,"");

  obj = fl_add_button(FL_NORMAL_BUTTON,10,10,80,20,"Fit to window");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj,magnify_reduce_proc,1);
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,100,10,50,20,"Reduce");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj,magnify_reduce_proc,2);
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,160,10,50,20,"Magnify");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj,magnify_reduce_proc,3);
	obj->u_vdata = fdui;
  obj = fl_add_input(FL_INT_INPUT,280,10,40,20,"Window size:");
    if(reducefonts) fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_North);
    fl_set_object_resize(obj, FL_RESIZE_X);
    fl_set_object_callback(obj,change_comput_params,0);
    fl_set_input(obj, "20");
	fdui->win_size_type_box = obj;
	obj->u_vdata = fdui;
  obj = fl_add_input(FL_INT_INPUT,420,10,50,20,"# matches/window:");
    if(reducefonts) fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_gravity(obj, FL_North, FL_NorthEast);
    fl_set_object_resize(obj, FL_RESIZE_X);
    fl_set_object_callback(obj,change_comput_params,0);
    fl_set_input(obj, "13");
	fdui->ident_type_box = obj;
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,480,10,60,20,"Compute");
    fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj,compute_proc,0);
	fdui->compute_butt = obj;
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,545,10,90,20,"Write Postscript");
    fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj,plot_button_proc,0);
	obj->u_vdata = fdui;
#ifdef MAIN
#define EXIT_LABEL "Exit"
#else
#define EXIT_LABEL "Close"
#endif
  obj = fl_add_button(FL_NORMAL_BUTTON,635,10,40,20,EXIT_LABEL);
    fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj,exit_button_proc,0);
	obj->u_vdata = fdui;
	fdui->title = def_title;
#ifdef MAIN
	fdui->align_button = NULL;
#else
  obj = fl_add_button(FL_NORMAL_BUTTON,10,31,45,18,"Align");
    fl_set_object_boxtype(obj,FL_UP_BOX);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj, align_callback, 0);
	obj->u_vdata = fdui;
	fdui->align_button = obj;
  obj = fl_add_button(FL_NORMAL_BUTTON,60,31,90,18,"Record alignment");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj,record_alignment_callback,0);
	obj->u_vdata = fdui;
  obj = fl_add_choice(FL_DROPLIST_CHOICE,250,31,150,18,"Ref. sequence");
    if(reducefonts) fl_set_object_lsize(obj, FL_TINY_SIZE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj, choice_ref_seq_callback, 0);
	obj->u_vdata = fdui;
	fdui->choice_ref_seq = obj;
  obj = fl_add_button(FL_NORMAL_BUTTON,615,31,60,18,"Interrupt");
    fl_set_object_boxtype(obj,FL_UP_BOX);
    fl_set_object_gravity(obj, FL_NorthEast, FL_NorthEast);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_callback(obj, interrupt_callback, 0);
	obj->u_vdata = fdui;
	fdui->interrupt_butt = obj;
#endif
  obj = fl_add_button(FL_NORMAL_BUTTON,5,50,20,20,"@<-");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_callback(obj,move_box_step,1);
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,25,50,20,20,"@->");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_callback(obj,move_box_step,2);
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,5,70,20,20,"@1->");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_callback(obj,move_box_step,3);
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,25,70,20,20,"@9->");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_callback(obj,move_box_step,4);
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,5,90,20,20,"@2->");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_callback(obj,move_box_step,5);
	obj->u_vdata = fdui;
  obj = fl_add_button(FL_NORMAL_BUTTON,25,90,20,20,"@8->");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthWest);
    fl_set_object_resize(obj, FL_RESIZE_NONE);
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_callback(obj,move_box_step,6);
	obj->u_vdata = fdui;

  obj = fl_add_box(FL_FRAME_BOX,50,50,625,60,"");
    fl_set_object_lalign(obj,FL_ALIGN_LEFT | FL_ALIGN_INSIDE);
if(reducefonts)
    fl_set_object_lsize(obj,FL_MEDIUM_SIZE);
else
    fl_set_object_lsize(obj,FL_LARGE_SIZE);
    fl_set_object_lstyle(obj,FL_FIXED_STYLE);
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthEast);
    fl_set_object_resize(obj, FL_RESIZE_X);
	fdui->region_box = obj;
  obj = fl_add_slider(FL_HOR_FILL_SLIDER,150,110,525,20,"");
    fl_set_object_gravity(obj, FL_NorthWest, FL_NorthEast);
    fl_set_object_resize(obj, FL_RESIZE_X);
    fl_set_object_callback(obj,region_size_proc,0);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
    fl_set_slider_bounds(obj, 4, 50);
    fl_set_slider_value(obj, 10);
	fdui->region_slider = obj;
	obj->u_vdata = fdui;

  obj = fl_add_slider(FL_VERT_SLIDER,655,140,20,640,"");
    fl_set_object_gravity(obj, FL_NorthEast, FL_SouthEast);
    fl_set_object_resize(obj, FL_RESIZE_Y);
    fl_set_object_callback(obj,move_mat_proc,1);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
	fdui->y_slider = obj;
	obj->u_vdata = fdui;
  obj = fl_add_slider(FL_HOR_SLIDER,10,785,640,20,"");
    fl_set_object_gravity(obj, FL_SouthWest, FL_SouthEast);
    fl_set_object_resize(obj, FL_RESIZE_X);
    fl_set_object_callback(obj,move_mat_proc,2);
    fl_set_slider_return(obj, FL_RETURN_CHANGED);
	fdui->x_slider = obj;
	obj->u_vdata = fdui;

/* mat_panel */
  obj = fl_add_frame(FL_ENGRAVED_FRAME,10,140,640,640,"");
    fl_set_object_gravity(obj, FL_North, FL_SouthEast);
  obj = fl_add_free(FL_NORMAL_FREE,10,140,640,640,"", mat_handle_proc);
    fl_set_object_gravity(obj, FL_North, FL_SouthEast);
    fl_set_object_color(obj, FL_BLACK, FL_GRAY90);
	fdui->mat_panel = obj;
	obj->u_vdata = fdui;
#ifndef MAIN
	fdui->gap_sites = gap_sites;
#endif
  fl_end_form();

  return fdui;
}


static void err_message(char *text)
{
fl_show_alert(text, "", "", TRUE);
exit(1);
}

static char *check_alloc(int nbrelt, int sizelt)
{
char *retval;
if( (retval = (char *)calloc(nbrelt,sizelt)) != NULL ) return retval;
err_message("ERROR: I cannot obtain enough memory.");
}


void log_to_phys(int lx, int ly, int *px, int *py, FD_matpt *matpt)
{
*px = floor(lx * matpt->factor + matpt->kx + 0.5);
*py = floor( - ly * matpt->factor + matpt->ky + 0.5);
}


void phys_to_log(int px, int py, int *lx, int *ly, FD_matpt *matpt)
{
*lx = floor( (px - matpt->kx) / matpt->factor + 0.5 );
*ly = floor( (matpt->ky - py) / matpt->factor + 0.5 );
}


void reset_mat_data(FD_matpt *matpt)
{
int a, b, c, d;
matpt->factor = ((double) matpt->phys_width) / matpt->view_size;
a = matpt->view_x; b = a + matpt->view_size; 
c = matpt->mat_panel->x + matpt->margin; d = c + matpt->phys_width;
matpt->kx = (b*c - a*d) / (double) matpt->view_size;
a = matpt->view_y; b = a + matpt->view_size; 
c = matpt->mat_panel->y + matpt->mat_panel->h - matpt->margin; 
d = c - matpt->phys_width;
matpt->ky = (b*c - a*d) / (double) matpt->view_size;
}


void reset_sliders_data(FD_matpt * matpt)
{
fl_set_slider_bounds(matpt->x_slider, 0, matpt->longmax - matpt->view_size);
fl_set_slider_size(matpt->x_slider, matpt->view_size / (double)matpt->longmax);
fl_set_slider_step(matpt->x_slider, 1);
fl_set_slider_bounds(matpt->y_slider, - (matpt->longmax - matpt->view_size), 0);
fl_set_slider_size(matpt->y_slider, matpt->view_size / (double)matpt->longmax);
fl_set_slider_step(matpt->y_slider, 1);
fl_set_slider_value(matpt->x_slider, matpt->view_x);
fl_set_slider_value(matpt->y_slider, - matpt->view_y);
}


void init_mat_data(FD_matpt * matpt, int seqlong1, int seqlong2,
	char *seqname1, char *seqname2, char *seq1, char *seq2, char *name,
	int maxseqlength)
{
const int margin = 5;
int fenetre, identites;

matpt->longmax = FL_max(seqlong1, seqlong2);
matpt->margin = margin;
matpt->seqlong1 = seqlong1;
matpt->seqlong2 = seqlong2;
matpt->seq1 = seq1;
matpt->seq2 = seq2;
matpt->seqname1 = seqname1;
matpt->seqname2 = seqname2;
matpt->view_x = matpt->view_y = 0;
matpt->view_size = matpt->longmax;
sscanf( fl_get_input(matpt->win_size_type_box), "%d", &fenetre);
matpt->fenetre = fenetre;
sscanf( fl_get_input(matpt->ident_type_box), "%d", &identites);
matpt->identites = identites;
matpt->region_size = fenetre;
matpt->hitx = seqlong1/2;
matpt->hity = seqlong2/2;
matpt->totsegments = -1;
matpt->need_compute = FALSE;
matpt->modif_but_not_saved = FALSE;
matpt->plotname = (char *)malloc(strlen(name) + 1);
strcpy(matpt->plotname, name);
if(matpt->align_button != NULL) {
	char temp[200];
	sprintf(temp, "align to %s|align to %s", seqname1, seqname2);
	fl_clear_choice(matpt->choice_ref_seq);
	fl_addto_choice(matpt->choice_ref_seq, temp);
	fl_set_choice(matpt->choice_ref_seq, 0);
#ifndef MAIN
	matpt->tot_gap_sites = 0;
#endif
	matpt->maxseqlength = maxseqlength;
	}
}


void set_size_data(FD_matpt *matpt)
{
matpt->phys_width = FL_min(matpt->mat_panel->w, matpt->mat_panel->h) - 
	2 * matpt->margin;
reset_mat_data(matpt);
reset_sliders_data(matpt);
}


void compute_region_text(FD_matpt *matpt)
{
int i, matches=0, l;
char *p;

if(matpt->longmax == 0) return;
p = matpt->regionboxtext;
sprintf(p, "%5d ", matpt->hitx);
l = FL_min(matpt->region_size, matpt->seqlong1 - matpt->hitx + 1);
l = FL_min(l, matpt->seqlong2 - matpt->hity + 1);
memcpy(p+6, (matpt->seq1 + matpt->hitx), l);
*(p + l + 6) = '\n';
p += l + 7;

strcpy(p, "      ");
for(i=0; i < l; i++) {
	if( *(matpt->seq1 + matpt->hitx + i) ==
		 *(matpt->seq2 + matpt->hity + i)  &&
		 *(matpt->seq2 + matpt->hity + i) != '-' ) {
		*(p + i + 6) = '|';
		matches++;
		}
	else
		*(p + i + 6)=' ';
	}
sprintf(p,"%d/%d", matches, matpt->region_size);
*(p + strlen(p)) = ' ';
*(p + 6 + l)='\n';
p += l + 7;

sprintf(p, "%5d ", matpt->hity);
memcpy(p+6, (matpt->seq2 + matpt->hity), l);
*(p + l + 6)='\0';
fl_set_object_label(matpt->region_box, matpt->regionboxtext);
}


void draw_rect(FD_matpt *matpt, int has_old)
{
#undef DRAWMODE_KNOWN
#ifdef FL_INCLUDE_VERSION
#if FL_INCLUDE_VERSION >= 81
#define DRAWMODE_KNOWN
#endif
#endif
int px, py, pxf, pyf;
static rectangle old_rect;
#ifndef DRAWMODE_KNOWN
GC gc = fl_state[fl_vmode].gc[0];
Display *disp = fl_get_display();
#endif

fl_set_clipping(matpt->mat_panel->x, matpt->mat_panel->y, 
	matpt->mat_panel->w, matpt->mat_panel->h);
/* sous v 0.81 utiliser fl_drawmode(GXinvert); qui marche bien */
#ifndef DRAWMODE_KNOWN
XSetFunction(disp, gc, GXinvert); /*GXxor marche aussi et fait presque pareil */
#else
fl_drawmode(GXinvert);
#endif
if(has_old) { /* erase old rectangle */
	fl_rectangle(0, old_rect.x, old_rect.y, old_rect.w, old_rect.h, 
		FL_BLACK);
	}
log_to_phys(matpt->hitx, matpt->hity, &px, &py, matpt);
log_to_phys(matpt->hitx + matpt->region_size, matpt->hity + matpt->region_size, 
	&pxf, &pyf, matpt);
old_rect.x = px; old_rect.y = py; 
old_rect.w = pxf - px; old_rect.h = pyf - py;
fl_rectangle(0, old_rect.x, old_rect.y, old_rect.w, old_rect.h, FL_BLACK);
#ifndef DRAWMODE_KNOWN
XSetFunction(disp, gc, GXcopy);
#else
fl_drawmode(GXcopy);
#endif
/* sous v 0.81 utiliser fl_drawmode(GXcopy); qui marche bien */
fl_unset_clipping();
}


int mat_handle_proc(FL_OBJECT *ob, int event, FL_Coord x, FL_Coord y,
	int key, void *xevent)
{
FD_matpt *matpt = (FD_matpt *)ob->u_vdata;
static int erreur = FALSE;
static char *errmess;

switch (event)
{
case FL_DRAW:
	{
	int i, pxd, pyd, pxf, pyf;
	static int old_w = 0, old_h = 0;
	if( ob->w != old_w || ob->h != old_h ) { /* was resized */
		old_w = ob->w; old_h = ob->h;
		set_size_data(matpt);
		compute_region_text(matpt);
		fl_set_slider_value(matpt->region_slider, matpt->region_size);
		fl_redraw_form(ob->form);
		return 0;
		}
	fl_rectangle(1, ob->x, ob->y, ob->w, ob->h, ob->col2);
#ifndef MAIN 
/* draw the diagonal line */
	if( ( (SEA_VIEW *) matpt->seaview_data )->numb_gc > 1) {
/* in red on color displays */
		log_to_phys(0, 0, &pxd, &pyd, matpt);
		i = FL_min(matpt->seqlong1, matpt->seqlong2);
		log_to_phys(i, i, &pxf, &pyf, matpt);
		fl_simple_line(pxd, pyd, pxf, pyf, FL_RED);
		}
	else	{
/* as a dotted line on B&W displays */
		int p, q;
		log_to_phys(0, 0, &pxd, &pyd, matpt);
		i = FL_min(matpt->seqlong1, matpt->seqlong2);
		log_to_phys(i, i, &pxf, &pyf, matpt);
		q = pyd;
		for(p=pxd; p<=pxf; p += 2) {
			fl_line(p, q, p, q, FL_BLACK);
			q -= 2;
			}
		}
#endif
	log_to_phys(0, 0, &pxd, &pyd, matpt);
	log_to_phys(matpt->seqlong1, 0, &pxf, &pyf, matpt);
	fl_simple_line(pxd, pyd, pxf, pyf, FL_BLACK);
	log_to_phys(0, matpt->seqlong2, &pxf, &pyf, matpt);
	fl_simple_line(pxd, pyd, pxf, pyf, FL_BLACK);
	if(matpt->need_compute) {
		matpt->totsegments = compute_diags(matpt, &erreur, &errmess);
		if(erreur) break;
		}
	else	{
		for (i = 0; i <= matpt->totsegments; i++) {
			log_to_phys(segments[i].x,
				segments[i].y, 
				&pxd, &pyd, matpt);
			log_to_phys(segments[i].x+segments[i].longueur, 
				segments[i].y+segments[i].longueur, 
				&pxf, &pyf, matpt);
			fl_simple_line(pxd, pyd, pxf, pyf, FL_BLACK);
			}
		}
	draw_rect(matpt, FALSE);
	break;
	}
case FL_PUSH:
	{
	int lx, ly;
	if(erreur) {
		fl_show_message("", errmess, "");
		erreur = FALSE;
		break;
		}
	phys_to_log(x, y, &lx, &ly, matpt);
	if(lx <= 0 || ly <= 0 || lx > matpt->seqlong1 || ly > matpt->seqlong2)
		break;
	matpt->hitx = lx; matpt->hity = ly;
	draw_rect(matpt, TRUE);
	compute_region_text(matpt);
	fl_redraw_object(matpt->region_box);
	break;
	}
}
return 0;
}


void center_view_on_hit(FD_matpt *matpt)
{
int newval;
newval = matpt->hitx + (matpt->region_size - matpt->view_size) / 2;
newval = FL_min( FL_max(newval, 0), matpt->longmax - matpt->view_size);
matpt->view_x = newval;
newval = matpt->hity + (matpt->region_size - matpt->view_size) / 2;
newval = FL_min( FL_max(newval, 0), matpt->longmax - matpt->view_size);
matpt->view_y = newval;
reset_mat_data(matpt);
reset_sliders_data(matpt);
}


void magnify_reduce_proc(FL_OBJECT *ob, long data)
{
const double zoom = 2;
FD_matpt *matpt = (FD_matpt *)ob->u_vdata;

if( data == 3 ) { 	/* magnify */
	matpt->view_size /= zoom;
	}
else if ( data == 1 ) { /* fit to window */
	matpt->view_size = matpt->longmax;
	}
else	{ 		/* reduce */
	matpt->view_size = FL_min( matpt->view_size * zoom, matpt->longmax );
	}
center_view_on_hit(matpt);
fl_redraw_object(matpt->mat_panel);
fl_redraw_object(matpt->x_slider);
fl_redraw_object(matpt->y_slider);
}


void change_comput_params(FL_OBJECT *ob, long data)
{
char *p;
int value = -1;
FD_matpt *fdui = (FD_matpt *)ob->u_vdata;

p= (char *)fl_get_input(ob);
sscanf(p,"%d",&value);
if(value<=0 || value>50) {
	fl_set_input(ob,"??");
	value = -1;
	}
if(ob == fdui->win_size_type_box)
	fdui->fenetre = value;
else
	fdui->identites = value;
if(fdui->identites > fdui->fenetre && fdui->fenetre>0) {
	char tmp[10];
	fdui->identites = fdui->fenetre;
	sprintf(tmp,"%d", fdui->identites);
	fl_set_input(fdui->ident_type_box, tmp);	
	}
}


void compute_proc(FL_OBJECT *ob, long data)
{
FD_matpt *fdui = (FD_matpt *)ob->u_vdata;
change_comput_params(fdui->win_size_type_box, 0);
change_comput_params(fdui->ident_type_box, 0);
if(fdui->fenetre == -1 || fdui->identites == -1) return;
my_watch_cursor(ob->form->window);
fdui->need_compute = TRUE;
fdui->interrupted = FALSE;
fl_redraw_object( fdui->mat_panel);
if(!fdui->form->visible) return;
fdui->region_size = fdui->fenetre;
fl_set_slider_value(fdui->region_slider, fdui->region_size);
compute_region_text(fdui);
fl_redraw_object(fdui->region_box);
fl_redraw_object(fdui->region_slider);
fl_reset_cursor(ob->form->window);
}


void interrupt_callback(FL_OBJECT *ob, long data)
{
FD_matpt *fdui = (FD_matpt *)ob->u_vdata;
fdui->interrupted = TRUE;
fl_reset_cursor(ob->form->window);
}


void ps_draw_line(int x1, int y1, int x2, int y2, FD_matpt *matpt,
	FILE *plotfile)
{
int px, py;
px = floor(x1 * matpt->factor + matpt->kx + 0.5);
py = floor(y1 * matpt->factor + matpt->ky + 0.5);
fprintf(plotfile,"%d %d moveto ",px,py);
px = floor(x2 * matpt->factor + matpt->kx + 0.5);
py = floor(y2 * matpt->factor + matpt->ky + 0.5);
fprintf(plotfile,"%d %d lineto stroke\n",px,py);
}

void ps_set_mat_data(FD_matpt *matpt)
{
int a, b, c, d;
matpt->factor = ((double) matpt->phys_width) / matpt->view_size;
a = matpt->view_x; b = a + matpt->view_size; 
c = matpt->margin; d = c + matpt->phys_width;
matpt->kx = (b*c - a*d) / (double) matpt->view_size;
a = matpt->view_y; b = a + matpt->view_size; 
c = matpt->margin; 
d = c + matpt->phys_width;
matpt->ky = (b*c - a*d) / (double) matpt->view_size;
}


void plot_button_proc(FL_OBJECT *ob, long data)
{
FD_matpt *matpt = (FD_matpt *)ob->u_vdata;
int i;
char plotfname[150], *sp;
int old_phys;
FILE *plotfile;

strcpy(plotfname, matpt->plotname);
sp = strchr(plotfname,'.'); 
if( sp == NULL || strcmp(sp, ".ps") == 0 ) 
	sp = plotfname+strlen(plotfname);
strcpy(sp, ".ps");
plotfile=fopen(plotfname,"w");
if(plotfile == NULL) {
	fl_show_alert("Cannot write to file", plotfname, "", TRUE);
	return;
	}
fprintf(plotfile,"%%!\n1 setlinecap 1 setlinejoin 1 setlinewidth 0 setgray\n");
fprintf(plotfile,"/basefont /Helvetica findfont 12 scalefont def\n");
fprintf(plotfile,"basefont setfont\n");
fprintf(plotfile,"50 200 translate\n");
fprintf(plotfile,"-10 -10 moveto 510 -10 lineto 510 510 lineto -10 510 lineto \
-10 -10 lineto stroke\n");

old_phys = matpt->phys_width; matpt->phys_width = 500;
ps_set_mat_data(matpt);

ps_draw_line(0, 0, matpt->seqlong1, 0, matpt, plotfile);
ps_draw_line(0, 0, 0, matpt->seqlong2, matpt, plotfile);
for (i = 0; i <= matpt->totsegments; i++)	{
	ps_draw_line(segments[i].x, segments[i].y,
		segments[i].x+segments[i].longueur,
		segments[i].y+segments[i].longueur, matpt, plotfile);

	}
matpt->phys_width = old_phys;
reset_mat_data(matpt);

fl_show_message("Dot plot is now in file", plotfname, "in postscript format");
sprintf(plotfname,
	"Horizontal: %s (%d)  Vertical: %s (%d)  Window: %d Matches: %d",
	matpt->seqname1, matpt->seqlong1, matpt->seqname2, matpt->seqlong2, 
		matpt->fenetre, matpt->identites);
fprintf(plotfile,"-10 -30 moveto (%s) show\n",plotfname);
fprintf(plotfile,"showpage\n");
fclose(plotfile);
}


int really_close(FD_matpt *matpt)
{
int rep;
if(matpt->modif_but_not_saved) {
	rep =fl_show_question(
		"Changes in dot plot were not saved in alignment\n"
		"Do you really want to close the dot plot?", 1);
	if( ! rep) return FALSE;
	}
free(matpt->seq1 + 1);
free(matpt->seq2 + 1);
matpt->seq1 = matpt->seq2 = NULL;
return TRUE;
}


void exit_button_proc(FL_OBJECT *ob, long data)
{
#ifdef MAIN
exit(0);

#else
if( really_close( (FD_matpt *)ob->u_vdata ) )  fl_hide_form(ob->form);
#endif
}


int dotplot_close_callback(FL_FORM *form, void *data)
{
if( really_close( (FD_matpt *)data ) )  return FL_OK;
else return FL_IGNORE;
}


void move_mat_proc(FL_OBJECT *ob, long data)
{
FD_matpt *matpt = (FD_matpt *)ob->u_vdata;
double val;
val = fl_get_slider_value(ob);
if(data == 1)
	matpt->view_y = - val;
else
	matpt->view_x = val;
reset_mat_data(matpt);
fl_redraw_object(matpt->mat_panel);
}


void move_box_step(FL_OBJECT *ob, long data)
{
FD_matpt *matpt = (FD_matpt *)ob->u_vdata;
if(data == 1) {
	matpt->hitx = FL_max(matpt->hitx - 1, 1);
	}
else if(data == 2) {
	matpt->hitx = FL_min(matpt->hitx + 1, matpt->seqlong1);
	}
else if(data == 3) {
	matpt->hitx = FL_max(matpt->hitx - 1, 1);
	matpt->hity = FL_max(matpt->hity - 1, 1);
	}
else if(data == 4) {
	matpt->hitx = FL_min(matpt->hitx + 1, matpt->seqlong1);
	matpt->hity = FL_min(matpt->hity + 1, matpt->seqlong2);
	}
else if(data == 5) {
	matpt->hity = FL_max(matpt->hity - 1, 1);
	}
else	{
	matpt->hity = FL_min(matpt->hity + 1, matpt->seqlong2);
	}
draw_rect(matpt, TRUE);
compute_region_text(matpt);
fl_redraw_object(matpt->region_box);
}


void region_size_proc(FL_OBJECT *ob, long data)
{
FD_matpt *matpt = (FD_matpt *)ob->u_vdata;
matpt->region_size = fl_get_slider_value(ob);
draw_rect(matpt, TRUE);
compute_region_text(matpt);
fl_redraw_object(matpt->region_box);
}

#ifdef MAIN

char *readseq(FILE *infile, int *slong, char **seqname)
{
char *pos, *seq, *p;
int l;
long filepos;
static char line[500];

/* read seq name: first line with ; */
fgets(line, sizeof(line), infile);
l = strlen(line);
*seqname = (char *)malloc(l+1);
pos=line+1; l=0;
while(*pos!=' ' && *pos!='\n') {
	(*seqname)[l]=*pos;
	pos++; l++;
	}
(*seqname)[l]=0;
/* skip next ; lines if any */
while( ( pos=fgets(line,sizeof(line),infile) , *pos==';' ) )
	filepos=ftell(infile);
if(pos==NULL) err_message("Unknown sequence file format.");
seq=(char *)check_alloc(MAXSEQLENGTH+2,1);
pos=seq+1; *slong=0;
do	{
	l=strlen(line)-1;
	memcpy(pos,line,l); pos+=l; *slong += l;
	if(*slong >= MAXSEQLENGTH) err_message("Sequence is too long.");
	filepos=ftell(infile);
	p=fgets(line,sizeof(line),infile);
	}
while(p!=NULL && *p!=';');
seq[*slong+1]=0;
p=seq+1; while(*p) { *p=toupper(*p); if(*p=='U') *p='T'; p++; }
fseek(infile, filepos, SEEK_SET);
return seq;
}


char *readseqfile(char *fname, int *seqlong1, int *seqlong2,
	char **name1, char **name2, char **seq1, char **seq2)
{
FILE *infile;
static char line[100];

infile=fopen(fname,"r");
if(infile==NULL) {
	sprintf(line,"File not found: %s",fname);
	return line;
	}
*seq1 = readseq(infile, seqlong1, name1);
*seq2 = readseq(infile, seqlong2, name2);
return NULL;
}


/* dop plot simple pour sequences sans gaps */
int compute_diags(FD_matpt *matpt, int *erreur, char **errmess)
{
int lwin,  match,  seqlong1,  seqlong2;
char *seq1, *seq2;
int pxd, pyd, pxf, pyf;
int dmin, dmax, k, deb, fin, *it, i, pp, nmatch, finw, d, totsegments, kk,
	centre, flip;
static char err_mem[]="Not enough memory";
static char err_seg[]="Only part of the dot plot was computed";

matpt->need_compute = FALSE;
lwin = matpt->fenetre; match = matpt->identites; 
seqlong1 = matpt->seqlong1; seqlong2 = matpt->seqlong2;
seq1 = matpt->seq1; seq2 = matpt->seq2;

dmin = lwin-seqlong2; dmax = seqlong1-lwin-1;
totsegments= -1;
it = (int *)calloc( FL_max(seqlong1, seqlong2) + 1 , sizeof(int));
if(it == NULL) {
	*erreur = TRUE;
	*errmess = err_mem;
	return totsegments;
	}
centre = (dmin + dmax)/2; flip = 1;
for(kk = dmin + 1; kk <= dmax + 1; kk++) {
/* pour faire la boucle k = [dmin,dmax] en partant du centre et s'eloignant */
	flip = - flip;
	k = centre + ((kk - dmin)/2) * flip;
	deb= ( k>=0 ? k+1 : 1);
	fin= ( seqlong2+k >= seqlong1 ? seqlong1 : seqlong2+k);
	for(i = deb; i <= fin; i++) 
		it[i] = (seq1[i] == seq2[i-k] && seq1[i] != '-' ? 1 : 0);
	pp=it[deb];
	nmatch=0;
	for(i = deb; i < deb+lwin; i++) nmatch += it[i];
	if(nmatch>=match)
		it[deb]=1;
	else
		it[deb]=0;
	for(i = deb+1; i <= fin-lwin+1; i++) {
		nmatch += (it[i+lwin-1]-pp);
		pp=it[i];
		if(nmatch>=match)
			it[i]=1;
		else
			it[i]=0;
		}
	i=deb-1;
	finw=fin-lwin+1;
	while(i<finw) {
		i++;
		if(it[i]==0) continue;
		d=i;
		do	{
			i++;
			if(i>finw) break;
			}
		while(it[i]==1);
		if(totsegments>=MAXSEGMENTS) {
			*erreur = TRUE;
			*errmess = err_seg;
			goto fin;
			}
		totsegments++;
		segments[totsegments].x = d;
		segments[totsegments].y = d-k;
		segments[totsegments].longueur = i-d;
		log_to_phys(segments[totsegments].x,
			segments[totsegments].y, 
			&pxd, &pyd, matpt);
		log_to_phys(segments[totsegments].x + 
			segments[totsegments].longueur, 
			segments[totsegments].y+segments[totsegments].longueur, 
			&pxf, &pyf, matpt);
		fl_simple_line(pxd, pyd, pxf, pyf, FL_BLACK);
		}
	}
*erreur = FALSE;
fin:
free(it);
return totsegments;
}
#endif

void compute_title(FD_matpt *matpt)
{
static char title[100];
sprintf(title, "Horizontal: %s (%d)   Vertical: %s (%d)",
	matpt->seqname1, matpt->seqlong1, matpt->seqname2, matpt->seqlong2);
matpt->title = title;
fl_set_form_title(matpt->mat_panel->form, title);
}


int find_next_gap_site(int pos, gap_site *gap_sites, int tot_gap_sites)
{
int num;
for(num = 0; num < tot_gap_sites; num++)
	if(gap_sites[num].pos > pos) return num;
return -1;
}


void new_gap_site(int pos, int l, gap_site *gap_sites, int *p_tot_gap_sites,
	int seqrank)
{
int num, i;
for(num = 0; num < *p_tot_gap_sites; num++)
	if(gap_sites[num].pos >= pos) break;
if(num < *p_tot_gap_sites && gap_sites[num].pos == pos)
	gap_sites[num].l[seqrank-1] += l;
else 	{
	if(*p_tot_gap_sites >= MAX_GAP_SITES) return;
	if(num < *p_tot_gap_sites) {
		for(i = *p_tot_gap_sites; i > num; i--)
			gap_sites[i] = gap_sites[i - 1];
		}
	(*p_tot_gap_sites)++;
	gap_sites[num].pos = pos;
	gap_sites[num].l[0] = 0;
	gap_sites[num].l[1] = 0;
	gap_sites[num].l[seqrank-1] = l;
	}
}


int delete_gaps_bef_pos(char *seq, int pos, int number, int length, 
	int totsegments, int offset)
{
int i;
if(number == 0) return length;
memmove(seq + pos - number, seq + pos, length - pos + 2);
for(i=0; i <= totsegments; i++)
	if(segment_x_ou_y(i, offset) + segments[i].longueur - 1 >= pos ) 
		segment_x_ou_y(i, offset) -= number;
return length - number;
}


int insert_gaps_bef_pos(char *seq, int pos, int number, int length, 
	int totsegments, int offset, int maxlen)
{
int i;
if(length + number > maxlen) return length;
memmove(seq + pos + number, seq + pos, length - pos + 2);
memset(seq + pos, '-', number);
for(i=0; i <= totsegments; i++)
	if(segment_x_ou_y(i, offset) + segments[i].longueur - 1 >= pos ) 
		segment_x_ou_y(i, offset) += number;
return length + number;
}


int dispatch_gaps_bef(int pos, int number, char *seq, gap_site * gap_sites, 
	int *p_tot_gap_sites, int offset, int seqlen, int totsegments,
	int seqrank, char *other_seq, int *other_seqlen, int other_offset,
	int maxlen)
{
int site, lnextgap, other_rank, i, seuil;
site = find_next_gap_site(pos + number, gap_sites, *p_tot_gap_sites);
if(site != -1) {
	if(gap_sites[site].l[seqrank-1] >= number) {
		seqlen = delete_gaps_bef_pos(seq, gap_sites[site].pos, number, 
			seqlen, totsegments, offset);
		seqlen = insert_gaps_bef_pos(seq, pos, number, seqlen, 
			totsegments, offset, maxlen);
		gap_sites[site].l[seqrank-1] -= number;
		}
	else	{
		lnextgap = gap_sites[site].l[seqrank-1];
		other_rank = (seqrank == 1 ? 2 : 1);
		seqlen = delete_gaps_bef_pos(seq, gap_sites[site].pos, lnextgap,
			seqlen, totsegments, offset);
		*other_seqlen = insert_gaps_bef_pos(other_seq, 
			gap_sites[site].pos, 
			number - lnextgap, *other_seqlen, 
			totsegments, other_offset, maxlen);
		seqlen = insert_gaps_bef_pos(seq, pos, number, seqlen, 
			totsegments, offset, maxlen);
		gap_sites[site].l[seqrank-1] = 0;
		gap_sites[site].l[other_rank-1] += number - lnextgap;
		seuil = gap_sites[site].pos;
		for(i = 0; i < *p_tot_gap_sites; i++) {
			if(gap_sites[i].pos < seuil) continue;
			gap_sites[i].pos += number - lnextgap;
			}
		}
	}
else	{
	seqlen = insert_gaps_bef_pos(seq, pos, number, seqlen, totsegments, 
		offset, maxlen);
	}
new_gap_site(pos + number, number, gap_sites, p_tot_gap_sites, seqrank);
return seqlen;
}


#ifndef MAIN

void align_callback(FL_OBJECT *ob, long data)
{
int number, offset_1, offset_2;
FD_matpt *matpt = (FD_matpt *)ob->u_vdata;
if(matpt->hitx == matpt->hity) return;
fl_set_cursor(ob->form->window, XC_watch);
offset_1 = (char *)&(segments[0].x) - (char *)&(segments[0]);
offset_2 = (char *)&(segments[0].y) - (char *)&(segments[0]);
if(matpt->hitx > matpt->hity) {
	number = matpt->hitx - matpt->hity;
	matpt->seqlong2 = dispatch_gaps_bef(matpt->hity, number, 
		matpt->seq2, matpt->gap_sites, 
		&(matpt->tot_gap_sites), offset_2, matpt->seqlong2, 
		matpt->totsegments, 2, matpt->seq1, &matpt->seqlong1, offset_1,
		matpt->maxseqlength);
	matpt->hity = matpt->hitx;
	}
else 	{
	number = matpt->hity - matpt->hitx;
	matpt->seqlong1 = dispatch_gaps_bef(matpt->hitx, number, 
		matpt->seq1, matpt->gap_sites, 
		&(matpt->tot_gap_sites), offset_1, matpt->seqlong1, 
		matpt->totsegments, 1, matpt->seq2, &matpt->seqlong2, offset_2,
		matpt->maxseqlength);
	matpt->hitx = matpt->hity;
	}
matpt->longmax = FL_max(matpt->seqlong1, matpt->seqlong2);
center_view_on_hit(matpt);
fl_redraw_object(matpt->mat_panel);
fl_redraw_object(matpt->x_slider);
fl_redraw_object(matpt->y_slider);
compute_region_text(matpt);
fl_redraw_object(matpt->region_box);
compute_title(matpt);
matpt->modif_but_not_saved = TRUE;
fl_reset_cursor(ob->form->window);
}


void choice_ref_seq_callback(FL_OBJECT *ob, long data)
{
int rep;
if(fl_get_choice_maxitems(ob) == 0) return;
rep = fl_get_choice(ob);
fl_set_choice_item_mode(ob, 1, FL_PUP_NONE);
fl_set_choice_item_mode(ob, 2, FL_PUP_NONE);
if(rep != 0) fl_set_choice_item_mode(ob, rep, FL_PUP_CHECK);
}


void update_col_lines(int num, SEA_VIEW *view)
{
int l, col, i;
int (*calc_color_function)(int);

if(view->numb_gc == 1) return;
calc_color_function = ( view->protein ? 
				get_color_for_aa : get_color_for_base );
l = view->each_length[num];
for(col=0; col < view->numb_gc; col++) {
	memset(view->col_seq[num][col], ' ', l);
	view->col_seq[num][col][l]=0;
	}
for(i=0; i<l; i++) {
	col = calc_color_function( view->sequence[num][i] );
	view->col_seq[num][col][i] = view->sequence[num][i];
	}
}


void record_alignment_callback(FL_OBJECT *ob, long data)
{
int num1, num2, choice, site, need_big_gaps = FALSE, seqrank, num, ngaps,
	newlength;
FD_matpt *matpt = (FD_matpt *)ob->u_vdata;
SEA_VIEW *view = (SEA_VIEW *)matpt->seaview_data;
choice = fl_get_choice(matpt->choice_ref_seq);
if(choice == 0) {
	fl_show_message("Please, select which is the reference sequence",
		"", "");
	return;
	}
else 
	seqrank = choice;
fl_set_cursor(ob->form->window, XC_watch);
for(site = 0; site < matpt->tot_gap_sites; site++) {
	if(matpt->gap_sites[site].l[seqrank - 1] != 0) {
		need_big_gaps = TRUE;
		break;
		}
	}
for(num1 = 0; num1 < view->tot_seqs; num1++)
	if(view->sel_seqs[num1]) break;
for(num2 = num1 + 1; num2 < view->tot_seqs; num2++)
	if(view->sel_seqs[num2]) break;
memcpy(view->sequence[num1], matpt->seq1 + 1, matpt->seqlong1 + 1);
view->each_length[num1] = matpt->seqlong1;
update_col_lines(num1, view);
memcpy(view->sequence[num2], matpt->seq2 + 1, matpt->seqlong2 + 1);
view->each_length[num2] = matpt->seqlong2;
update_col_lines(num2, view);
if( need_big_gaps ) {
	newlength = FL_max(matpt->seqlong1, matpt->seqlong2);
	for(site = 0; site < matpt->tot_gap_sites; site++) {
		ngaps = matpt->gap_sites[site].l[seqrank-1];
		if( ngaps == 0) continue;
		for(num = 0; num < view->tot_seqs; num++) {
			if( view->sel_seqs[num] ) continue;
			insert_gaps_at(view, num+1, 
				matpt->gap_sites[site].pos - ngaps, ngaps);
			newlength = FL_max(newlength, view->each_length[num]);
			}
		matpt->gap_sites[site].l[seqrank-1] = 0;
		insert_region_part(view, matpt->gap_sites[site].pos - ngaps, 
			ngaps);
		}
	update_current_seq_length(newlength, view);
	fl_redraw_object(view->horsli);
	}
view->modif_but_not_saved = TRUE;
matpt->modif_but_not_saved = FALSE;
fl_redraw_object(view->DNA_obj);
fl_reset_cursor(ob->form->window);
}


/* dot plot pour sequences avec gaps:
les segments sont calcules sans les gaps
leurs coordonnees sont reportees sur les seqs avec gaps
puis ils sont coupes en autant de morceaux sans gap
*/
int compute_diags(FD_matpt *matpt, int *erreur, char **errmess)
{
int lwin,  match, seqlong1, seqlong2, longmax;
char *seq1, *seq2;
int pxd, pyd, pxf, pyf;
int dmin, dmax, k, deb, fin, *it, i, pp, nmatch, finw, d, totsegments, kk,
	centre, flip;
static char err_mem[]="Not enough memory";
static char err_seg[]="Only part of the dot plot was computed";
int *addgaps1, *addgaps2, deb1, deb2, fin1, fin2, lfrag;
char *p;
XEvent new_event;

matpt->need_compute = FALSE;
lwin = matpt->fenetre; match = matpt->identites; 
seqlong1 = matpt->seqlong1; seqlong2 = matpt->seqlong2;
seq1 = matpt->seq1; seq2 = matpt->seq2;

totsegments= -1;
/* calcul corresp coord sans gap -> coord avec gap */
addgaps1 = (int *)malloc( (seqlong1+2) * sizeof(int));
addgaps2 = (int *)malloc( (seqlong2+2) * sizeof(int));
if(addgaps1 == NULL || addgaps2 == NULL) {
	*erreur = TRUE;
	*errmess = err_mem;
	return totsegments;
	}
p = seq1; seqlong1 = 0;
while( *(++p) != 0) {
	if( *p == '-') continue;
	addgaps1[++seqlong1] = p - seq1;
	}
p = seq2; seqlong2 = 0;
while( *(++p) != 0) {
	if( *p == '-') continue;
	addgaps2[++seqlong2] = p - seq2;
	}

dmin = lwin-seqlong2; dmax = seqlong1-lwin-1;
longmax = FL_max(seqlong1, seqlong2);
it = (int *)malloc( (longmax + 2) * sizeof(int));
if(it == NULL) {
	*erreur = TRUE;
	*errmess = err_mem;
	return totsegments;
	}
centre = (dmin + dmax)/2; flip = 1;
for(kk = dmin + 1; kk <= dmax + 1; kk++) {
	if( XCheckWindowEvent(fl_display, matpt->form->window, ~(long)0, 
			&new_event)){
		XPutBackEvent(fl_display, &new_event);
		fl_check_forms();
		if(matpt->interrupted) break;
		if(!matpt->form->visible) {
			*erreur = TRUE;
			goto fin;
			}
		}
	
/* pour faire la boucle k = [dmin,dmax] en partant du centre et s'eloignant */
	flip = - flip;
	k = centre + ((kk - dmin)/2) * flip;
	deb= ( k>=0 ? k+1 : 1);
	fin= FL_min( seqlong2+k , seqlong1);
/* on met it[1] ssi bases egales dans les 2 seqs sur la diagonale k */
	for(i = deb; i <= fin; i++) 
		it[i] = (seq1[addgaps1[i]] == seq2[addgaps2[i-k]] ? 1 : 0);
	it[fin + 1] = 0;
/* on met it[1] ssi au moins match bases egales dans fenetre de taille lwin 
sur la diagonale k 
*/
	pp=it[deb];
	nmatch=0;
	for(i = deb; i < deb+lwin; i++) nmatch += it[i];
	if(nmatch>=match)
		it[deb]=1;
	else
		it[deb]=0;
	finw = fin-lwin+1;
	for(i = deb+1; i <= finw; i++) {
		nmatch += (it[i+lwin-1]-pp);
		pp=it[i];
		if(nmatch>=match)
			it[i]=1;
		else
			it[i]=0;
		}
	i=deb-1;
/* calcul de d = debut des runs de 1, i = suivant de la fin du run de 1 */
	while(i<finw) {
		i++;
		if(it[i]==0) continue;
		d=i;
		do	{
			i++;
			if(i>finw) break;
			}
		while(it[i]==1);
/* decoupage du segment sans gaps en autant de morceaux non coupes de gaps */
		deb1 = addgaps1[d]; deb2 = addgaps2[d-k]; lfrag = 0;
		do	{
			fin1 = deb1; fin2 = deb2;
			while(lfrag < i - d && seq1[fin1] != '-' && 
							seq2[fin2] != '-') {
				fin1++; fin2++; lfrag++;
				}
			fin1--; fin2--;
			if(totsegments>=MAXSEGMENTS) {
				*erreur = TRUE;
				*errmess = err_seg;
				goto fin;
				}
			totsegments++;
			segments[totsegments].x = deb1;
			segments[totsegments].y = deb2;
			segments[totsegments].longueur = fin1 - deb1 + 1;
			log_to_phys(segments[totsegments].x,
				segments[totsegments].y, 
				&pxd, &pyd, matpt);
			log_to_phys(segments[totsegments].x + 
				segments[totsegments].longueur, 
				segments[totsegments].y + 
				segments[totsegments].longueur, 
				&pxf, &pyf, matpt);
			fl_simple_line(pxd, pyd, pxf, pyf, FL_BLACK);
			deb1 = fin1+1; deb2 = fin2+1;
			while(seq1[deb1] == '-') deb1++;
			while(seq2[deb2] == '-') deb2++;
			}
		while(lfrag < i - d);
		}
	}
*erreur = FALSE;
fin:
free(it);
free(addgaps1); free(addgaps2);
return totsegments;
}

#endif
