/*
 * (C) Copyright Keith Visco 1999  All rights reserved.
 *
 * The program is provided "as is" without any warranty express or
 * implied, including the warranty of non-infringement and the implied
 * warranties of merchantibility and fitness for a particular purpose.
 * The Copyright owner will not be liable for any damages suffered by
 * you as a result of using the Program. In no event will the Copyright
 * owner be liable for any special, indirect or consequential damages or
 * lost profits even if the Copyright owner has been advised of the
 * possibility of their occurrence.
 */
package com.kvisco.xsl.functions;

import com.kvisco.xsl.*;
import com.kvisco.util.List;

/**
 * A class for representing function call
 * @author <a href="mailto:kvisco@ziplink.net">Keith Visco</a>
**/
public abstract class FunctionCall implements Expr {
    
    public static final String INVALID_NUMBER_PARAMS = 
        "invalid number of parameters for function: ";
        
    public static final String INVALID_RESULT =
        "unexpected result for function: ";
        
    private static String START_PARAMLIST = "(";
    private static String END_PARAMLIST   = ")";
    private static String EMPTY_PARAMLIST = "()";
    private static String PARAMETER_SEP   = ",";
    
    private List params;
    String name = "undefined";
    
    protected FunctionCall(String name) {
        params = new List();
        this.name = name;
    } //-- FunctionCall
    
    /**
     * Returns the type of Expr this Expr represents
     * @return the type of Expr this Expr represents
    **/
    public short getExprType() {
        return Expr.PRIMARY;
    } //-- getExprType
    
    
    /**
     * Returns the name of this function call
     * @return the name of this function call
    **/
    public String getFunctionName() {
        return this.name;
    } //-- getFunctionName
    
    protected List getParameterList() {
        return params;
    } //-- getParamList
    
    /**
     * Returns the String representation of this FunctionCall
     * @return the String representation of this FunctionCall
    **/
    public String toString() {
        StringBuffer sb = new StringBuffer(getFunctionName());
        sb.append(START_PARAMLIST);
        for (int i = 0; i < params.size(); i++) {
            if (i > 0) sb.append(PARAMETER_SEP);
            sb.append( params.get(i));
        }
        sb.append(END_PARAMLIST);
        return sb.toString();
    } //-- toString
    
    public void addExprParameter(Expr paramExpr) {
        params.add(paramExpr);
    } //-- addExprParameter
    
    public boolean removeExprParameter(Expr paramExpr) {
        return params.remove(paramExpr);
    } //-- removeExprParameter
    
} //-- FunctionCall