/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xsl.functions;

import com.kvisco.util.List;
import com.kvisco.xml.XMLUtil;
import com.kvisco.xsl.BooleanResult;
import com.kvisco.xsl.Expr;
import com.kvisco.xsl.ExprResult;
import com.kvisco.xsl.InvalidExprException;
import com.kvisco.xsl.ProcessorState;
import com.kvisco.xsl.StringExpr;
import com.kvisco.xsl.StringResult;
import com.kvisco.xsl.functions.FunctionCall;
import org.w3c.dom.Node;

public class SystemFunctionCall
extends FunctionCall {
    public static final short SYSTEM_PROPERTY = 1;
    public static final short FUNCTION_AVAILABLE = 2;
    private short fType = 1;

    public SystemFunctionCall() {
        super("system-property");
    }

    public SystemFunctionCall(short s) {
        super(SystemFunctionCall.getFunctionName(s));
        this.fType = s;
    }

    public ExprResult evaluate(Node node, ProcessorState processorState) throws InvalidExprException {
        List list = this.getParameterList();
        if (list.size() != 1) {
            throw new InvalidExprException("invalid number of parameters for function: " + this);
        }
        Expr expr = (Expr)list.get(0);
        StringResult stringResult = StringExpr.toStringResult(expr.evaluate(node, processorState));
        String string = stringResult.getValue();
        if (this.fType == 2) {
            String string2;
            String string3 = XMLUtil.getNameSpace(string);
            if (string3.length() == 0) {
                string3 = null;
            }
            return new BooleanResult(processorState.getScriptHandler(string2 = XMLUtil.getLocalPart(string), string3) != null);
        }
        return new StringResult(processorState.getProperty(string));
    }

    private static String getFunctionName(short s) {
        if (s == 2) {
            return "function-available";
        }
        return "system-property";
    }
}

