/*
 * Decompiled with CFR 0.152.
 */
package com.kvisco.xml;

import com.kvisco.xml.XMLPrinter;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLPrinter
extends XMLPrinter {
    public static final String BREAK = "BR";
    public static final String PARAGRAPH = "P";
    public static final String HORIZONTAL_RULE = "HR";
    public static final String IMAGE = "IMG";
    public static final String LIST_ITEM = "LI";
    public static final String META = "META";
    public static final String SCRIPT = "SCRIPT";
    public static final String AREA = "AREA";
    public static final String BASE = "BASE";
    public static final String BASEFONT = "BASEFONT";
    public static final String FRAME = "FRAME";
    public static final String INPUT = "INPUT";
    public static final String ISINDEX = "ISINDEX";
    public static final String LINK = "LINK";
    public static final String PARAM = "PARAM";
    private PrintWriter pw = null;
    private Hashtable specialElements = null;
    private boolean useFormat = false;

    public HTMLPrinter(PrintWriter printWriter) {
        this(printWriter, XMLPrinter.DEFAULT_INDENT);
    }

    public HTMLPrinter(PrintWriter printWriter, int n) {
        super(printWriter, n);
        super.setUnescapeCDATA(false);
        super.setUseEmptyElementShorthand(false);
        this.pw = printWriter;
        this.specialElements = HTMLPrinter.getSpecialElements();
    }

    private static Hashtable getSpecialElements() {
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        Boolean bl = new Boolean(true);
        hashtable.put(BREAK, bl);
        hashtable.put(HORIZONTAL_RULE, bl);
        hashtable.put(IMAGE, bl);
        hashtable.put(META, bl);
        hashtable.put(LIST_ITEM, bl);
        hashtable.put(PARAGRAPH, bl);
        hashtable.put(AREA, bl);
        hashtable.put(BASE, bl);
        hashtable.put(BASEFONT, bl);
        hashtable.put(FRAME, bl);
        hashtable.put(INPUT, bl);
        hashtable.put(ISINDEX, bl);
        hashtable.put(LINK, bl);
        hashtable.put(PARAM, bl);
        return hashtable;
    }

    protected boolean print(Node node, String string) {
        if (node == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case 9: {
                Document document = (Document)node;
                NodeList nodeList = document.getChildNodes();
                int n = 0;
                while (n < nodeList.getLength()) {
                    this.print(nodeList.item(n), string);
                    ++n;
                }
                break;
            }
            case 1: {
                Node node2;
                Element element = (Element)node;
                String string2 = element.getNodeName().toUpperCase();
                if (element.hasChildNodes() || this.specialElements.get(string2) == null) {
                    return super.print(node, string);
                }
                super.printStartTag(element.getNodeName(), element.getAttributes());
                if (!this.useFormat || (node2 = node.getNextSibling()) != null && node2.getNodeType() == 3) break;
                this.pw.println();
                return true;
            }
            case 4: {
                Node node3 = node.getParentNode();
                if (node3.getNodeType() == 1 && node3.getNodeName().equalsIgnoreCase(SCRIPT)) {
                    String string3 = ((CDATASection)node).getData();
                    super.printUTF8Chars(string3.toCharArray());
                    return false;
                }
                super.print(node, string);
                break;
            }
            default: {
                return super.print(node, string);
            }
        }
        return false;
    }

    public void setUseFormat(boolean bl) {
        super.setUseFormat(bl);
        this.useFormat = bl;
    }
}

