/*
 * Decompiled with CFR 0.152.
 */
package com.jtauber.fop.layout;

import com.jtauber.fop.layout.AreaContainer;
import com.jtauber.fop.layout.Box;
import com.jtauber.fop.layout.DisplaySpace;
import com.jtauber.fop.layout.FontInfo;
import com.jtauber.fop.layout.FontState;
import com.jtauber.fop.layout.Page;
import java.util.Vector;

public abstract class Area
extends Box {
    protected FontState fontState;
    protected Vector children = new Vector();
    protected int maxHeight;
    protected int currentHeight = 0;
    protected int contentRectangleWidth;
    protected int allocationWidth;
    protected AreaContainer areaContainer;
    protected Page page;

    public Area(FontState fontState) {
        this.fontState = fontState;
    }

    public Area(FontState fontState, int n, int n2) {
        this.fontState = fontState;
        this.allocationWidth = n;
        this.maxHeight = n2;
    }

    public void addChild(Box box) {
        this.children.addElement(box);
        box.parent = this;
    }

    public void addChildAtStart(Box box) {
        this.children.insertElementAt(box, 0);
        box.parent = this;
    }

    public void addDisplaySpace(int n) {
        this.addChild(new DisplaySpace(n));
        this.currentHeight += n;
    }

    public void end() {
    }

    public int getAllocationWidth() {
        return this.allocationWidth;
    }

    public Vector getChildren() {
        return this.children;
    }

    public int getContentWidth() {
        return this.contentRectangleWidth;
    }

    public FontInfo getFontInfo() {
        return this.page.getFontInfo();
    }

    public FontState getFontState() {
        return this.fontState;
    }

    public int getHeight() {
        return this.currentHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public Page getPage() {
        return this.page;
    }

    public void increaseHeight(int n) {
        this.currentHeight += n;
    }

    public void setPage(Page page) {
        this.page = page;
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
    }
}

