#ifndef __CONSOLE
#define __CONSOLE

#define CONSOLE_LINES_ONSCREEN 20
#define CONSOLE_LINES_BUFFER 128
#define CONSOLE_PROMPT "$"
#define CONSOLE_CURSOR_HOLLOW 1
#define CONSOLE_CURSOR_SOLID 2
#define CONSOLE_CURSOR_EMPTY 3

#define	CONSOLE_ACTIVATE_KEY	'`'
#define CONSOLE_SWITCH_KEY	'~'
#define CONSOLE_SCROLLUP_KEY	KEY_PGUP
#define CONSOLE_SCROLLDN_KEY	KEY_PGDN
#define CONSOLE_START_KEY	KEY_HOME
#define CONSOLE_END_KEY		KEY_END

#define CONSOLE_INPUT_SIZE	39


#ifdef	__cplusplus
extern "C" {
#endif

UINT8	console_init	(void);
void	console_cycle	(void);
void	report		(char *, ...);
void	console_prompt	(void);
void	console_lock	(void);

#ifdef __cplusplus
}
#endif

#endif //__CONSOLE
