/*
 *  Sarien AGI :: Copyright (C) 1998 Dark Fiber
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#ifdef NATIVE_WIN32
#include <io.h>
#else
#include <dir.h>
#endif

#include "sarien.h"
#include "agi.h"


UINT8 __file_exists(UINT8 *fname)
{
	UINT	rc;

	struct _finddata_t fdata;

	_D (("(\"%s\")", fname));
	fdata.attrib = _A_NORMAL | _A_ARCH | _A_RDONLY;
	rc = (0 >= _findfirst ((char*)fname, &fdata));

	return rc;
}



UINT8* __file_name(UINT8 *fname)
{
	UINT	rc;
	struct _finddata_t fdata;
	int f;
	short	l;

	_D (("(\"%s\")", fname));
	fdata.name[0]=0;
	fdata.attrib = _A_NORMAL;
	f = rc = _findfirst((char*)fname, &fdata);
	while (rc == 0)
	{
		rc = _findnext(f, &fdata);
		if(rc==0)
		{
			l=strlen(fdata.name);
			strlwr(fdata.name);
			if(strstr(fdata.name, (char*)"dir.")!=NULL)
			    rc=1;
		}
	}

	return (UINT8*)strdup((char*)fdata.name);
}


void fixpath(UINT8 flag, UINT8 *fname)
{
	/* _D (("(%d, %s)", flag, fname)); */
	strcpy((char*)path, (char*)gdir);

	if(*path && (path[strlen((char*)path)-1]!='\\' && path[strlen((char*)path)-1]!='/'))
	{
		if(path[strlen((char*)path)-1]==':')
			strcat((char*)path, ".\\");
		else
			strcat((char*)path, "\\");
	}
		    
	if(flag==1)
		strcat((char*)path, (char*)gname);

	strcat((char*)path, (char*)fname);
}
