/*
 *  Sarien AGI :: Copyright (C) 1998 Dark Fiber
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <string.h>
#include <glob.h>

#include "sarien.h"
#include "agi.h"


UINT8 __file_exists(UINT8 *fname)
{
	UINT rc;
	glob_t pglob;

	_D (("(\"%s\")", fname));
	rc = glob (fname, GLOB_ERR | GLOB_NOSORT, NULL, &pglob);
	if (!rc && pglob.gl_pathc <= 0)
		rc = -1;
	globfree (&pglob);

	return rc;
}



UINT8* __file_name(UINT8 *fname)
{
	UINT rc;
	glob_t pglob;
	char *s, *r = NULL;

	_D (("(\"%s\")", fname));
	rc = glob (fname, GLOB_ERR | GLOB_NOSORT, NULL, &pglob);
	if (!rc)
	{
		r = strdup (pglob.gl_pathv[0]);
		_D ((": found name \"%s\"", r));
	}

	globfree (&pglob);

	if ((s = strrchr (r, '/')))
		r = s + 1;

	return r;
}


void fixpath(UINT8 flag, UINT8 *fname)
{
	_D (("(%d, \"%s\")", flag, fname));

	strcpy((char*)path, (char*)gdir);

	if(*path && path[strlen((char*)path)-1]!='/')
		strcat((char*)path, "/");
		    
	if(flag==1)
		strcat((char*)path, (char*)gname);

	strcat((char*)path, (char*)fname);
	if(path[strlen((char*)path)-1]=='.')
		path[strlen((char*)path)-1]=0;
}
