/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include "sarien.h"
#include "agi.h"
#include "objects.h"
#include "console.h"

AGI_OBJECT		*objects;				/* objects in the game */
UINT32			num_objects;

UINT16 load_objects(UINT8 *fname)
{
	UINT16	ec=err_OK;
	FILE	*fp;
	UINT32	flen;
	UINT8	*mem;
	UINT16	count, so;
	int		padsize;

	if((game_flags&ID_AMIGA)==ID_AMIGA)
		padsize=4;
	else
		padsize=3;

	num_objects=0;
	objects=NULL;

	fixpath(NO_GAMEDIR, fname);
	report ("Loading objects: %s\n", path);
	if((fp=fopen((char*)path, "rb"))!=NULL)
	{
		fseek(fp, 0x0L, SEEK_END);
		flen=ftell(fp);
		fseek(fp, 0x0L, SEEK_SET);

		mem=(UINT8*)calloc(1, flen+32);
		if(mem!=NULL)
		{
			fread(mem, 1, flen, fp);

			/* check if first pointer exceeds file size
			   if so, its encrypted, else it is not */

			if(lohi_getword(mem)>flen)
			{
				report ("Decrypting objects... ");
				decrypt(mem, flen);
				report ("done.\n");
			}

			/* alloc memory for object list */
			/* byte 3 = number of animated objects
			   this is ignored.. ?? */

			num_objects=0;
			objects=NULL;
			if(lohi_getword(mem)/padsize<256)
			{
    			num_objects=lohi_getword(mem)/padsize;
    			objects=(AGI_OBJECT*)calloc(num_objects, sizeof(AGI_OBJECT));

    			if(objects!=NULL)
    			{
    				/* build the object list */
    				for(count=0, so=padsize; count<num_objects; count++, so+=padsize)
    				{
    					(objects+count)->location=lohi_getbyte(mem+so+2);

    					if( (lohi_getword(mem+so)+padsize) < flen)
    					{
	    					(objects+count)->name=(UINT8*)strdup((char*)mem+(lohi_getword(mem+so)+padsize));
	    				}
	    				else
	    				{
	    					printf("ERROR :: object %i name beyond object filesize!! (%04X)\n", count, (lohi_getword(mem+so)+3));
	    					(objects+count)->name=(UINT8*)strdup(null_msg);
	    				}
    				}
    			}
    			else
    				ec=err_NotEnoughMemory;
    			free(mem);
    		}
    		else
    		{
#ifdef AGDS_SUPPORT
    			/*  die with no error! AGDS game needs not to die to
    				work!! :( */
#else
				/* no AGDS support, die with error */
				ec=err_BadResource;
#endif
    		}
		}
		else
			ec=err_NotEnoughMemory;
		fclose(fp);
	}
	else
		ec=err_BadFileOpen;
	return(ec);
}

void unload_objects(void)
{
	UINT16	c;

	if(objects!=NULL)
	{
		for(c=0; c<num_objects; c++)
			free(objects[c].name);
		free(objects);
	}
}


