/*
 *  Sarien AGI :: Copyright (C) 1999 Dark Fiber 
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <limits.h>

#include "sarien.h"
#include "agi.h"
#include "gfx.h"
#include "view.h"


UINT8 hilo_getbyte(UINT8 *mem)
{
	return mem[0];
}


UINT16 hilo_getword(UINT8 *mem)
{
	return (mem[0]<<8) + (mem[1]);
}


UINT32 hilo_getpword(UINT8 *mem)
{
	return (mem[0]<<16) + (mem[1]<<8) + (mem[2]);
}


UINT32 hilo_getdword(UINT8 *mem)
{
	return (mem[0]<<24) + (mem[1]<<16) + (mem[2]<<8) + (mem[3]);
}


UINT8 lohi_getbyte(UINT8 *mem)
{
	return mem[0];
}


UINT16 lohi_getword(UINT8 *mem)
{
	return (mem[1]<<8) + (mem[0]);
}


UINT32 lohi_getpword(UINT8 *mem)
{
	return (mem[2]<<16) + (mem[1]<<8) + (mem[0]);
}


UINT32 lohi_getdword (UINT8 *mem)
{
	return (mem[3]<<24) + (mem[2]<<16) + (mem[1]<<8) + (mem[0]);

}


UINT8 getflag (UINT32 number)
{
	UINT8 *set = (UINT8*)&flags;
	UINT8 x;

	set += number/CHAR_BIT;
	x= *set & (1 << (number % CHAR_BIT));

	return x ? __TRUE : __FALSE;
}


void setflag(UINT32 number, UINT8 value)
{
	UINT8 *set=(UINT8*)&flags;

	set+=number/CHAR_BIT;
	if(value==1)
		*set|=1<<(number%CHAR_BIT);		/* set bit  */
	else
		*set&=~(1<<(number%CHAR_BIT));		/* clear bit*/
}


void flipflag(UINT32 number)
{
	UINT8 *set=(UINT8*)&flags;

	set+=number/CHAR_BIT;
	*set^=1<<(number%CHAR_BIT);			/* flip bit */
}


void setvar(UINT32 var, UINT8 val)
{
	vars[var]=val;
}


UINT8 getvar(UINT32 var)
{
    return vars[var];
}


void decrypt(UINT8 *mem, UINT32 len)
{
	UINT8	*key;
	UINT32	x;

	key = optAGDS ? (UINT8*)CRYPT_KEY_AGDS : (UINT8*)CRYPT_KEY_SIERRA;

	for (x = 0; x < len; x++)
		*(mem+x) ^= *(key + (x % 11));
}


/* unload all logic resources */
void unload_resources(void)
{
	UINT16	i;

	for(i=0; i<MAX_DIRS; i++)
	{
		dir_view[i].flags&=~RES_CACHED;		/* clear cache flag */
		loader->unload_resource(rVIEW, i);	/* free view */

		dir_pic[i].flags&=~RES_CACHED;		/* clear cache flag */
		loader->unload_resource(rPICTURE, i);	/* free resource */

		dir_logic[i].flags&=~RES_CACHED;	/* clear cache flag */
		loader->unload_resource(rLOGIC, i);	/* free resource */

		dir_sound[i].flags&=~RES_CACHED;	/* clear cache flag */
		loader->unload_resource(rSOUND, i);	/* free resource */
	}
}


void new_room_resources(void)
{
	UINT16	x;

	for(x=0; x<MAX_DIRS; x++)
	{
      /* FR: 
       * According to the specs, only the logic resources need to
       * be freed ( And now freeing the view resources will corrupt
       * the program )
       *
		 * loader->unload_resource(rVIEW, x);
		 * loader->unload_resource(rPICTURE, x);
       */
		loader->unload_resource(rLOGIC, x);
	}

	for(x=0; x<MAX_VIEWTABLE; x++)
		reset_view(x);
}


UINT8 o_status = 0;	/* FIXME */

void update_status_line (UINT8 force)
{
	char x[64], y[64];
	static UINT8 o_score = 255, o_sound = __FALSE, o_status = __FALSE;

   	if (!force && o_status == status_line && o_score == getvar (V_score) && 
		o_sound == getflag (F_sound_on))
		return;

	o_score = getvar(V_score);
   	o_sound = getflag(F_sound_on);
   	o_status = status_line;

	if (line_min_print == 0)
		return;

	if(status_line == __FALSE)
	{
		sprintf(x, "                                        ");
		print_text ((UINT8*)x, 0, line_status, 0, 41,
			STATUS_FG_CLEAN, STATUS_FG_CLEAN);
	}
	else {
		sprintf (y, " Score:%i of %03i", o_score, getvar(V_max_score));
		sprintf (x, "%-17s             Sound:%s ",
			y, o_sound == __TRUE ? "On " : "Off");

		print_text((UINT8*)x, 0, line_status, 0, 41,
			STATUS_FG, STATUS_BG);
	}
	gfx->put_block (0, 0, 319, 8);
}

