// Copyright (c) 1997,1998,1999,2000 Albrecht Kleine    All rights reserved
// file version #300

#include "tyaconfig.h"
#include <stdio.h>
#include <native.h>
#include <monitor.h>
#include "tya.h"

#ifdef MEMDEBUG
#include "MemDebug.h"
#endif

//---------------- helpers for function recode()----------------------
//
// all together they are a kind of construction set
//
// compile handling of integer comparison
//
void CompVergleich(unsigned char code,int* pj,unsigned short int opcode86,
		   struct CINFO* cinfo,int altercode)
{
   int i;
   cinfo->backp[cinfo->backcnt].java=cinfo->bptr+(*pj-1);
   cinfo->backp[cinfo->backcnt].currcnt=cinfo->ipcnt;
   i=getint16S(pj,cinfo);   
   dprintf(stderr,"jump %d java byte\n",i);
   if (code==0xA7)
     CB(JMP1);
   else
     {
	if (code<=0x9e)
	  {
#ifdef COMBINEOP
	     if (GET_OPTFLAG(DF_CmpI))
	       {
		  CB(POPAX);
		  opcode86=altercode;
	       }
	     else
	       if (GET_OPTFLAG(DF_CmpL))
		 CB(POPAX);
	       else	 
	       if (GET_OPTFLAG(DF_TestI))
		   CW(TEST_BXBX);	// to set proper flags
	       else
#endif	       
	       {
		  CW(TEST_AXAX);	// to set proper flags
		  CB(POPAX);
	       }
	  }
	else
	  if (code>=0x9f && code<=0xA4)
	    {
	       cinfo->iptab[cinfo->ipcnt-1].type=COMP;
	       CB(POPBX);
	       CW(CMP_BXAX);	// to set proper flags
	       CB(POPAX);
	    }
	CW(opcode86);
     }
     cinfo->backp[cinfo->backcnt].x86=cinfo->cptr;
     CL(0);			// backpatched later
     cinfo->backp[cinfo->backcnt].javadist=i;
     cinfo->backcnt++;
}

// compile handling of double/float comparison
//
void Comp87Vergleich(unsigned char code,struct CINFO* cinfo,unsigned char nextcode)
{
#ifdef COMBINEOP
   if (nextcode>=0x99 && nextcode<=0x9E && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
     {
	CW(FCOMPP);
	CW(FSTSW_AX);
	if ((code==0x97 || code==0x95) && (nextcode==0x9B || nextcode==0x9E))
	  {
	     dprintf(stderr,"TYA: fcmpl || dcmpl && iflt || ifle\n");// flags are useful w/o any changes
	     if (nextcode==0x9B)	//iflt
	       {
		  CW(SHR_AX);		// we need only carry
		  CB(9);
	       }
	     else
	      CB(SAHF);
	  }
	else
	  {
	     CB(SAHF);
	     CB(JNE);
	     CB(4);
	     CB(JNC);
	     CB(2);
	     CB(INC_AX);			// set state for NaN: clear zero flag
	     CB(code==0x97||code==0x95?STC:CLC);// .. and adjust carry flag for cmp
	     dprintf(stderr,"code=%x next=%x\n",code,nextcode);
	  }
	SET_OPTFLAG(DF_CmpI);
     }
   else
#endif     
     {
	CW(FCOMPP);
	CW(XOR_BXBX);	// ebx=0
	CW(FSTSW_AX);
	CB(SAHF);
	CW(MOV_AXBX);	// mov 0 to ax without "xor","sub"
	CB(JNE);	// to label0
	if (code==0x97 || code == 0x95)	// handling NaN
	{
	  CB(2);
	  CB(JNC);	// to label1 both equal
	  CB(5);
	}
	else
	{
	  CB(3);
	  CB(JNC);	// to label1 both equal
	  CB(6);
	  CB(CMC);
	}
#if 1
	//label0:	// not_equal
	CB(DEC_AX);	// eax=-1
	CB(JB);		// jb label1
	CB(2);
	CB(INC_AX);	// 
	CB(INC_AX);	// eax=+1
#else
	CB(0x0F);CB(0x93);CB(0xc0);		//setnc al
	CB(0x8D);CB(0x44);CB(0);CB(0xFF);	//lea eax,[eax+1*eax-1]
	// code is:  nc-> eax:=1+1*1-1 /  cy-> eax:=0+1*0-1
#endif	
   	//label1:	// ready
	// result in eax == stacktop
     }
}


// for truncate
// uses a helper place for temporary storing the x87-control-word
// (compute 1000.89 to 1000 ,  not 1001)
// FIXME: avoid slow FLDCW_MBP coding
// FIXME: should use own NPU stack in general
//
void Comp87ToInteger(unsigned char code,struct CINFO* cinfo)
{
   switch (code)
     {
      case 0x8b:	// f2i
	CW(MOV_BXAX);
	CB(AND_AX_LONG);
	CL(0x7FC00000);
	CB(CMP_AX);
	CL(0x7FC00000);			// FIXME perhaps easier recognition of nan
	CB(JNE);
	CB(4);
	CW(XOR_AXAX);
	CB(JMPS);
	CB(14+6+7    +13);			// jmp nan_label
	
	CB(PUSHBX);			// 1
	CW(FSTCW_MBP);			// 3
	CB(LOCSTART-4 );		// 4
	CW(MOV_AX_MBP_8);		// 6
	CB(LOCSTART-4);			// 7
	CW(OR_MBP_8_BYTE);		// 9
	CB(LOCSTART-4 +1);		// 10
	CB(0xC);			// 11
	CW(FLDCW_MBP);			// 13
	CB(LOCSTART-4);			// 14
	
	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	// 17	fld dword [esp]
	CW(FISTP_MSP);CB(SP_ADDR_BYTE3);// 20	put Int32 result on stack
	CB(POPDX);	//1
	CW(CMP_DX_LONG);//3
	CL(0x80000000);	//7
	CB(JNE);	//8
	CB(3);		//9
	CW(ADC_DX_BYTE);//11
	CB(0xff);	//12
	CB(PUSHDX);	//13
	break;
      case 0x8c:	// f2l
	CW(MOV_BXAX);
	CB(AND_AX_LONG);
	CL(0x7FC00000);
	CB(CMP_AX);
	CL(0x7FC00000);			// nan check FIXME
	CB(JNE);
	CB(5);
	CW(XOR_AXAX);
	CB(PUSHAX);
	CB(JMPS);
	CB(14+6+1+7   +22);			// jmp nan_label
	
	CB(PUSHBX);			// 1
	CW(FSTCW_MBP);			// 3
	CB(LOCSTART-4 );		// 4
	CW(MOV_AX_MBP_8);		// 6
	CB(LOCSTART-4);			// 7
	CW(OR_MBP_8_BYTE);		// 9
	CB(LOCSTART-4 +1);		// 10
	CB(0xC);			// 11
	CW(FLDCW_MBP);			// 13
	CB(LOCSTART-4);			// 14

	CW(FLDW_MSP);CB(SP_ADDR_BYTE3);	
	CB(PUSHBX);			// get 32bit space on stack
	CW(FISTPQ_MSP);CB(SP_ADDR_BYTE3);

	CB(POPCX);	//1
	CB(POPDX);	//2
	CW(CMP_DX_LONG);//4
	CL(0x80000000);	//8
	CB(JNE);	//9
	CB(10);		//10
	
	CW(OR_CXCX);	//12
	CB(JNE);	//13
	CB(3+3);	//14
 	CW(ADC_CX_BYTE);//16
	CB(0xff);	//17
	CW(ADC_DX_BYTE);//19
	CB(0xff);	//20

 
	CB(PUSHDX);	//21
	CB(PUSHCX);	//22
	break;
      case 0x8e:	// d2i
	CW(MOV_BXAX);
	CB(POPAX);
	CB(PUSHAX);
	CB(AND_AX_LONG);
	CL(0x7FF80000);
	CB(CMP_AX);
	CL(0x7FF80000);			// nan check FIXME
	CB(JNE);
	CB(5);
	CB(POPBX);			// remove 2nd part from stack
	CW(XOR_AXAX);
	CB(JMPS);
	CB(14+6+1+7  +13);			// jmp nan_label
	
	CB(PUSHBX);			// 1
	
	CW(FSTCW_MBP);			// 3
	CB(LOCSTART-4 );		// 4
	CW(MOV_AX_MBP_8);		// 6
	CB(LOCSTART-4);			// 7
	CW(OR_MBP_8_BYTE);		// 9
	CB(LOCSTART-4 +1);		// 10
	CB(0xC);			// 11
	CW(FLDCW_MBP);			// 13
	CB(LOCSTART-4);			// 14

	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);	
	CB(POPBX);
	CW(FISTP_MSP);CB(SP_ADDR_BYTE3);
	
	
	CB(POPDX);	//1
	CW(CMP_DX_LONG);//3
	CL(0x80000000);	//7
	CB(JNE);	//8
	CB(3);		//9
	CW(ADC_DX_BYTE);//11
	CB(0xff);	//12
	CB(PUSHDX);	//13
	break;
      case 0x8f:	// d2l
	CW(MOV_BXAX);
	CB(POPAX);
	CB(PUSHAX);
	CB(AND_AX_LONG);
	CL(0x7FF80000);
	CB(CMP_AX);
	CL(0x7FF80000);			// nan check FIXME

	CB(JNE);
	CB(6);
	CB(POPBX);			// remove 2nd part from stack
	CW(XOR_AXAX);
	CB(PUSHAX);
	CB(JMPS);
	CB(14+6+7 +22);			// jmp nan_label

	CB(PUSHBX);			// 1
	
	CW(FSTCW_MBP);			// 3
	CB(LOCSTART-4 );		// 4
	CW(MOV_AX_MBP_8);		// 6
	CB(LOCSTART-4);			// 7
	CW(OR_MBP_8_BYTE);		// 9
	CB(LOCSTART-4 +1);		// 10
	CB(0xC);			// 11
	CW(FLDCW_MBP);			// 13
	CB(LOCSTART-4);			// 14
	
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FISTPQ_MSP);CB(SP_ADDR_BYTE3);// 6

	CB(POPCX);	//1
	CB(POPDX);	//2
	CW(CMP_DX_LONG);//4
	CL(0x80000000);	//8
	CB(JNE);	//9
	CB(10);		//10
	
	CW(OR_CXCX);	//12
	CB(JNE);	//13
	CB(3+3);	//14
 	CW(ADC_CX_BYTE);//16
	CB(0xff);	//17
	CW(ADC_DX_BYTE);//19
	CB(0xff);	//20
 
	CB(PUSHDX);	//21
	CB(PUSHCX);	//22
	break;
     }
   CW(MOV_MBP_8_AX);	//2
   CB(LOCSTART-4);	//3
   CW(FLDCW_MBP);	//5
   CB(LOCSTART-4);	//6
   CB(POPAX);		//7
   // nan_label:
}


#ifdef FAST_FPARITH
// This is _one_ way for some JNI speedup, but not really fast.
// If you want true speed, try INLINE_FPARITM, but only if you
// know your args: INLINE_FPARITM is NOT a complete math lib! 
// Maybe you'd like to write some more fast inline maths there...?
//
int CompFastCallFP(struct CINFO* cinfo,struct methodblock *mbp,int stac,int nextcode)
{
   if (!mbp->code) 
     return 0;
   if (!strcmp(mbp->fb.signature,"(DD)D"))	// args are in reversed order
     {
	CB(POPBX);
	CB(POPCX);
	CB(POPDX);
	CB(POPAX);
	CB(PUSHCX);
	CB(PUSHBX);
	CB(PUSHAX);
	CB(PUSHDX);
     }
   CB(MOV_BX);
   CL(mbp->code);   
   CB(PUSHAX);		//two stack dummies
   CB(PUSHAX);
   CL(CALL_ADDSP);
   CB(stac);		//8 or 16

#ifdef COMBINEOP
   if (NEXT_LOADS_QWORD(nextcode) && (cinfo->mb->CompiledCodeFlags & CCF_COMBOK))
     SET_OPTFLAG(DF_DD);
   else
#endif
   {
      CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
      CB(POPAX);
   }
   return 1;
}
#endif

#ifdef INLINE_FPARITM
// performance booster -- for experimental usage only
// (some of them need check against oversized _double_ args! )
// Compare above comment in FAST_FPARITH section.
//
int CompInlineFP(struct CINFO* cinfo,struct methodblock *mbp)
{
   if (!strcmp(mbp->fb.name,"sin"))
     {
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSIN);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	return 1;
     }
   else
     if (!strcmp(mbp->fb.name,"cos"))
     {
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FCOS);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	return 1;
     }
   else
     if (!strcmp(mbp->fb.name,"sqrt"))
     {
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FSQRT);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	return 1;	
     }
   else
   if (!strcmp(mbp->fb.name,"pow"))
     {
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPBX);
	CB(POPAX);
	CW(FLDQW_MSP);CB(SP_ADDR_BYTE3);
	CW(FYL2X);
	CW(FLD);
	CW(FRNDINT);
	CW(FLD);
	CW(FSUBP_ST2);
	CW(FXCH);
	CW(F2XM1);
	CW(FLD1);
	CW(FADDP_ST1);
	CW(F_SCALE);
	CW(FSTP_ST1);
	CW(FSTPQW_MSP);CB(SP_ADDR_BYTE3);
	CB(POPAX);
	return 1;
     }
   return 0;
}
#endif	     

//-------------------------- local variables ---------------------------------
	  
// read a local variable on stack via ebp
// FIXME: should better arrange #parameter or #variable to both registers...
// ... currently we are using variable only but paramter ("this" etc.)
// ... could be _much_ better   (EXCEPT isinline - of course)
//
// FYI: PUSH means write the logical stacktop, this is not CPU-stacktop
//
void Comp_PUSH_LocalVarToReg(int wo,struct CINFO* cinfo,int reg)
{
  // if reg = EAX then you need
  // to pushax before if applicable, because you have to save OLD stacktop!
  if (cinfo->isinline)
    {     
      if (0==wo)
	{
	  MOV_R_R( reg, EDI );
	}
      else
	if (1 ==wo)
	  {
	    MOV_R_R( reg, ESI );
	  }	
      return;
    }
#ifdef USE_REG_OPT
  if (cinfo->mb->args_size==wo)
    {
      MOV_R_R( reg, EDI );
    }
  else
    if (cinfo->mb->args_size+1 ==wo)
      {
	MOV_R_R( reg, ESI );
      }
    else
#endif
      {
	int offset = LOCSTART + SIS4* (cinfo->mb->nlocals + cinfo->mb->args_size -1 - wo);
	MOV_R_Rmemoffs_(reg, EBP, offset );	// 5 _or_ 6 byte
      }
}


//
// a special case needed by ret and ret_w opcodes
//
int  Comp_PUSH_LocalVarToStack(int wo,struct CINFO* cinfo)
{
  if (cinfo->isinline)
  {     
    if (0==wo)
       CB(PUSHDI);
    else
     if (1 ==wo)
	CB(PUSHSI);
    return 0;
  }
#ifdef USE_REG_OPT
  if (cinfo->mb->args_size==wo)
     {
	CB(PUSHDI);
	return 0;
     }
   
  else
     if (cinfo->mb->args_size+1 ==wo)
     {
	CB(PUSHSI);
	return 0;
     }
   else
#endif
     {
	int offset = LOCSTART + SIS4* (cinfo->mb->nlocals + cinfo->mb->args_size -1 - wo);
	if (offset < 128)
	  {
	     CW(MOV_BX_MBP_8);
	     CB(offset);
	  }
	else
	  {
	     CW(MOV_BX_MBP_32);
	     CL(offset);
	  }
     }
   return 1;//this means "pending push_bx"
}


//
// write local variable on stack frame via ebp
//
void Comp_POP_StoreLocalVarFromReg(int wo,struct CINFO* cinfo,int isnoobj,int reg)
{
   if (cinfo->isinline)
   {     
    if (0==wo)
    {
       MOV_R_R( EDI, reg);
    }
    else
     if (1 ==wo)
     {
	  MOV_R_R( ESI,reg );
     }
    return;
   }
#ifdef USE_REG_OPT   
   if (cinfo->mb->args_size==wo)
   {
       MOV_R_R( EDI, reg);	
   }
   else
     if (cinfo->mb->args_size+1 ==wo)
     {
	 MOV_R_R( ESI,reg );	
     }
   
   // ***!!***
   // conditions where not to care about gc and exception register reload
   if (cinfo->mb->args_size==wo || cinfo->mb->args_size+1 ==wo)
    if (!cinfo->mb->exception_table_length)
      if (isnoobj)
	return;
#endif
     {
      int offset = LOCSTART + SIS4* (cinfo->mb->nlocals + cinfo->mb->args_size -1 - wo);
      MOV_Rmemoffs__R(EBP, offset, reg )
     }
}


// inc local integer only var
//
void Comp_INC_LocalVar(int wo,int inc,struct CINFO* cinfo)
{
  int offset = LOCSTART + SIS4* (cinfo->mb->nlocals + cinfo->mb->args_size -1 - wo);
  if (cinfo->isinline)
  {
     if (0==wo)
     {
	if (inc==1) 
	  CB(INC_DI);
	else 
	  if (inc==-1) 
	    CB(DEC_DI);
	  else
	  {
	     CW(ADD_DI);
	     CL(inc);
	  }
     }
     else
       if (1==wo)
       {
	  if (inc==1)
	    CB(INC_SI);
	  else
	    if (inc==-1)
	      CB(DEC_SI);
	    else
	    {
	       CW(ADD_SI);
	       CL(inc);
	    }
       }
     return;
  } 
  // ----- end of inline stuff ---------
  if (cinfo->wide)
     dprintf(stderr,"wide iinc:  offs %d  , inc %d\n",offset,inc);
#ifdef USE_REG_OPT
   if (cinfo->mb->args_size==wo)
     {
	if (inc==1) 
	  CB(INC_DI);
	else 
	  if (inc==-1) 
	    CB(DEC_DI);
	else
	  {
	     CW(ADD_DI);
	     CL(inc);
	  }
     }
   else
     if (cinfo->mb->args_size+1==wo)
	  {
	     if (inc==1)
	       CB(INC_SI);
	     else
	       if (inc==-1)
		 CB(DEC_SI);
	     else
	       {
		  CW(ADD_SI);
		  CL(inc);
	       }
	  }
   // compare above comment marked "***!!***" in Comp_POP_StoreLocalVar()
   if (cinfo->mb->args_size==wo || cinfo->mb->args_size+1 ==wo)
    if (!cinfo->mb->exception_table_length)
	return;
#endif
	  {
	   if (offset < 128)
	       {

		  if (cinfo->wide)
		    {
		       CW(ADD_MBP_8_LONG);
		       CB(offset);
		       CL(inc);
	            }
		  else
		    {
		       CW(ADD_MBP_8_BYTE);
		       CB(offset);
		       CB(inc);
	            }
               }
	       else
	       {
	       	  CW(ADD_MBP_32_LONG);
		  CL(offset);
		  CL(inc);
	       }

          }
}


#ifdef PASS2
//
// additional stuff 
//
int LoopFinder(struct CINFO *cinfo)
{
     int i,j,k=0,max=0;
     for (i=0;i<cinfo->backcnt;i++)
     {
       cinfo->backp[i].loop=0;
       if (cinfo->backp[i].javadist<0)
	 for (j=i;j<cinfo->backcnt;j++)
	   if (cinfo->backp[i].currcnt > cinfo->backp[j].destcnt)
	     cinfo->backp[i].loop++;
     }
     for (i=0;i<cinfo->backcnt;i++)
     {
	 if (cinfo->backp[i].javadist<0)
	 {
	   if (cinfo->backp[i].loop>max)
	   {
	     max=cinfo->backp[i].loop;
	     k=i;
	   }
	   dprintf(stderr,"%s%s %s   #curr:%d   loop:%d    #dest:%d\n ", unha11(cinfo->mb->fb.clazz)->name,      
		 cinfo->mb->fb.name,cinfo->mb->fb.signature, cinfo->backp[i].currcnt,  cinfo->backp[i].loop,cinfo->backp[i].destcnt);
	 }
     }
     return max ? k:0;		// index of max loop depth in cinfo->backp
}


//
// Initial try of optimizer pass dealing some simple cases.
// Any called functions like Comp_PUSH_LocalVarToReg() have to be..
// ...controlled by register parameter (here usually ebx,ecx)
//
void Pass2(struct CINFO *cinfo)
{
  int n;
  for (n=0;n<cinfo->ipcnt-3;n++)
   if (cinfo->iptab[n].type==LOAD)
   {
	if (cinfo->iptab[n+1].type==CONST)
	{
           if ((cinfo->iptab[n+1].isdest & DF_ISDEST) || (cinfo->iptab[n+2].isdest & DF_ISDEST))
	     continue;
	   if (cinfo->iptab[n+2].type==ARIT)
	   {
	    cinfo->cptr=cinfo->iptab[n].x86;
	    CB(PUSHAX);
	    Comp_PUSH_LocalVarToReg(cinfo->iptab[n].arg,cinfo,EAX);
	    CB(NOP);
	    CB(MOV_BX);
	    CL(cinfo->iptab[n+1].arg);
	    CB(NOP);
	    if (cinfo->iptab[n+2].arg==40)
	      CW(ADD_AXBX);
	    else
	      if (cinfo->iptab[n+2].arg==41)
	      {
		CW(SUB_AXBX);
		CW(NOP2);
	      }
	   }
	   else
	   {
	    if (cinfo->iptab[n+2].type==COMP)
	     {
	       cinfo->cptr=cinfo->iptab[n].x86;
	       CB(NOP);
	       Comp_PUSH_LocalVarToReg(cinfo->iptab[n].arg,cinfo,EBX);
	       CB(NOP);
	       CB(MOV_CX);
	       CL(cinfo->iptab[n+1].arg);
	       CB(NOP);
	       CW(CMP_BXCX);
               CB(NOP);
	     }
	   }
	}
	else
	{
	   if (cinfo->iptab[n+1].type==LOAD)
	   {
              if ((cinfo->iptab[n+1].isdest & DF_ISDEST) || (cinfo->iptab[n+2].isdest & DF_ISDEST))
	        continue;
	      if (cinfo->iptab[n+2].type==COMP)
	      {
		 cinfo->cptr=cinfo->iptab[n].x86;
		 CB(NOP);
		 Comp_PUSH_LocalVarToReg(cinfo->iptab[n].arg,cinfo,EBX);
		 CB(NOP);
		 Comp_PUSH_LocalVarToReg(cinfo->iptab[n+1].arg,cinfo,ECX);
		 CB(NOP);
		 CW(CMP_BXCX);
		 CB(NOP);
      	      }
	      else
	      {
		 if (cinfo->iptab[n+2].type==ARIT && cinfo->iptab[n+3].type==STORE)
		 {
		    if (cinfo->iptab[n+3].isdest & DF_ISDEST)
		      continue;
		    cinfo->cptr=cinfo->iptab[n].x86;
		    CB(NOP);
		    Comp_PUSH_LocalVarToReg(cinfo->iptab[n].arg,cinfo,EBX);
		    CB(NOP);
		    Comp_PUSH_LocalVarToReg(cinfo->iptab[n+1].arg,cinfo,ECX);
		    CB(NOP);
		    if (cinfo->iptab[n+2].arg==ADD)
		      CW(ADD_BXCX);
		    else
		      if (cinfo->iptab[n+2].arg==SUB)
		      {
			 CW(SUB_BXCX);
			 CW(NOP2);
		      }
      		    Comp_POP_StoreLocalVarFromReg(cinfo->iptab[n+3].arg,cinfo,1,EBX);
		    CB(NOP);
		 }
              }
	   }
        }
     }
}
#endif
