/*

------------------------------------------------------------------------------

A license is hereby granted to reproduce this software source code and
to create executable versions from this source code for personal,
non-commercial use.  The copyright notice included with the software
must be maintained in all copies produced.

THIS PROGRAM IS PROVIDED "AS IS". THE AUTHOR PROVIDES NO WARRANTIES
WHATSOEVER, EXPRESSED OR IMPLIED, INCLUDING WARRANTIES OF
MERCHANTABILITY, TITLE, OR FITNESS FOR ANY PARTICULAR PURPOSE.  THE
AUTHOR DOES NOT WARRANT THAT USE OF THIS PROGRAM DOES NOT INFRINGE THE
INTELLECTUAL PROPERTY RIGHTS OF ANY THIRD PARTY IN ANY COUNTRY.

Copyright (c) 1995, John Conover, All Rights Reserved.

Comments and/or bug reports should be addressed to:

    john@johncon.com (John Conover)

------------------------------------------------------------------------------

eval.h, general include file for eval.c

$Revision: 1.0 $
$Date: 1995/04/22 05:14:50 $
$Id: eval.h,v 1.0 1995/04/22 05:14:50 john Exp $
$Log: eval.h,v $
 * Revision 1.0  1995/04/22  05:14:50  john
 * Initial revision
 *

*/

#ifndef _EVAL_H /* if not defined then eval.h has not yet been included */

#define _EVAL_H

#define EVAL_H_ID "$Id: eval.h,v 1.0 1995/04/22 05:14:50 john Exp $" /* module version */

#ifdef __STDC__

typedef void (*PTF) (struct eval_element *element); /* how function algorithms are called */

#else

typedef void (*PTF) (); /* how function algorithms are called */

#endif

typedef struct eval_element /* symbol element structure */
{
    int value; /* evaluated value of element */
    PTF function; /* reference to function */
    struct eval_element *next; /* reference to next element in the postfix evaluation stack's list */
} EVAL;

#ifdef __STDC__

extern int allocate_eval (ELEMENT *element);
extern int postfix_eval (ELEMENT *postfix_stack);

#else

extern int allocate_eval ();
extern int postfix_eval ();

#endif

#endif
