 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Tue May 27 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Definitions of the contour types.                                    */
 /*                                                                      */
 /************************************************************************/

#include "EST_TNamedEnum.h"
#include "EST_ContourType.h"

const EST_ContourType EST_ContourType::F0("F0");
const EST_ContourType EST_ContourType::SIMPLE_F0("simple_F0");
const EST_ContourType EST_ContourType::DIFF_F0("diff_F0");
const EST_ContourType EST_ContourType::LPC("lpc");
const EST_ContourType EST_ContourType::REFLECTION("rfc");
const EST_ContourType EST_ContourType::CEPSTRUM("cepstrum");
const EST_ContourType EST_ContourType::AREA("area");
const EST_ContourType EST_ContourType::LOGAREA("logarea");
const EST_ContourType EST_ContourType::POWER("power");
const EST_ContourType EST_ContourType::ENERGY("energy");
const EST_ContourType EST_ContourType::DIFFERENCE("difference");
const EST_ContourType EST_ContourType::PITCHMARKS("pitchmarks");
const EST_ContourType EST_ContourType::OTHER("unknown contour type");

typedef struct EST_TValuedEnumDefinition<const char *, const char *,EST_contour_type_info> CTDef;

#if INCLUDE_CONTOUR_TYPE_MAP
static CTDef ContourTypeNames[] = 
    {
      { "unknown contour type",		{"unknown"},				{0}},
      { "F0",				{"F0"},					{1}},
      { "simple_F0",			{"simple F0", "simpleF0"},		{2}},
      { "diff_F0",			{"differentiated F0", "diffF0"},	{3}},
      { "lpc",				{"lpc coefficients", "lpc", "LPC" },	{4}},
      { "rfc",				{"reflection coefficients", "reflection", "rfl", "RFL"},	{5}},
      { "cepstrum",			{"cepstral coefficients", "cepstral", "cep", "CEP"},		{6}},
      { "area",				{"true area", "area"},			{7}},
      { "logarea",			{"log area", "logarea"},		{8}},
      { "power",			{"power"},				{9}},
      { "energy",					{"energy"},				{10}},
      { "difference",			{"difference"},				{11}},
      { "pitchmarks",			{"pitchmarks", "pm", "PM" },		{12}},
      { "unknown contour type",		{NULL },				{0}}
    };

EST_TNamedEnumI<EST_ContourType,EST_contour_type_info>  EST_ContourTypeMap(ContourTypeNames, EST_ContourType::make);
#endif

#if defined(INSTANTIATE_TEMPLATES)

#include "../base_class/EST_TNamedEnum.cc"

template class EST_TValuedEnumDefinition<EST_ContourType, const char *,EST_contour_type_info>;
// template class EST_TNamedEnum<EST_ContourType>;
template class EST_TNamedEnumI<EST_ContourType, EST_contour_type_info>;
// template class EST_TValuedEnum<EST_ContourType, const char *>;
template class EST_TValuedEnumI<EST_ContourType, const char *, EST_contour_type_info>;


#endif
