/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1995,1996                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                       Author: Paul Taylor                             */
/*                       Date  : April 1995                              */
/*-----------------------------------------------------------------------*/
/*                     Generate feature vectors                          */
/*                                                                       */
/*=======================================================================*/
#include "EST.h"

EST_Track make_spectrogram(EST_Wave &sig, EST_Option &op);

int main(int argc, char *argv[])
{
    EST_String out_file;
    EST_StrList files;
    EST_Option al, op;
    int orig_sr;

    EST_Wave sig;
    EST_Track spec;
    
    print_help(argc, argv);

    parse_command_line(argc, argv, "-b:f -s:f -d:f -o:s -order:i -otype:s \n\
                -range:f -w:f", files, al);

    out_file = al.present("-o") ? al.val("-o") : (EST_String)"-";
    init_lib_ops(al, op);

    if (read_wave(sig, files.first(), al) == -1)
	exit(-1);
    orig_sr = sig.sample_rate();
    
    spec = make_spectrogram(sig, op);
    
    spec.save(out_file, al.val("-otype", 0));

    return 0;
}

void override_lib_ops(EST_Option &a_list, EST_Option &al)
{ 
    // overwrite options with command line args
    a_list.override_val("bc_frame_shift", al.val("-s", 0));
    a_list.override_val("bc_frame_length", al.val("-d", 0));
    a_list.override_val("bc_frame_order", al.val("-order", 0));
    a_list.override_val("sp_range", al.val("-range", 0));
    a_list.override_val("sp_wcut", al.val("-w", 0));
    a_list.override_val("sp_bcut", al.val("-b", 0));
}

void print_help(int argc, char *argv[])
{
    for (int i = 0; i < argc; ++i)
	if (strncmp(argv[i],"-help", 2) == 0)
	{
	    cout << "Usage:\n";
	    cout << "spectgen   <input file> <output file> <options>\n";
	    cout << "use \"-\" to make input and output files stdin/out\n";
	    cout << endl;
	    cout << "-h      options help\n";
	    cout << "-ops    print relevant system operations\n";
	    cout << endl;
	    cout << "-N      do NOT read environment operations file\n";
	    cout << endl;
	    cout << "-otype  output file type (one of 'esps'  'fspec'  'xmg'   'snns'\n";
	    cout << "                          'varsnns' 'xgraph' 'ascii', default is 'ascii')\n";
	    cout << "-d      <float> input frame length in milliseconds\n";
	    cout << "-s      <float> input frame spacing in milliseconds\n";
	    cout << "-f      <int> sample rate in Hz (for headerless data)\n";
	    cout<< "-range  <float> range in which output values should lie\n";
	    cout<< "-w  <float> white cut off (0.0 to 1.0)\n";
	    cout<< "-b  <float> black cut off (0.0 to 1.0)\n";
	    cout << "-order  cepstral order\n";
	    exit(0);
	}
    
}
