/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, and modify this software and its            */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                   Author :  Paul Taylor                               */
/*                   Date   :  November 1995                             */
/*************************************************************************/
/*                                                                       */
/*                   Event RFC labelling                                 */
/*                                                                       */
/*=======================================================================*/

#include "EST.h"
#include "EST_rfc.h"

int add_dummy_silence(EST_Stream &rfc_ev);
void print_rfc3_events(EST_Stream &ev);

int main (int argc, char *argv[])
{
    EST_Stream ev, ev_out;
    EST_Option al, op;
    EST_String out_file("-"), pstring;
    EST_StrList files, pos_list;
    
    parse_command_line2(argc, argv, 
       EST_String("Usage:   ")+
       "ch_ev <input file> -o <output file> <options>\n"+
       "Summary: Convert intonation event labelling\n"+
       "-h               Options help\n"+
       "-o <ofile>       Output filename, if not specified output is\n"+
       "                 to stdout\n"+
       "-otype <string>  Output file type, (optional).  If no type is\n"+
       "                 Specified the type of the input file is assumed\n"+
       "                 types are: "+options_stream_filetypes()+"\n"+
       "-pos <string>    A string of event names, default is: a b ab pos\n"+
       "-print           Output RFC info to standard out\n"+
       "-style <string>  Desired output styleL tilt, tilt2, rfc rfc2\n",
			files, al);

    out_file = al.present("-o") ? al.val("-o") : (EST_String)"-";

    ev.load(files.first(), "", 2);

    pstring = al.present("-pos") ? al.val("-pos"): EST_String("a b ab pos");
    StringtoStrList(pstring, pos_list);
    convert_to_broad(ev, pos_list);

//    add_dummy_silence(ev);
    if (read_ev_fields(ev) == -1)
	exit(-1);
//    cout << "style is: " << al.val("-style") << endl;
    
    if((ev.stream_name() == "rfc_event")  && (al.val("-style", 0) == "tilt"))
    {
	ev_out = rfc_to_tilt(ev);
	write_tilt_fields(ev_out);
    }
    else if((ev.stream_name() == "tilt_event") 
	    && (al.val("-style", 0) == "tilt2"))
    {
	ev_out = ev;
	write_tilt2_fields(ev_out);
    }
    else if((ev.stream_name() == "tilt_event")  && 
	    (al.val("-style", 0) == "rfc"))
    {
	ev_out = tilt_to_rfc(ev);
	write_rfc_fields(ev_out, "rfc2");
    }
    else
    {
	//	cout << "No conversion performed\n";
	ev_out = ev;
    }

    if (al.present("-print"))
	print_rfc3_events(ev_out);

    ev_out.save(out_file, al.val("-otype", 0), 2);
    return 0;
}

