/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                     Author :  Paul Taylor                             */
/*                     Date   :  April 1995                              */
/*-----------------------------------------------------------------------*/
/*               EST_Track Auxiliary function header file                */
/*                                                                       */
/*=======================================================================*/

#ifndef __EST_TRACK_AUX_H__
#define __EST_TRACK_AUX_H__

#include "EST_FMatrix.h"
#include "EST_TList.h"
#include "EST_Stream.h"
#include "EST_Option.h"
#include "EST_Track.h"

void track_smooth(EST_Track &c, float x, EST_String stype = "");
void time_med_smooth(EST_Track &c, float x);
void time_mean_smooth(EST_Track &c, float x);
void simple_med_smooth(EST_Track &c, int n, int channel=0);
void simple_mean_smooth(EST_Track &c, int n, int channel=0);

void absolute(EST_Track &tr);
void normalise(EST_Track &tr);
void normalise(EST_Track &tr, float mean, float sd, int channel);
void normalise(EST_Track &tr, EST_FVector &mean, EST_FVector &sd);
void normalise(EST_TrackList &trlist, EST_FVector &mean, EST_FVector &sd);

EST_Track differentiate(EST_Track &c, float samp_int=0.0);
EST_Track difference(EST_Track &a, EST_Track &b);

void meansd(EST_Track &a, float &m, float &sd, int channel);
float rms_error(EST_Track &a, EST_Track &b, int channel);
float abs_error(EST_Track &a, EST_Track &b, int channel);
float correlation(EST_Track &a, EST_Track &b, int channel);

void meansd(EST_Track &a, EST_FVector &m, EST_FVector &sd);
EST_FVector rms_error(EST_Track &a, EST_Track &b);
EST_FVector abs_error(EST_Track &a, EST_Track &b);
EST_FVector correlation(EST_Track &a, EST_Track &b);

void align_to_track(EST_Track &tr, int &start, int &end, int sample_rate);
void align_to_track(EST_Track &tr, float &start, float &end);

EST_Track error(EST_Track &ref, EST_Track &test, int relax= 0);
EST_Track extract(EST_Track &orig, float start, float end);

int track_divide(EST_TrackList &mtfr, EST_Track &fv, EST_Stream &key);
void ParallelTracks(EST_Track &a, EST_TrackList &list,const EST_String &style);
void track_info(EST_Track &track);
EST_String options_track_filetypes(void);

int read_track(EST_Track &tr, const EST_String &in_file, EST_Option &al);


// Some functions to answer questions about tracks which have a
// track map

// How many coefficiants in track (looks for Coef0 and coefN channels)
int get_order(const EST_Track &t);

// Note, these assume a length channel
int sum_lengths(const EST_Track &t, int start_frame=0, int end_frame=-1);
int *get_start_positions(const EST_Track &t);

#endif /* __EST_TRACK_AUX_H__ */
