/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*                Decoder class for stack decoder                        */
/*                                                                       */
/*=======================================================================*/


#ifndef __WORDDECODER_H__
#define __WORDDECODER_H__

#include "Decoder.h"
#include "LUBHeap.h"

class WordDecoder : public Decoder {

private:

protected:

    int max_heap_size;
    float lm_scale_factor;
    float am_scale_factor;

    EST_TList<Hypothesis*> generate_new_hypotheses(Hypothesis *current_hypothesis_ptr);
    bool extend(Hypothesis *hypothesis_ptr);
    
public:
    
    WordDecoder(Hypothesis *initial_hypothesis_ptr,
		Track_Acoustic_Model &amodel,
		Lattice_Language_Model &lmodel,
		float lm_sf=1.0,
		float am_sf=1.0,
		int m=DEFAULT_MAX_HEAP_SIZE);
    
    // destructor, deletes internal storage (heap)
    ~WordDecoder();

    void make_heap(int max_size);


    void set_eval_fn(Hypothesis *hypothesis_ptr);
    //void set_log_prob(Hypothesis *hypothesis_ptr); inherited
    void set_partial_log_prob(Hypothesis *hypothesis_ptr);
    void set_estimated_remaining_log_prob(Hypothesis *hypothesis_ptr);

    void print(Hypothesis *hypothesis_ptr);
    void delete_hypothesis(Hypothesis *hypothesis_ptr);

    // housekeeping
    void control_heap(); 

    bool is_finished(Hypothesis *hypothesis_ptr);
    bool lm_is_finished(Hypothesis *hypothesis_ptr);
    bool am_is_finished(Hypothesis *hypothesis_ptr);

};

#endif

