/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                    Author :  Simon King                               */
/*                    Date   :  January 1997                             */
/*-----------------------------------------------------------------------*/
/*             Language model class for stack decoder                    */
/*                                                                       */
/*=======================================================================*/


#ifndef __LANGUAGE_MODEL_H__
#define __LANGUAGE_MODEL_H__

#include "Hypothesis.h"
#include "lattice.h"

class Language_Model {

private:

protected:

public:

    virtual bool is_finished(void* lmodel_state);
    virtual void *start_state();
    virtual EST_TList<void*> extend(void* current_state);

};


class Lattice_Language_Model : public Language_Model {

private:

protected:

    Lattice *lattice;

    EST_IVector map;
    
    struct llm_state_t{
	Lattice::Node *current_node;
	EST_TList<int> path; // list of labels on arcs traversed
	float log_prob;
    };

    // to do : shared path records

public:

    Lattice_Language_Model(Lattice &l, EST_StrVector &wordlist);

    void *start_state();
    EST_TList<void*> extend(void* current_state);

    float get_log_prob(void *lmodel_state);
    bool is_finished(void* lmodel_state);

    void print_state(void *lmodel_state);
    void delete_state(void *lmodel_state);


    // slow and temporary
    EST_String get_current_word(void *lmodel_state);

    int get_current_word_index(void *lmodel_state);
    
};




#endif

