;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;   A tree to predict zcore durations build from f2b
;;;   doesn't use actual phonemes so it can have better generalizations
;;;

;;;
;;; on open test data
;;; --stop 17 -balance 5.7 
;;; RMSE 0.829679 Correlation is 0.555086 Mean (abs) Error 0.597969 (0.575234)
;;; On itself (previously used measure
;;; RMSE 0.734039 Correlation is 0.670192 Mean (abs) Error 0.539853 (0.497371)

(set! kd_durs
'(
  (uh 0.067 0.025)
  (hh 0.061 0.028)
  (ao 0.138 0.046)
  (hv 0.053 0.020)
  (v 0.051 0.019)
  (ih 0.058 0.023)
  (el 0.111 0.043)
  (ey 0.132 0.042)
  (em 0.080 0.033)
  (jh 0.094 0.024)
  (w 0.054 0.023)
  (uw 0.107 0.044)
  (ae 0.120 0.036)
  (en 0.117 0.056)
  (k 0.089 0.034)
  (y 0.048 0.025)
  (axr 0.147 0.035)
  (l 0.056 0.026)
  (ng 0.064 0.024)
  (zh 0.071 0.030)
  (z 0.079 0.034)
  (brth 0.246 0.046)
  (m 0.069 0.028)
  (iy 0.097 0.041)
  (n 0.059 0.025)
  (ah 0.087 0.031)
  (er 0.046 0.010)
  (b 0.069 0.024)
  (pau 0.200 0.104)
  (aw 0.166 0.053)
  (p 0.088 0.030)
  (ch 0.115 0.025)
  (ow 0.134 0.039)
  (dh 0.031 0.016)
  (nx 0.049 0.100)
  (d 0.048 0.021)
  (ax 0.046 0.024)
  (h# 0.060 0.083)
;  (r 0.053 0.031)
  (r 0.043 0.021)
  (eh 0.095 0.036)
  (ay 0.137 0.047)
  (oy 0.183 0.050)
  (f 0.095 0.033)
  (sh 0.108 0.031)
  (s 0.102 0.037)
  (g 0.064 0.021)
  (dx 0.031 0.016)
  (th 0.093 0.050)
  (aa 0.094 0.037)
  (t 0.070 0.020)
)
)

;;; To identify the special case of er-r for which we currently
;;; have no training data
(define (radio_er_r utt seg)
  (if (and (string-equal (utt.streamitem.feat utt seg 'name) "r")
	   (string-equal (utt.streamitem.feat utt seg 'p.name) "er"))
      "1"
      "0"))

(set! kd_duration_cart_tree
'
((name is pau)
 ((emph_sil is +)
  ((0.0 -1.0))
  ((p.Syllable.Word.pbreak is BB)
   ((0.0 2.0))  
   ((0.0 0.0))))
((lisp_radio_er_r is 1)     ;; hack until we get er-r trained
  ((0.0 -0.5))  
((n.ph_vheight is 2)
 ((pos_in_syl < 1.5)
  ((p.ph_vheight is 2)
   ((ph_ctype is n)
    ((Syllable.stress is 0)
     ((ph_cplace is a)
      ((0.441686 -0.613541))
      ((0.512809 -0.175484)))
     ((p.ph_vlng is d)
      ((0.446666 0.209903))
      ((Syllable.syl_break is 1)
       ((0.508698 0.298263))
       ((n.ph_vlng is d)
        ((0.424301 -0.0563529))
        ((Syllable.sub_phrases < 0.3)
         ((Syllable.n.syl_break is 1)
          ((0.677758 0.31125))
          ((0.589314 -0.12835)))
         ((0.641133 0.256222)))))))
    ((Syllable.stress is 0)
     ((Syllable.ssyl_in < 4)
      ((Syllable.next_accent < 1.2)
       ((Syllable.syl_out < 3.6)
        ((ph_cvox is -)
         ((Syllable.last_accent < 0.4)
          ((0.561495 0.618613))
          ((0.54952 0.0542857)))
         ((Syllable.n.syl_break is 0)
          ((Syllable.syl_in < 3.6)
           ((0.584798 -0.465095))
           ((0.611081 0.248684)))
          ((n.ph_cplace is 0)
           ((Syllable.asyl_in < 1.2)
            ((1.18208 0.287))
            ((0.827244 -0.0532353)))
           ((0.836045 -0.14435)))))
        ((Syllable.syl_in < 2.4)
         ((0.688775 0.0696786))
         ((0.533308 -0.146579))))
       ((ph_ctype is s)
        ((0.465166 -0.234333))
        ((Syllable.n.syl_break is 0)
         ((0.550903 0.297882))
         ((0.639434 0.0976667)))))
      ((p.ph_vlng is a)
       ((0.739447 -0.00709091))
       ((0.47856 0.330097))))
     ((ph_ctype is f)
      ((ph_cvox is -)
       ((p.ph_cplace is 0)
        ((n.ph_vlng is d)
         ((0.508916 0.48881))
         ((Syllable.asyl_out < 0.4)
          ((0.509129 0.518773))
          ((Syllable.ssyl_in < 0.3)
           ((0.750737 0.893208))
           ((0.710254 0.365143)))))
        ((Syllable.syl_break is 4)
         ((0.414035 0.727842))
         ((0.387482 0.431529))))
       ((n.ph_cplace is 0)
        ((n.ph_vfront is 1)
         ((0.423099 -0.202625))
         ((0.540047 0.24012)))
        ((0.214636 0.106571))))
      ((Syllable.asyl_in < 1.2)
       ((ph_cplace is v)
        ((Syllable.p.syl_break is 0)
         ((0.711039 0.404143))
         ((0.417435 0.76565)))
        ((ph_ctype is l)
         ((0.698056 0.632727))
         ((Syllable.next_accent < 1.2)
          ((n.ph_ctype is 0)
           ((Syllable.n.syl_break is 0)
            ((0.686483 0.79124))
            ((Syllable.n.syl_break is 4)
             ((0.832597 0.965722))
             ((n.ph_vlng is d)
              ((0.887449 1.09))
              ((1.15818 0.870107)))))
           ((0.510861 1.22786)))
          ((Syllable.ssyl_out < 2.5)
           ((0.847002 0.779375))
           ((0.563554 0.679263))))))
       ((Syllable.syl_out < 0.5)
        ((0.564413 0.993805))
        ((0.590088 0.617185)))))))
   ((p.ph_ctype is f)
    ((ph_cvox is -)
     ((pos_in_syl < 0.1)
      ((Syllable.p.syl_break is 0)
       ((ph_cplace is a)
        ((p.ph_cplace is a)
         ((Syllable.syl_in < 2.1)
          ((0.284239 -0.091))
          ((0.341183 0.0555429)))
         ((0.33472 -0.400435)))
        ((0.3664 -0.704963)))
       ((ph_ctype is f)
        ((Syllable.p.syl_break is 1)
         ((pp.ph_vc is +)
          ((Syllable.sub_phrases < 0.3)
           ((Syllable.ssyl_out < 0.4)
            ((0.712898 -0.420176))
            ((1.04284 -0.228464)))
           ((0.581785 0.224588)))
          ((0.564077 -0.657632)))
         ((0.58481 -0.696294)))
        ((Syllable.accented is 0)
         ((0.593261 0.0842308))
         ((0.70104 0.85144)))))
      ((ph_cplace is l)
       ((Syllable.ssyl_out < 1.2)
        ((0.282737 -1.05459))
        ((0.242718 -1.20788)))
       ((Syllable.stress is 0)
        ((0.217069 -0.112643))
        ((Syllable.sub_phrases < 0.5)
         ((Syllable.n.syl_break is 0)
          ((0.230024 -0.53035))
          ((Syllable.asyl_in < 0.3)
           ((0.303989 -0.326667))
           ((0.283495 -0.535818))))
         ((0.196178 -0.469471))))))
     ((ph_ctype is f)
      ((p.ph_cplace is b)
       ((Syllable.ssyl_in < 1.2)
        ((Syllable.asyl_out < 1.5)
         ((0.648635 -0.4446))
         ((0.430308 -0.753053)))
        ((0.323045 -0.564)))
       ((Syllable.next_accent < 0.4)
        ((Syllable.syl_out < 4)
         ((0.481167 0.281432))
         ((0.43429 0.441368)))
        ((0.41473 0.0911667))))
      ((ph_vlng is l)
       ((Syllable.last_accent < 1.5)
        ((Syllable.ssyl_in < 0.3)
         ((0.489991 0.325909))
         ((n.ph_vlng is a)
          ((0.689551 1.10427))
          ((0.608856 0.299273))))
        ((0.514376 0.140889)))
       ((Syllable.p.syl_break is 0)
        ((n.ph_vlng is s)
         ((0.451225 -0.57095))
         ((ph_cplace is l)
          ((0.459842 -0.221824))
          ((syl_final is 0)
           ((0.362739 -0.807286))
           ((0.983003 -0.129132)))))
        ((n.ph_vlng is d)
         ((Syllable.syl_in < 1.4)
          ((0.859257 0.277276))
          ((0.508231 -0.107)))
         ((ph_cplace is a)
          ((ph_ctype is s)
           ((0.3956 0.317632))
           ((Syllable.p.syl_break is 4)
            ((0.282018 -0.848235))
            ((p.ph_cplace is b)
             ((0.305757 -0.890238))
             ((0.756908 -0.0890909)))))
          ((ph_ctype is n)
           ((0.611734 0.168111))
           ((Syllable.sub_phrases < 0.3)
            ((Syllable.stress is 0)
             ((0.740472 -0.0668214))
             ((ph_ctype is r)
              ((0.554477 0.0448235))
              ((1.79626 0.714812))))
            ((0.921924 0.170857))))))))))
    ((p.ph_ctype is n)
     ((Syllable.stress is 0)
      ((ph_cplace is d)
       ((0.0438748 -1.072))
       ((n.ph_cplace is 0)
        ((Syllable.p.syl_break is 1)
         ((0.610568 -0.275243))
         ((ph_ctype is f)
          ((0.669844 -0.714607))
          ((Syllable.syl_in < 6)
           ((ph_cvox is -)
            ((0.552718 -0.706263))
            ((ph_ctype is s)
             ((0.18504 -0.713261))
             ((1.13948 -0.189937))))
           ((0.664365 -0.66256)))))
        ((ph_cplace is l)
         ((0.378138 -0.942421))
         ((ph_cvox is +)
          ((0.501692 -0.989778))
          ((0.734883 -0.376333))))))
      ((p.ph_cplace is a)
       ((Syllable.asyl_out < 0.6)
        ((ph_ctype is s)
         ((0.582372 0.0549048))
         ((Syllable.syl_break is 4)
          ((0.651179 -0.248944))
          ((0.752209 -0.272074))))
        ((Syllable.n.syl_break is 4)
         ((0.587807 0.0205))
         ((Syllable.next_accent < 0.6)
          ((0.70355 -0.0797353))
          ((Syllable.syl_in < 3.9)
           ((Syllable.p.syl_break is 0)
            ((0.734168 -0.329))
            ((Syllable.asyl_in < 0.1)
             ((1.21111 0.627067))
             ((0.903483 -0.00418182))))
           ((0.805937 0.0861364))))))
       ((ph_cvox is +)
        ((Syllable.ssyl_out < 1.5)
         ((0.75333 -0.414522))
         ((0.546753 -0.714882)))
        ((Syllable.asyl_in < 0.3)
         ((0.635717 0.144632))
         ((0.606325 -0.0731053))))))
     ((ph_cvox is -)
      ((Syllable.stress is 0)
       ((Syllable.sub_phrases < 0.2)
        ((ph_cplace is a)
         ((n.ph_vlng is d)
          ((0.258281 0.131944))
          ((n.ph_ctype is 0)
           ((Syllable.p.syl_break is 1)
            ((0.533959 0.143706))
            ((Syllable.n.syl_break is 0)
             ((0.533144 0.320167))
             ((0.883987 -0.0503333))))
           ((0.402776 0.317885))))
         ((ph_cplace is g)
          ((0.560679 -0.391348))
          ((ph_ctype is f)
           ((0.453051 0.0456667))
           ((Syllable.p.syl_break is 0)
            ((ph_cplace is v)
             ((0.43539 -0.240056))
             ((0.653874 -0.715136)))
            ((Syllable.syl_out < 3.4)
             ((0.831613 0.409684))
             ((0.56064 -0.1812)))))))
        ((Syllable.syl_break is 1)
         ((0.465461 -0.280211))
         ((0.492852 0.237867))))
       ((Syllable.p.syl_break is 4)
        ((Syllable.asyl_out < 0.4)
         ((0.538773 0.4218))
         ((n.ph_vlng is d)
          ((0.586757 0.537333))
          ((Syllable.next_accent < 0.3)
           ((0.528573 0.3456))
           ((0.77183 0.358577)))))
        ((Syllable.accented is 0)
         ((p.ph_vheight is 1)
          ((0.592671 0.603545))
          ((n.ph_vlng is s)
           ((0.547404 -0.09735))
           ((0.954205 0.323517))))
         ((Syllable.syl_break is 3)
          ((Syllable.asyl_in < 0.4)
           ((0.624342 0.293941))
           ((0.666068 0.370147)))
          ((p.ph_cvox is +)
           ((p.ph_ctype is r)
            ((0.628289 1.22747))
            ((0.779155 0.617667)))
           ((ph_cplace is v)
            ((0.497952 0.528312))
            ((Syllable.syl_break is 4)
             ((Syllable.asyl_in < 0.3)
              ((0.514056 1.07859))
              ((0.92404 0.5868)))
             ((pp.ph_vc is -)
              ((Syllable.syl_out < 4.6)
               ((Syllable.n.syl_break is 0)
                ((0.874653 0.985))
                ((p.ph_vheight is 1)
                 ((1.09595 1.18921))
                 ((1.21847 0.201294))))
               ((0.987158 -0.0602381)))
              ((0.816957 0.183758))))))))))
      ((p.ph_cvox is +)
       ((ph_ctype is s)
        ((n.ph_ctype is 0)
         ((Syllable.next_accent < 1.2)
          ((n.ph_vfront is 2)
           ((0.40174 0.131217))
           ((0.610931 0.357167)))
          ((0.360447 0.2665)))
         ((ph_cplace is v)
          ((0.433013 -0.95))
          ((0.290291 -0.151889))))
        ((n.ph_vlng is d)
         ((ph_ctype is a)
          ((0.467048 -0.294435))
          ((ph_ctype is n)
           ((0.55959 0.196588))
           ((ph_cplace is a)
            ((Syllable.n.syl_break is 1)
             ((0.766035 -0.309706))
             ((0.648823 0.362118)))
            ((0.640901 0.533087)))))
         ((ph_cplace is d)
          ((p.ph_ctype is s)
           ((0.261453 -1.00371))
           ((ph_ctype is f)
            ((Syllable.last_accent < 0.5)
             ((0.478994 -0.4705))
             ((0.388312 0.0499524)))
            ((0.0206429 -0.282696))))
          ((n.ph_vfront is 1)
           ((ph_ctype is a)
            ((0.533674 -0.115636))
            ((ph_cplace is a)
             ((0.873579 0.338647))
             ((0.539728 0.328222))))
           ((n.ph_vlng is a)
            ((ph_ctype is r)
             ((Syllable.sub_phrases < 0.4)
              ((Syllable.accented is 0)
               ((0.588254 0.165))
               ((0.692491 0.578786)))
              ((0.569236 0.762545)))
             ((ph_ctype is l)
              ((0.417534 -0.578741))
              ((ph_vheight is 0)
               ((Syllable.n.syl_break is 1)
                ((0.408996 -0.677905))
                ((Syllable.sub_phrases < 0.3)
                 ((0.57984 -0.207609))
                 ((0.531364 -0.631765))))
               ((pp.ph_vc is +)
                ((Syllable.n.syl_break is 4)
                 ((1.1102 1.268))
                 ((1.19783 0.668821)))
                ((0.665884 0.340167))))))
            ((ph_cplace is a)
             ((0.405701 -0.419586))
             ((0.783184 0.407579))))))))
       ((p.ph_ctype is s)
        ((p.ph_cplace is l)
         ((n.ph_vfront is 1)
          ((ph_ctype is l)
           ((0.13314 -1.09884))
           ((0.225591 -0.920909)))
          ((n.ph_vlng is d)
           ((0.290791 -0.84748))
           ((Syllable.asyl_in < 0.4)
            ((0.357203 -0.623308))
            ((Syllable.ssyl_out < 1.2)
             ((Syllable.syl_out < 1.5)
              ((0.966534 -0.122118))
              ((0.727335 -0.577529)))
             ((0.453498 -0.753765))))))
         ((ph_vheight is 0)
          ((pos_in_syl < 0.1)
           ((n.ph_vlng is a)
            ((Syllable.n.syl_break is 0)
             ((0.493743 -0.826905))
             ((Syllable.p.syl_break is 0)
              ((0.53707 -0.864208))
              ((0.82935 -0.23))))
            ((pp.ph_vc is +)
             ((Syllable.ssyl_in < 0.4)
              ((0.884639 -0.101619))
              ((1.15789 0.552529)))
             ((0.735643 -0.300091))))
           ((Syllable.asyl_in < 0.4)
            ((0.229219 -1.03423))
            ((n.ph_vlng is s)
             ((0.319297 -0.903412))
             ((Syllable.ssyl_out < 0.4)
              ((0.717936 -0.496882))
              ((0.353363 -0.903737))))))
          ((Syllable.last_accent < 0.3)
           ((Syllable.n.syl_break is 0)
            ((0.663767 -0.0671176))
            ((0.769863 0.402727)))
           ((0.50345 0.307105)))))
        ((ph_ctype is n)
         ((p.ph_vheight is 3)
          ((0.548934 -0.579893))
          ((Syllable.sub_phrases < 0.2)
           ((Syllable.syl_in < 4.2)
            ((Syllable.syl_out < 6)
             ((Syllable.accented is 0)
              ((0.688477 -0.481783))
              ((1.08089 0.265182)))
             ((0.768047 -0.473789)))
            ((0.658322 -0.142111)))
           ((0.59169 -0.0825625))))
         ((Syllable.p.syl_break is 1)
          ((Syllable.ssyl_out < 0.5)
           ((0.584203 0.425581))
           ((Syllable.syl_break is 0)
            ((0.661711 0.104531))
            ((Syllable.syl_in < 1.8)
             ((Syllable.asyl_out < 1.2)
              ((0.650144 -0.256444))
              ((0.532191 0.142389)))
             ((Syllable.last_accent < 1.2)
              ((0.846995 0.162038))
              ((1.04899 0.994176))))))
          ((ph_cplace is a)
           ((ph_ctype is f)
            ((Syllable.accented is 0)
             ((0.36599 -0.448708))
             ((0.444163 -0.0561935)))
            ((p.ph_vlng is s)
             ((0.724169 0.6215))
             ((ph_ctype is l)
              ((0.694879 -0.2405))
              ((p.ph_vheight is 3)
               ((1.26865 0.311875))
               ((0.852411 0.051))))))
           ((Syllable.syl_break is 0)
            ((pos_in_syl < 0.1)
             ((Syllable.n.syl_break is 0)
              ((0.887792 0.139368))
              ((0.977259 -0.4008)))
             ((0.594219 0.10545)))
            ((Syllable.ssyl_out < 2.4)
             ((Syllable.syl_break is 1)
              ((ph_ctype is r)
               ((0.958082 -0.0850357))
               ((Syllable.asyl_out < 1.2)
                ((Syllable.next_accent < 0.2)
                 ((Syllable.syl_out < 2.2)
                  ((2.33047 0.640265))
                  ((1.44339 0.0837308)))
                 ((1.23699 0.412583)))
                ((1.09853 0.347194))))
              ((p.ph_vheight is 1)
               ((1.04919 0.837278))
               ((0.603368 -0.25468))))
             ((ph_ctype is s)
              ((0.781184 0.39585))
              ((ph_cplace is d)
               ((0.965607 0.0849355))
               ((0.92662 -0.332)))))))))))))))
  ((ph_ctype is s)
   ((p.ph_cvox is -)
    ((Syllable.syl_in < 1.8)
     ((0.306041 0.0365294))
     ((0.413533 -0.0972727)))
    ((p.ph_ctype is n)
     ((Syllable.syl_out < 3.6)
      ((0.507605 -0.712906))
      ((0.314381 -0.609824)))
     ((ph_cplace is v)
      ((Syllable.asyl_in < 0.4)
       ((0.732764 -0.07192))
       ((0.48347 -0.0167895)))
      ((p.ph_vheight is 3)
       ((0.516593 -0.794667))
       ((ph_cvox is -)
        ((0.528067 -0.97525))
        ((p.ph_vlng is s)
         ((Syllable.ssyl_out < 2.5)
          ((0.540556 -0.628556))
          ((0.352062 -1.16096)))
         ((0.767395 -0.0143478))))))))
   ((ph_ctype is n)
    ((Syllable.syl_out < 4.4)
     ((Syllable.last_accent < 1.2)
      ((Syllable.n.syl_break is 4)
       ((0.456545 -0.340684))
       ((Syllable.accented is 0)
        ((0.468218 -0.502423))
        ((Syllable.sub_phrases < 0.4)
         ((Syllable.syl_in < 1.3)
          ((0.839709 -0.307111))
          ((1.06948 0.0161111)))
         ((0.522026 -0.283529)))))
      ((ph_cplace is l)
       ((0.339506 -0.3375))
       ((0.382526 -0.575167))))
     ((0.441852 -0.722647)))
    ((ph_cvox is -)
     ((p.ph_cvox is -)
      ((Syllable.n.syl_break is 0)
       ((0.449143 -1.10482))
       ((0.599124 -0.706136)))
      ((p.ph_vheight is 3)
       ((Syllable.asyl_out < 1.5)
        ((0.300842 0.13735))
        ((0.37143 -0.243789)))
       ((Syllable.n.syl_break is 4)
        ((0.472604 0.192455))
        ((Syllable.sub_phrases < 0.3)
         ((Syllable.n.syl_break is 0)
          ((0.68359 0.186941))
          ((Syllable.syl_break is 0)
           ((0.508985 -0.380455))
           ((0.662944 0.0716842))))
         ((0.531941 -0.174391))))))
     ((p.ph_cplace is a)
      ((Syllable.ssyl_in < 2.4)
       ((n.ph_vfront is 2)
        ((ph_cplace is a)
         ((Syllable.syl_out < 2.7)
          ((0.512142 -0.645412))
          ((0.396211 -0.481176)))
         ((p.ph_ctype is s)
          ((0.852935 0.0213333))
          ((0.978462 0.35119))))
        ((0.521103 -0.559476)))
       ((0.45768 -0.44135)))
      ((n.ph_cplace is 0)
       ((Syllable.p.syl_break is 0)
        ((ph_ctype is l)
         ((0.56505 0.169615))
         ((Syllable.sub_phrases < 0.2)
          ((Syllable.accented is 0)
           ((0.655053 0.20224))
           ((ph_ctype is f)
            ((0.861889 0.153125))
            ((1.02973 0.86185))))
          ((0.547526 0.221815))))
        ((Syllable.next_accent < 0.5)
         ((Syllable.last_accent < 1.2)
          ((Syllable.syl_break is 1)
           ((0.922462 0.492529))
           ((0.858949 0.132318)))
          ((0.442436 -0.214368)))
         ((Syllable.syl_in < 3.3)
          ((p.ph_vlng is l)
           ((Syllable.syl_break is 0)
            ((0.794728 -0.295095))
            ((1.05123 0.456)))
           ((p.ph_vlng is s)
            ((Syllable.next_accent < 2.2)
             ((ph_cplace is d)
              ((1.01503 0.7955))
              ((Syllable.last_accent < 0.3)
               ((0.546197 -0.575368))
               ((ph_ctype is f)
                ((0.372882 -0.641684))
                ((2.1546 1.11653)))))
             ((0.50849 -0.644632)))
            ((0.786181 -0.194792))))
          ((p.ph_vheight is 3)
           ((0.598359 0.175647))
           ((0.970395 0.232286))))))
       ((ph_ctype is l)
        ((0.215233 -0.522667))
        ((Syllable.p.syl_break is 1)
         ((0.596198 -0.292579))
         ((0.487669 0.0387407))))))))))
 ((Syllable.asyl_out < 1.2)
  ((Syllable.syl_break is 1)
   ((n.ph_ctype is s)
    ((Syllable.syl_out < 3.4)
     ((p.ph_ctype is f)
      ((Syllable.ssyl_in < 2.4)
       ((Syllable.syl_in < 2.1)
        ((n.ph_cplace is l)
         ((Syllable.asyl_out < 0.1)
          ((0.502516 -0.532579))
          ((0.588727 -0.237556)))
         ((Syllable.p.syl_break is 0)
          ((0.589269 -0.217448))
          ((n.ph_cvox is -)
           ((p.ph_cvox is -)
            ((0.637535 -0.598174))
            ((ph_vheight is 3)
             ((0.644557 -0.449194))
             ((pp.ph_vc is +)
              ((0.931029 0.324619))
              ((0.832073 -0.0371111)))))
           ((0.598794 -0.491273)))))
        ((Syllable.ssyl_out < 0.2)
         ((0.356252 -0.18984))
         ((ph_vlng is s)
          ((0.335933 -0.19615))
          ((0.68994 -0.347966)))))
       ((n.ph_cvox is -)
        ((0.464402 0.0500303))
        ((0.38563 -0.428333))))
      ((ph_vheight is 2)
       ((p.ph_ctype is r)
        ((Syllable.accented is 0)
         ((0.388802 -0.799875))
         ((0.709408 -0.189471)))
        ((Syllable.accented is 0)
         ((p.ph_cvox is +)
          ((Syllable.p.syl_break is 4)
           ((0.586698 -0.293333))
           ((nn.ph_vc is +)
            ((0.547169 -0.177583))
            ((Syllable.ssyl_in < 1.2)
             ((0.728184 0.540818))
             ((0.846136 -0.285)))))
          ((Syllable.syl_in < 2.4)
           ((0.479631 0.0883636))
           ((0.498097 -0.455077))))
         ((Syllable.last_accent < 1.5)
          ((0.58632 -0.0675714))
          ((0.510908 0.158056)))))
       ((ph_vc is +)
        ((p.ph_ctype is r)
         ((Syllable.syl_in < 3.2)
          ((Syllable.stress is 0)
           ((0.438183 -0.792667))
           ((0.42765 -0.310045)))
          ((0.257236 -0.690353)))
         ((Syllable.ssyl_out < 0.3)
          ((p.ph_cvox is +)
           ((0.447573 -0.25435))
           ((0.488741 -0.773947)))
          ((syl_final is 0)
           ((ph_vfront is 3)
            ((0.455858 0.145826))
            ((Syllable.ssyl_in < 1.5)
             ((ph_vheight is 1)
              ((0.740124 0.284684))
              ((0.830721 -0.148522)))
             ((0.54355 0.0357222))))
           ((n.ph_cvox is -)
            ((Syllable.stress is 0)
             ((0.457649 -0.453056))
             ((0.750936 -0.0792222)))
            ((0.349029 -0.754462))))))
        ((p.ph_cplace is 0)
         ((ph_ctype is f)
          ((n.ph_cplace is l)
           ((0.433687 -0.445375))
           ((n.ph_cplace is a)
            ((p.ph_vlng is l)
             ((0.479113 -0.301176))
             ((Syllable.accented is 0)
              ((ph_cvox is -)
               ((0.701014 -0.660179))
               ((0.633351 -0.0469474)))
              ((0.520993 -0.196857))))
            ((pos_in_syl < 1.2)
             ((0.568038 0.121059))
             ((0.485515 -0.0812632)))))
          ((ph_ctype is s)
           ((ph_cplace is v)
            ((0.550574 -1.4198))
            ((n.ph_cvox is -)
             ((0.735117 -0.299259))
             ((0.661001 -0.957394))))
           ((Syllable.next_accent < 0.2)
            ((Syllable.ssyl_out < 0.3)
             ((Syllable.ssyl_in < 1.4)
              ((0.718203 0.20195))
              ((0.569841 -0.260238)))
             ((syl_final is 0)
              ((ph_ctype is n)
               ((Syllable.p.syl_break is 1)
                ((0.581192 -0.697632))
                ((0.651072 -0.195143)))
               ((0.598373 0.207375)))
              ((ph_ctype is r)
               ((0.796559 -0.181192))
               ((n.ph_cplace is l)
                ((0.734782 -0.0542222))
                ((p.ph_vlng is s)
                 ((0.744311 0.734412))
                 ((1.08025 0.661125)))))))
            ((Syllable.syl_in < 3.6)
             ((Syllable.sub_phrases < 0.2)
              ((Syllable.p.syl_break is 0)
               ((0.652699 -0.444235))
               ((Syllable.stress is 0)
                ((0.718317 -0.619))
                ((0.809391 -0.168259))))
              ((0.645776 -0.390778)))
             ((0.463313 -0.505391))))))
         ((p.ph_cvox is -)
          ((Syllable.syl_in < 0.9)
           ((0.494867 -1.21524))
           ((0.52369 -1.01288)))
          ((Syllable.asyl_in < 1.2)
           ((ph_ctype is s)
            ((0.529192 -0.92712))
            ((Syllable.p.syl_break is 0)
             ((0.614334 -0.855783))
             ((0.680546 0.01784))))
           ((0.479315 -0.629))))))))
     ((ph_vheight is 1)
      ((Syllable.p.syl_break is 4)
       ((0.272184 -0.764118))
       ((n.ph_cplace is a)
        ((0.596665 -0.445903))
        ((0.292863 -0.851577))))
      ((ph_vheight is 2)
       ((n.ph_cplace is l)
        ((0.470799 -0.396167))
        ((Syllable.stress is 0)
         ((n.ph_cvox is -)
          ((0.601048 0.0658))
          ((0.576004 -0.4555)))
         ((0.465097 -0.458471))))
       ((Syllable.ssyl_out < 1.4)
        ((p.ph_vc is +)
         ((0.519307 -0.666519))
         ((0.439972 -0.942647)))
        ((p.ph_vlng is l)
         ((0.38142 -0.333593))
         ((Syllable.next_accent < 2.5)
          ((p.ph_cplace is a)
           ((0.636231 -0.789964))
           ((ph_ctype is f)
            ((0.634582 -0.0723333))
            ((p.ph_vheight is 2)
             ((0.655283 -0.681316))
             ((Syllable.n.syl_break is 0)
              ((0.872992 -0.152632))
              ((0.935324 -0.764529))))))
          ((0.511615 -0.800261))))))))
    ((n.ph_ctype is n)
     ((ph_vlng is a)
      ((n.ph_cplace is a)
       ((Syllable.p.syl_break is 1)
        ((nn.ph_vc is +)
         ((0.31377 -0.598118))
         ((0.43597 -0.46175)))
        ((Syllable.next_accent < 1.5)
         ((Syllable.syl_in < 4.8)
          ((p.ph_cvox is -)
           ((0.44791 -0.387931))
           ((Syllable.sub_phrases < 0.4)
            ((p.ph_cplace is a)
             ((0.847878 -0.102273))
             ((0.606509 -0.352364)))
            ((0.456599 -0.3333))))
          ((p.ph_cvox is +)
           ((0.545464 -0.43765))
           ((0.252965 -0.741474))))
         ((0.427977 -0.561852))))
       ((Syllable.n.syl_break is 1)
        ((0.235073 -0.788867))
        ((Syllable.syl_out < 3.7)
         ((n.ph_cplace is l)
          ((0.524407 -0.481031))
          ((0.394226 -0.785368)))
         ((0.252863 -0.699222)))))
      ((n.ph_cplace is l)
       ((p.ph_cplace is v)
        ((0.371065 -0.848143))
        ((Syllable.ssyl_in < 2.1)
         ((Syllable.n.syl_break is 1)
          ((0.592886 -0.719323))
          ((Syllable.accented is 0)
           ((Syllable.p.syl_break is 4)
            ((0.568708 -0.479))
            ((p.ph_vc is +)
             ((0.705552 -0.287929))
             ((0.698394 -0.787714))))
           ((0.60537 -0.126059))))
         ((0.500881 -0.51816))))
       ((Syllable.ssyl_out < 0.4)
        ((n.ph_cplace is a)
         ((Syllable.n.syl_break is 1)
          ((0.359552 -1.0516))
          ((ph_vheight is 3)
           ((0.421745 -0.89925))
           ((ph_ctype is f)
            ((0.51809 -0.771824))
            ((0.973921 -0.25555)))))
         ((0.265164 -0.939174)))
        ((nn.ph_vc is +)
         ((p.ph_cvox is -)
          ((0.399186 -0.897839))
          ((Syllable.ssyl_in < 1.5)
           ((ph_cvox is +)
            ((0.596839 -0.29675))
            ((ph_vfront is 1)
             ((0.61428 -0.626789))
             ((0.689977 -0.8377))))
           ((0.585839 -0.514864))))
         ((Syllable.asyl_out < 0.1)
          ((p.ph_cvox is -)
           ((0.447683 -0.95768))
           ((ph_vlng is s)
            ((0.630347 -0.684522))
            ((0.7417 -0.136714))))
          ((Syllable.syl_out < 3.1)
           ((Syllable.accented is 0)
            ((Syllable.next_accent < 0.1)
             ((ph_vheight is 3)
              ((Syllable.ssyl_out < 1.2)
               ((0.458712 -1.01571))
               ((0.726168 -0.386964)))
              ((Syllable.ssyl_in < 0.6)
               ((0.884647 0.622824))
               ((p.ph_cplace is a)
                ((1.07529 0.248722))
                ((0.517409 -0.843167)))))
             ((0.47828 -0.647633)))
            ((p.ph_ctype is r)
             ((0.681518 -0.327333))
             ((ph_vheight is 3)
              ((0.805612 0.881444))
              ((0.811505 0.208958)))))
           ((Syllable.syl_in < 1.4)
            ((Syllable.next_accent < 0.4)
             ((0.475968 -0.25881))
             ((0.901986 -0.442833)))
            ((0.569909 -0.767741)))))))))
     ((p.ph_ctype is f)
      ((n.ph_ctype is r)
       ((ph_vfront is 3)
        ((Syllable.stress is 0)
         ((Syllable.next_accent < 0.3)
          ((0.214675 -1.14327))
          ((0.0664112 -1.16485)))
         ((Syllable.p.syl_break is 4)
          ((0.408901 -0.587571))
          ((0.313925 -0.741158))))
        ((ph_ctype is s)
         ((0.480843 0.308696))
         ((Syllable.syl_in < 4.5)
          ((ph_vlng is l)
           ((0.57012 -0.748368))
           ((ph_vfront is 1)
            ((0.521338 -0.4498))
            ((0.797105 -0.0138125))))
          ((0.439905 -0.344529)))))
       ((ph_cvox is +)
        ((n.ph_cvox is -)
         ((n.ph_cplace is a)
          ((0.458949 -0.468211))
          ((0.349035 -0.142947)))
         ((ph_ctype is n)
          ((0.55762 -0.01332))
          ((n.ph_cplace is a)
           ((0.535068 -0.44155))
           ((n.ph_vfront is 3)
            ((0.481647 -0.403059))
            ((Syllable.syl_out < 3.1)
             ((pp.ph_vc is +)
              ((p.ph_cplace is b)
               ((0.768897 -0.455176))
               ((0.907171 0.203913)))
              ((0.506368 -0.474)))
             ((0.528078 0.226706)))))))
        ((ph_vlng is l)
         ((Syllable.n.syl_break is 3)
          ((0.559965 -0.717375))
          ((Syllable.syl_in < 3.3)
           ((nn.ph_vc is +)
            ((Syllable.asyl_out < 0.1)
             ((0.24736 -0.457824))
             ((0.698716 -0.185042)))
            ((Syllable.next_accent < 0.3)
             ((0.678108 0.574826))
             ((0.603891 0.127))))
           ((0.459919 -0.1865))))
         ((n.ph_cplace is b)
          ((Syllable.asyl_out < 0.1)
           ((0.500698 -0.374346))
           ((ph_vfront is 2)
            ((pp.ph_vc is +)
             ((0.601652 0.305593))
             ((0.491457 0.0765556)))
            ((0.67971 -0.426464))))
          ((ph_cplace is a)
           ((pos_in_syl < 0.4)
            ((Syllable.asyl_in < 0.3)
             ((0.526532 0.922483))
             ((0.521169 0.189308)))
            ((0.467677 -0.5455)))
           ((n.ph_ctype is f)
            ((Syllable.p.syl_break is 4)
             ((Syllable.n.syl_break is 0)
              ((0.429902 0.47605))
              ((0.880532 0.212833)))
             ((Syllable.stress is 0)
              ((ph_vlng is a)
               ((Syllable.n.syl_break is 1)
                ((0.730769 0.495389))
                ((syl_final is 0)
                 ((1.08036 1.25726))
                 ((Syllable.syl_in < 1.6)
                  ((0.850329 0.419261))
                  ((0.589329 -0.0833529)))))
               ((0.908914 -0.264926)))
              ((Syllable.ssyl_out < 1.4)
               ((0.782707 0.622882))
               ((0.65197 0.240529)))))
            ((n.ph_vheight is 1)
             ((Syllable.n.syl_break is 0)
              ((0.455431 -0.261889))
              ((0.454979 -0.67125)))
             ((ph_vlng is s)
              ((0.307938 -0.516316))
              ((Syllable.asyl_in < 1.5)
               ((n.ph_ctype is l)
                ((0.505368 -0.427273))
                ((n.ph_vlng is s)
                 ((0.631801 -0.362941))
                 ((0.844489 -0.00442424))))
               ((0.555269 -0.54915)))))))))))
      ((Syllable.p.syl_break is 0)
       ((n.ph_vlng is s)
        ((ph_cplace is v)
         ((n.ph_vheight is 0)
          ((0.343619 -0.268387))
          ((0.352953 -0.0605926)))
         ((Syllable.ssyl_in < 2.5)
          ((n.ph_vheight is 0)
           ((ph_ctype is s)
            ((0.462919 -0.074))
            ((0.438943 -0.764118)))
           ((p.ph_ctype is s)
            ((0.603907 -0.330478))
            ((Syllable.sub_phrases < 0.4)
             ((Syllable.n.syl_break is 1)
              ((0.481421 -0.518882))
              ((1.02968 -0.0163548)))
             ((0.499078 0.0476667)))))
          ((ph_ctype is f)
           ((0.355361 -0.16681))
           ((0.593565 -0.42116)))))
        ((Syllable.asyl_in < 1.5)
         ((Syllable.syl_out < 3.7)
          ((p.ph_cplace is a)
           ((ph_vlng is l)
            ((0.538408 -0.121243))
            ((ph_ctype is f)
             ((0.605783 -0.35))
             ((Syllable.syl_in < 1.6)
              ((0.761628 -0.551267))
              ((pos_in_syl < 1.2)
               ((n.ph_ctype is f)
                ((0.707258 0.156167))
                ((Syllable.syl_out < 1.2)
                 ((0.809934 -0.491529))
                 ((Syllable.asyl_out < 0.1)
                  ((0.876656 0.0641))
                  ((1.12864 -0.185522)))))
               ((0.771519 -0.555625))))))
           ((Syllable.syl_in < 3.2)
            ((ph_ctype is s)
             ((pos_in_syl < 1.2)
              ((nn.ph_vc is +)
               ((0.862181 0.655833))
               ((0.704838 0.0128333)))
              ((Syllable.syl_in < 1.2)
               ((0.738039 -0.479353))
               ((0.539282 -0.0462778))))
             ((p.ph_cvox is +)
              ((ph_vheight is 2)
               ((0.823812 -0.58181))
               ((0.74919 -0.0415556)))
              ((p.ph_vlng is l)
               ((nn.ph_vc is +)
                ((0.677075 0.404118))
                ((0.867885 0.125882)))
               ((p.ph_ctype is 0)
                ((Syllable.stress is 0)
                 ((pos_in_syl < 0.3)
                  ((0.742095 0.381368))
                  ((Syllable.next_accent < 0.2)
                   ((n.ph_cvox is +)
                    ((1.06727 0.537105))
                    ((1.24839 0.216969)))
                   ((0.801183 -0.292565))))
                 ((0.822695 0.423704)))
                ((0.878425 -0.320688))))))
            ((pp.ph_vc is +)
             ((0.559968 -0.419118))
             ((Syllable.last_accent < 1.5)
              ((0.894468 -0.193548))
              ((0.678614 0.141913))))))
          ((p.ph_ctype is s)
           ((syl_final is 0)
            ((0.696514 -0.3861))
            ((0.522482 -0.554882)))
           ((ph_vc is +)
            ((0.614669 -0.229433))
            ((p.ph_vlng is s)
             ((0.534993 -0.326952))
             ((Syllable.syl_in < 2.1)
              ((Syllable.ssyl_out < 2.2)
               ((nn.ph_vc is +)
                ((0.94494 -0.219167))
                ((1.03957 0.283895)))
               ((0.753394 -0.403526)))
              ((0.605754 -0.101552)))))))
         ((p.ph_ctype is s)
          ((n.ph_cplace is a)
           ((ph_vheight is 2)
            ((0.650629 -0.875706))
            ((0.78037 -0.590444)))
           ((0.435671 -0.409273)))
          ((ph_vc is +)
           ((pos_in_syl < 0.2)
            ((0.676417 0.120448))
            ((0.455516 -0.241917)))
           ((ph_ctype is f)
            ((n.ph_vheight is 1)
             ((0.300592 -0.204667))
             ((0.739384 -0.1934)))
            ((p.ph_ctype is 0)
             ((Syllable.n.syl_break is 4)
              ((0.514392 0.0141429))
              ((n.ph_cplace is a)
               ((0.623986 -0.0739355))
               ((ph_ctype is n)
                ((0.681601 -0.353529))
                ((0.877822 -0.3434)))))
             ((pos_in_syl < 1.2)
              ((n.ph_vc is +)
               ((0.732852 -0.762059))
               ((0.681663 -0.467222)))
              ((0.545361 -0.945)))))))))
       ((n.ph_cvox is -)
        ((ph_cvox is -)
         ((ph_cplace is v)
          ((0.500209 -0.570848))
          ((syl_final is 0)
           ((0.471006 -0.523108))
           ((Syllable.ssyl_in < 1.5)
            ((p.ph_vlng is a)
             ((0.533397 -0.912353))
             ((n.ph_ctype is f)
              ((p.ph_vheight is 3)
               ((0.541567 -0.778611))
               ((p.ph_vheight is 2)
                ((0.89686 -0.725412))
                ((0.927503 -0.360857))))
              ((0.55475 -0.949111))))
            ((0.542581 -0.917708)))))
         ((p.ph_ctype is s)
          ((Syllable.p.syl_break is 4)
           ((0.391996 -0.443833))
           ((n.ph_cplace is a)
            ((0.442334 -0.245083))
            ((Syllable.asyl_in < 0.2)
             ((0.584103 -0.169211))
             ((0.844763 0.1546)))))
          ((ph_vheight is 2)
           ((ph_vfront is 2)
            ((p.ph_ctype is r)
             ((0.581598 -0.242095))
             ((0.701934 0.526567)))
            ((0.371479 0.200895)))
           ((n.ph_cplace is g)
            ((Syllable.p.syl_break is 4)
             ((0.539417 -0.527417))
             ((Syllable.sub_phrases < 0.2)
              ((0.709358 0.135611))
              ((0.729146 -0.247053))))
            ((ph_ctype is n)
             ((Syllable.accented is 0)
              ((Syllable.stress is 0)
               ((Syllable.syl_out < 2.5)
                ((0.740556 0.240882))
                ((1.05328 0.515955)))
               ((0.735487 0.659833)))
              ((0.774536 1.00871)))
             ((pos_in_syl < 1.2)
              ((p.ph_cplace is l)
               ((0.421608 -0.422))
               ((p.ph_ctype is l)
                ((0.504772 0.843889))
                ((Syllable.ssyl_in < 0.6)
                 ((0.656837 0.540793))
                 ((0.849479 -0.05595)))))
              ((p.ph_vheight is 3)
               ((0.387265 -0.509278))
               ((ph_ctype is l)
                ((0.492874 -0.261333))
                ((n.ph_ctype is f)
                 ((0.978811 -0.147621))
                 ((0.589959 -0.191636)))))))))))
        ((n.ph_ctype is f)
         ((ph_ctype is f)
          ((pos_in_syl < 1.2)
           ((Syllable.syl_in < 3)
            ((0.625736 -0.240148))
            ((0.497943 -0.203588)))
           ((0.472391 -0.80665)))
          ((ph_ctype is n)
           ((Syllable.stress is 0)
            ((0.535701 -0.0426177))
            ((0.347693 0.176696)))
           ((n.ph_cplace is d)
            ((Syllable.syl_out < 3.4)
             ((Syllable.asyl_out < 0.1)
              ((0.533213 -0.628353))
              ((0.678464 -0.370483)))
             ((0.333206 -0.487647)))
            ((p.ph_ctype is r)
             ((0.69048 -0.183781))
             ((ph_vc is +)
              ((ph_vheight is 1)
               ((0.78753 0.725156))
               ((Syllable.next_accent < 1.5)
                ((Syllable.sub_phrases < 0.2)
                 ((Syllable.ssyl_in < 0.6)
                  ((1.13565 0.952526))
                  ((1.10217 0.0408125)))
                 ((0.703104 -0.0187083)))
                ((0.650136 -0.501))))
              ((0.717491 0.1288)))))))
         ((Syllable.asyl_out < 0.1)
          ((ph_ctype is 0)
           ((Syllable.p.syl_break is 1)
            ((Syllable.n.syl_break is 4)
             ((0.724666 -0.333333))
             ((0.687727 -0.670222)))
            ((0.463351 -0.721895)))
           ((Syllable.syl_in < 3.3)
            ((p.ph_cvox is +)
             ((Syllable.n.syl_break is 4)
              ((0.712474 0.17644))
              ((ph_ctype is s)
               ((0.807579 -0.102174))
               ((0.579907 -0.620818))))
             ((Syllable.syl_in < 1.2)
              ((pp.ph_vc is +)
               ((0.89119 -0.00927777))
               ((n.ph_vc is +)
                ((Syllable.n.syl_break is 3)
                 ((0.896963 -0.100174))
                 ((n.ph_vfront is 3)
                  ((1.39058 0.861737))
                  ((1.10835 -0.014))))
                ((0.973196 -0.026))))
              ((p.ph_vheight is 2)
               ((0.839859 0.329647))
               ((0.750321 -0.00114285)))))
            ((pp.ph_vc is +)
             ((0.703234 -0.0946))
             ((0.738331 0.333625)))))
          ((Syllable.stress is 0)
           ((Syllable.syl_in < 2.4)
            ((n.ph_vc is +)
             ((Syllable.ssyl_out < 1.2)
              ((Syllable.p.syl_break is 1)
               ((p.ph_vc is +)
                ((0.47701 -0.578))
                ((0.987648 -0.0991515)))
               ((Syllable.syl_out < 3.4)
                ((n.ph_vfront is 3)
                 ((0.944008 0.159522))
                 ((n.ph_vheight is 1)
                  ((0.792901 -0.32135))
                  ((1.26636 0.294739))))
                ((0.830159 0.23845))))
              ((pp.ph_vc is +)
               ((0.585661 -0.242143))
               ((0.770762 0.0859091))))
             ((nn.ph_vc is +)
              ((n.ph_cplace is l)
               ((0.586944 -0.746294))
               ((ph_cvox is +)
                ((0.68788 -0.143263))
                ((0.909666 -0.197231))))
              ((0.433017 -0.984773))))
            ((n.ph_vfront is 3)
             ((0.498073 -0.0211111))
             ((ph_ctype is f)
              ((0.87336 -0.11756))
              ((0.686137 -0.35975)))))
           ((n.ph_vlng is s)
            ((Syllable.syl_out < 3.4)
             ((p.ph_cvox is -)
              ((0.659338 -0.215333))
              ((Syllable.ssyl_in < 0.3)
               ((0.847133 -0.147103))
               ((1.02979 0.880219))))
             ((0.655496 -0.347926)))
            ((ph_ctype is 0)
             ((ph_vfront is 1)
              ((0.505291 -0.702862))
              ((p.ph_cplace is l)
               ((0.519906 -0.119789))
               ((Syllable.n.syl_break is 0)
                ((0.543837 0.202765))
                ((1.0174 0.563619)))))
             ((n.ph_vheight is 1)
              ((Syllable.p.syl_break is 4)
               ((0.697605 0.251031))
               ((n.ph_vfront is 1)
                ((pp.ph_vc is +)
                 ((0.639866 -0.539091))
                 ((0.878801 0.0442632)))
                ((p.ph_cvox is +)
                 ((0.960057 -0.0626))
                 ((1.05768 1.32257)))))
              ((n.ph_vlng is l)
               ((p.ph_cvox is -)
                ((0.767759 -0.391739))
                ((syl_final is 0)
                 ((pp.ph_vc is +)
                  ((0.93818 0.387706))
                  ((1.23779 0.899053)))
                 ((0.922599 -0.4605))))
               ((n.ph_ctype is l)
                ((0.996938 0.422636))
                ((n.ph_cplace is l)
                 ((0.982005 -0.0945357))
                 ((ph_cplace is b)
                  ((0.953998 0.126636))
                  ((Syllable.syl_in < 3.5)
                   ((ph_ctype is f)
                    ((1.14965 0.901955))
                    ((Syllable.asyl_in < 0.2)
                     ((Syllable.n.syl_break is 1)
                      ((1.31564 0.591))
                      ((2.21286 1.5403)))
                     ((1.20264 0.56))))
                   ((1.13685 0.6084))))))))))))))))))
   ((Syllable.accented is 0)
    ((ph_vfront is 1)
     ((Syllable.n.syl_break is 1)
      ((n.ph_ctype is n)
       ((p.ph_ctype is n)
        ((0.393075 -1.05956))
        ((0.377954 -0.812238)))
       ((ph_vlng is d)
        ((0.403553 -0.7125))
        ((n.ph_cplace is d)
         ((0.353755 -0.58481))
         ((n.ph_ctype is r)
          ((0.457238 -0.929389))
          ((Syllable.ssyl_in < 1.2)
           ((Syllable.syl_in < 0.5)
            ((0.441172 -0.557278))
            ((n.ph_ctype is s)
             ((0.544261 -0.701647))
             ((0.685384 -0.159316))))
           ((0.367493 -0.666286)))))))
      ((p.ph_cplace is l)
       ((n.ph_ctype is r)
        ((0.2626 -0.33432))
        ((Syllable.n.syl_break is 4)
         ((0.452325 -0.066963))
         ((Syllable.p.syl_break is 1)
          ((0.51945 -0.60035))
          ((0.680917 -0.373)))))
       ((p.ph_ctype is r)
        ((ph_vheight is 2)
         ((0.384609 -0.882931))
         ((n.ph_ctype is s)
          ((0.459617 -0.800773))
          ((n.ph_cvox is -)
           ((0.336741 -0.8881))
           ((Syllable.n.syl_break is 0)
            ((0.639394 -0.489864))
            ((0.595082 -0.29315))))))
        ((p.ph_ctype is 0)
         ((n.ph_cplace is a)
          ((Syllable.p.syl_break is 1)
           ((0.550763 -0.829588))
           ((0.661417 -0.522789)))
          ((0.361263 -0.473167)))
         ((n.ph_cvox is -)
          ((syl_final is 0)
           ((Syllable.n.syl_break is 4)
            ((0.422389 0.294762))
            ((0.562709 -0.0755455)))
           ((p.ph_ctype is s)
            ((0.280882 -0.501722))
            ((0.372348 -0.205889))))
          ((Syllable.sub_phrases < 0.4)
           ((Syllable.stress is 0)
            ((n.ph_ctype is s)
             ((0.497758 -0.7929))
             ((Syllable.n.syl_break is 0)
              ((n.ph_ctype is n)
               ((0.627921 -0.690474))
               ((0.886169 -0.314222)))
              ((0.496597 -0.803714))))
            ((p.ph_ctype is f)
             ((0.794406 0.255393))
             ((0.698005 -0.303407))))
           ((Syllable.n.syl_break is 0)
            ((0.620762 -0.605412))
            ((0.507108 -0.317278)))))))))
     ((n.ph_ctype is s)
      ((n.ph_cplace is l)
       ((p.ph_ctype is r)
        ((ph_vlng is l)
         ((0.473544 -0.652333))
         ((0.395283 -0.788353)))
        ((Syllable.sub_phrases < 0.4)
         ((p.ph_cvox is +)
          ((0.507455 -0.226621))
          ((p.ph_vlng is a)
           ((0.340133 -0.29545))
           ((p.ph_ctype is f)
            ((0.465445 -0.444071))
            ((n.ph_cvox is -)
             ((0.758062 -0.0563704))
             ((0.662969 -0.624929))))))
         ((nn.ph_vc is +)
          ((0.534366 -0.308433))
          ((0.413345 -0.344474)))))
       ((Syllable.stress is 0)
        ((n.ph_cplace is a)
         ((Syllable.n.syl_break is 1)
          ((ph_cplace is a)
           ((0.467807 -0.925955))
           ((0.571205 -0.363556)))
          ((p.ph_cvox is -)
           ((Syllable.p.syl_break is 0)
            ((0.534551 -0.953))
            ((0.502897 -0.387963)))
           ((p.ph_ctype is r)
            ((0.223957 -0.850889))
            ((Syllable.n.syl_break is 4)
             ((0.621248 -0.52725))
             ((ph_ctype is n)
              ((0.632981 0.128963))
              ((ph_vlng is a)
               ((0.632342 -0.119467))
               ((0.868101 -0.73792))))))))
         ((Syllable.n.syl_break is 4)
          ((n.ph_cvox is -)
           ((0.59323 -0.222889))
           ((0.416625 -0.0832941)))
          ((Syllable.syl_out < 5)
           ((p.ph_cplace is a)
            ((Syllable.syl_out < 2.2)
             ((0.654183 -0.213765))
             ((0.51565 -0.481579)))
            ((p.ph_ctype is f)
             ((0.592594 0.276316))
             ((Syllable.syl_in < 3.6)
              ((0.971897 0.274808))
              ((0.585997 -0.100706)))))
           ((0.518687 -0.342773)))))
        ((ph_ctype is n)
         ((n.ph_cvox is -)
          ((0.396422 -0.851214))
          ((0.373723 -0.679118)))
         ((ph_cvox is +)
          ((Syllable.asyl_out < 0.1)
           ((0.471612 0.0158824))
           ((0.269637 -0.5186)))
          ((ph_vheight is 2)
           ((0.362089 -0.610111))
           ((Syllable.asyl_in < 1.2)
            ((pos_in_syl < 1.5)
             ((0.812882 -0.541609))
             ((0.49877 -1.06842)))
            ((0.498362 -0.4687))))))))
      ((p.ph_cvox is -)
       ((n.ph_ctype is n)
        ((Syllable.asyl_in < 0.4)
         ((0.331891 -0.656185))
         ((Syllable.syl_out < 3.1)
          ((Syllable.next_accent < 0.2)
           ((Syllable.ssyl_in < 1.2)
            ((0.552738 -0.701526))
            ((0.948005 -0.292174)))
           ((0.360106 -0.647792)))
          ((0.440822 -0.736087))))
        ((ph_ctype is r)
         ((p.ph_cplace is v)
          ((0.201799 -1.129))
          ((p.ph_cplace is l)
           ((0.371566 -1.02738))
           ((Syllable.n.syl_break is 4)
            ((0.506635 -0.356944))
            ((p.ph_cplace is a)
             ((0.8487 -0.2258))
             ((0.628208 -0.692941))))))
         ((n.ph_ctype is f)
          ((ph_vlng is s)
           ((0.283989 -0.178412))
           ((n.ph_cplace is d)
            ((0.420234 -0.380407))
            ((Syllable.p.syl_break is 0)
             ((0.494234 -0.00603846))
             ((0.717876 0.400966)))))
          ((ph_vlng is a)
           ((n.ph_ctype is l)
            ((0.330319 -0.408844))
            ((0.322061 -0.697526)))
           ((ph_vlng is l)
            ((pp.ph_vc is +)
             ((0.392934 -0.638556))
             ((0.5109 -0.623455)))
            ((p.ph_cplace is p)
             ((ph_vc is +)
              ((0.38979 -0.934824))
              ((0.368826 -0.289176)))
             ((Syllable.asyl_in < 1.2)
              ((syl_final is 0)
               ((pos_in_syl < 0.2)
                ((Syllable.stress is 0)
                 ((p.ph_ctype is 0)
                  ((0.79911 0.0345294))
                  ((0.884222 0.454412)))
                 ((ph_ctype is s)
                  ((0.804289 0.0702941))
                  ((0.806781 -0.466895))))
                ((0.692046 -0.730105)))
               ((0.638153 -0.16864)))
              ((0.574807 -0.126032)))))))))
       ((n.ph_vlng is s)
        ((ph_ctype is n)
         ((p.ph_vc is +)
          ((Syllable.syl_out < 2.2)
           ((0.608054 -0.122773))
           ((0.429263 -0.346722)))
          ((0.41886 -0.900105)))
         ((pos_in_syl < 1.2)
          ((p.ph_vheight is 0)
           ((n.ph_ctype is n)
            ((0.588902 -0.544615))
            ((p.ph_ctype is f)
             ((0.558809 -0.000411763))
             ((ph_ctype is f)
              ((0.580769 0.0708421))
              ((Syllable.next_accent < 0.6)
               ((p.ph_ctype is n)
                ((0.98941 0.0900952))
                ((0.536082 0.604588)))
               ((0.785262 -0.477476))))))
           ((p.ph_vlng is d)
            ((0.334998 0.461318))
            ((p.ph_vlng is l)
             ((0.541504 0.425667))
             ((ph_ctype is f)
              ((0.652498 0.377571))
              ((0.833977 0.646321))))))
          ((ph_cvox is +)
           ((0.634039 0.20929))
           ((0.446745 -0.145471)))))
        ((Syllable.n.syl_break is 1)
         ((n.ph_vlng is l)
          ((p.ph_cplace is l)
           ((0.243259 0.24475))
           ((p.ph_vc is +)
            ((ph_cplace is a)
             ((0.979428 0.75724))
             ((0.564646 0.136045)))
            ((0.575572 -0.207217))))
          ((pos_in_syl < 1.2)
           ((nn.ph_vc is +)
            ((n.ph_cplace is d)
             ((0.461216 -0.38625))
             ((Syllable.ssyl_in < 2.5)
              ((Syllable.syl_out < 2.5)
               ((0.682783 -0.325235))
               ((syl_final is 0)
                ((0.787661 0.398917))
                ((n.ph_ctype is f)
                 ((0.789913 0.0575294))
                 ((0.883701 -0.449471)))))
              ((0.622216 -0.216947))))
            ((ph_vlng is l)
             ((0.255914 -1.25265))
             ((p.ph_ctype is n)
              ((0.604962 -0.450471))
              ((0.695045 -0.801944)))))
           ((Syllable.syl_out < 3.2)
            ((0.516803 -0.345))
            ((0.494694 -0.6872)))))
         ((n.ph_cvox is -)
          ((ph_ctype is n)
           ((pos_in_syl < 1.2)
            ((0.714045 0.4379))
            ((0.535469 -0.0191)))
           ((ph_cvox is -)
            ((0.55435 -0.691889))
            ((pp.ph_vc is +)
             ((Syllable.sub_phrases < 0.3)
              ((p.ph_ctype is n)
               ((0.676959 0.0626667))
               ((0.882281 0.3324)))
              ((0.62781 0.359105)))
             ((Syllable.n.syl_break is 4)
              ((0.536028 -0.239952))
              ((Syllable.asyl_in < 0.4)
               ((0.956761 0.02505))
               ((0.819911 -0.577)))))))
          ((ph_vfront is 2)
           ((p.ph_ctype is r)
            ((n.ph_ctype is f)
             ((0.226798 -0.90205))
             ((n.ph_cplace is a)
              ((0.866704 -0.456263))
              ((0.136558 -0.880053))))
            ((p.ph_cplace is l)
             ((n.ph_ctype is l)
              ((0.202275 -0.867941))
              ((0.885005 -0.221583)))
             ((Syllable.asyl_in < 1.2)
              ((Syllable.sub_phrases < 0.3)
               ((n.ph_cplace is a)
                ((Syllable.asyl_out < 0.1)
                 ((p.ph_cplace is a)
                  ((0.797873 0.158294))
                  ((1.56089 0.0324091)))
                 ((0.555387 -0.0905455)))
                ((0.747572 -0.185565)))
               ((Syllable.syl_out < 2.2)
                ((0.934427 -0.0147895))
                ((0.424294 -0.393059))))
              ((n.ph_ctype is n)
               ((0.462656 -0.656333))
               ((0.700762 0.0210606))))))
           ((p.ph_vheight is 1)
            ((ph_cplace is p)
             ((0.500559 0.515034))
             ((ph_cplace is l)
              ((0.524593 0.255323))
              ((pos_in_syl < 1.2)
               ((ph_cvox is +)
                ((0.664273 0.371774))
                ((0.676619 0.981588)))
               ((0.526269 -0.00923529)))))
            ((p.ph_vlng is s)
             ((n.ph_cplace is a)
              ((0.526201 -0.386412))
              ((p.ph_ctype is l)
               ((0.459122 0.472579))
               ((n.ph_vlng is l)
                ((0.830779 -0.27025))
                ((0.739583 0.419467)))))
             ((Syllable.sub_phrases < 0.3)
              ((n.ph_vfront is 3)
               ((ph_vc is +)
                ((0.172534 1.39))
                ((p.ph_ctype is l)
                 ((0.386754 0.453579))
                 ((1.20502 0.231152))))
               ((ph_vheight is 0)
                ((ph_ctype is f)
                 ((0.778729 0.142242))
                 ((Syllable.asyl_in < 0.4)
                  ((n.ph_cplace is a)
                   ((0.852892 0.478278))
                   ((0.809438 -0.0250556)))
                  ((n.ph_cplace is p)
                   ((0.890134 -0.9626))
                   ((Syllable.syl_out < 2.6)
                    ((Syllable.n.syl_break is 0)
                     ((0.701195 0.226263))
                     ((Syllable.syl_in < 4.3)
                      ((ph_ctype is s)
                       ((1.18672 -0.377421))
                       ((1.92526 0.777095)))
                      ((0.871103 0.0488823))))
                    ((0.760336 0.195714))))))
                ((nn.ph_vc is +)
                 ((0.714123 -0.342115))
                 ((0.556611 -1.03429)))))
              ((ph_vheight is 0)
               ((n.ph_vlng is d)
                ((0.552867 -0.498278))
                ((ph_cplace is l)
                 ((0.739027 -0.301882))
                 ((p.ph_vlng is a)
                  ((0.70365 -0.00705882))
                  ((n.ph_vheight is 1)
                   ((1.36429 0.0178095))
                   ((0.862794 0.0334706))))))
               ((0.465038 -0.731316)))))))))))))
    ((Syllable.syl_out < 1.6)
     ((Syllable.ssyl_out < 0.1)
      ((n.ph_vc is +)
       ((ph_ctype is f)
        ((p.ph_vlng is a)
         ((ph_cvox is -)
          ((Syllable.stress is 0)
           ((0.427835 0.574176))
           ((0.590696 0.481903)))
          ((Syllable.syl_in < 7)
           ((0.674674 0.1066))
           ((0.598985 0.0547647))))
         ((n.ph_vheight is 0)
          ((p.ph_vlng is d)
           ((0.594952 -0.0815294))
           ((0.624027 -0.640697)))
          ((p.ph_cvox is +)
           ((Syllable.stress is 0)
            ((0.48543 -0.116556))
            ((n.ph_vlng is s)
             ((0.60595 0.449333))
             ((0.635854 0.0892))))
           ((p.ph_vlng is s)
            ((Syllable.ssyl_in < 1.5)
             ((0.667017 -0.304526))
             ((0.600971 0.486353)))
            ((ph_cvox is -)
             ((p.ph_vc is +)
              ((Syllable.stress is 0)
               ((0.519819 0.158522))
               ((n.ph_vfront is 3)
                ((0.929989 1.17956))
                ((0.783096 0.606778))))
              ((Syllable.asyl_in < 1.2)
               ((1.01837 0.05748))
               ((0.843984 -0.425222))))
             ((p.ph_vlng is d)
              ((0.910132 0.287684))
              ((0.592139 -0.00594117))))))))
        ((ph_cplace is l)
         ((n.ph_vheight is 0)
          ((0.384948 -0.372111))
          ((Syllable.syl_in < 5.2)
           ((Syllable.asyl_in < 1.2)
            ((p.ph_vlng is a)
             ((0.784494 0.7276))
             ((Syllable.p.syl_break is 0)
              ((0.877553 -0.332294))
              ((Syllable.syl_break is 3)
               ((0.845627 0.415412))
               ((1.38006 0.672565)))))
            ((0.765016 -0.02895)))
           ((0.433397 0.333696))))
         ((p.ph_ctype is f)
          ((Syllable.syl_in < 1.1)
           ((0.642338 -0.117364))
           ((Syllable.next_accent < 0.3)
            ((0.695924 -0.16872))
            ((ph_cvox is -)
             ((0.620923 -0.0656875))
             ((p.ph_cplace is a)
              ((0.723145 0.108706))
              ((1.09175 0.959969))))))
          ((ph_ctype is l)
           ((p.ph_vc is +)
            ((n.ph_vlng is l)
             ((0.646963 0.588063))
             ((0.671523 1.08014)))
            ((p.ph_cplace is a)
             ((0.773363 0.1115))
             ((Syllable.syl_in < 3.4)
              ((0.591086 -0.727368))
              ((0.871448 -0.431389)))))
           ((Syllable.stress is 0)
            ((Syllable.asyl_in < 2.4)
             ((ph_ctype is s)
              ((Syllable.n.syl_break is 1)
               ((p.ph_vheight is 2)
                ((0.628716 -0.371235))
                ((0.875511 -0.23236)))
               ((0.574712 -0.445765)))
              ((Syllable.last_accent < 1.2)
               ((pos_in_syl < 0.2)
                ((1.03465 -0.314313))
                ((syl_final is 0)
                 ((0.847188 -0.186613))
                 ((1.40072 1.00876))))
               ((0.983806 0.0658636))))
             ((pos_in_syl < 0.4)
              ((0.667788 -0.395368))
              ((0.77173 0.0673158))))
            ((p.ph_vlng is a)
             ((n.ph_vlng is d)
              ((0.62884 1.23078))
              ((1.05202 1.40279)))
             ((ph_cplace is v)
              ((p.ph_vc is +)
               ((0.876794 1.43453))
               ((0.675027 0.494765)))
              ((Syllable.syl_in < 5.2)
               ((ph_ctype is n)
                ((0.832943 0.108375))
                ((pos_in_syl < 1.2)
                 ((ph_ctype is r)
                  ((p.ph_cvox is -)
                   ((0.632153 -0.801333))
                   ((p.ph_ctype is s)
                    ((0.561271 -0.0891765))
                    ((1.41073 0.628905))))
                  ((Syllable.syl_break is 3)
                   ((1.21406 1.49294))
                   ((1.11648 0.964176))))
                 ((0.927258 0.474368))))
               ((0.898013 0.0422414))))))))))
       ((Syllable.syl_break is 4)
        ((ph_vfront is 1)
         ((n.ph_ctype is f)
          ((Syllable.ssyl_in < 2.4)
           ((Syllable.asyl_in < 0.3)
            ((0.541998 2.65223))
            ((Syllable.next_accent < 0.5)
             ((pp.ph_vc is +)
              ((0.75953 2.06612))
              ((0.942132 2.54355)))
             ((p.ph_cplace is a)
              ((p.ph_ctype is f)
               ((0.820245 2.20389))
               ((Syllable.last_accent < 0.3)
                ((1.00759 1.31794))
                ((1.80119 1.89525))))
              ((0.643159 1.35422)))))
           ((n.ph_cvox is -)
            ((0.695908 1.21665))
            ((0.867349 1.63873))))
          ((p.ph_ctype is r)
           ((p.ph_cplace is l)
            ((0.536246 0.91625))
            ((n.ph_ctype is r)
             ((0.64197 0.75125))
             ((Syllable.last_accent < 1.4)
              ((Syllable.stress is 0)
               ((0.980995 -0.0424243))
               ((0.909871 1.01148)))
              ((0.809589 1.25718)))))
           ((Syllable.p.syl_break is 0)
            ((n.ph_cplace is v)
             ((n.ph_ctype is n)
              ((p.ph_cplace is a)
               ((0.659731 0.158074))
               ((0.448079 -0.25336)))
              ((0.737672 1.36643)))
             ((pos_in_syl < 0.2)
              ((syl_final is 0)
               ((0.896553 0.946455))
               ((0.73768 0.6219)))
              ((n.ph_ctype is 0)
               ((p.ph_ctype is f)
                ((0.764993 1.64635))
                ((1.07254 1.47467)))
               ((Syllable.last_accent < 1.2)
                ((ph_vlng is s)
                 ((1.04072 1.18058))
                 ((1.02224 0.37869)))
                ((0.835007 0.976619))))))
            ((ph_vheight is 3)
             ((Syllable.ssyl_in < 1.2)
              ((0.691597 2.17553))
              ((0.856556 1.76339)))
             ((pos_in_syl < 0.2)
              ((0.860946 1.79039))
              ((n.ph_ctype is n)
               ((ph_vlng is s)
                ((0.796309 1.29739))
                ((0.7929 0.708412)))
               ((n.ph_ctype is l)
                ((1.01732 0.962476))
                ((p.ph_ctype is s)
                 ((1.27665 2.38621))
                 ((0.646536 1.74233))))))))))
         ((ph_ctype is s)
          ((Syllable.syl_in < 6.5)
           ((n.ph_ctype is 0)
            ((p.ph_cvox is -)
             ((Syllable.last_accent < 0.3)
              ((0.564163 0.490941))
              ((0.721907 0.741458)))
             ((nn.ph_vc is +)
              ((p.ph_vheight is 0)
               ((0.879604 0.35695))
               ((0.787114 0.957765)))
              ((Syllable.syl_in < 2.4)
               ((pos_in_syl < 2.2)
                ((0.861591 1.51555))
                ((1.03259 1.157)))
               ((ph_cplace is v)
                ((0.977205 0.278944))
                ((p.ph_vheight is 2)
                 ((0.917708 0.9335))
                 ((Syllable.last_accent < 1.2)
                  ((Syllable.syl_in < 3.3)
                   ((1.15097 0.922833))
                   ((1.4019 0.628312)))
                  ((0.888554 1.11371))))))))
            ((pos_in_syl < 2.5)
             ((p.ph_ctype is n)
              ((Syllable.stress is 0)
               ((0.819099 -0.463333))
               ((0.971516 0.752889)))
              ((p.ph_cvox is +)
               ((n.ph_ctype is r)
                ((1.1312 0.756667))
                ((0.848119 0.201364)))
               ((p.ph_vlng is a)
                ((1.01039 1.01128))
                ((ph_cplace is v)
                 ((p.ph_vlng is s)
                  ((1.04409 -0.688955))
                  ((0.825026 0.144294)))
                 ((Syllable.next_accent < 1.2)
                  ((Syllable.asyl_in < 1.2)
                   ((Syllable.next_accent < 0.1)
                    ((2.20264 1.89832))
                    ((1.28834 0.992667)))
                   ((1.20696 0.552263)))
                  ((1.2164 0.414056)))))))
             ((n.ph_ctype is s)
              ((0.803061 -0.8594))
              ((Syllable.last_accent < 1.2)
               ((p.ph_ctype is n)
                ((1.19123 -0.400767))
                ((1.06507 0.28669)))
               ((0.715998 -0.408789))))))
           ((pos_in_syl < 0.4)
            ((0.816046 0.388774))
            ((ph_cvox is -)
             ((p.ph_vheight is 1)
              ((0.93372 0.311842))
              ((Syllable.ssyl_in < 4.5)
               ((n.ph_ctype is 0)
                ((1.01932 0.483333))
                ((1.1058 -0.187207)))
               ((0.947328 -0.367348))))
             ((0.976492 0.88795)))))
          ((Syllable.ssyl_in < 3.2)
           ((n.ph_ctype is s)
            ((ph_cvox is -)
             ((p.ph_vheight is 1)
              ((0.64637 0.480667))
              ((p.ph_vheight is 2)
               ((0.713564 0.568724))
               ((p.ph_cvox is -)
                ((0.72344 -0.0569412))
                ((0.88342 0.156393)))))
             ((ph_ctype is 0)
              ((p.ph_ctype is f)
               ((0.780821 1.4677))
               ((n.ph_cvox is -)
                ((Syllable.ssyl_in < 1.2)
                 ((0.990245 1.7995))
                 ((1.27899 0.950323)))
                ((1.03901 2.36632))))
              ((p.ph_cvox is +)
               ((syl_final is 0)
                ((0.734267 0.676708))
                ((0.616756 0.0265)))
               ((p.ph_vlng is l)
                ((1.01511 0.970282))
                ((p.ph_vheight is 3)
                 ((Syllable.syl_in < 3.4)
                  ((0.944775 -0.182059))
                  ((1.20129 0.196476)))
                 ((Syllable.sub_phrases < 0.4)
                  ((ph_ctype is n)
                   ((syl_final is 0)
                    ((Syllable.syl_in < 4.5)
                     ((1.43393 0.607824))
                     ((1.04306 0.201571)))
                    ((1.15058 1.38457)))
                   ((1.1369 1.20937)))
                  ((n.ph_cvox is -)
                   ((0.98546 0.461654))
                   ((1.13611 0.964706)))))))))
            ((n.ph_ctype is n)
             ((Syllable.stress is 0)
              ((p.ph_cplace is p)
               ((Syllable.syl_in < 4.4)
                ((0.520267 0.402778))
                ((0.6268 0.136)))
               ((p.ph_cvox is -)
                ((0.652471 0.149))
                ((p.ph_ctype is f)
                 ((0.795827 -0.0265455))
                 ((p.ph_ctype is r)
                  ((0.505216 -0.4766))
                  ((Syllable.n.syl_break is 0)
                   ((0.832237 0.02592))
                   ((Syllable.asyl_in < 1.3)
                    ((0.804028 0.175393))
                    ((1.00382 0.831667))))))))
              ((ph_vfront is 3)
               ((0.886554 1.63443))
               ((ph_vheight is 2)
                ((1.24287 2.33105))
                ((pos_in_syl < 1.2)
                 ((0.741971 1.365))
                 ((0.766855 0.453833))))))
             ((p.ph_ctype is s)
              ((ph_vlng is d)
               ((0.936764 0.786533))
               ((ph_cvox is -)
                ((n.ph_ctype is 0)
                 ((Syllable.syl_in < 5.5)
                  ((Syllable.asyl_in < 1.2)
                   ((1.01918 1.26713))
                   ((0.927051 0.646474)))
                  ((0.802295 0.662737)))
                 ((0.856407 -0.1786)))
                ((ph_ctype is r)
                 ((0.959169 1.22452))
                 ((n.ph_ctype is r)
                  ((0.810016 0.363588))
                  ((p.ph_cvox is -)
                   ((0.852085 1.68656))
                   ((ph_cplace is a)
                    ((1.21337 1.24763))
                    ((1.22304 2.44926))))))))
              ((nn.ph_vc is -)
               ((Syllable.last_accent < 1.2)
                ((ph_ctype is n)
                 ((n.ph_cvox is -)
                  ((ph_cplace is v)
                   ((0.823127 -0.00825926))
                   ((p.ph_vlng is s)
                    ((0.884811 0.663471))
                    ((pos_in_syl < 1.2)
                     ((1.16916 0.914263))
                     ((Syllable.asyl_in < 1.2)
                      ((1.21864 0.534056))
                      ((1.73633 1.01883))))))
                  ((p.ph_vheight is 2)
                   ((0.891564 2.534))
                   ((0.820933 1.45157))))
                 ((ph_ctype is r)
                  ((n.ph_ctype is f)
                   ((p.ph_cvox is +)
                    ((0.584698 1.25126))
                    ((0.867376 2.01004)))
                   ((0.755766 0.773457)))
                  ((ph_vheight is 3)
                   ((p.ph_cplace is a)
                    ((1.03247 2.11628))
                    ((Syllable.last_accent < 0.1)
                     ((0.813564 0.299105))
                     ((0.886516 1.12812))))
                   ((p.ph_vheight is 2)
                    ((ph_cplace is b)
                     ((0.854414 0.393391))
                     ((p.ph_vlng is s)
                      ((0.665171 0.637955))
                      ((ph_cvox is -)
                       ((1.45017 2.70448))
                       ((Syllable.asyl_in < 1.2)
                        ((1.20157 1.42812))
                        ((1.46954 1.73365))))))
                    ((p.ph_vlng is l)
                     ((1.43235 1.01322))
                     ((pos_in_syl < 2.4)
                      ((ph_vfront is 3)
                       ((1.46247 1.99586))
                       ((p.ph_cvox is -)
                        ((1.72972 2.99))
                        ((Syllable.next_accent < 0.4)
                         ((1.67573 1.58575))
                         ((p.ph_cplace is a)
                          ((1.72324 0.8962))
                          ((3.1458 2.70237))))))
                      ((Syllable.next_accent < 0.3)
                       ((1.13172 1.41871))
                       ((1.58864 1.49881)))))))))
                ((Syllable.stress is 0)
                 ((Syllable.asyl_in < 1.2)
                  ((1.13851 1.22589))
                  ((0.782116 0.827667)))
                 ((ph_vheight is 3)
                  ((0.927599 1.68971))
                  ((Syllable.ssyl_in < 2.1)
                   ((Syllable.syl_in < 2.6)
                    ((1.44864 1.30533))
                    ((Syllable.syl_in < 3.5)
                     ((1.30459 2.05106))
                     ((1.83003 1.40157))))
                   ((1.24512 1.36768))))))
               ((ph_vc is +)
                ((Syllable.asyl_in < 1.2)
                 ((1.24149 1.45611))
                 ((0.856621 0.9178)))
                ((p.ph_vheight is 0)
                 ((Syllable.stress is 0)
                  ((0.781972 0.478333))
                  ((1.17921 0.356679)))
                 ((n.ph_ctype is r)
                  ((1.1293 0.618724))
                  ((Syllable.ssyl_in < 1.2)
                   ((p.ph_vlng is s)
                    ((1.26368 -0.118879))
                    ((1.21522 0.835929)))
                   ((Syllable.syl_in < 3.4)
                    ((1.08455 1.66667))
                    ((Syllable.next_accent < 0.4)
                     ((0.913012 0.999895))
                     ((p.ph_vheight is 2)
                      ((1.47429 1.28775))
                      ((1.37123 1.78761)))))))))))))
           ((Syllable.last_accent < 2.4)
            ((n.ph_ctype is 0)
             ((ph_vc is +)
              ((0.684463 0.961733))
              ((pos_in_syl < 2.2)
               ((Syllable.next_accent < 1.2)
                ((p.ph_cplace is a)
                 ((1.01225 1.76559))
                 ((ph_ctype is f)
                  ((0.985969 1.81785))
                  ((pos_in_syl < 1.1)
                   ((0.948763 0.754294))
                   ((1.67093 1.11958)))))
                ((0.988775 1.45283)))
               ((Syllable.ssyl_in < 4.3)
                ((0.808773 1.17095))
                ((0.887684 0.524706)))))
             ((n.ph_ctype is n)
              ((p.ph_cvox is -)
               ((0.618045 0.163056))
               ((Syllable.syl_in < 6.4)
                ((0.599541 0.548389))
                ((0.942143 0.298594))))
              ((ph_ctype is f)
               ((0.909559 0.0641714))
               ((ph_ctype is r)
                ((0.935684 1.17114))
                ((n.ph_ctype is f)
                 ((ph_vlng is a)
                  ((0.917951 2.5416))
                  ((pos_in_syl < 1.2)
                   ((1.39288 2.0673))
                   ((1.20413 1.31676))))
                 ((ph_vfront is 2)
                  ((0.950885 0.286588))
                  ((Syllable.syl_in < 6.7)
                   ((1.25478 1.15668))
                   ((1.10316 0.0645769)))))))))
            ((p.ph_vheight is 1)
             ((0.709381 1.58871))
             ((p.ph_vlng is l)
              ((0.742192 0.298045))
              ((ph_ctype is f)
               ((0.653795 0.958471))
               ((1.155 0.867526)))))))))
        ((ph_ctype is s)
         ((p.ph_ctype is n)
          ((nn.ph_vc is +)
           ((pos_in_syl < 0.4)
            ((0.861047 -0.265765))
            ((0.878758 -0.765105)))
           ((0.280317 -1.09573)))
          ((n.ph_ctype is s)
           ((0.750783 -0.709694))
           ((Syllable.syl_in < 6)
            ((Syllable.stress is 0)
             ((p.ph_vheight is 2)
              ((0.640173 -0.100056))
              ((0.666084 -0.6395)))
             ((pos_in_syl < 1.5)
              ((0.769249 0.91675))
              ((ph_cvox is -)
               ((0.711908 -0.497939))
               ((0.793931 0.09825)))))
            ((0.681678 -0.0272069)))))
         ((ph_ctype is f)
          ((Syllable.last_accent < 1.2)
           ((n.ph_cplace is l)
            ((0.638201 -0.261812))
            ((n.ph_cplace is d)
             ((0.736012 -0.740423))
             ((p.ph_cvox is +)
              ((n.ph_cplace is a)
               ((0.582751 -0.244522))
               ((0.704023 0.288059)))
              ((n.ph_cvox is -)
               ((Syllable.p.syl_break is 0)
                ((0.995781 -0.917783))
                ((n.ph_ctype is f)
                 ((0.888108 -0.481611))
                 ((0.966816 0.0691429))))
               ((0.890369 0.48396))))))
           ((pos_in_syl < 2.5)
            ((0.664547 -0.356107))
            ((0.595199 -0.436947))))
          ((n.ph_ctype is n)
           ((Syllable.stress is 0)
            ((p.ph_cvox is -)
             ((0.444198 -0.578545))
             ((Syllable.next_accent < 0.3)
              ((0.480369 -0.5138))
              ((Syllable.asyl_in < 1.5)
               ((0.600703 -0.498861))
               ((0.563815 -0.244056)))))
            ((p.ph_ctype is r)
             ((0.578788 0.104353))
             ((Syllable.next_accent < 1.2)
              ((p.ph_cvox is -)
               ((0.73976 0.443))
               ((0.676985 1.07476)))
              ((0.784547 0.250409)))))
           ((Syllable.sub_phrases < 0.4)
            ((p.ph_ctype is f)
             ((n.ph_cplace is a)
              ((n.ph_ctype is f)
               ((Syllable.ssyl_in < 0.5)
                ((0.598362 1.66795))
                ((p.ph_cplace is a)
                 ((Syllable.next_accent < 0.4)
                  ((0.661817 1.42383))
                  ((0.794517 1.58138)))
                 ((0.788344 0.896222))))
               ((Syllable.syl_in < 3.8)
                ((0.814739 0.767633))
                ((0.698331 0.166815))))
              ((n.ph_ctype is f)
               ((0.541256 0.676))
               ((0.683652 0.447316))))
             ((n.ph_ctype is f)
              ((Syllable.ssyl_in < 0.5)
               ((0.912926 0.791897))
               ((p.ph_cplace is a)
                ((syl_final is 0)
                 ((0.973987 0.772))
                 ((0.758525 0.284412)))
                ((ph_cplace is v)
                 ((0.729832 0.493471))
                 ((ph_ctype is 0)
                  ((1.15779 1.53004))
                  ((p.ph_ctype is 0)
                   ((1.23774 0.949419))
                   ((0.958059 0.210529)))))))
              ((Syllable.ssyl_in < 2.1)
               ((Syllable.asyl_in < 1.2)
                ((Syllable.syl_in < 3.6)
                 ((p.ph_cvox is -)
                  ((0.991208 0.153741))
                  ((p.ph_vlng is s)
                   ((1.03853 0.412885))
                   ((ph_cplace is a)
                    ((1.05131 -0.0621379))
                    ((Syllable.p.syl_break is 1)
                     ((1.10798 1.14727))
                     ((1.28266 0.198625))))))
                 ((0.940842 0.354061)))
                ((1.00703 0.27)))
               ((pos_in_syl < 1.2)
                ((0.996863 0.296167))
                ((0.649162 -0.3375))))))
            ((Syllable.ssyl_in < 2.4)
             ((p.ph_ctype is r)
              ((0.619009 -0.0368889))
              ((p.ph_cvox is -)
               ((0.675986 0.765263))
               ((n.ph_ctype is s)
                ((0.836267 0.201742))
                ((Syllable.syl_in < 2.4)
                 ((0.956155 0.618476))
                 ((0.991536 0.989529))))))
             ((0.700899 0.0606296)))))))))
      ((ph_vfront is 1)
       ((ph_vlng is d)
        ((Syllable.asyl_in < 1.2)
         ((p.ph_ctype is s)
          ((0.285252 -0.0774737))
          ((n.ph_cvox is -)
           ((0.567981 -0.0579643))
           ((0.405579 -0.43385))))
         ((0.273991 -0.204176)))
        ((ph_vheight is 3)
         ((n.ph_ctype is f)
          ((0.431867 0.806556))
          ((Syllable.ssyl_in < 1.5)
           ((0.684148 0.542516))
           ((0.375526 0.830526))))
         ((p.ph_ctype is r)
          ((n.ph_ctype is s)
           ((0.3319 -0.476167))
           ((n.ph_ctype is f)
            ((0.536452 -0.301214))
            ((0.494627 -0.685056))))
          ((n.ph_ctype is n)
           ((Syllable.syl_in < 5)
            ((0.439995 -0.5267))
            ((0.366729 -0.105941)))
           ((n.ph_ctype is f)
            ((Syllable.n.syl_break is 3)
             ((0.413416 0.0205926))
             ((n.ph_cplace is d)
              ((0.342651 0.208176))
              ((ph_vlng is l)
               ((0.279928 0.503588))
               ((0.634314 0.531257)))))
            ((ph_vlng is l)
             ((0.409827 -0.414944))
             ((pp.ph_vc is +)
              ((0.399795 0.04485))
              ((n.ph_ctype is l)
               ((0.437261 -0.201571))
               ((0.634383 0.1245))))))))))
       ((n.ph_ctype is s)
        ((Syllable.syl_in < 6)
         ((ph_ctype is n)
          ((ph_cplace is a)
           ((p.ph_vlng is l)
            ((0.313234 -0.570471))
            ((0.596287 -0.253216)))
           ((0.408651 -0.974176)))
          ((ph_cvox is +)
           ((0.47226 -0.0350645))
           ((ph_cplace is v)
            ((0.495459 -1.56073))
            ((p.ph_ctype is s)
             ((0.634165 0.339727))
             ((p.ph_vheight is 3)
              ((0.580353 -0.320235))
              ((Syllable.p.syl_break is 0)
               ((0.678474 -0.759714))
               ((p.ph_ctype is r)
                ((0.702961 -0.332444))
                ((0.842754 -0.0784062)))))))))
         ((pos_in_syl < 1.2)
          ((0.592034 0.052579))
          ((0.506218 -0.475242))))
        ((ph_ctype is 0)
         ((Syllable.ssyl_in < 0.8)
          ((n.ph_ctype is n)
           ((0.391298 0.0252778))
           ((0.642358 -0.00288571)))
          ((pos_in_syl < 1.2)
           ((n.ph_ctype is f)
            ((ph_vheight is 3)
             ((0.453308 1.19409))
             ((Syllable.last_accent < 1.2)
              ((0.654399 0.623762))
              ((0.37784 0.612471))))
            ((p.ph_cplace is l)
             ((0.404572 -0.342227))
             ((ph_vlng is s)
              ((0.464103 -0.156947))
              ((nn.ph_vc is +)
               ((0.556141 0.7502))
               ((Syllable.sub_phrases < 0.2)
                ((Syllable.ssyl_in < 1.3)
                 ((0.548036 -0.377579))
                 ((0.968606 0.372471)))
                ((0.502363 -0.318889)))))))
           ((p.ph_ctype is r)
            ((0.408928 0.0395833))
            ((0.436633 0.67715)))))
         ((pos_in_syl < 0.4)
          ((p.ph_vlng is a)
           ((Syllable.p.syl_break is 0)
            ((n.ph_vlng is s)
             ((0.555657 -0.04495))
             ((ph_ctype is s)
              ((0.690653 0.858522))
              ((0.61924 0.313833))))
            ((n.ph_vlng is s)
             ((0.485813 0.697667))
             ((Syllable.syl_in < 2.8)
              ((0.449087 1.09188))
              ((0.600935 1.25395)))))
           ((p.ph_vheight is 0)
            ((ph_cvox is -)
             ((ph_cplace is v)
              ((n.ph_vlng is l)
               ((0.374235 0.804647))
               ((0.603201 0.726737)))
              ((n.ph_vlng is l)
               ((0.531572 0.676778))
               ((p.ph_ctype is n)
                ((0.544999 0.346727))
                ((Syllable.last_accent < 1.5)
                 ((n.ph_ctype is r)
                  ((0.845475 1.33528))
                  ((0.929586 0.487292)))
                 ((0.802093 -0.0339))))))
             ((p.ph_ctype is f)
              ((Syllable.syl_in < 3.3)
               ((0.575337 -0.00433334))
               ((0.460391 0.156588)))
              ((ph_ctype is l)
               ((0.631227 0.0935909))
               ((p.ph_ctype is n)
                ((0.721284 -0.487265))
                ((ph_cplace is a)
                 ((0.970381 0.6408))
                 ((Syllable.asyl_in < 0.4)
                  ((1.20082 -0.391824))
                  ((1.01633 0.14795))))))))
            ((Syllable.syl_in < 4.5)
             ((Syllable.n.syl_break is 3)
              ((0.654314 0.557895))
              ((n.ph_vlng is l)
               ((0.678461 1.22672))
               ((0.795765 0.890118))))
             ((0.506322 0.542)))))
          ((p.ph_ctype is s)
           ((ph_ctype is l)
            ((0.125894 -1.11089))
            ((p.ph_cvox is -)
             ((n.ph_vheight is 3)
              ((0.246644 -0.9766))
              ((0.63603 -0.626875)))
             ((0.471139 -0.18625))))
           ((n.ph_cvox is -)
            ((ph_cplace is a)
             ((0.459287 -0.1095))
             ((0.501533 -0.712619)))
            ((syl_final is 0)
             ((Syllable.ssyl_in < 1.5)
              ((0.521812 -0.131))
              ((0.59818 -0.549273)))
             ((Syllable.syl_in < 6)
              ((Syllable.syl_in < 3.5)
               ((n.ph_ctype is n)
                ((0.816917 -0.38176))
                ((n.ph_ctype is r)
                 ((0.739096 0.512526))
                 ((ph_cvox is +)
                  ((Syllable.sub_phrases < 0.5)
                   ((1.22383 0.00681818))
                   ((0.680173 -0.141958)))
                  ((0.669686 0.495)))))
               ((p.ph_vlng is s)
                ((0.440549 -0.440118))
                ((0.712888 -0.163034))))
              ((ph_ctype is f)
               ((0.582236 -0.0252941))
               ((0.792353 -0.21587))))))))))))
     ((ph_vheight is 2)
      ((Syllable.syl_out < 3.5)
       ((p.ph_cplace is l)
        ((n.ph_ctype is l)
         ((0.179738 -1.00169))
         ((n.ph_ctype is n)
          ((0.365304 -0.817105))
          ((Syllable.ssyl_in < 1.2)
           ((0.363201 -0.419333))
           ((0.464316 -0.0742941)))))
        ((Syllable.ssyl_out < 1.2)
         ((Syllable.last_accent < 0.4)
          ((n.ph_ctype is f)
           ((0.58878 -0.25605))
           ((0.453181 -0.603842)))
          ((p.ph_ctype is r)
           ((0.504466 -0.426815))
           ((n.ph_cvox is -)
            ((0.488922 0.141172))
            ((Syllable.p.syl_break is 0)
             ((p.ph_cvox is -)
              ((0.46867 -0.298))
              ((0.513624 -0.45585)))
             ((Syllable.syl_in < 4)
              ((p.ph_cvox is -)
               ((0.791068 -0.0532778))
               ((0.852292 0.237)))
              ((0.541019 -0.00256)))))))
         ((n.ph_ctype is f)
          ((0.440043 -0.257))
          ((0.424082 -0.50887)))))
       ((p.ph_cvox is -)
        ((0.283056 -0.360684))
        ((ph_vlng is s)
         ((p.ph_ctype is s)
          ((0.319788 -0.298353))
          ((0.546992 -0.393524)))
         ((0.331592 -0.617611)))))
      ((n.ph_ctype is f)
       ((p.ph_vlng is l)
        ((n.ph_cplace is p)
         ((0.266206 0.1127))
         ((0.392847 -0.489031)))
        ((ph_vfront is 3)
         ((Syllable.asyl_in < 0.5)
          ((0.538003 0.17305))
          ((0.387292 0.564652)))
         ((ph_vlng is l)
          ((0.461415 -0.357441))
          ((pos_in_syl < 1.2)
           ((p.ph_ctype is s)
            ((0.456803 0.346059))
            ((Syllable.p.syl_break is 1)
             ((Syllable.n.syl_break is 0)
              ((0.661546 0.40055))
              ((0.673835 -0.218263)))
             ((0.394015 -0.00482608))))
           ((ph_cvox is +)
            ((0.489336 -0.0896897))
            ((0.564007 -0.691192)))))))
       ((n.ph_ctype is s)
        ((ph_vheight is 3)
         ((ph_vlng is s)
          ((0.518669 0.542696))
          ((0.676378 -0.109556)))
         ((p.ph_vheight is 1)
          ((0.569623 -0.371441))
          ((Syllable.p.syl_break is 0)
           ((0.559646 -0.687581))
           ((syl_final is 0)
            ((0.530512 -0.382765))
            ((p.ph_cplace is a)
             ((0.486005 -1.20084))
             ((p.ph_vlng is l)
              ((0.502068 -0.633333))
              ((Syllable.syl_out < 2.5)
               ((0.743376 -0.962839))
               ((0.671304 -0.321407)))))))))
        ((ph_vheight is 0)
         ((n.ph_vlng is s)
          ((p.ph_ctype is s)
           ((pos_in_syl < 0.4)
            ((0.557403 0.0240909))
            ((0.328924 -0.749367)))
           ((p.ph_ctype is f)
            ((0.619214 -0.268483))
            ((ph_cplace is l)
             ((0.73934 -0.170742))
             ((ph_ctype is s)
              ((0.645292 0.861652))
              ((p.ph_vlng is s)
               ((0.693393 -0.133912))
               ((Syllable.p.syl_break is 1)
                ((1.12755 0.442552))
                ((0.571369 0.1465))))))))
          ((p.ph_cvox is +)
           ((Syllable.syl_in < 5.5)
            ((pos_in_syl < 0.5)
             ((ph_cvox is -)
              ((p.ph_ctype is n)
               ((0.487934 0.282105))
               ((0.818208 0.950406)))
              ((Syllable.asyl_in < 0.3)
               ((1.01442 0.140077))
               ((0.671098 -0.390714))))
             ((0.544762 -0.2341)))
            ((0.650673 -0.138704)))
           ((n.ph_cplace is a)
            ((pos_in_syl < 0.4)
             ((Syllable.n.syl_break is 0)
              ((0.678743 0.762353))
              ((0.969843 1.1095)))
             ((ph_ctype is s)
              ((0.527462 -0.508722))
              ((0.613318 -0.0116552))))
            ((n.ph_cplace is p)
             ((Syllable.ssyl_out < 1.3)
              ((n.ph_ctype is a)
               ((0.590438 -0.324409))
               ((0.732065 0.439824)))
              ((0.491112 -0.71345)))
             ((p.ph_vlng is a)
              ((ph_ctype is s)
               ((0.708638 0.965524))
               ((0.745004 0.240864)))
              ((p.ph_ctype is 0)
               ((n.ph_cplace is d)
                ((0.278484 2.19961))
                ((Syllable.asyl_in < 1.2)
                 ((ph_ctype is r)
                  ((0.913024 0.831412))
                  ((pos_in_syl < 1.2)
                   ((Syllable.syl_out < 2.5)
                    ((n.ph_vfront is 3)
                     ((1.18738 0.355824))
                     ((2.39759 1.7482)))
                    ((0.863229 0.700353)))
                   ((0.794996 0.0584783))))
                 ((0.676131 0.396947))))
               ((pos_in_syl < 0.4)
                ((1.15311 0.729815))
                ((0.356154 -0.984865)))))))))
         ((n.ph_ctype is r)
          ((p.ph_cvox is -)
           ((0.552572 -0.944903))
           ((0.593376 -0.547556)))
          ((pos_in_syl < 0.3)
           ((p.ph_cvox is +)
            ((0.470816 0.235941))
            ((0.598821 0.111269)))
           ((p.ph_ctype is r)
            ((0.342189 -0.837897))
            ((pos_in_syl < 1.1)
             ((ph_vfront is 3)
              ((n.ph_ctype is n)
               ((0.287941 -0.112368))
               ((0.30653 0.313389)))
              ((Syllable.n.syl_break is 0)
               ((0.551538 -0.119562))
               ((0.61418 -0.834))))
             ((0.432349 0.218762)))))))))))))
  ((n.ph_ctype is s)
   ((ph_vlng is s)
    ((p.ph_ctype is r)
     ((p.ph_cplace is a)
      ((n.ph_cplace is v)
       ((0.513533 -0.490316))
       ((0.539361 -0.871348)))
      ((0.366505 -0.404167)))
     ((n.ph_cplace is l)
      ((ph_vfront is 1)
       ((0.428527 -0.0139412))
       ((nn.ph_vc is +)
        ((0.379278 -0.326))
        ((0.590825 -0.145))))
      ((Syllable.accented is 0)
       ((Syllable.next_accent < 0.4)
        ((ph_vheight is 3)
         ((0.52679 -0.634636))
         ((Syllable.p.syl_break is 0)
          ((0.48997 -0.450944))
          ((p.ph_cvox is +)
           ((0.600514 -0.29535))
           ((0.70076 0.239286)))))
        ((0.423109 -0.736414)))
       ((ph_vheight is 2)
        ((Syllable.syl_out < 4.1)
         ((0.470607 0.02304))
         ((0.366864 -0.37019)))
        ((p.ph_ctype is f)
         ((0.489479 0.127706))
         ((0.636371 0.61475)))))))
    ((ph_cvox is -)
     ((p.ph_vheight is 3)
      ((ph_cplace is v)
       ((0.381442 -1.5125))
       ((Syllable.ssyl_out < 3)
        ((Syllable.syl_out < 4.4)
         ((0.515848 -0.76956))
         ((0.468521 -0.857588)))
        ((0.412356 -0.926529))))
      ((pos_in_syl < 0.5)
       ((p.ph_cplace is a)
        ((0.65712 -0.664348))
        ((Syllable.syl_out < 4.4)
         ((0.654625 0.205792))
         ((0.637183 -0.272238))))
       ((p.ph_cvox is -)
        ((0.485139 -1.10384))
        ((ph_cplace is v)
         ((0.477944 -1.62896))
         ((Syllable.p.syl_break is 0)
          ((0.562564 -0.918077))
          ((Syllable.syl_out < 7.4)
           ((syl_final is 0)
            ((0.506382 -0.840607))
            ((Syllable.syl_break is 0)
             ((0.773306 -1.02465))
             ((0.944889 -0.474531))))
           ((0.642533 -0.881588))))))))
     ((p.ph_ctype is s)
      ((ph_vheight is 1)
       ((n.ph_cvox is -)
        ((n.ph_cplace is l)
         ((0.16404 -0.880833))
         ((0.474591 -0.686174)))
        ((0.165477 -0.873941)))
       ((pos_in_syl < 1.2)
        ((Syllable.sub_phrases < 0.2)
         ((ph_vheight is 2)
          ((p.ph_cplace is l)
           ((0.563971 -0.02695))
           ((0.839692 -0.260969)))
          ((0.593065 0.0376667)))
         ((0.519828 -0.315176)))
        ((0.371987 -0.10825))))
      ((Syllable.syl_in < 2.7)
       ((p.ph_vheight is 3)
        ((Syllable.asyl_out < 2.3)
         ((syl_final is 0)
          ((Syllable.syl_out < 4.4)
           ((0.512929 -0.241118))
           ((0.540351 -0.574762)))
          ((ph_ctype is r)
           ((Syllable.syl_out < 5.6)
            ((0.495268 -0.4838))
            ((0.440951 -0.318944)))
           ((p.ph_vlng is s)
            ((0.785126 -0.279))
            ((0.983364 0.328944)))))
         ((0.490625 -0.290971)))
        ((Syllable.next_accent < 1.2)
         ((Syllable.next_accent < 0.1)
          ((p.ph_cplace is d)
           ((Syllable.ssyl_out < 2.3)
            ((0.671002 -0.0232353))
            ((0.750085 -0.283296)))
           ((n.ph_cplace is l)
            ((Syllable.syl_in < 0.2)
             ((0.496431 -0.0905))
             ((0.890241 -0.217032)))
            ((pp.ph_vc is +)
             ((0.790224 0.163517))
             ((p.ph_vlng is a)
              ((0.76391 -0.0523044))
              ((ph_vlng is l)
               ((0.794914 0.105714))
               ((p.ph_cvox is +)
                ((0.566903 -0.524471))
                ((syl_final is 0)
                 ((0.875844 -0.539158))
                 ((ph_cplace is a)
                  ((0.935985 -0.323962))
                  ((0.925068 1.08564))))))))))
          ((p.ph_vheight is 1)
           ((0.46275 -0.67463))
           ((Syllable.p.syl_break is 0)
            ((0.597833 -0.619852))
            ((ph_vfront is 2)
             ((0.688339 -0.539579))
             ((syl_final is 0)
              ((0.72647 0.3466))
              ((0.578495 -0.463)))))))
         ((ph_vheight is 2)
          ((0.59653 -0.402091))
          ((p.ph_vheight is 1)
           ((0.675042 -0.685167))
           ((p.ph_cplace is a)
            ((0.685221 -0.572048))
            ((Syllable.syl_break is 0)
             ((0.711686 -0.452667))
             ((0.778975 -0.00214286))))))))
       ((n.ph_cvox is -)
        ((pos_in_syl < 1.2)
         ((ph_vheight is 2)
          ((0.561543 0.0722632))
          ((nn.ph_vc is +)
           ((0.683468 -0.274389))
           ((0.816118 0.0758947))))
         ((0.612246 -0.411559)))
        ((Syllable.syl_break is 0)
         ((0.458791 -0.908261))
         ((Syllable.next_accent < 0.5)
          ((0.416014 -0.64795))
          ((0.59506 -0.302667)))))))))
   ((n.ph_ctype is n)
    ((Syllable.p.syl_break is 0)
     ((p.ph_ctype is f)
      ((p.ph_cvox is -)
       ((0.312953 -0.412471))
       ((0.496514 -0.6487)))
      ((ph_vlng is a)
       ((p.ph_cvox is -)
        ((0.419108 -0.806579))
        ((0.480408 -0.440571)))
       ((p.ph_ctype is n)
        ((0.529829 -0.681059))
        ((ph_vlng is l)
         ((0.55891 -0.5805))
         ((syl_final is 0)
          ((Syllable.n.syl_break is 0)
           ((0.992772 0.22685))
           ((0.824892 -0.533536)))
          ((0.610244 -0.239632)))))))
     ((Syllable.next_accent < 1.2)
      ((ph_vfront is 1)
       ((p.ph_ctype is 0)
        ((ph_vheight is 3)
         ((0.442626 -0.556488))
         ((0.372799 -1.02905)))
        ((p.ph_ctype is r)
         ((0.439078 -0.88763))
         ((ph_vheight is 2)
          ((0.570998 -0.563462))
          ((Syllable.syl_in < 2.4)
           ((nn.ph_vc is +)
            ((0.553569 -0.391333))
            ((Syllable.ssyl_out < 3.5)
             ((0.837234 -0.190176))
             ((0.644201 -0.286706))))
           ((0.64118 -0.789353))))))
       ((p.ph_ctype is r)
        ((pp.ph_vc is +)
         ((0.496712 -0.753182))
         ((pos_in_syl < 1.2)
          ((0.872413 -0.308))
          ((0.570966 -0.588294))))
        ((ph_cplace is a)
         ((p.ph_vheight is 1)
          ((0.515727 -0.357111))
          ((ph_ctype is s)
           ((0.51039 -0.613824))
           ((n.ph_cplace is a)
            ((0.518775 -0.51792))
            ((0.970644 -0.101531)))))
         ((p.ph_ctype is s)
          ((Syllable.accented is 0)
           ((0.433622 -0.504389))
           ((0.798679 -0.169211)))
          ((ph_vlng is d)
           ((ph_vheight is 2)
            ((0.575857 -0.172059))
            ((0.758803 -0.952421)))
           ((Syllable.syl_out < 7)
            ((ph_vlng is l)
             ((0.881552 0.4959))
             ((Syllable.syl_out < 3.2)
              ((0.748308 -0.0485))
              ((Syllable.stress is 0)
               ((syl_final is 0)
                ((0.949181 -0.231889))
                ((1.4113 0.3384)))
               ((0.933579 -0.669789)))))
            ((syl_final is 0)
             ((0.802681 0.0637826))
             ((0.384643 -0.559882)))))))))
      ((p.ph_ctype is s)
       ((Syllable.last_accent < 0.4)
        ((0.237154 -0.768947))
        ((0.555184 -0.472889)))
       ((ph_vlng is d)
        ((0.463807 -0.926419))
        ((ph_vfront is 2)
         ((0.521033 -0.54137))
         ((ph_ctype is n)
          ((0.673849 -1.12895))
          ((p.ph_cvox is -)
           ((0.534167 -0.331474))
           ((p.ph_cplace is a)
            ((0.607991 0.00905556))
            ((nn.ph_vc is +)
             ((0.457226 -0.78319))
             ((1.09539 0.0551765)))))))))))
    ((p.ph_ctype is f)
     ((ph_vheight is 3)
      ((Syllable.stress is 0)
       ((n.ph_ctype is r)
        ((0.115168 -1.14339))
        ((0.719845 -0.62837)))
       ((Syllable.accented is 0)
        ((0.365408 -0.452314))
        ((n.ph_ctype is r)
         ((Syllable.syl_break is 0)
          ((0.481602 -0.695077))
          ((0.404602 -0.343722)))
         ((0.767117 0.128242)))))
      ((Syllable.syl_in < 1.1)
       ((p.ph_cplace is d)
        ((ph_vlng is s)
         ((0.468299 -0.489478))
         ((Syllable.next_accent < 0.4)
          ((Syllable.asyl_out < 2.2)
           ((Syllable.p.syl_break is 1)
            ((0.841037 0.46375))
            ((0.756986 0.0889048)))
           ((0.578637 0.298176)))
          ((0.566624 0.1497))))
        ((pos_in_syl < 0.5)
         ((ph_ctype is s)
          ((Syllable.next_accent < 1.2)
           ((0.814863 0.772))
           ((0.593415 0.6185)))
          ((Syllable.ssyl_in < 0.1)
           ((n.ph_vheight is 1)
            ((ph_ctype is f)
             ((0.731175 -0.511138))
             ((0.548659 0.1065)))
            ((ph_cvox is -)
             ((0.807192 -0.084))
             ((Syllable.accented is 0)
              ((1.09282 0.860966))
              ((0.830461 0.588647)))))
           ((0.6117 -0.117133))))
         ((ph_vheight is 0)
          ((n.ph_vfront is 3)
           ((0.382808 -0.255647))
           ((pp.ph_vc is +)
            ((0.687521 -0.35375))
            ((0.32485 -0.915222))))
          ((nn.ph_vc is +)
           ((Syllable.asyl_out < 2.4)
            ((Syllable.syl_in < 0.1)
             ((0.646315 -0.249222))
             ((0.456645 -0.220471)))
            ((0.397987 -0.494737)))
           ((Syllable.syl_break is 0)
            ((0.555252 -0.20925))
            ((p.ph_cplace is a)
             ((0.449983 0.75925))
             ((0.73133 0.345829))))))))
       ((Syllable.syl_out < 4)
        ((nn.ph_vc is +)
         ((0.464341 -0.0881765))
         ((0.605301 -0.22948)))
        ((Syllable.syl_out < 7.2)
         ((Syllable.next_accent < 1.2)
          ((Syllable.syl_in < 4.1)
           ((Syllable.last_accent < 1.2)
            ((syl_final is 0)
             ((0.882335 -0.103171))
             ((0.537576 0.0168333)))
            ((0.711004 -0.561143)))
           ((0.617012 -0.50565)))
          ((Syllable.next_accent < 2.2)
           ((0.68056 -0.0696786))
           ((0.460087 -0.31475))))
         ((Syllable.stress is 0)
          ((0.650595 -0.0138333))
          ((0.328723 -0.305)))))))
     ((n.ph_cvox is -)
      ((ph_cvox is -)
       ((ph_cplace is v)
        ((Syllable.next_accent < 0.3)
         ((0.374352 -0.918524))
         ((0.376041 -0.652333)))
        ((Syllable.p.syl_break is 0)
         ((Syllable.syl_in < 2.7)
          ((0.576567 -1.02293))
          ((0.40525 -0.875941)))
         ((syl_final is 0)
          ((Syllable.n.syl_break is 0)
           ((0.502461 -0.3675))
           ((0.257209 -0.483118)))
          ((p.ph_vheight is 2)
           ((0.508752 -0.809889))
           ((pos_in_syl < 2.2)
            ((n.ph_ctype is 0)
             ((0.71459 -1.0487))
             ((0.803205 -0.228727)))
            ((0.588321 -0.708261)))))))
       ((Syllable.next_accent < 1.2)
        ((p.ph_cplace is l)
         ((ph_vlng is d)
          ((0.276288 0.0328824))
          ((ph_vheight is 3)
           ((0.324761 0.47187))
           ((syl_final is 0)
            ((ph_vheight is 1)
             ((0.600254 -0.321476))
             ((0.747743 0.209667)))
            ((0.655283 -0.686706)))))
         ((Syllable.syl_in < 2.7)
          ((Syllable.syl_break is 0)
           ((syl_final is 0)
            ((0.436194 -0.0330556))
            ((p.ph_ctype is 0)
             ((0.660515 0.179481))
             ((0.731721 -0.454433))))
           ((Syllable.p.syl_break is 0)
            ((n.ph_cplace is a)
             ((0.526659 0.326529))
             ((0.826321 0.367286)))
            ((p.ph_vlng is l)
             ((0.678084 0.15097))
             ((ph_ctype is f)
              ((p.ph_vlng is s)
               ((0.977546 -0.240045))
               ((0.584646 -0.0755294)))
              ((ph_vfront is 1)
               ((0.865697 0.515))
               ((ph_ctype is s)
                ((0.749533 -0.372588))
                ((Syllable.syl_out < 3.2)
                 ((0.807077 0.468222))
                 ((p.ph_vlng is s)
                  ((1.13388 0.665844))
                  ((0.980287 -0.150423))))))))))
          ((p.ph_vheight is 2)
           ((0.534714 -0.0483333))
           ((Syllable.p.syl_break is 0)
            ((0.546219 -0.288478))
            ((0.804626 0.130966))))))
        ((Syllable.syl_out < 4.8)
         ((0.368054 -0.1755))
         ((ph_vfront is 3)
          ((0.423156 0.171364))
          ((ph_vlng is s)
           ((0.51841 0.243786))
           ((Syllable.last_accent < 0.6)
            ((0.574119 -0.0124167))
            ((0.654194 -0.428308))))))))
      ((p.ph_ctype is s)
       ((p.ph_cplace is l)
        ((ph_ctype is r)
         ((0.45755 -0.779048))
         ((ph_ctype is l)
          ((0.413333 -0.663))
          ((n.ph_ctype is l)
           ((0.474739 -0.50012))
           ((n.ph_ctype is r)
            ((0.628747 -0.668905))
            ((0.798861 0.00567742))))))
        ((ph_vfront is 3)
         ((Syllable.syl_in < 2.1)
          ((Syllable.syl_break is 0)
           ((0.37996 -0.595235))
           ((nn.ph_vc is +)
            ((0.472967 -0.417471))
            ((0.780001 -0.0296087))))
          ((0.534713 0.118294)))
         ((p.ph_cplace is a)
          ((ph_ctype is s)
           ((Syllable.sub_phrases < 0.2)
            ((0.799714 0.608321))
            ((0.726853 0.112556)))
           ((pos_in_syl < 1.5)
            ((ph_cplace is a)
             ((pp.ph_vc is +)
              ((0.715076 -0.1216))
              ((0.710117 -0.5017)))
             ((Syllable.ssyl_out < 3.5)
              ((ph_cvox is +)
               ((0.814531 -0.20304))
               ((Syllable.asyl_in < 0.3)
                ((p.ph_cvox is -)
                 ((0.910073 0.1075))
                 ((1.2653 0.898545)))
                ((0.878979 0.000238096))))
              ((0.725052 -0.0940303))))
            ((ph_cplace is a)
             ((0.55473 -0.825684))
             ((0.666736 -0.382588)))))
          ((ph_ctype is r)
           ((0.501286 -0.736367))
           ((nn.ph_vc is +)
            ((0.769543 -0.343963))
            ((0.685694 -0.160792)))))))
       ((pos_in_syl < 1.2)
        ((pos_in_syl < 0.1)
         ((Syllable.asyl_in < 0.4)
          ((p.ph_vlng is a)
           ((ph_cvox is -)
            ((Syllable.syl_out < 6.5)
             ((n.ph_vheight is 3)
              ((0.628711 0.776393))
              ((0.765574 1.18979)))
             ((0.464146 0.727842)))
            ((n.ph_vlng is l)
             ((0.718443 0.849))
             ((ph_cplace is a)
              ((0.680728 0.546739))
              ((Syllable.next_accent < 0.4)
               ((0.66374 -0.05985))
               ((1.17232 0.339308))))))
           ((ph_cplace is a)
            ((Syllable.stress is 0)
             ((ph_cvox is -)
              ((0.469837 0.764529))
              ((0.726246 -0.108552)))
             ((p.ph_vheight is 1)
              ((0.81415 1.18772))
              ((Syllable.syl_out < 6.8)
               ((p.ph_ctype is n)
                ((0.805194 0.26195))
                ((pp.ph_vc is +)
                 ((0.773305 1.37865))
                 ((ph_ctype is s)
                  ((0.988972 0.868867))
                  ((0.802843 0.164647)))))
               ((0.815121 0.194182)))))
            ((Syllable.sub_phrases < 0.4)
             ((n.ph_vheight is 1)
              ((ph_cplace is g)
               ((0.6751 -0.06125))
               ((p.ph_vheight is 0)
                ((ph_ctype is r)
                 ((0.795378 -0.430263))
                 ((Syllable.syl_in < 0.4)
                  ((1.27802 0.469912))
                  ((0.751629 -0.3323))))
                ((0.81084 0.207667))))
              ((ph_cplace is b)
               ((p.ph_cvox is -)
                ((0.826017 -0.525429))
                ((0.853498 0.370077)))
               ((n.ph_vlng is s)
                ((p.ph_ctype is 0)
                 ((1.08911 0.555833))
                 ((0.752761 -0.112714)))
                ((ph_vheight is 3)
                 ((Syllable.accented is 0)
                  ((0.854644 -0.621182))
                  ((0.399999 -0.134)))
                 ((Syllable.syl_out < 7.2)
                  ((Syllable.syl_out < 3.5)
                   ((1.00693 0.419826))
                   ((Syllable.ssyl_in < 0.2)
                    ((Syllable.ssyl_out < 3)
                     ((Syllable.syl_in < 0.2)
                      ((n.ph_cplace is a)
                       ((1.30317 1.54221))
                       ((2.13141 1.17078)))
                      ((1.30274 0.213333)))
                     ((1.05077 0.441684)))
                    ((1.13271 0.935444))))
                  ((1.14947 0.168037)))))))
             ((ph_cplace is l)
              ((0.629693 0.0430526))
              ((n.ph_vlng is l)
               ((0.795415 -0.0776667))
               ((Syllable.next_accent < 1.5)
                ((Syllable.n.syl_break is 0)
                 ((1.28588 0.966706))
                 ((1.0888 0.356095)))
                ((0.77246 -0.00974999))))))))
          ((ph_cplace is l)
           ((p.ph_cvox is 0)
            ((Syllable.syl_out < 4.4)
             ((0.454322 0.566))
             ((0.645309 0.331263)))
            ((0.494732 -0.167063)))
           ((Syllable.last_accent < 0.4)
            ((Syllable.syl_out < 6.5)
             ((ph_cvox is +)
              ((0.608714 -0.582154))
              ((n.ph_vheight is 0)
               ((0.823068 -0.658647))
               ((0.893935 0.187957))))
             ((0.421678 -0.253762)))
            ((Syllable.accented is 0)
             ((Syllable.syl_break is 0)
              ((0.628576 0.240765))
              ((Syllable.n.syl_break is 0)
               ((0.945016 -0.0451538))
               ((0.617727 -0.585739))))
             ((nn.ph_vc is +)
              ((0.690123 0.643737))
              ((Syllable.syl_out < 5.6)
               ((Syllable.syl_break is 0)
                ((n.ph_vheight is 1)
                 ((0.78691 0.251632))
                 ((0.73557 -0.0194706)))
                ((1.11014 1.03769)))
               ((0.71293 0.0434))))))))
         ((ph_vlng is s)
          ((ph_vheight is 1)
           ((0.411877 -0.677269))
           ((pp.ph_vc is +)
            ((0.400072 -0.0337059))
            ((0.443927 -0.534844))))
          ((ph_vheight is 2)
           ((Syllable.syl_break is 0)
            ((0.33836 -0.54081))
            ((n.ph_ctype is l)
             ((0.479465 -0.641421))
             ((0.767259 -0.0407273))))
           ((n.ph_cplace is d)
            ((Syllable.stress is 0)
             ((Syllable.ssyl_in < 0.3)
              ((0.668602 0.0488889))
              ((0.529653 -0.136471)))
             ((0.593305 -0.633556)))
            ((ph_vheight is 3)
             ((Syllable.last_accent < 0.3)
              ((0.680508 -0.7839))
              ((0.599736 -0.073)))
             ((ph_vfront is 1)
              ((0.677667 -0.524774))
              ((n.ph_ctype is l)
               ((0.595912 -0.22064))
               ((Syllable.asyl_in < 0.2)
                ((ph_ctype is f)
                 ((0.674188 0.590077))
                 ((n.ph_ctype is f)
                  ((0.823886 0.637696))
                  ((Syllable.stress is 0)
                   ((0.989654 -0.282542))
                   ((0.837102 0.5355)))))
                ((0.720518 -0.192808))))))))))
        ((p.ph_ctype is 0)
         ((ph_ctype is f)
          ((n.ph_ctype is r)
           ((0.43191 0.0565))
           ((p.ph_vheight is 3)
            ((0.335493 -0.193158))
            ((p.ph_vlng is l)
             ((0.413455 -0.265235))
             ((n.ph_vheight is 0)
              ((0.588012 -0.820474))
              ((0.783266 0.0907308))))))
          ((ph_cvox is -)
           ((ph_cplace is a)
            ((0.445346 -1.00947))
            ((0.583257 -0.0778846)))
           ((n.ph_cplace is d)
            ((Syllable.next_accent < 1.2)
             ((0.690925 -0.1819))
             ((0.37642 -0.549529)))
            ((ph_ctype is s)
             ((ph_cplace is l)
              ((0.446302 -0.75005))
              ((0.711128 -0.303806)))
             ((Syllable.sub_phrases < 0.5)
              ((p.ph_vheight is 3)
               ((0.785814 -0.310032))
               ((n.ph_vheight is 1)
                ((0.865731 0.0265833))
                ((n.ph_ctype is r)
                 ((0.98161 0.021))
                 ((ph_ctype is l)
                  ((1.1507 2.04141))
                  ((Syllable.n.syl_break is 0)
                   ((1.08281 0.656056))
                   ((1.02008 -0.0950909)))))))
              ((Syllable.syl_break is 0)
               ((0.674444 -0.334105))
               ((0.77984 0.142286))))))))
         ((ph_vfront is 3)
          ((0.52129 0.0755882))
          ((p.ph_ctype is n)
           ((0.355281 -0.8255))
           ((ph_cvox is +)
            ((0.497836 -0.361238))
            ((Syllable.next_accent < 1.2)
             ((0.501814 -0.950105))
             ((0.556348 -0.481941)))))))))))))))
;; RMSE 0.734039 Correlation is 0.670192 Mean (abs) Error 0.539853 (0.497371)
)))

(provide 'kddurtreeZ)
