/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                       Copyright (c) 1996,1997                         */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author :  Alan W Black (and Paul Taylor)                  */
/*             Date   :  April 199[4|6]                                  */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/* Simple intonation prediction: a hat shape on each content word        */
/*                                                                       */
/*=======================================================================*/
#include <stdio.h>
#include "festival.h"
#include "intonation.h"

static void add_f0_end(EST_Utterance &u, EST_Stream_Item &esyl,float end_f0);
static void add_f0_start(EST_Utterance &u, EST_Stream_Item &ssyl,float start_f0);
static void add_targets(EST_Utterance &u,EST_Stream_Item &s, float baseline);

static float f0_mean, f0_std;

LISP FT_Intonation_Simple_Utt(LISP utt)
{
    // Predict some accents
    //  Lets try on all non-function words
    EST_Utterance *u = GETUTTVAL(utt);
    EST_Stream_Item *s;
    LISP accent_tree;
    EST_Val paccent;

    *cdebug << "Simple intonation module" << endl;

    accent_tree = siod_get_lval("int_accent_cart_tree","no accent tree");

    u->create_stream("IntEvent");

    for (s=(u->stream("Syllable")).head(); s != 0; s = next(s))
    {	
	paccent = wagon_predict(*u,*s,accent_tree);
	if (paccent != "NONE")
	    add_IntEvent_to_syl(*u,*s,paccent.string());
    }

    return utt;
}

LISP FT_Int_Targets_Simple_Utt(LISP utt)
{
    // Predict F0 targets 
    EST_Utterance *u = GETUTTVAL(utt);
    EST_Relation rw, sr;
    EST_Stream_Item *s, *p, start_word, end_word;
    float start,end,duration;
    float baseline, decline;
    EST_Stream_Item *start_syl, *end_syl;
    LISP simple_params;

    *cdebug << "Simple int targets module" << endl;

    // Create some down step accents
    simple_params = siod_get_lval("int_simple_params","no simple params");
    f0_mean = get_param_int("f0_mean",simple_params,110);
    f0_std = get_param_int("f0_std",simple_params,25);
    
    u->create_stream("Target");
    
    for (p=u->stream("Phrase").head(); p != 0 ; p=next(p))
    {
	baseline = f0_mean + (f0_std * 0.6);
	rw = *(p->link("Word"));
	start_word = u->ritem("Word", rw(rw.head()));
	end_word = u->ritem("Word", rw(rw.tail()));
	start = start_word.start();
	end = end_word.end();
	duration = end - start;
	decline = f0_std / duration;
	sr  = *(start_word.link("Syllable"));
	start_syl = u->item("Syllable",sr(sr.head()));
	sr  = *(end_word.link("Syllable"));
	end_syl = u->item("Syllable",sr(sr.tail()));
	add_f0_start(*u,*start_syl,baseline);
	for (s=start_syl; s != next(end_syl); s = next(s))
	{
	    if (ffeature(*u,*s,"accented") == 1)
		add_targets(*u,*s,baseline);
	    baseline -= decline*s->dur();
	}
	add_f0_end(*u,*end_syl,f0_mean-f0_std);
    }

    return utt;
}

static void add_f0_start(EST_Utterance &u, EST_Stream_Item &ssyl,float start_f0)
{
    // Add target for start
    EST_Relation segs;
    EST_Stream_Item seg;

    if (ffeature(u,ssyl,"accented") == 0)
    {
	segs = *(ssyl.link("Segment"));
	seg = u.ritem("Segment",segs(segs.head()));
	link(*add_target(u,seg.start(),start_f0),seg);
    }

}

static void add_f0_end(EST_Utterance &u, EST_Stream_Item &esyl,float end_f0)
{
    // Add target for end
    EST_Relation segs;
    EST_Stream_Item seg;

    if (ffeature(u,esyl,"accented") == 0)
    {
	segs = *(esyl.link("Segment"));
	seg = u.ritem("Segment",segs(segs.tail()));
	link(*add_target(u,seg.end(),end_f0),seg);
    }

}

static void add_targets(EST_Utterance &u,EST_Stream_Item &s, float baseline)
{
    // Add a down stepped accent at this point 
    EST_Relation segs;
    EST_Stream_Item *first_seg, *vowel_seg, *end_seg, *t;

    segs = *(s.link("Segment"));
    first_seg = &u.ritem("Segment",segs(segs.head()));
    end_seg = &u.ritem("Segment",segs(segs.tail()));
    vowel_seg = end_seg; // by default
    for (t = first_seg; t != 0; t = next(t))
    {
	EST_Val p = ffeature(u,*t,"ph_vc");
	if (p.string() == "+")
	{
	    vowel_seg = t;
	    break;
	}
    }
    
    t = add_target(u,first_seg->start(),baseline);
    link(*t,*first_seg);
    t = add_target(u,vowel_seg->mid(),baseline+f0_std);
    link(*t,*vowel_seg);
    t = add_target(u,end_seg->end(),baseline);
    link(*t,*end_seg);

}
       

