 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /*************************************************************************/
 /*                                                                       */
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             */
 /*                   Date: Tue Jul 29 1997                               */
 /* --------------------------------------------------------------------  */
 /* Some things which are useful in modules.                              */
 /*                                                                       */
 /*************************************************************************/


#ifndef __MODULE_SUPPORT_H__
#define __MODULE_SUPPORT_H__

#include "EST.h"
#include "festival.h"
#include "ModuleDescription.h"

// To extract arguments passed as a list

void unpack_multiple_args(LISP args, LISP &v1, LISP &v2, LISP &v3, LISP &v4);
void unpack_multiple_args(LISP args, LISP &v1, LISP &v2, LISP &v3, LISP &v4, LISP &v5);

// To extract arguments for a module, modules are called
//	(module-function Utterance StreamName1 StreamName2 StreamName3 ...)

// To tell the unpacking functions what is expected of the stream.
enum StreamArgType {
	sat_existing,		// must exist
	sat_new,		// must be new
	sat_replace,		// erase if there, then create
	sat_as_is		// take what we find
};
	

void unpack_stream_arg(EST_Utterance *utt,
		       LISP lstream_name,
		       EST_String &stream_name, EST_Stream *&stream, StreamArgType type);

void unpack_module_args(LISP args, 
			EST_Utterance *&utt);
void unpack_module_args(LISP args, 
			EST_Utterance *&utt, 
			EST_String &stream1_name, EST_Stream *&stream1, StreamArgType type1);
void unpack_module_args(LISP args, 
			EST_Utterance *&utt,
			EST_String &stream1_name, EST_Stream *&stream1, StreamArgType type1,
			EST_String &stream2_name, EST_Stream *&stream2, StreamArgType type2
			);
void unpack_module_args(LISP args, 
			EST_Utterance *&utt,
			EST_String &stream1_name, EST_Stream *&stream1, StreamArgType type1,
			EST_String &stream2_name, EST_Stream *&stream2, StreamArgType type2,
			EST_String &stream3_name, EST_Stream *&stream3, StreamArgType type3
			);
void unpack_module_args(LISP args, 
			EST_Utterance *&utt,
			EST_String &stream1_name, EST_Stream *&stream1, StreamArgType type1,
			EST_String &stream2_name, EST_Stream *&stream2, StreamArgType type2,
			EST_String &stream3_name, EST_Stream *&stream3, StreamArgType type3,
			EST_String &stream4_name, EST_Stream *&stream4, StreamArgType type4
			);
void unpack_module_args(LISP args, 
			EST_Utterance *&utt,
			EST_String &stream1_name, EST_Stream *&stream1, StreamArgType type1,
			EST_String &stream2_name, EST_Stream *&stream2, StreamArgType type2,
			EST_String &stream3_name, EST_Stream *&stream3, StreamArgType type3,
			EST_String &stream4_name, EST_Stream *&stream4, StreamArgType type4,
			EST_String &stream5_name, EST_Stream *&stream5, StreamArgType type5
			);

LISP	      lisp_parameter_get(const EST_String parameter);
int            int_parameter_get(const EST_String parameter, int def=0);
float        float_parameter_get(const EST_String parameter, float def=0.0);
bool          bool_parameter_get(const EST_String parameter);
EST_String  string_parameter_get(const EST_String parameter, EST_String def="");

#endif
