;;;
;;;  Converted from C to Festival LTS format 
;;;  (awb@cstr.ed.ac.uk) September 10th 1996
;;;
;;;  This version was extracted from the ausay program 
;;;  text to speech program for net audio (nas) by
;;;  Steve Hocking <sysseh@devetir.qld.gov.au> but a
;;;  readme points at John A. Wasser who had some play
;;;  in the following code (whose address is given as
;;;  WASSER%VIKING.DEC@decwrl.ARPA and dated 4/15/85)
;;;  I reckon he is now wasser@ranger.enet.dec.com
;;;
;;;	English to Phoneme rules.
;;;	Derived from: 
;;;	     AUTOMATIC TRANSLATION OF ENGLISH TEXT TO PHONETICS 
;;;           BY MEANS OF LETTER-TO-SOUND RULES 
;;; 
;;;			NRL Report 7948 
;;; 
;;;		      January 21st, 1976
;;; 	    Naval Research Laboratory, Washington, D.C.
;;; 
;;;	Published by the National Technical Information Service as 
;;; document "AD/A021 929". 
;;;
;;;  Navy Research Laboratory Letter to Sound rules in Festival format
;;;  They've been converted a little to produce mrpa phoneset for 
;;;  British English


(lts.ruleset
 nrl
;;;  Sets
(
 (V a e i o u)
 (C b c d f g h j k l m n p q r s t v w x y z)
 (Cv b d v g j l m n r w z)   ;; voiced consonants
 (VF e i y )                  ;; a front vowel
 (TSRDLZNJ t s r d l z n j )
 (TCS t c s)
 (SCGZXJ s c g z x j)
 (RSD r s d)
 (SD s d)
 (OT o t)
 (SY s y)
)
;; The rule set
(
 ;; A rules
 (   [ a ]   # = @ )               ;; {Anything, "A", Nothing, "AX"},
 (   [ a h ] # = @@ )
 ( # [ a r ] o = @ r )	           ;; {Nothing, "AR", "O", "AXr"},
 (   [ a r ] e d # = e@ ) 
 (   [ a r ] V = e r )             ;; {Anything, "AR", "#", "EHr"},
 ( C [ a s ] V = ei s )            ;; {"^", "AS", "#", "EYs"},
 (   [ a ]   w a = @ )             ;; {Anything, "A", "WA", "AX"},
 (   [ a w ]     = oo )            ;; {Anything, "AW", Anything, "AO"},
 ( # C * [ a n y ] = e n ii )        ;; {" :", "ANY", Anything, "EHnIY"},
 (   [ a ] C VF V + = ei )         ;; {Anything, "A", "^+#", "EY"},
 ( V + C * [ a l l y ] = @ l ii )  ;; {"#:", "ALLY", Anything, "AXlIY"},
 ( # [ a l ] V + = @ l )           ;; {Nothing, "AL", "#", "AXl"},
 (  [ a g a i n ] = @ g e n )      ;; {Anything, "AGAIN", Anything, "AXgEHn"},
 ( V + C * [ a g ] e = i jh )      ;; {"#:", "AG", "E", "IHj"},
 ( [ a ] C VF C * V + =  a )       ;; {Anything, "A", "^+:#", "AE"},
 ( h [ a ] C VF = a )
 ( # C * [ a ] C VF = ei )         ;; {" :", "A", "^+ ", "EY"},
 (  [ a ] C e # = ei )             ;; {Anything, "A", "^%", "EY"},
 (  [ a ] C e RSD # = ei )         ;; {Anything, "A", "^%", "EY"},
 (  [ a ] C e r SY # = ei )         ;; {Anything, "A", "^%", "EY"},
 (  [ a ] C e l y # = ei )         ;; {Anything, "A", "^%", "EY"},
 (  [ a ] C i n g # = ei )         ;; {Anything, "A", "^%", "EY"},
 ( # [ a r r ] = @ r )             ;; {Nothing, "ARR", Anything, "AXr"},
 (   [ a r r ] = a r )             ;; {Anything, "ARR", Anything, "AEr"},
 ( # C * [ a r ] = aa r )            ;; {" :", "AR", Nothing, "AAr"},
 ( [ a r ] # = @@ r )              ;; {Anything, "AR", Nothing, "ER"},
 ( [ a r ] C  = aa r)               ;; {Anything, "AR", Nothing, "ER"},
 ( [ a r ] V = aa r )              ;; {Anything, "AR", Anything, "AAr"},
 ( [ a i r ] = e@ r)                ;; {Anything, "AIR", Anything, "EHr"},
 ( [ a i ] = ei )                  ;; {Anything, "AI", Anything, "EY"},
 ( [ a y ] = ei )                  ;; {Anything, "AY", Anything, "EY"},
 ( [ a u ] = oo )                  ;; {Anything, "AU", Anything, "AO"},
 ( V + C * [ a l ] # = @ l )       ;; {"#:", "AL", Nothing, "AXl"},
 ( V + C * [ a l s ] # = @ l z )   ;; {"#:", "ALS", Nothing, "AXlz"},
 ( [ a l k ] = oo k )              ;; {Anything, "ALK", Anything, "AOk"},
 ( [ a l ] C = oo l )              ;; {Anything, "AL", "^", "AOl"},
 ( # C * [ a b l e ] = ei b @ l )  ;; {" :", "ABLE", Anything, "EYbAXl"},
 ( [ a b l e ] = @ b @ l )         ;; {Anything, "ABLE", Anything, "AXbAXl"},
 ( [ a n g ] VE = ei n jh )        ;; {Anything, "ANG", "+", "EYnj"},
 ( [ a ] = a )                     ;; {Anything, "A", Anything, "AE"},

;; B rules
 ( # [ b e ] C V + = b i )         ;; {Nothing, "BE", "^#", "bIH"},
 ( [ b e i n g ] = b ii i ng )     ;; {Anything, "BEING", Anything, "bIYIHNG"},
 ( # [ b u s ] V + = b i z )       ;; {Nothing, "BUS", "#", "bIHz"},
 ( [ b u i l ] = b i l )           ;; {Anything, "BUIL", Anything, "bIHl"},
 ( [ b ] = b )                     ;; {Anything, "B", Anything, "b"},

;; C rules
 ( # [ c h  ] C = k )              ;; {Nothing, "CH", "^", "k"},
 ( # [ c h ] a r a = k )
 ( C e [ c h ] = k )               ;; {"^E", "CH", Anything, "k"},
 ( i a r [ c h ] = k )          
 ( C [ c h ] # = ch )
 ( [ c h ] # = k )
 ( a r [ c h ] i n g  = ch )          
 ( a r [ c h ] e RSD = ch )          
 ( a r [ c h ] V = k )          
 ( a r [ c h ] y # = k )          
 ( [ c h ] = ch )                  ;; {Anything, "CH", Anything, "CH"},
 ( s [ c i ] V + = s ai )            ;; {" S", "CI", "#", "sAY"},
 ( [ c i ] a = sh )                ;; {Anything, "CI", "A", "SH"},
 ( [ c i ] o = sh )                ;; {Anything, "CI", "O", "SH"},
 ( [ c i ] e n = sh )              ;; {Anything, "CI", "EN", "SH"},
 ( [ c ] VF = s )                  ;; {Anything, "C", "+", "s"},
 ( [ c k ] = k )                   ;; {Anything, "CK", Anything, "k"},
 ( [ c o m ] e # = k uh m )        ;; {Anything, "COM", "%", "kAHm"},
 ( [ c o m ] e RSD # = k uh m )    ;; {Anything, "COM", "%", "kAHm"},
 ( [ c o m ] e l y # = k uh m )    ;; {Anything, "COM", "%", "kAHm"},
 ( [ c o m ] i n g # = k uh m )    ;; {Anything, "COM", "%", "kAHm"},
 ( [ c ] = k )                     ;; {Anything, "C", Anything, "k"},

;; D rules
 ( V + C * [ d e d ] # = d i d)    ;; {"#:", "DED", Nothing, "dIHd"},
 ( Cv e [ d ] # = d )              ;; {".E", "D", Nothing, "d"},
 ( V + C * e [ d ] # = t )         ;; {"#^:E", "D", Nothing, "t"},
 ( # [ d e ] C V + = d i )         ;; {Nothing, "DE", "^#", "dIH"},
 ( # [ d o e s ] = d uh z )        ;; {Nothing, "DOES", Anything, "dAHz"},
 ( # [ d o i n g ] = d uu i ng )   ;; {Nothing, "DOING", Anything, "dUWIHNG"},
 ( # [ d o w ] = d au )            ;; {Nothing, "DOW", Anything, "dAW"},
 ( [ d u ] a = jh uu )             ;; {Anything, "DU", "A", "jUW"},
 ( [ d ] = d )                     ;; {Anything, "D", Anything, "d"},

;; E rules
 ( V + C * [ e ] # = )             ;; {"#:", "E", Nothing, Silent},
;; ( \' C + [ e ] # = )              ;; {"'^:", "E", Nothing, Silent},
 ( # C * [ e ] # = ii )            ;; {" :", "E", Nothing, "IY"},
 ( V + [ e d ] # = d )             ;; {"#", "ED", Nothing, "d"},
 ( V + C * [ e ] d # = )           ;; {"#:", "E", "D ", Silent},
 ( [ e v ] e r = e v )             ;; {Anything, "EV", "ER", "EHv"},
 ( [ e r ] e d = @@ r)  
 ( [ e r ] V + = e r )             ;; {Anything, "ER", "#", "EHr"},
 ( [ e r ] = @@ r)                 ;; {Anything, "ER", Anything, "ER"},
 ( [ e ] C e # = ii )              ;; {Anything, "E", "^%", "IY"},
 ( [ e ] C e RSD # = ii )          ;; {Anything, "E", "^%", "IY"},
 ( [ e ] C e l y # = ii )          ;; {Anything, "E", "^%", "IY"},
 ( [ e ] C i n g # = ii )          ;; {Anything, "E", "^%", "IY"},
 ( [ e r i ] V + = ii r ii )       ;; {Anything, "ERI", "#", "IYrIY"},
 ( [ e r i ] = e r i )             ;; {Anything, "ERI", Anything, "EHrIH"},
 ( V + C * [ e r ] V + = @@ r)      ;; {"#:", "ER", "#", "ER"},
 ( # [ e v e n ] = ii v e n )      ;; {Nothing, "EVEN", Anything, "IYvEHn"},
 ( V + C * [ e  w ] # = uu )       
 ( V + C * [ e ] w = )             ;; {"#:", "E", "W", Silent},
 ( n [ e w ] = y uu )              ;;
 ( TSRDLZNJ [ e w ] = uu )         ;; {"T", "EW", Anything, "UW"},
 ( TCS h [ e w ] = uu )            ;; {"TH", "EW", Anything, "UW"},
 ( [ e w ] = y uu )                ;; {Anything, "EW", Anything, "YUw"},
 ( [ e ] o = ii )                  ;; {Anything, "E", "O", "IY"},
 ( V + C * SCGZXJ [ e s ] # = i z )  ;; {"#:S", "ES", Nothing, "IHz"},
 ( V + C * c h [ e s ] # = i z )   ;; {"#:CH", "ES", Nothing, "IHz"},
 ( V + C * s h [ e s ] # = i z )   ;; {"#:SH", "ES", Nothing, "IHz"},
 ( V + C * [ e ] s # = )           ;; {"#:", "E", "S ", Silent},
 ( V + C * [ e l y ] # = l ii )    ;; {"#:", "ELY", Nothing, "lIY"},
 ( V + C * [ e m e n t ] = m e n t ) ;; {"#:", "EMENT", Anything, "mEHnt"},
 ( [ e f u l ] = f u l )           ;; {Anything, "EFUL", Anything, "fUHl"},
 ( [ e e ] = ii )                  ;; {Anything, "EE", Anything, "IY"},
 ( [ e a r n ] = @@ n )            ;; {Anything, "EARN", Anything, "ERn"},
 ( # [ e a r ] C = @@ r)            ;; {Nothing, "EAR", "^", "ER"},
 ( [ e a d ] = e d )               ;; {Anything, "EAD", Anything, "EHd"},
 ( V + C * [ e a ] # = i@ )        ;; {"#:", "EA", Nothing, "IYAX"},
 ( [ e a ] s u = e )               ;; {Anything, "EA", "SU", "EH"},
 ( [ e a r ] C = @@ r)              ;; 
 ( [ e a r ] = i@ r)                ;; 
 ( C [ e a u ] # = ou )
 ( C [ e a u x ] # = ou )
 ( [ e a ] = ii )                  ;; {Anything, "EA", Anything, "IY"},
 ( [ e i g h ] = ei )              ;; {Anything, "EIGH", Anything, "EY"},
 ( [ e i ] = ei )                  ;; {Anything, "EI", Anything, "IY"},
 ( [ e y e ] = ai )                ;; {Nothing, "EYE", Anything, "AY"},
 ( [ e y ] = ii )                  ;; {Anything, "EY", Anything, "IY"},
 ( [ e u ] = y uu )                ;; {Anything, "EU", Anything, "YUw"},
 ( [ e ] = e )                     ;; {Anything, "E", Anything, "EH"},

;; F rules
 ( [ f u l ] = f u l )             ;; {Anything, "FUL", Anything, "fUHl"},
 ( [ f ] = f )                     ;; {Anything, "F", Anything, "f"},

;; G rules 
 ( [ g i v ] = g i v )             ;; {Anything, "GIV", Anything, "gIHv"},
 ( # [ g ] i C = g )               ;; {Nothing, "G", "I^", "g"},
 ( [ g e ] t = g e )               ;; {Anything, "GE", "T", "gEH"},
 ( s u [ g g e s ] = jh e s )      ;; {"SU", "GGES", Anything, "gjEHs"},
 (  [ g g ] = g )                  ;; {Anything, "GG", Anything, "g"},
 ( # b V + [ g ] = g )             ;; {" B#", "G", Anything, "g"},
 ( [ g ] VF = jh )                 ;; {Anything, "G", "+", "j"},
 ( [ g r e a t ] = g r ei t )      ;; {Anything, "GREAT", Anything, "grEYt"},
 ( V + [ g h ] = )                 ;; {"#", "GH", Anything, Silent},
 ( [ g ] = g )                     ;; {Anything, "G", Anything, "g"},

;; H rules
 ( # [ h a v ] = h a v )           ;; {Nothing, "HAV", Anything, "hAEv"},
 ( # [ h e r e ] = h i@ r)        ;; {Nothing, "HERE", Anything, "hIYr"},
 ( # [ h o u r ] = au @ r)          ;; {Nothing, "HOUR", Anything, "AWER"},
 ( [ h o w ] = h au )              ;; {Anything, "HOW", Anything, "hAW"},
 ( [ h ] V + = h )                 ;; {Anything, "H", "#", "h"},
 ( [ h ] = )                       ;; {Anything, "H", Anything, Silent},

;; I rules 
 ( # [ i n ] = i n )               ;; {Nothing, "IN", Anything, "IHn"},
 ( [ i n ] d = ai n )              ;; {Anything, "IN", "D", "AYn"},
 ( [ i e r ] = ii @@ r)             ;; {Anything, "IER", Anything, "IYER"},
 ( V + C * r [ i e d ] = ii d )    ;; {"#:R", "IED", Anything, "IYd"},
 ( [ i e d ] = ai d )              ;; {Anything, "IED", Nothing, "AYd"},
 ( [ i e n ] = ii e n )            ;; {Anything, "IEN", Anything, "IYEHn"},
 ( [ i e ] t = ai e )              ;; {Anything, "IE", "T", "AYEH"},
 ( # C * [ i ] e # = ai )          ;; {" :", "I", "%", "AY"},
 ( # C * [ i ] e RSD # = ai )      ;; {" :", "I", "%", "AY"},
 ( # C * [ i ] e l y # = ai )      ;; {" :", "I", "%", "AY"},
 ( # C * [ i ] i n g # = ai )      ;; {" :", "I", "%", "AY"},
 ( [ i ] e # = ii )                ;; {Anything, "I", "%", "IY"},
 ( [ i ] e RSD # = ii )            ;; {Anything, "I", "%", "IY"},
 ( [ i ] e l y # = ii )            ;; {Anything, "I", "%", "IY"},
 ( [ i ] i n g # = ii )            ;; {Anything, "I", "%", "IY"},
 ( [ i e ] = ii )                  ;; {Anything, "IE", Anything, "IY"},
 ( [ i r ] e s = ai r )           ;; {Anything, "IR", "#", "AYr"},
 ( [ i r ] e d = ai r )           ;; {Anything, "IR", "#", "AYr"},
 ( [ i r ] V + = ai r )            ;; {Anything, "IR", "#", "AYr"},
 ( [ i ] C e # = ai )              ;;
 ( [ i ] C e RSD # = ai )          ;;
 ( [ i ] C e l y # = ai )          ;;
 ( [ i ] C i n g # = ai )          ;;
 ( [ i ] C V + C + = i )           ;; {Anything, "I", "^+:#", "IH"},
 ( [ i z ] e # = ai z )            ;; {Anything, "IZ", "%", "AYz"},
 ( [ i z ] e RSD # = ai z )        ;; {Anything, "IZ", "%", "AYz"},
 ( [ i z ] e l y # = ai z )        ;; {Anything, "IZ", "%", "AYz"},
 ( [ i z ] i n g # = ai z )        ;; {Anything, "IZ", "%", "AYz"},
 ( [ i s ] e # = ai z )            ;; {Anything, "IS", "%", "AYz"},
 ( [ i s ] e RSD # = ai z )        ;; {Anything, "IS", "%", "AYz"},
 ( [ i s ] e l y # = ai z )        ;; {Anything, "IS", "%", "AYz"},
 ( [ i s ] i n g # = ai z )        ;; {Anything, "IS", "%", "AYz"},
 ( [ i ] d e # = ai )              ;; {Anything, "I", "D%", "AY"},
 ( [ i ] d e RSD # = ai )          ;; {Anything, "I", "D%", "AY"},
 ( [ i ] d e l y # = ai )          ;; {Anything, "I", "D%", "AY"},
 ( [ i ] d i n g # = ai )          ;; {Anything, "I", "D%", "AY"},
 ( VF C [ i ] VF = i )             ;; {"+^", "I", "^+", "IH"},
 ( [ i ] t e # = ai )              ;; {Anything, "I", "T%", "AY"}, 
 ( [ i ] t e RSD # = ai )          ;; {Anything, "I", "T%", "AY"}, 
 ( [ i ] t e l y # = ai )          ;; {Anything, "I", "T%", "AY"}, 
 ( [ i ] t i n g # = ai )          ;; {Anything, "I", "T%", "AY"}, 
 ( V + C + [ i ] C VF = i )        ;; {"#^:", "I", "^+", "IH"},
 ( [ i ] C VF = ai )               ;; {Anything, "I", "^+", "AY"},
 ( [ i r ] = @@ r)                  ;; {Anything, "IR", Anything, "ER"},
 ( [ i g h ] = ai )                ;; {Anything, "IGH", Anything, "AY"},
 ( [ i l d ] = ai l d )            ;; {Anything, "ILD", Anything, "AYld"},
 ( [ i g n ] # = ai n )            ;; {Anything, "IGN", Nothing, "AYn"},
 ( [ i g n ] C = ai n )            ;; {Anything, "IGN", "^", "AYn"},
 ( [ i g n ] e # = ai n )          ;; {Anything, "IGN", "%", "AYn"},
 ( [ i g n ] e RSD # = ai n )      ;; {Anything, "IGN", "%", "AYn"},
 ( [ i g n ] e l y # = ai n )      ;; {Anything, "IGN", "%", "AYn"},
 ( [ i g n ] i n g # = ai n )      ;; {Anything, "IGN", "%", "AYn"},
 ( [ i q u e ] = ii k )            ;; {Anything, "IQUE", Anything, "IYk"},
 ( [ i c r ] = ai k r )
 ( [ i ] = i )                     ;; {Anything, "I", Anything, "IH"},

;; J rules
 ( [ j ] = jh )                    ;; {Anything, "J", Anything, "j"},
 
;; K rules
 ( [ k ] n = )                     ;; {Nothing, "K", "N", Silent},
 ( [ k ] = k )                     ;; {Anything, "K", Anything, "k"},

;; L rules 
 ( [ l o ] c V + = l au )          ;; {Anything, "LO", "C#", "lOW"},
 ( l [ l ] = )                     ;; {"L", "L", Anything, Silent},
 ( V + C + [ l ] e # = @ l )       ;; {"#^:", "L", "%", "AXl"},
 ( V + C + [ l ] e RSD # = @ l )   ;; {"#^:", "L", "%", "AXl"},
 ( V + C + [ l ] e l y # = @ l )   ;; {"#^:", "L", "%", "AXl"},
 ( V + C + [ l ] i n g # = @ l )   ;; {"#^:", "L", "%", "AXl"},
 ( [ l e a d ] = l ii d )          ;; {Anything, "LEAD", Anything, "lIYd"},
 ( [ l ] = l )                     ;; {Anything, "L", Anything, "l"},

;; M rules 
 ( [ m o v ] = m uu v )            ;; {Anything, "MOV", Anything, "mUWv"},
 ( [ m ] = m )                     ;; {Anything, "M", Anything, "m"},

;; N rules 
 ( e [ n g ] VF = n jh )           ;; {"E", "NG", "+", "nj"},
 ( [ n g ] r = ng g )              ;; {Anything, "NG", "R", "NGg"},
 ( [ n g ] V + = ng g )            ;; {Anything, "NG", "#", "NGg"},
 ( [ n g l ] e # = ng g @ l )      ;; {Anything, "NGL", "%", "NGgAXl"},
 ( [ n g l ] e RSD # = ng g @ l )  ;; {Anything, "NGL", "%", "NGgAXl"},
 ( [ n g l ] e l y # = ng g @ l )  ;; {Anything, "NGL", "%", "NGgAXl"},
 ( [ n g l ] i n g # = ng g @ l )  ;; {Anything, "NGL", "%", "NGgAXl"},
 ( [ n g ] = ng )                  ;; {Anything, "NG", Anything, "NG"},
 ( [ n k ] = ng k )                ;; {Anything, "NK", Anything, "NGk"},
 ( [ n ] = n )                     ;; {Anything, "N", Anything, "n"},

;; O rules
 ( [ o f ] # = @ v )               ;; {Anything, "OF", Nothing, "AXv"},
 ( [ o r o u g h ] = uh r @@ )     ;; {Anything, "OROUGH", Anything, "EROW"},
 ( V + C * [ o r ] # = @@ r)        ;; {"#:", "OR", Nothing, "ER"},
 ( V + C * [ o r s ] # = @@ z )    ;; {"#:", "ORS", Nothing, "ERz"},
 ( [ o r ] = oo r)                  ;; {Anything, "OR", Anything, "AOr"},
 ( # [ o n e ] = w uh n )          ;; {Nothing, "ONE", Anything, "wAHn"},
 ( [ o w ] = ou )                  ;; {Anything, "OW", Anything, "OW"},
 ( # [ o v e r ] = ou v @ r)        ;; {Nothing, "OVER", Anything, "OWvER"},
 ( # [ o v ] = uh v )              ;; {Anything, "OV", Anything, "AHv"},
 ( [ o ] C e # = ou )              ;; {Anything, "O", "^%", "OW"},
 ( [ o ] C e RSD # = ou )          ;; {Anything, "O", "^%", "OW"},
 ( [ o ] C e l y # = ou )          ;; {Anything, "O", "^%", "OW"},
 ( [ o ] C i n g # = ou )          ;; {Anything, "O", "^%", "OW"},
 ( [ o ] C e n  = ou )             ;; {Anything, "O", "^EN", "OW"},
 ( [ o ] C i V + = ou )            ;; {Anything, "O", "^I#", "OW"},
 ( [ o l ] d = ou l )              ;; {Anything, "OL", "D", "OWl"},
 ( [ o u g h t ] = oo t )          ;; {Anything, "OUGHT", Anything, "AOt"},
 ( [ o u g h ] = uh f )            ;; {Anything, "OUGH", Anything, "AHf"},
 ( # [ o u ] = au )                ;; {Nothing, "OU", Anything, "AW"},
 ( h [ o u ] s V + = au )          ;; {"H", "OU", "S#", "AW"},
 ( [ o u s ] = @ s )               ;; {Anything, "OUS", Anything, "AXs"},
 ( [ o u r ] = oo r )               ;;  {Anything, "OUR", Anything, "AOr"},
 ( [ o u l d ] = u d )             ;; {Anything, "OULD", Anything, "UHd"},
 ( C [ o u ] C l = uh )            ;; {"^", "OU", "^L", "AH"},
 ( [ o u p ] = uu )                ;; {Anything, "OUP", Anything, "UWp"},
 ( [ o u ] = au )                  ;; {Anything, "OU", Anything, "AW"},
 ( [ o y ] = oi )                  ;; {Anything, "OY", Anything, "OY"},
 ( [ o i n g ] = ou i ng )         ;; {Anything, "OING", Anything, "OWIHNG"},
 ( [ o i ] = oi )                  ;; {Anything, "OI", Anything, "OY"},
 ( [ o o r ] = oo r)                ;; {Anything, "OOR", Anything, "AOr"},
 ( [ o o k ] = u k )               ;; {Anything, "OOK", Anything, "UHk"},
 ( [ o o d ] = u d )               ;; {Anything, "OOD", Anything, "UHd"},
 ( [ o o ] = uu )                  ;; {Anything, "OO", Anything, "UW"},
 ( [ o ] e = ou )                  ;; {Anything, "O", "E", "OW"},
 ( [ o ] # = ou )                  ;; {Anything, "O", Nothing, "OW"},
 ( [ o a ] = ou )                  ;; {Anything, "OA", Anything, "OW"},
 ( # [ o n l y ] = ou n l ii )     ;; {Nothing, "ONLY", Anything, "OWnlIY"},
 ( # [ o n c e ] = w uh n s )      ;; {Nothing, "ONCE", Anything, "wAHns"},
;; ( [ o n \' t ] = ou n t )         ;; {Anything, "ON'T", Anything, "OWnt"},
 ( c [ o ] n = o )                 ;; {"C", "O", "N", "AA"},
 ( [ o ] n g = oo )                ;; {Anything, "O", "NG", "AO"},
 ( C + [ o ] n = uh )              ;; {"^:", "O", "N", "AH"},
 ( i [ o n ] = @ n )               ;; {"I", "ON", Anything, "AXn"},
 ( V + C * [ o n ] # = @ n )       ;; {"#:", "ON", Nothing, "AXn"},
 ( V + C [ o n ] = @ n )           ;; {"#^", "ON", Anything, "AXn"},
 ( [ o ] s t # = ou )              ;; {Anything, "O", "ST ", "OW"},
 ( [ o f ] C = oo f )              ;; {Anything, "OF", "^", "AOf"},
 ( [ o t h e r ] = uh dh @@ r)     ;; {Anything, "OTHER", Anything, "AHDHER"},
 ( [ o s s ] # = oo s )            ;; {Anything, "OSS", Nothing, "AOs"},
 ( V + C * [ o m ] = uh m )        ;; {"#^:", "OM", Anything, "AHm"},
 ( [ o ] = o )                     ;; {Anything, "O", Anything, "AA"},

;; P rules
 ( [ p h ] = f )                   ;; {Anything, "PH", Anything, "f"},
 ( [ p e o p ] = p ii p )          ;; {Anything, "PEOP", Anything, "pIYp"},
 ( [ p o w ] = p au )              ;; {Anything, "POW", Anything, "pAW"},
 ( [ p u t ] = p u t )             ;; {Anything, "PUT", Nothing, "pUHt"},
 ( [ p ] = p )                     ;; {Anything, "P", Anything, "p"},

;; Q rules
 ( [ q u a r ] = k w oo r)         ;; {Anything, "QUAR", Anything, "kwAOr"},
 ( V [ q u e s ] # = k )           
 ( C [ q u e s ] # = k )           
 ( [ q u ] = k w )                 ;; {Anything, "QU", Anything, "kw"},
 ( [ q ] = k )                     ;; {Anything, "Q", Anything, "k"},

;; R rules 
 ( # [ r e ] C V + = r ii )        ;; {Nothing, "RE", "^#", "rIY"},
 ( t [ r e ] # = @@ r)             ;; centre
 ( # [ r h ] = r )
 ( # [ r ] C = @@ r)
 ( [ r ] # = @ r )
 ( [ r ] = r )                     ;; {Anything, "R", Anything, "r"},

;; S rules
 ( [ s h ] = sh )                  ;; {Anything, "SH", Anything, "SH"},
 ( V + [ s i o n ] = zh @ n )      ;; {"#", "SION", Anything, "ZHAXn"},
 ( [ s o m e ] = s uh m )          ;; {Anything, "SOME", Anything, "sAHm"},
 ( V + [ s u r ] V + = zh @@ r)     ;; {"#", "SUR", "#", "ZHER"},
 ( [ s u r ] V + = sh @@ r)         ;; {Anything, "SUR", "#", "SHER"},
 ( V + [ s u ] V + = zh uu )       ;; {"#", "SU", "#", "ZHUW"},
 ( V + [ s s u ] V + = sh uu )     ;; {"#", "SSU", "#", "SHUW"},
 ( V + [ s e d ] # = z d )         ;; {"#", "SED", Nothing, "zd"},
 ( V + [ s ] V + = z )             ;; {"#", "S", "#", "z"},
 ( [ s a i d ] = s e d )           ;; {Anything, "SAID", Anything, "sEHd"},
 ( C [ s i o n ] = sh @ n )        ;; {"^", "SION", Anything, "SHAXn"},
 ( [ s ] s = )                     ;; {Anything, "S", "S", Silent},
 ( Cv [ s ] # = z )                ;; {".", "S", Nothing, "z"},
 ( V + C * Cv e [ s ] # = z )      ;; {"#:.E", "S", Nothing, "z"},
 ( V + C + V V + [ s ] # = z )     ;; {"#^:##", "S", Nothing, "z"},
 ( V + C + V + [ s ] # = s )       ;; {"#^:#", "S", Nothing, "s"},
 ( u [ s ] # = s )                 ;; {"U", "S", Nothing, "s"},
 ( # C + V + [ s ] # = z )           ;; {" :#", "S", Nothing, "z"},
 ( [ s c h ] = s k )               ;; {Nothing, "SCH", Anything, "sk"},
 ( [ s ] c VF = )                  ;; {Anything, "S", "C+", Silent},
 ( V + [ s m ] = z m )             ;; {"#", "SM", Anything, "zm"},
 ( V + [ s n ] = z @ n )           ;; {"#", "SN", "'", "zAXn"},
 ( [ s ] = s )                     ;; {Anything, "S", Anything, "s"},

;; T rules 
 ( [ t o ] # = t uu )              ;; {Anything, "TO", Nothing, "tUW"},
 ( # [ t h e y ] = dh ei )         ;; {Nothing, "THEY", Anything, "DHEY"},
 ( # [ t h e r e ] = dh e@ )       ;; {Nothing, "THERE", Anything, "DHEHr"},
 ( [ t h e r ] = dh e@ r)           ;; {Anything, "THER", Anything, "DHER"},
 ( [ t h e i r ] = dh e@ r)         ;; {Anything, "THEIR", Anything, "DHEHr"},
 ( [ t h e s e ] # = dh ii z )     ;; {Anything, "THESE", Nothing, "DHIYz"},
 ( [ t h e n ] = dh e n )          ;; {Nothing, "THEN", Anything, "DHEHn"},
 ( [ t h r o u g h ] = th r uu )   ;; {Anything, "THROUGH", Anything, "THrUW"},
 ( [ t h o s e ] = dh ou z )       ;; {Anything, "THOSE", Anything, "DHOWz"},
 ( [ t h o u g h ] = dh ou )       ;; {Anything, "THOUGH", Nothing, "DHOW"},
 ( [ t h u s ] = dh uh s )         ;; {Nothing, "THUS", Anything, "DHAHs"},
 ( [ t h ] = th )                  ;; {Anything, "TH", Anything, "TH"},
 ( V + C * [ t e d ] # = t i d )   ;; {"#:", "TED", Nothing, "tIHd"},
 ( s [ t i ] V + n = ch )          ;; {"S", "TI", "#N", "CH"},
 ( [ t i ] o = sh )                ;; {Anything, "TI", "O", "SH"},
 ( [ t i ] a = sh )                ;; {Anything, "TI", "A", "SH"},
 ( [ t i e n ] = sh @ n )          ;; {Anything, "TIEN", Anything, "SHAXn"},
 ( [ t u r ] V + = ch @@ r)         ;; {Anything, "TUR", "#", "CHER"},
 ( [ t u ] a = ch uu )             ;; {Anything, "TU", "A", "CHUW"},
 ( # [ t w o ] = t uu )            ;; {Nothing, "TWO", Anything, "tUW"},
 ( [ t ] = t )                     ;; {Anything, "T", Anything, "t"},

;; U rules 
 ( # [ u n ] i = y uu n )          ;;{Nothing, "UN", "I", "yUWn"},
 ( # [ u n ] = uh n )              ;; {Nothing, "UN", Anything, "AHn"},
 ( # [ u p o n ] = @ p oo n )      ;; {Nothing, "UPON", Anything, "AXpAOn"},
 ( TSRDLZNJ [ u r ] V + = u r )    ;; {"T", "UR", "#", "UHr"},
 ( TCS h [ u r ] V + = u r )       ;; {"TH", "UR", "#", "UHr"},
 ( [ u r ] e SD = y u@ r)
 ( [ u r ] V + = y u r )           ;; {Anything, "UR", "#", "yUHr"},
 ( [ u r ] = @@ r)                  ;; {Anything, "UR", Anything, "ER"},
 ( [ u ] C # = uh )                ;; {Anything, "U", "^ ", "AH"},
 ( [ u ] C C = uh )                ;; {Anything, "U^^", Anything, "AH"},
 ( [ u y ] = ai )                  ;; {Anything, "UY", Anything, "AY"},
 ( # g [ u ] V + = )               ;; {" G", "U", "#", Silent},
 ( g [ u ] e # = )                 ;; {"G", "U", "%", Silent},
 ( g [ u ] e RSD # = )             ;; {"G", "U", "%", Silent},
 ( g [ u ] e l y # = )             ;; {"G", "U", "%", Silent},
 ( g [ u ] i n g # = )             ;; {"G", "U", "%", Silent},
 ( g [ u ] V + = w )               ;; {"G", "U", "#", "w"},
 ( V + n [ u ] = y uu )            ;; {"#N", "U", Anything, "YUw"},
 ( TSRDLZNJ [ u ] = u )            ;; {"T", "U", Anything, "UH"},
 ( TCS h [ u ] = u )               ;; {"TH", "U", Anything, "UH"},
 ( [ u ] = u )                     ;; {Anything, "U", Anything, "UH"},

;; V rules
 ( [ v i e w ] = v y uu )          ;; {Anything, "VIEW", Anything, "vYUw"},
 ( [ v ] = v )                     ;; {Anything, "V", Anything, "v"},

;; W rules 
 ( # [ w e r e ] = w @@ )          ;; {Nothing, "WERE", Anything, "wER"},
 ( [ w a ] s = w o )               ;; {Anything, "WA", "S", "wAA"},
 ( [ w a ] t = w o )               ;; {Anything, "WA", "T", "wAA"},
 ( [ w e r e ] = w @@ )            ;; {Anything, "WERE", Anything, "WHEHr"},
 ( [ w h e r e ] = w e@ )          
 ( [ w h a t ] = w o t )           ;; {Anything, "WHAT", Anything, "WHAAt"},
 ( [ w h o l ] = h ou l )          ;; {Anything, "WHOL", Anything, "hOWl"},
 ( [ w h o ] = h uu )              ;; {Anything, "WHO", Anything, "hUW"},
 ( [ w h ] = w )                   ;; {Anything, "WH", Anything, "WH"},
 ( [ w a r e ] = w e@ r)           
 ( [ w a r ] = w oo r)              ;; {Anything, "WAR", Anything, "wAOr"},
 ( [ w o r ] C = w @@ r)            ;; {Anything, "WOR", "^", "wER"},
 ( [ w r ] = r )                   ;; {Anything, "WR", Anything, "r"},
 ( [ w ] = w )                     ;; {Anything, "W", Anything, "w"},

;; X rules
 ( [ x ] = k s )                   ;; {Anything, "X", Anything, "ks"},

;; Y rules 
 ( [ y o u n g ] = y uh ng )       ;; {Anything, "YOUNG", Anything, "yAHNG"},
 ( # [ y o u ] = y uu )            ;; {Nothing, "YOU", Anything, "yUW"},
 ( # [ y e s ] = y e s )           ;; {Nothing, "YES", Anything, "yEHs"},
 ( # [ y ] C = ii )                
 ( # [ y ] = y )                   ;; {Nothing, "Y", Anything, "y"},
 ( V + C + [ y ] # = ii )          ;; {"#^:", "Y", Nothing, "IY"},
 ( V + C + [ y ] i = ii )          ;; {"#^:", "Y", "I", "IY"},
 ( # C + [ y ] # = ai )              ;; {" :", "Y", Nothing, "AY"},
 ( # C + [ y ] V + = ai )            ;; {" :", "Y", "#", "AY"},
 ( # C + [ y ] C VF V + = i )        ;; {" :", "Y", "^+:#", "IH"},
 ( # C + [ y ] C V + = ai )          ;; {" :", "Y", "^#", "AY"},
 ( [ y ] = i )                     ;; {Anything, "Y", Anything, "IH"},

;; Z rules 
 ( [ z ] = z )                     ;; {Anything, "Z", Anything, "z"},
))

(provide 'lts_nrl)
