;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;                                                                       ;;
;;;                Centre for Speech Technology Research                  ;;
;;;                     University of Edinburgh, UK                       ;;
;;;                       Copyright (c) 1996,1997                         ;;
;;;                        All Rights Reserved.                           ;;
;;;                                                                       ;;
;;;  Permission to use, copy, modify, distribute this software and its    ;;
;;;  documentation for research, educational and individual use only, is  ;;
;;;  hereby granted without fee, subject to the following conditions:     ;;
;;;   1. The code must retain the above copyright notice, this list of    ;;
;;;      conditions and the following disclaimer.                         ;;
;;;   2. Any modifications must be clearly marked as such.                ;;
;;;   3. Original authors' names are not deleted.                         ;;
;;;  This software may not be used for commercial purposes without        ;;
;;;  specific prior written permission from the authors.                  ;;
;;;                                                                       ;;
;;;  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ;;
;;;  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ;;
;;;  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ;;
;;;  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ;;
;;;  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ;;
;;;  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ;;
;;;  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ;;
;;;  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ;;
;;;  THIS SOFTWARE.                                                       ;;
;;;                                                                       ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  Dump word/break info for testing prediction
;;;

(set! data_dir "SET_THIS_TO_YOUR_DATABASE_DIRECTORY")

;;  Sets db_dir and database_files
;;  This should list all the utterance names in your db.
(load (string-append data_dir "bin/db_description.scm"))

;;; The stream you wish to extract the feature from
(set! desired_stream 'Segment)

;;;  Set your desired features here
(set! desired_feats
      '(duration
	name
	n.name
	p.name
	Syllable.position_type
	pos_in_syl
	syl_initial
	syl_final
	Syllable.p.syl_break
	Syllable.syl_break
	Syllable.n.syl_break
	Syllable.p.stress
	Syllable.stress
	Syllable.n.stress))

;;; Output sekeleton for saved features
(set! outskeleton "feats/%s.dur")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define (dump_all_features streamname feats names outskeleton)
  (mapcar
   (lambda (file)
     (print file)
     (extract_feats 
      streamname feats 
      file
      (format nil outskeleton file)))
   names))

(define (extract_feats streamname feats uttname outfile)
  (let ((fd (fopen outfile "w"))
	(utt (get_utt uttname)))
    (mapcar
     (lambda (d)
       (mapcar 
	(lambda (f)
	  (format fd "%s " f))
	 d)
       (format fd "\n"))
     (utt.features utt streamname feats))
    (fclose fd)))

(define (get_utt fname)
  (utt.load nil (string-append db_dir "utts/seg/" fname ".seg.utt")))


;;;
;;;  Call as 
 
(dump_all_features 
 desired_stream
 desired_feats 
 database_files
 outskeleton)
