/********************************************************************************
 * Copyright (C) Clarendon Hill Software 1992
 *               Erik Kunze 1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Clarendon Hill Software
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: dis.c,v 3.5 1997/05/17 17:12:18 erik Rel $";
#endif

#include <stdio.h>
#include <string.h>
#include "z80.h"
#include "mem.h"
#include "dis.h"

struct opcode {
	char *name;
	int args;
};



static char undefined[] = "undefined";
static struct opcode major[256] = {
	{	"nop",					0	},
	{	"ld   bc,%02X%02X",	2	},
	{	"ld   bc,a",			0	},
	{	"inc  bc",				0	},
	{	"inc  b",				0	},
	{	"dec  b",				0	},
	{	"ld   b,%02X",			1	},
	{	"rlc  a",				0	},
	{	"ex   af,af'",			0	},
	{	"add  hl,bc",			0	},
	{	"ld   a,(bc)",			0	},
	{	"dec  bc",				0	},
	{	"inc  c",				0	},
	{	"dec  c",				0	},
	{	"ld   c,%02X",			1	},
	{	"rrc  a",				0	},
	{	"djnz %04X",			-1	},
	{	"ld   de,%02X%02X",		2	},
	{	"ld   (de),a",			0	},
	{	"inc  de",				0	},
	{	"inc  d",				0	},
	{	"dec  d",				0	},
	{	"ld   d,%02X",			1	},
	{	"rla",					0	},
	{	"jr   %04X",			-1	},
	{	"add  hl,de",			0	},
	{	"ld   a,(de)",			0	},
	{	"dec  de",				0	},
	{	"inc  e",				0	},
	{	"dec  e",				0	},
	{	"ld   e,%02X",			1	},
	{	"rra",					0	},
	{	"jr   nz,%04X",			-1	},
	{	"ld   hl,%02X%02X",		2	},
	{	"ld   (%02X%02X),hl",	2	},
	{	"inc  hl",				0	},
	{	"inc  h",				0	},
	{	"dec  h",				0	},
	{	"ld   h,%02X",			1	},
	{	"daa",					0	},
	{	"jr   z,%04X",			-1	},
	{	"add  hl,hl",			0	},
	{	"ld   hl,(%02X%02X)",	2	},
	{	"dec  hl",				0	},
	{	"inc  l",				0	},
	{	"dec  l",				0	},
	{	"ld   l,%02X",			1	},
	{	"cpl",					0	},
	{	"jr   nc,%04X",			-1	},
	{	"ld   sp,%02X%02X",		2	},
	{	"ld   (%02X%02X),a",	2	},
	{	"inc  sp",				0	},
	{	"inc  (hl)",			0	},
	{	"dec  (hl)",			0	},
	{	"ld   (hl),%02X",		1	},
	{	"scf",					0	},
	{	"jr   c,%04X",			-1	},
	{	"add  hl,sp",			0	},
	{	"ld   a,(%02X%02X)",	2	},
	{	"dec  sp",				0	},
	{	"inc  a",				0	},
	{	"dec  a",				0	},
	{	"ld   a,%02X",			1	},
	{	"ccf",					0	},
	{	"ld   b,b",				0	},
	{	"ld   b,c",				0	},
	{	"ld   b,d",				0	},
	{	"ld   b,e",				0	},
	{	"ld   b,h",				0	},
	{	"ld   b,l",				0	},
	{	"ld   b,(hl)",			0	},
	{	"ld   b,a",				0	},
	{	"ld   c,b",				0	},
	{	"ld   c,c",				0	},
	{	"ld   c,d",				0	},
	{	"ld   c,e",				0	},
	{	"ld   c,h",				0	},
	{	"ld   c,l",				0	},
	{	"ld   c,(hl)",			0	},
	{	"ld   c,a",				0	},
	{	"ld   d,b",				0	},
	{	"ld   d,c",				0	},
	{	"ld   d,d",				0	},
	{	"ld   d,e",				0	},
	{	"ld   d,h",				0	},
	{	"ld   d,l",				0	},
	{	"ld   d,(hl)",			0	},
	{	"ld   d,a",				0	},
	{	"ld   e,b",				0	},
	{	"ld   e,c",				0	},
	{	"ld   e,d",				0	},
	{	"ld   e,e",				0	},
	{	"ld   e,h",				0	},
	{	"ld   e,l",				0	},
	{	"ld   e,(hl)",			0	},
	{	"ld   e,a",				0	},
	{	"ld   h,b",				0	},
	{	"ld   h,c",				0	},
	{	"ld   h,d",				0	},
	{	"ld   h,e",				0	},
	{	"ld   h,h",				0	},
	{	"ld   h,l",				0	},
	{	"ld   h,(hl)",			0	},
	{	"ld   h,a",				0	},
	{	"ld   l,b",				0	},
	{	"ld   l,c",				0	},
	{	"ld   l,d",				0	},
	{	"ld   l,e",				0	},
	{	"ld   l,h",				0	},
	{	"ld   l,l",				0	},
	{	"ld   l,(hl)",			0	},
	{	"ld   l,a",				0	},
	{	"ld   (hl),b",			0	},
	{	"ld   (hl),c",			0	},
	{	"ld   (hl),d",			0	},
	{	"ld   (hl),e",			0	},
	{	"ld   (hl),h",			0	},
	{	"ld   (hl),l",			0	},
	{	"halt",					0	},
	{	"ld   (hl),a",			0	},
	{	"ld   a,b",				0	},
	{	"ld   a,c",				0	},
	{	"ld   a,d",				0	},
	{	"ld   a,e",				0	},
	{	"ld   a,h",				0	},
	{	"ld   a,l",				0	},
	{	"ld   a,(hl)",			0	},
	{	"ld   a,a",				0	},
	{	"add  a,b",				0	},
	{	"add  a,c",				0	},
	{	"add  a,d",				0	},
	{	"add  a,e",				0	},
	{	"add  a,h",				0	},
	{	"add  a,l",				0	},
	{	"add  a,(hl)",			0	},
	{	"add  a,a",				0	},
	{	"adc  a,b",				0	},
	{	"adc  a,c",				0	},
	{	"adc  a,d",				0	},
	{	"adc  a,e",				0	},
	{	"adc  a,h",				0	},
	{	"adc  a,l",				0	},
	{	"adc  a,(hl)",			0	},
	{	"adc  a,a",				0	},
	{	"sub  b",				0	},
	{	"sub  c",				0	},
	{	"sub  d",				0	},
	{	"sub  e",				0	},
	{	"sub  h",				0	},
	{	"sub  l",				0	},
	{	"sub  (hl)",			0	},
	{	"sub  a",				0	},
	{	"sbc  a,b",				0	},
	{	"sbc  a,c",				0	},
	{	"sbc  a,d",				0	},
	{	"sbc  a,e",				0	},
	{	"sbc  a,h",				0	},
	{	"sbc  a,l",				0	},
	{	"sbc  a,(hl)",			0	},
	{	"sbc  a,a",				0	},
	{	"and  b",				0	},
	{	"and  c",				0	},
	{	"and  d",				0	},
	{	"and  e",				0	},
	{	"and  h",				0	},
	{	"and  l",				0	},
	{	"and  (hl)",			0	},
	{	"and  a",				0	},
	{	"xor  b",				0	},
	{	"xor  c",				0	},
	{	"xor  d",				0	},
	{	"xor  e",				0	},
	{	"xor  h",				0	},
	{	"xor  l",				0	},
	{	"xor  (hl)",			0	},
	{	"xor  a",				0	},
	{	"or   b",				0	},
	{	"or   c",				0	},
	{	"or   d",				0	},
	{	"or   e",				0	},
	{	"or   h",				0	},
	{	"or   l",				0	},
	{	"or   (hl)",			0	},
	{	"or   a",				0	},
	{	"cp   b",				0	},
	{	"cp   c",				0	},
	{	"cp   d",				0	},
	{	"cp   e",				0	},
	{	"cp   h",				0	},
	{	"cp   l",				0	},
	{	"cp   (hl)",			0	},
	{	"cp   a",				0	},
	{	"ret  nz",				0	},
	{	"pop  bc",				0	},
	{	"jp   nz,%02X%02X",		2	},
	{	"jp   %02X%02X",		2	},
	{	"call nz,%02X%02X",		2	},
	{	"push bc",				0	},
	{	"add  a,%02X",			1	},
	{	"rst  0",				0	},
	{	"ret  z",				0	},
	{	"ret",					0	},
	{	"jp   z,%02X%02X",		2	},
	{	NULL,					0	},
	{	"call z,%02X%02X",		2	},
	{	"call %02X%02X",		2	},
	{	"adc  a,%02X",			1	},
	{	"rst  8",				0	},
	{	"ret  nc",				0	},
	{	"pop  de",				0	},
	{	"jp   nc,%02X%02X",		2	},
	{	"out  (%02X),a",		1	},
	{	"call nc,%02X%02X",		2	},
	{	"push de",				0	},
	{	"sub  %02X",			1	},
	{	"rst  10h",				0	},
	{	"ret  c",				0	},
	{	"exx",					0	},
	{	"jp   c,%02X%02X",		2	},
	{	"in   a,(%02X)",		1	},
	{	"call c,%02X%02X",		2	},
	{	NULL,					1	},
	{	"sbc  a,%02X",			1	},
	{	"rst  18h",				0	},
	{	"ret  po",				0	},
	{	"pop  hl",				0	},
	{	"jp   po,%02X%02X",		2	},
	{	"ex   (sp),hl",			0	},
	{	"call po,%02X%02X",		2	},
	{	"push hl",				0	},
	{	"and  %02X",			1	},
	{	"rst  20h",				0	},
	{	"ret  pe",				0	},
	{	"jp   (hl)",			0	},
	{	"jp   pe,%02X%02X",		2	},
	{	"ex   de,hl",			0	},
	{	"call pe,%02X%02X",		2	},
	{	NULL,					2	},
	{	"xor  %02X",			1	},
	{	"rst  28h",				0	},
	{	"ret  p",				0	},
	{	"pop  af",				0	},
	{	"jp   p,%02X%02X",		2	},
	{	"di",					0	},
	{	"call p,%02X%02X",		2	},
	{	"push af",				0	},
	{	"or   %02X",			1	},
	{	"rst  30h",				0	},
	{	"ret  m",				0	},
	{	"ld   sp,hl",			0	},
	{	"jp   m,%02X%02X",		2	},
	{	"ei",					0	},
	{	"call m,%02X%02X",		2	},
	{	NULL,					1	},
	{	"cp   %02X",			1	},
	{	"rst  38h",				0	},
};
static struct opcode minor[][256] = {
  {
	{	"rlc  b",				0	},
	{	"rlc  c",				0	},
	{	"rlc  d",				0	},
	{	"rlc  e",				0	},
	{	"rlc  h",				0	},
	{	"rlc  l",				0	},
	{	"rlc  (hl)",			0	},
	{	"rlc  a",				0	},
	{	"rrc  b",				0	},
	{	"rrc  c",				0	},
	{	"rrc  d",				0	},
	{	"rrc  e",				0	},
	{	"rrc  h",				0	},
	{	"rrc  l",				0	},
	{	"rrc  (hl)",			0	},
	{	"rrc  a",				0	},
	{	"rl   b",				0	},
	{	"rl   c",				0	},
	{	"rl   d",				0	},
	{	"rl   e",				0	},
	{	"rl   h",				0	},
	{	"rl   l",				0	},
	{	"rl   (hl)",			0	},
	{	"rl   a",				0	},
	{	"rr   b",				0	},
	{	"rr   c",				0	},
	{	"rr   d",				0	},
	{	"rr   e",				0	},
	{	"rr   h",				0	},
	{	"rr   l",				0	},
	{	"rr   (hl)",			0	},
	{	"rr   a",				0	},
	{	"sla  b",				0	},
	{	"sla  c",				0	},
	{	"sla  d",				0	},
	{	"sla  e",				0	},
	{	"sla  h",				0	},
	{	"sla  l",				0	},
	{	"sla  (hl)",			0	},
	{	"sla  a",				0	},
	{	"sra  b",				0	},
	{	"sra  c",				0	},
	{	"sra  d",				0	},
	{	"sra  e",				0	},
	{	"sra  h",				0	},
	{	"sra  l",				0	},
	{	"sra  (hl)",			0	},
	{	"sra  a",				0	},
	{	"slai b",				0	},
	{	"slai c",				0	},
	{	"slai d",				0	},
	{	"slai e",				0	},
	{	"slai h",				0	},
	{	"slai l",				0	},
	{	"slai (hl)",			0	},
	{	"slai a",				0	},
	{	"srl  b",				0	},
	{	"srl  c",				0	},
	{	"srl  d",				0	},
	{	"srl  e",				0	},
	{	"srl  h",				0	},
	{	"srl  l",				0	},
	{	"srl  (hl)",			0	},
	{	"srl  a",				0	},
	{	"bit  0,b",				0	},
	{	"bit  0,c",				0	},
	{	"bit  0,d",				0	},
	{	"bit  0,e",				0	},
	{	"bit  0,h",				0	},
	{	"bit  0,l",				0	},
	{	"bit  0,(hl)",			0	},
	{	"bit  0,a",				0	},
	{	"bit  1,b",				0	},
	{	"bit  1,c",				0	},
	{	"bit  1,d",				0	},
	{	"bit  1,e",				0	},
	{	"bit  1,h",				0	},
	{	"bit  1,l",				0	},
	{	"bit  1,(hl)",			0	},
	{	"bit  1,a",				0	},
	{	"bit  2,b",				0	},
	{	"bit  2,c",				0	},
	{	"bit  2,d",				0	},
	{	"bit  2,e",				0	},
	{	"bit  2,h",				0	},
	{	"bit  2,l",				0	},
	{	"bit  2,(hl)",			0	},
	{	"bit  2,a",				0	},
	{	"bit  3,b",				0	},
	{	"bit  3,c",				0	},
	{	"bit  3,d",				0	},
	{	"bit  3,e",				0	},
	{	"bit  3,h",				0	},
	{	"bit  3,l",				0	},
	{	"bit  3,(hl)",			0	},
	{	"bit  3,a",				0	},
	{	"bit  4,b",				0	},
	{	"bit  4,c",				0	},
	{	"bit  4,d",				0	},
	{	"bit  4,e",				0	},
	{	"bit  4,h",				0	},
	{	"bit  4,l",				0	},
	{	"bit  4,(hl)",			0	},
	{	"bit  4,a",				0	},
	{	"bit  5,b",				0	},
	{	"bit  5,c",				0	},
	{	"bit  5,d",				0	},
	{	"bit  5,e",				0	},
	{	"bit  5,h",				0	},
	{	"bit  5,l",				0	},
	{	"bit  5,(hl)",			0	},
	{	"bit  5,a",				0	},
	{	"bit  6,b",				0	},
	{	"bit  6,c",				0	},
	{	"bit  6,d",				0	},
	{	"bit  6,e",				0	},
	{	"bit  6,h",				0	},
	{	"bit  6,l",				0	},
	{	"bit  6,(hl)",			0	},
	{	"bit  6,a",				0	},
	{	"bit  7,b",				0	},
	{	"bit  7,c",				0	},
	{	"bit  7,d",				0	},
	{	"bit  7,e",				0	},
	{	"bit  7,h",				0	},
	{	"bit  7,l",				0	},
	{	"bit  7,(hl)",			0	},
	{	"bit  7,a",				0	},
	{	"res  0,b",				0	},
	{	"res  0,c",				0	},
	{	"res  0,d",				0	},
	{	"res  0,e",				0	},
	{	"res  0,h",				0	},
	{	"res  0,l",				0	},
	{	"res  0,(hl)",			0	},
	{	"res  0,a",				0	},
	{	"res  1,b",				0	},
	{	"res  1,c",				0	},
	{	"res  1,d",				0	},
	{	"res  1,e",				0	},
	{	"res  1,h",				0	},
	{	"res  1,l",				0	},
	{	"res  1,(hl)",			0	},
	{	"res  1,a",				0	},
	{	"res  2,b",				0	},
	{	"res  2,c",				0	},
	{	"res  2,d",				0	},
	{	"res  2,e",				0	},
	{	"res  2,h",				0	},
	{	"res  2,l",				0	},
	{	"res  2,(hl)",			0	},
	{	"res  2,a",				0	},
	{	"res  3,b",				0	},
	{	"res  3,c",				0	},
	{	"res  3,d",				0	},
	{	"res  3,e",				0	},
	{	"res  3,h",				0	},
	{	"res  3,l",				0	},
	{	"res  3,(hl)",			0	},
	{	"res  3,a",				0	},
	{	"res  4,b",				0	},
	{	"res  4,c",				0	},
	{	"res  4,d",				0	},
	{	"res  4,e",				0	},
	{	"res  4,h",				0	},
	{	"res  4,l",				0	},
	{	"res  4,(hl)",			0	},
	{	"res  4,a",				0	},
	{	"res  5,b",				0	},
	{	"res  5,c",				0	},
	{	"res  5,d",				0	},
	{	"res  5,e",				0	},
	{	"res  5,h",				0	},
	{	"res  5,l",				0	},
	{	"res  5,(hl)",			0	},
	{	"res  5,a",				0	},
	{	"res  6,b",				0	},
	{	"res  6,c",				0	},
	{	"res  6,d",				0	},
	{	"res  6,e",				0	},
	{	"res  6,h",				0	},
	{	"res  6,l",				0	},
	{	"res  6,(hl)",			0	},
	{	"res  6,a",				0	},
	{	"res  7,b",				0	},
	{	"res  7,c",				0	},
	{	"res  7,d",				0	},
	{	"res  7,e",				0	},
	{	"res  7,h",				0	},
	{	"res  7,l",				0	},
	{	"res  7,(hl)",			0	},
	{	"res  7,a",				0	},
	{	"set  0,b",				0	},
	{	"set  0,c",				0	},
	{	"set  0,d",				0	},
	{	"set  0,e",				0	},
	{	"set  0,h",				0	},
	{	"set  0,l",				0	},
	{	"set  0,(hl)",			0	},
	{	"set  0,a",				0	},
	{	"set  1,b",				0	},
	{	"set  1,c",				0	},
	{	"set  1,d",				0	},
	{	"set  1,e",				0	},
	{	"set  1,h",				0	},
	{	"set  1,l",				0	},
	{	"set  1,(hl)",			0	},
	{	"set  1,a",				0	},
	{	"set  2,b",				0	},
	{	"set  2,c",				0	},
	{	"set  2,d",				0	},
	{	"set  2,e",				0	},
	{	"set  2,h",				0	},
	{	"set  2,l",				0	},
	{	"set  2,(hl)",			0	},
	{	"set  2,a",				0	},
	{	"set  3,b",				0	},
	{	"set  3,c",				0	},
	{	"set  3,d",				0	},
	{	"set  3,e",				0	},
	{	"set  3,h",				0	},
	{	"set  3,l",				0	},
	{	"set  3,(hl)",			0	},
	{	"set  3,a",				0	},
	{	"set  4,b",				0	},
	{	"set  4,c",				0	},
	{	"set  4,d",				0	},
	{	"set  4,e",				0	},
	{	"set  4,h",				0	},
	{	"set  4,l",				0	},
	{	"set  4,(hl)",			0	},
	{	"set  4,a",				0	},
	{	"set  5,b",				0	},
	{	"set  5,c",				0	},
	{	"set  5,d",				0	},
	{	"set  5,e",				0	},
	{	"set  5,h",				0	},
	{	"set  5,l",				0	},
	{	"set  5,(hl)",			0	},
	{	"set  5,a",				0	},
	{	"set  6,b",				0	},
	{	"set  6,c",				0	},
	{	"set  6,d",				0	},
	{	"set  6,e",				0	},
	{	"set  6,h",				0	},
	{	"set  6,l",				0	},
	{	"set  6,(hl)",			0	},
	{	"set  6,a",				0	},
	{	"set  7,b",				0	},
	{	"set  7,c",				0	},
	{	"set  7,d",				0	},
	{	"set  7,e",				0	},
	{	"set  7,h",				0	},
	{	"set  7,l",				0	},
	{	"set  7,(hl)",			0	},
	{	"set  7,a",				0	},
  },
  {
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"add	ix,bc",			0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"add  ix,de",			0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ld   ix,%02X%02X",	2	},
	{	"ld   (%02X%02X),ix",	2	},
	{	"inc  ix",				0	},
	{	"inc  iX",				0	},
	{	"dec  iX",				0	},
	{	"ld   iX,%02X",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"add  ix,ix",			0	},
	{	"ld   ix,(%02X%02X)",	2	},
	{	"dec  ix",				0	},
	{	"inc  ixl",				0	},
	{	"dec  ixl",				0	},
	{	"ld   ixl,%02X",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"inc  (ix+%02X)",		1	},
	{	"dec  (ix+%02X)",		1	},
	{	"ld   (ix+%02X),%02X",	2	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"add  ix,sp",			0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ld   b,iX",			0	},
	{	"ld   b,ixl",			0	},
	{	"ld   b,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ld   c,iX",			0	},
	{	"ld   c,ixl",			0	},
	{	"ld   c,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ld   d,iX",			0	},
	{	"ld   d,ixl",			0	},
	{	"ld   d,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ld   e,iX",			0	},
	{	"ld   e,iX",			0	},
	{	"ld   e,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	"ld   ixh,b",			0	},
	{	"ld   ixh,c",			0	},
	{	"ld   ixh,d",			0	},
	{	"ld   ixh,e",			0	},
	{	"ld   ixh,ixh",			0	},
	{	"ld   ixh,ixl",			0	},
	{	"ld   h,(ix+%02X)",		1	},
	{	"ld   ixh,a",			0	},
	{	"ld   ixl,b",			0	},
	{	"ld   ixl,c",			0	},
	{	"ld   ixl,d",			0	},
	{	"ld   ixl,e",			0	},
	{	"ld   ixl,ixh",			0	},
	{	"ld   ixl,ixh",			0	},
	{	"ld   l,(ix+%02X)",		1	},
	{	"ld   ixl,a",			0	},
	{	"ld   (ix+%02X),b",		1	},
	{	"ld   (ix+%02X),c",		1	},
	{	"ld   (ix+%02X),d",		1	},
	{	"ld   (ix+%02X),e",		1	},
	{	"ld   (ix+%02X),h",		1	},
	{	"ld   (ix+%02X),l",		1	},
	{	undefined,				0	},
	{	"ld   (ix+%02X),a",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ld   a,ixh",			0	},
	{	"ld   a,ixl",			0	},
	{	"ld   a,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"add  a,ixh",			0	},
	{	"add  a,ixl",			0	},
	{	"add  a,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"adc  a,ixh",			0	},
	{	"adc  a,ixl",			0	},
	{	"adc  a,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"sub  a,ixh",			0	},
	{	"sub  a,ixl",			0	},
	{	"sub  (ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"sbc  a,ixh",			0	},
	{	"sbc  a,ixl",			0	},
	{	"sbc  a,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"and  a,ixh",			0	},
	{	"and  a,ixl",			0	},
	{	"and  a,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"xor  a,ixh",			0	},
	{	"xor  a,ixl",			0	},
	{	"xor  a,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"or   a,ixh",			0	},
	{	"or   a,ixl",			0	},
	{	"or   a,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"cp   a,ixh",			0	},
	{	"cp   a,ixl",			0	},
	{	"cp   a,(ix+%02X)",		1	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	NULL,					3	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"pop  ix",				0	},
	{	undefined,				0	},
	{	"ex   (sp),ix",			0	},
	{	undefined,				0	},
	{	"push ix",				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"jp   (ix)",			0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ld   sp,ix",			0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
  },
  {
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"in   b,(c)",			0	},
	{	"out  (c),b",			0	},
	{	"sbc  hl,bc",			0	},
	{	"ld   (%02X%02X),bc",	2	},
	{	"neg",					0	},
	{	"retn",					0	},
	{	"im   0",				0	},
	{	"ld   i,a",				0	},
	{	"in   c,(c)",			0	},
	{	"out  (c),c",			0	},
	{	"adc  hl,bc",			0	},
	{	"ld   bc,(%02X%02X)",	2	},
	{	"neg",					0	},
	{	"reti",					0	},
	{	"im   0",				0	},
	{	"ld   r,a",				0	},
	{	"in   d,(c)",			0	},
	{	"out  (c),d",			0	},
	{	"sbc  hl,de",			0	},
	{	"ld   (%02X%02X),de",	2	},
	{	"neg",					0	},
	{	"retn",					0	},
	{	"im   1",				0	},
	{	"ld   a,i",				0	},
	{	"in   e,(c)",			0	},
	{	"out  (c),e",			0	},
	{	"adc  hl,de",			0	},
	{	"ld   de,(%02X%02X)",	2	},
	{	"neg",					0	},
	{	"retn",					0	},
	{	"im   2",				0	},
	{	"ld   a,r",				0	},
	{	"in   h,(c)",			0	},
	{	"out  (c),h",			0	},
	{	"sbc  hl,hl",			0	},
	{	"ld   (%02X%02X),hl",	0	},
	{	"neg",					0	},
	{	"retn",					0	},
	{	"im   0",				0	},
	{	"rrd",					0	},
	{	"in   l,(c)",			0	},
	{	"out  (c),l",			0	},
	{	"adc  hl,hl",			0	},
	{	"ld   hl,(%02X%02X)",	0	},
	{	"neg",					0	},
	{	"retn",					0	},
	{	"im   0",				0	},
	{	"rld",					0	},
	{	"in   f,(c)",			0	},
	{	"out  (c),0",			0	},
	{	"sbc  hl,sp",			0	},
	{	"ld   (%02X%02X),sp",	2	},
	{	"neg",					0	},
	{	"retn",					0	},
	{	"im   1",				0	},
	{	"nop",					0	},
	{	"in   a,(c)",			0	},
	{	"out  (c),a",			0	},
	{	"adc  hl,sp",			0	},
	{	"ld   sp,(%02X%02X)",	2	},
	{	"neg",					0	},
	{	"retn",					0	},
	{	"im   2",				0	},
	{	"nop",					0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ldi",					0	},
	{	"cpi",					0	},
	{	"ini",					0	},
	{	"outi",					0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ldd",					0	},
	{	"cpd",					0	},
	{	"ind",					0	},
	{	"outd",					0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"ldir",					0	},
	{	"cpir",					0	},
	{	"inir",					0	},
	{	"otir",					0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	"lddr",					0	},
	{	"cpdr",					0	},
	{	"indr",					0	},
	{	"otdr",					0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
	{	undefined,				0	},
  },
  {
	{	"rlc  (ix+%02X),b",		-2	},
	{	"rlc  (ix+%02X),c",		-2	},
	{	"rlc  (ix+%02X),d",		-2	},
	{	"rlc  (ix+%02X),e",		-2	},
	{	"rlc  (ix+%02X),h",		-2	},
	{	"rlc  (ix+%02X),l",		-2	},
	{	"rlc  (ix+%02X)",		-2	},
	{	"rlc  (ix+%02X),a",		-2	},
	{	"rrc  (ix+%02X),b",		-2	},
	{	"rrc  (ix+%02X),c",		-2	},
	{	"rrc  (ix+%02X),d",		-2	},
	{	"rrc  (ix+%02X),e",		-2	},
	{	"rrc  (ix+%02X),h",		-2	},
	{	"rrc  (ix+%02X),l",		-2	},
	{	"rrc  (ix+%02X)",		-2	},
	{	"rrc  (ix+%02X),a",		-2	},
	{	"rl   (ix+%02X),b",		-2	},
	{	"rl   (ix+%02X),c",		-2	},
	{	"rl   (ix+%02X),d",		-2	},
	{	"rl   (ix+%02X),e",		-2	},
	{	"rl   (ix+%02X),h",		-2	},
	{	"rl   (ix+%02X),l",		-2	},
	{	"rl   (ix+%02X)",		-2	},
	{	"rl   (ix+%02X),a",		-2	},
	{	"rr   (ix+%02X),b",		-2	},
	{	"rr   (ix+%02X),c",		-2	},
	{	"rr   (ix+%02X),d",		-2	},
	{	"rr   (ix+%02X),e",		-2	},
	{	"rr   (ix+%02X),h",		-2	},
	{	"rr   (ix+%02X),l",		-2	},
	{	"rr   (ix+%02X)",		-2	},
	{	"rr   (ix+%02X),a",		-2	},
	{	"sla  (ix+%02X),b",		-2	},
	{	"sla  (ix+%02X),c",		-2	},
	{	"sla  (ix+%02X),d",		-2	},
	{	"sla  (ix+%02X),e",		-2	},
	{	"sla  (ix+%02X),h",		-2	},
	{	"sla  (ix+%02X),l",		-2	},
	{	"sla  (ix+%02X)",		-2	},
	{	"sla  (ix+%02X),a",		-2	},
	{	"sra  (ix+%02X),b",		-2	},
	{	"sra  (ix+%02X),c",		-2	},
	{	"sra  (ix+%02X),d",		-2	},
	{	"sra  (ix+%02X),e",		-2	},
	{	"sra  (ix+%02X),h",		-2	},
	{	"sra  (ix+%02X),l",		-2	},
	{	"sra  (ix+%02X)",		-2	},
	{	"sra  (ix+%02X),a",		-2	},
	{	"slai (ix+%02X),b",		-2	},
	{	"slai (ix+%02X),c",		-2	},
	{	"slai (ix+%02X),d",		-2	},
	{	"slai (ix+%02X),e",		-2	},
	{	"slai (ix+%02X),h",		-2	},
	{	"slai (ix+%02X),l",		-2	},
	{	"slai (ix+%02X)",		-2	},
	{	"slai (ix+%02X),a",		-2	},
	{	"srl  (ix+%02X),b",		-2	},
	{	"srl  (ix+%02X),c",		-2	},
	{	"srl  (ix+%02X),d",		-2	},
	{	"srl  (ix+%02X),e",		-2	},
	{	"srl  (ix+%02X),h",		-2	},
	{	"srl  (ix+%02X),l",		-2	},
	{	"srl  (ix+%02X)",		-2	},
	{	"srl  (ix+%02X),a",		-2	},
	{	"bit  0,(ix+%02X)",		-2	},
	{	"bit  0,(ix+%02X)",		-2	},
	{	"bit  0,(ix+%02X)",		-2	},
	{	"bit  0,(ix+%02X)",		-2	},
	{	"bit  0,(ix+%02X)",		-2	},
	{	"bit  0,(ix+%02X)",		-2	},
	{	"bit  0,(ix+%02X)",		-2	},
	{	"bit  0,(ix+%02X)",		-2	},
	{	"bit  1,(ix+%02X)",		-2	},
	{	"bit  1,(ix+%02X)",		-2	},
	{	"bit  1,(ix+%02X)",		-2	},
	{	"bit  1,(ix+%02X)",		-2	},
	{	"bit  1,(ix+%02X)",		-2	},
	{	"bit  1,(ix+%02X)",		-2	},
	{	"bit  1,(ix+%02X)",		-2	},
	{	"bit  1,(ix+%02X)",		-2	},
	{	"bit  2,(ix+%02X)",		-2	},
	{	"bit  2,(ix+%02X)",		-2	},
	{	"bit  2,(ix+%02X)",		-2	},
	{	"bit  2,(ix+%02X)",		-2	},
	{	"bit  2,(ix+%02X)",		-2	},
	{	"bit  2,(ix+%02X)",		-2	},
	{	"bit  2,(ix+%02X)",		-2	},
	{	"bit  2,(ix+%02X)",		-2	},
	{	"bit  3,(ix+%02X)",		-2	},
	{	"bit  3,(ix+%02X)",		-2	},
	{	"bit  3,(ix+%02X)",		-2	},
	{	"bit  3,(ix+%02X)",		-2	},
	{	"bit  3,(ix+%02X)",		-2	},
	{	"bit  3,(ix+%02X)",		-2	},
	{	"bit  3,(ix+%02X)",		-2	},
	{	"bit  3,(ix+%02X)",		-2	},
	{	"bit  4,(ix+%02X)",		-2	},
	{	"bit  4,(ix+%02X)",		-2	},
	{	"bit  4,(ix+%02X)",		-2	},
	{	"bit  4,(ix+%02X)",		-2	},
	{	"bit  4,(ix+%02X)",		-2	},
	{	"bit  4,(ix+%02X)",		-2	},
	{	"bit  4,(ix+%02X)",		-2	},
	{	"bit  4,(ix+%02X)",		-2	},
	{	"bit  5,(ix+%02X)",		-2	},
	{	"bit  5,(ix+%02X)",		-2	},
	{	"bit  5,(ix+%02X)",		-2	},
	{	"bit  5,(ix+%02X)",		-2	},
	{	"bit  5,(ix+%02X)",		-2	},
	{	"bit  5,(ix+%02X)",		-2	},
	{	"bit  5,(ix+%02X)",		-2	},
	{	"bit  5,(ix+%02X)",		-2	},
	{	"bit  6,(ix+%02X)",		-2	},
	{	"bit  6,(ix+%02X)",		-2	},
	{	"bit  6,(ix+%02X)",		-2	},
	{	"bit  6,(ix+%02X)",		-2	},
	{	"bit  6,(ix+%02X)",		-2	},
	{	"bit  6,(ix+%02X)",		-2	},
	{	"bit  6,(ix+%02X)",		-2	},
	{	"bit  6,(ix+%02X)",		-2	},
	{	"bit  7,(ix+%02X)",		-2	},
	{	"bit  7,(ix+%02X)",		-2	},
	{	"bit  7,(ix+%02X)",		-2	},
	{	"bit  7,(ix+%02X)",		-2	},
	{	"bit  7,(ix+%02X)",		-2	},
	{	"bit  7,(ix+%02X)",		-2	},
	{	"bit  7,(ix+%02X)",		-2	},
	{	"bit  7,(ix+%02X)",		-2	},
	{	"res  0,(ix+%02X),b",	-2	},
	{	"res  0,(ix+%02X),c",	-2	},
	{	"res  0,(ix+%02X),d",	-2	},
	{	"res  0,(ix+%02X),e",	-2	},
	{	"res  0,(ix+%02X),h",	-2	},
	{	"res  0,(ix+%02X),l",	-2	},
	{	"res  0,(ix+%02X)",		-2	},
	{	"res  0,(ix+%02X),a",	-2	},
	{	"res  1,(ix+%02X),b",	-2	},
	{	"res  1,(ix+%02X),c",	-2	},
	{	"res  1,(ix+%02X),d",	-2	},
	{	"res  1,(ix+%02X),e",	-2	},
	{	"res  1,(ix+%02X),h",	-2	},
	{	"res  1,(ix+%02X),l",	-2	},
	{	"res  1,(ix+%02X)",		-2	},
	{	"res  1,(ix+%02X),a",	-2	},
	{	"res  2,(ix+%02X),b",	-2	},
	{	"res  2,(ix+%02X),c",	-2	},
	{	"res  2,(ix+%02X),d",	-2	},
	{	"res  2,(ix+%02X),e",	-2	},
	{	"res  2,(ix+%02X),h",	-2	},
	{	"res  2,(ix+%02X),l",	-2	},
	{	"res  2,(ix+%02X)",		-2	},
	{	"res  2,(ix+%02X),a",	-2	},
	{	"res  3,(ix+%02X),b",	-2	},
	{	"res  3,(ix+%02X),c",	-2	},
	{	"res  3,(ix+%02X),d",	-2	},
	{	"res  3,(ix+%02X),e",	-2	},
	{	"res  3,(ix+%02X),h",	-2	},
	{	"res  3,(ix+%02X),l",	-2	},
	{	"res  3,(ix+%02X)",		-2	},
	{	"res  3,(ix+%02X),a",	-2	},
	{	"res  4,(ix+%02X),b",	-2	},
	{	"res  4,(ix+%02X),c",	-2	},
	{	"res  4,(ix+%02X),d",	-2	},
	{	"res  4,(ix+%02X),e",	-2	},
	{	"res  4,(ix+%02X),h",	-2	},
	{	"res  4,(ix+%02X),l",	-2	},
	{	"res  4,(ix+%02X)",		-2	},
	{	"res  4,(ix+%02X),a",	-2	},
	{	"res  5,(ix+%02X),b",	-2	},
	{	"res  5,(ix+%02X),c",	-2	},
	{	"res  5,(ix+%02X),d",	-2	},
	{	"res  5,(ix+%02X),e",	-2	},
	{	"res  5,(ix+%02X),h",	-2	},
	{	"res  5,(ix+%02X),l",	-2	},
	{	"res  5,(ix+%02X)",		-2	},
	{	"res  5,(ix+%02X),a",	-2	},
	{	"res  6,(ix+%02X),b",	-2	},
	{	"res  6,(ix+%02X),c",	-2	},
	{	"res  6,(ix+%02X),d",	-2	},
	{	"res  6,(ix+%02X),e",	-2	},
	{	"res  6,(ix+%02X),h",	-2	},
	{	"res  6,(ix+%02X),l",	-2	},
	{	"res  6,(ix+%02X)",		-2	},
	{	"res  6,(ix+%02X),a",	-2	},
	{	"res  7,(ix+%02X),b",	-2	},
	{	"res  7,(ix+%02X),c",	-2	},
	{	"res  7,(ix+%02X),d",	-2	},
	{	"res  7,(ix+%02X),e",	-2	},
	{	"res  7,(ix+%02X),h",	-2	},
	{	"res  7,(ix+%02X),l",	-2	},
	{	"res  7,(ix+%02X)",		-2	},
	{	"res  7,(ix+%02X),a",	-2	},
	{	"set  0,(ix+%02X),b",	-2	},
	{	"set  0,(ix+%02X),c",	-2	},
	{	"set  0,(ix+%02X),d",	-2	},
	{	"set  0,(ix+%02X),e",	-2	},
	{	"set  0,(ix+%02X),h",	-2	},
	{	"set  0,(ix+%02X),l",	-2	},
	{	"set  0,(ix+%02X)",		-2	},
	{	"set  0,(ix+%02X),a",	-2	},
	{	"set  1,(ix+%02X),b",	-2	},
	{	"set  1,(ix+%02X),c",	-2	},
	{	"set  1,(ix+%02X),d",	-2	},
	{	"set  1,(ix+%02X),e",	-2	},
	{	"set  1,(ix+%02X),h",	-2	},
	{	"set  1,(ix+%02X),l",	-2	},
	{	"set  1,(ix+%02X)",		-2	},
	{	"set  1,(ix+%02X),a",	-2	},
	{	"set  2,(ix+%02X),b",	-2	},
	{	"set  2,(ix+%02X),c",	-2	},
	{	"set  2,(ix+%02X),d",	-2	},
	{	"set  2,(ix+%02X),e",	-2	},
	{	"set  2,(ix+%02X),h",	-2	},
	{	"set  2,(ix+%02X),l",	-2	},
	{	"set  2,(ix+%02X)",		-2	},
	{	"set  2,(ix+%02X),a",	-2	},
	{	"set  3,(ix+%02X),b",	-2	},
	{	"set  3,(ix+%02X),c",	-2	},
	{	"set  3,(ix+%02X),d",	-2	},
	{	"set  3,(ix+%02X),e",	-2	},
	{	"set  3,(ix+%02X),h",	-2	},
	{	"set  3,(ix+%02X),l",	-2	},
	{	"set  3,(ix+%02X)"	,	-2	},
	{	"set  3,(ix+%02X),a",	-2	},
	{	"set  4,(ix+%02X),b",	-2	},
	{	"set  4,(ix+%02X),c",	-2	},
	{	"set  4,(ix+%02X),d",	-2	},
	{	"set  4,(ix+%02X),e",	-2	},
	{	"set  4,(ix+%02X),h",	-2	},
	{	"set  4,(ix+%02X),l",	-2	},
	{	"set  4,(ix+%02X)",		-2	},
	{	"set  4,(ix+%02X),a",	-2	},
	{	"set  5,(ix+%02X),b",	-2	},
	{	"set  5,(ix+%02X),c",	-2	},
	{	"set  5,(ix+%02X),d",	-2	},
	{	"set  5,(ix+%02X),e",	-2	},
	{	"set  5,(ix+%02X),h",	-2	},
	{	"set  5,(ix+%02X),l",	-2	},
	{	"set  5,(ix+%02X)",		-2	},
	{	"set  5,(ix+%02X),a",	-2	},
	{	"set  6,(ix+%02X),b",	-2	},
	{	"set  6,(ix+%02X),c",	-2	},
	{	"set  6,(ix+%02X),d",	-2	},
	{	"set  6,(ix+%02X),e",	-2	},
	{	"set  6,(ix+%02X),h",	-2	},
	{	"set  6,(ix+%02X),l",	-2	},
	{	"set  6,(ix+%02X)",		-2	},
	{	"set  6,(ix+%02X),a",	-2	},
	{	"set  7,(ix+%02X),b",	-2	},
	{	"set  7,(ix+%02X),c",	-2	},
	{	"set  7,(ix+%02X),d",	-2	},
	{	"set  7,(ix+%02X),e",	-2	},
	{	"set  7,(ix+%02X),h",	-2	},
	{	"set  7,(ix+%02X),l",	-2	},
	{	"set  7,(ix+%02X)",		-2	},
	{	"set  7,(ix+%02X),a",	-2	},
  },
};

uns16
Disassemble(char *str, uns16 pc)
{
	int firstByte, i, j;
	struct opcode *code;
	firstByte = i = RD_BYTE(pc++);
	if (!major[i].name)
	{
		j = major[i].args;
		i = RD_BYTE(pc++);
		if (!minor[j][i].name)
		{
			j = minor[j][i].args;
			i = RD_BYTE(pc + 1);
		}
		code = &minor[j][i];
	}
	else
	{
		code = &major[i];
	}
	switch (code->args)
	{
		case 2:
			(void)sprintf(str, code->name, RD_BYTE(pc + 1), RD_BYTE(pc));
			pc += 2;
			break;
		case 1:
			(void)sprintf(str, code->name, RD_BYTE(pc));
			pc += 1;
			break;
		case 0:
			(void)sprintf(str, code->name);
			break;
		case -1:
			(void)sprintf(str, code->name,
						  (pc + 1 + (sgn8)RD_BYTE(pc)) & 0xffff);
			pc += 1;
			break;
		case -2:
			(void)sprintf(str, code->name, RD_BYTE(pc));
			pc += 2;
			break;
	}
	if (firstByte == 0xfd)
	{
		while ((str = strchr(str, 'x')) != 0)
		{
			*str++ = 'y';
		}
	}
	return pc;
}

