/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995, 1996, 1997
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU, DNH
 *******************************************************************************/
#ifndef lint
static char pcspkr_c[] = "$Id: pcspkr.c,v 3.7 1997/09/07 11:56:48 erik Rel $";
#endif

#include <unistd.h>
#include <asm/io.h>
#include "z80.h"
#include "io.h"
#include "util.h"
#include "pcspkr.h"



int SpActive = False;
int SpOn = False;


int
SpeakerInit(int audioOn)
{

	if (ioperm(0x61, 1, 1))
	{
		Msg(M_PERR, "couldn't get permission for the speaker port");
		return -1;
	}
	setgid(getgid());
	setuid(getuid());
	SpActive = True;
	SpOn = True;
	if (!audioOn)
	{
		SpeakerOnOff();
	}
	return 0;
}

void
SpeakerOnOff(void)
{
	if (SpActive)
	{
		SpOn = !SpOn;
	}
}

void
SpeakerOutByte(uns8 oldval, uns8 newval)
{
	if (SpActive && SpOn && ((newval ^ oldval) & B_SPEAKER))
	{
		if (newval & B_SPEAKER)
		{
			outb(inb(0x61) | 0x02, 0x61);
		}
		else
		{
			outb(inb(0x61) & 0xfc, 0x61);
		}
	}
}

