;;============================================================================
;;
;;    SSSS    tt          lll  lll              
;;   SS  SS   tt           ll   ll                
;;   SS     tttttt  eeee   ll   ll   aaaa    "An Atari 2600 VCS Emulator"
;;    SSSS    tt   ee  ee  ll   ll      aa      
;;       SS   tt   eeeeee  ll   ll   aaaaa   Copyright (c) 1995,1996,1997
;;   SS  SS   tt   ee      ll   ll  aa  aa         Bradford W. Mott
;;    SSSS     ttt  eeeee llll llll  aaaaa    
;;
;;============================================================================
;;
;; Stella's "dummy" Supercharger ROM routines
;;
;; @author  Bradford W. Mott
;; @version $Id: rom.asm,v 1.1 1997/05/17 19:07:26 bwmott Exp $
;;
;;============================================================================

        processor 6502

        org $FA00      

;;
;; Normal clear page zero routine for initial program load
;;
        LDA #0
        LDX #0
clear   STA $80,X
        INX
        CPX #$80
        BNE clear
        JMP cpcode

;;
;; Clear page zero routine for multi-load
;;
        org $FA20

        LDA #0
        LDX #0
mlclr   STA $80,X
        INX
        CPX #$1E
        BNE mlclr

;;
;; Now, copy some code into page zero to do the initial bank switch
;;

cpcode  LDX #0
copy    LDA code,X
        STA $f7,X
        INX
        CPX #9
        BNE copy

;;
;; Initialize X and Y registers
;;
        LDX #$ff
        LDY #$00

;;
;; Store the bank configuration in $80 and in CMP instruction
;;
        LDA #$00    ;; $00 is changed by emulator to the correct value
        STA $80
        STA $f8

;;
;; Execute the code to do bank switch and start running cartridge code
;;
        JMP $f7

;; This is not correct the CMP $f0?? shouldn't be in page zero.
;; Where should it be?
code    dc.b $cd, $00, $f0    ;; CMP $f0?? 
        dc.b $ad, $f8, $ff    ;; LDA $fff8
        dc.b $4c, $00, $00    ;; JMP $???? ($???? is filled in by emulator)

