/* This file Copyright 1992 by Clifford A. Adams */
/* scorefile.h
 *
 */

#define DEFAULT_SCOREDIR "%p/scores"

typedef struct sf_entry {
    int head_type;	/* header # (see head.h) */
    int score;		/* score change */
    char *str1;		/* first string part */
    char *str2;		/* second string part */
    COMPEX *compex;	/* regular expression ptr */
    char flags;		/* to be used later */
} SF_ENTRY;
/* note that negative header #s are used to indicate special entries... */

EXT int sf_num_entries INIT(0);	/* # of entries */
EXT SF_ENTRY *sf_entries;	/* array of entries */

#ifdef SCOREFILE_CACHE
/* for cached score rules */
typedef struct sf_file {
    char *fname;
    int num_lines;
    int num_alloc;
    long line_on;
    char **lines;
} SF_FILE;

EXT SF_FILE *sf_files INIT((SF_FILE*)NULL);
EXT int sf_num_files INIT(0);
#endif

EXT char **sf_abbr;		/* abbreviations */

/* when true, the scoring routine prints lots of info... */
EXT int sf_score_verbose INIT(FALSE);

EXT bool sf_verbose INIT(TRUE);  /* if true print more stuff while loading */

/* if TRUE, only header types that are cached are scored... */
EXT bool cached_rescore INIT(FALSE);

/* if TRUE, newauthor is active */
EXT bool newauthor_active INIT(FALSE);
/* bonus score given to a new (unscored) author */
EXT int newauthor INIT(0);

/* should we match by pattern? */
EXT int sf_pattern_status INIT(FALSE);

void	sf_init		_((void));
int	sf_score	_((ART_NUM));
void	sf_grow		_((void));
void	sf_clean	_((void));

void	sf_do_file	_((char *));
void	sf_exclude_file	_((char *));
void	sf_append	_((char *));
char	*sf_get_line	_((ART_NUM,int));
char	*sf_get_filename _((int));
void	sf_print_match	_((int));
void	sf_edit_file	_((char *));
int	sf_open_file	_((char *));
