/************************************************************
 *                                                          *
 *  Permission is hereby granted  to  any  individual   or  *
 *  institution   for  use,  copying, or redistribution of  *
 *  the xgobi code and associated documentation,  provided  *
 *  that   such  code  and documentation are not sold  for  *
 *  profit and the  following copyright notice is retained  *
 *  in the code and documentation:                          *
 *        Copyright (c) 1990, ..., 1996 Bellcore            *
 *                                                          *
 *  We welcome your questions and comments, and request     *
 *  that you share any modifications with us.               *
 *                                                          *
 *    Deborah F. Swayne            Dianne Cook              *
 *   dfs@research.att.com       dicook@iastate.edu          *
 *      (973) 360-8423    www.public.iastate.edu/~dicook/   *
 *                                                          *
 *                    Andreas Buja                          *
 *                andreas@research.att.com                  *
 *              www.research.att.com/~andreas/              *
 *                                                          *
 ************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "xincludes.h"
#include "xgobitypes.h"
#include "xgobivars.h"
#include "xgobiexterns.h"
#include <X11/Xatom.h>
#include <X11/Xproto.h>

#include "../bitmaps/leftarrow.xbm"
#include "../bitmaps/rightarrow.xbm"
#include "../bitmaps/uparrow.xbm"
#include "../bitmaps/downarrow.xbm"
#include "../bitmaps/plus.xbm"
#include "../bitmaps/minus.xbm"
#include "../bitmaps/lrarrow.xbm"

static Widget form1, main_panel;

#ifdef XPLORE
#define NFILEBTNS 7 /* xplore */
#else
#define NFILEBTNS 5
#endif

static Widget file_menu_cmd, file_menu, file_menu_btn[NFILEBTNS];
#define EXIT       file_menu_btn[NFILEBTNS-1]
#define NVIEWBTNS 10
static Widget view_menu_cmd, view_menu, view_menu_btn[NVIEWBTNS];
static char *view_menu_labelname[] = {
  "View: DotPlot",
  "View: XYPlot",
  "View: Rotate",
  "View: GrTour",
  "View: CoTour",
  "View: Scale",
  "View: Brush",
  "View: Ident",
  "View: LineEd",
  "View: MovePts",
};

#ifdef XPLORE
#define NTOOLBTNS 11 /* xplore */
#else
#define NTOOLBTNS 9
#endif

Widget tool_menu_cmd, tool_menu, tool_menu_btn[NTOOLBTNS];
#define CLONE_BTN     0
#define SMOOTH_BTN    1
#define SUBSET_BTN    2
#define JITTER_BTN    3
#define PARCOORD_BTN  4
#define VARLIST_BTN   5
#define CASELIST_BTN  6

#ifdef XPLORE
#define XPLORE_BTN           7 /* xplore */
#define XPLORE_END_BTN       8 /* xplore */
#define LAUNCH_MISSING_BTN   9 /* missing */
#define IMPUTE_BTN    10       /* missing */
#else
#define LAUNCH_MISSING_BTN   7
#define IMPUTE_BTN    8
#endif

#define NDISPLAYBTNS 6
static Widget display_menu_cmd, display_menu, display_menu_btn[NDISPLAYBTNS];
#define ADDAXES        0
#define CENTERAXES     1
#define SHOWPOINTS     2
#define SHOWLINES      3
#define SHOWARROWS     4
#define CARRYVARS      5

void
init_options(xg)
  xgobidata *xg;
{
  /* These are now on the brush panel */
  xg->link_glyph_brushing =   appdata.linkGlyphBrush;
  xg->link_color_brushing =   appdata.linkColorBrush;
  xg->link_erase_brushing =   appdata.linkEraseBrush;
  xg->link_line_brushing =    appdata.linkLineBrush;
  xg->jump_brush =            appdata.jumpBrush;
  xg->reshape_brush =         appdata.reshapeBrush;
  xg->sync_brush =            appdata.syncBrush;

  /* This is now on the identify panel */
  xg->link_identify =         appdata.linkIdentify;

  xg->is_axes =               appdata.showAxes;
  xg->is_axes_centered =      True;
  xg->plot_the_points =       appdata.showPoints;
  xg->plot_the_arrows =       False;
  xg->connect_the_points =    appdata.showLines;
  xg->carry_vars =            appdata.carryVars;

  /* For cloning */
  xg->isCloned =              appdata.isCloned;
  xg->clone_PID =             appdata.clonePID;
  xg->clone_Time =            appdata.cloneTime;
  xg->clone_Type =            (enum clone_data_type) appdata.cloneType;
  xg->clone_Name =            appdata.cloneName;
  xg->delete_clone_data =     appdata.deleteCloneData;
}

void
set_mono(w)
  Widget w;
{
  XtVaSetValues(w,
    XtNforeground, appdata.fg,
    XtNbackground, appdata.bg,
    XtNborderColor, appdata.fg,
    NULL);
}

void
set_Edit_Lines_cmd(xg, lgl)
  xgobidata *xg;
  Boolean lgl;
{
  XtVaSetValues(view_menu_btn[LINEEDIT_MODE],
    XtNsensitive, (Boolean) lgl,
    NULL);
}

void
set_Smooth_cmd(xg, lgl)
  xgobidata *xg;
  Boolean lgl;
{
  XtVaSetValues(tool_menu_btn[SMOOTH_BTN],
    XtNsensitive, (Boolean) lgl,
    NULL);
}
     
void
reset_Exit_cmd(xg)
  xgobidata *xg;
{
  XtVaSetValues(EXIT, XtNsensitive, (Boolean) False, NULL);
}

Widget
CreateCommand(xg, label, sensitive, href, vref, parent, helpLabel)
  xgobidata *xg;
  char *label, *helpLabel;
  Boolean sensitive;
  Widget href, vref;
  Widget parent;
{
  Widget pb;

  if (mono)
    pb = XtVaCreateWidget("Command",
      commandWidgetClass, parent,
      XtNlabel, (String) label,
      XtNsensitive, (Boolean) sensitive,
      XtNfromHoriz, (Widget) href,
      XtNfromVert, (Widget) vref,
      XtNforeground, appdata.fg,
      XtNbackground, appdata.bg,
      XtNborderColor, appdata.fg,
      NULL);
  else
    pb = XtVaCreateWidget("Command",
      commandWidgetClass, parent,
      XtNlabel, (String) label,
      XtNsensitive, (Boolean) sensitive,
      XtNfromHoriz, (Widget) href,
      XtNfromVert, (Widget) vref,
      NULL);

  add_pb_help(&xg->nhelpids.pb, pb, helpLabel);
  return(pb);
}

Widget
CreateToggle(xg, label, sensitive,
href, vref, radioref,
set, type, parent, helpLabel)
  xgobidata *xg;
  char *label, *helpLabel;
  Boolean sensitive, set;
  Widget href, vref, radioref;
  int type;
  Widget parent;
{
  Widget pb;
  char name[8];

  /*
   * Using the fallback resources, we force some
   * toggle widgets to follow "one of many" behavior
   * while others are permitted to be unselected.
  */
  if (type == ONE_OF_MANY)
    strcpy(name, "Toggle");
  else
    strcpy(name, "Command");

  if (mono)
    pb = XtVaCreateWidget(name,
      toggleWidgetClass, parent,
      XtNlabel, (String) label,
      XtNsensitive, (Boolean) sensitive,
      XtNfromHoriz, (Widget) href,
      XtNfromVert, (Widget) vref,
      XtNradioGroup, (Widget) radioref,
      XtNstate, (Boolean) set,
      XtNforeground, appdata.fg,
      XtNbackground, appdata.bg,
      XtNborderColor, appdata.fg,
      NULL);
  else
    pb = XtVaCreateWidget(name,
      toggleWidgetClass, parent,
      XtNlabel, (String) label,
      XtNsensitive, (Boolean) sensitive,
      XtNfromHoriz, (Widget) href,
      XtNfromVert, (Widget) vref,
      XtNradioGroup, (Widget) radioref,
      XtNstate, (Boolean) set,
      NULL);

  add_pb_help(&xg->nhelpids.pb, pb, helpLabel);
  return(pb);
}

void
build_labelled_menu(box, labelw, labelstr, cmd, menu, btn, btnlabel, nbtns,
initval, parent, vref, xg)
  Widget *box, *labelw, *cmd, *menu, *btn;
  char *labelstr;
  char **btnlabel;
  int nbtns, initval;
  Widget parent, vref;
  xgobidata *xg;
{

  Dimension width = 0, maxwidth = 0;
  int longest = 0;
  int k;

  *box = XtVaCreateManagedWidget("Panel",
    boxWidgetClass, parent,
    XtNorientation, (XtOrientation) XtorientHorizontal,
    XtNfromVert, vref,
    NULL);
  if (mono) set_mono(*box);

  /* Find the widest label */
  *labelw = XtVaCreateManagedWidget("Label",
    labelWidgetClass, *box,
    XtNlabel, labelstr,
    NULL);
  if (mono) set_mono(*labelw);

  for (k=0; k<nbtns; k++)
  {
    width =
      XTextWidth(appdata.font, btnlabel[k],
        strlen(btnlabel[k]) + 2*ASCII_TEXT_BORDER_WIDTH);
    if (width > maxwidth)
    {
      maxwidth = width;
      longest = k;
    }
  }

  *cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, *box,
    XtNlabel, (String) btnlabel[longest],
    XtNmenuName, (String) "Menu",
    XtNfromHoriz, *labelw,
    XtNresize, False,
    NULL);
  if (mono) set_mono(*cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    *cmd, "CopyXGobi");

  *menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, *cmd,
    NULL);
  if (mono) set_mono(*menu);

  for (k=0; k<nbtns; k++) {
    btn[k] = XtVaCreateWidget("Command",
      smeBSBObjectClass, *menu,
      XtNlabel, btnlabel[k],
      NULL);
    if (mono) set_mono(btn[k]);
  }
  XtManageChildren(btn, (Cardinal) nbtns);

  XtVaSetValues(*cmd,
    XtNlabel, (String) btnlabel[initval],
    NULL);
}

Boolean
tour_on(xg)
  xgobidata *xg;
{
  return(xg->plot_mode == GTOUR_MODE);
}

void
set_showlines_option(lgl, xg)
  Boolean lgl;
  xgobidata *xg;
{
/*
 * This is needed because we're going to duplicate
 * this button on the line editing panel, and they
 * both need to show the same state, but we don't
 * want to call the callback twice.
*/
  XtVaSetValues(display_menu_btn[SHOWLINES], XtNstate, lgl, NULL);
  set_display_menu_marks(xg);
}

void
set_showarrows_option(lgl, xg)
  Boolean lgl;
  xgobidata *xg;
{
  XtVaSetValues(display_menu_btn[SHOWARROWS], XtNstate, lgl, NULL);
  set_display_menu_marks(xg);
}

void
turn_on_showlines_option(xg)
  xgobidata *xg;
{
/*
 * This is called when line editing is entered.
 * It sets xg->connect_the_points to True if it's False,
 * and calls the callback, and then makes certain the
 * toggle in the options menu is set to True.
*/
  if (!xg->connect_the_points) {
    XtCallCallbacks(display_menu_btn[SHOWLINES], XtNcallback, (XtPointer) xg);
    set_showlines_option(True, xg);
  }
}

void
make_plotwindow_mouse_labels(xg)
  xgobidata *xg;
{
  Arg args[4];

  XtSetArg(args[0], XtNfromVert, (Widget) xg->workspace);
  XtSetArg(args[1], XtNtop, (XtEdgeType) XtChainBottom);
  XtSetArg(args[2], XtNbottom, (XtEdgeType) XtChainBottom);

  XtSetArg(args[3], XtNlabel, "L or M: Move points ");
  xg->spin_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->spin_mouse);

  XtSetArg(args[3], XtNlabel, "L: Move pts, M: Shape pts ");
  xg->scale_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->scale_mouse);

  XtSetArg(args[3], XtNlabel, "Drag L: paint, M: shape ");
  xg->brush_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->brush_mouse);

  XtSetArg(args[3], XtNlabel, "L: Toggle sticky labels ");
  xg->identify_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->identify_mouse);

  XtSetArg(args[3], XtNlabel, "Drag L: Add line, M: Remove last ");
  xg->le_add_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->le_add_mouse);

  XtSetArg(args[3], XtNlabel, "L: Delete line, M: Put it back ");
  xg->le_delete_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->le_delete_mouse);

  XtSetArg(args[3], XtNlabel, "L: Move point ");
  xg->movepts_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->movepts_mouse);

  XtSetArg(args[3], XtNlabel, "L or M: Manipulate Variable ");
  xg->tour_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->tour_mouse);

  XtSetArg(args[3], XtNlabel, "L or M: Manipulate Variable ");
  xg->corr_mouse = XtCreateManagedWidget("MouseLabel",
    labelWidgetClass, xg->box1, args, 4);
  if (mono) set_mono(xg->corr_mouse);
}

void
make_plot_window(xg)
  xgobidata *xg;
/*
 * PlotWindow: the plot window
*/
{
  xg->workspace = XtVaCreateManagedWidget("PlotWindow",
    labelWidgetClass, xg->box1,
    XtNresizable, (Boolean) True,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNright, (XtEdgeType) XtRubber,
    XtNbottom, (XtEdgeType) XtChainBottom,
    /*XtNbottom, (XtEdgeType) XtRubber,*/
    /*XtNfromVert, (Widget) xg->scale_mouse,*/
    XtNlabel, (String) "",
    NULL);
  if (mono) set_mono(xg->workspace);
  add_pb_help(&xg->nhelpids.pb,
    xg->workspace, "PlotWindow");

  XtAddEventHandler(xg->workspace, ExposureMask,
    FALSE, (XtEventHandler) expose_cback, (XtPointer) xg);
  XtAddEventHandler(xg->workspace, StructureNotifyMask,
    FALSE, (XtEventHandler) resize_cback, (XtPointer) xg);
}

void
make_arrows(xg)
  xgobidata *xg;
{
  Drawable root_window = RootWindowOfScreen(XtScreen(xg->shell));

  /*
   * Define arrows.  (depth is a global variable)
  */
  leftarr = XCreatePixmapFromBitmapData(display, root_window,
    leftarrow_bits, leftarrow_width, leftarrow_height,
    appdata.fg, appdata.bg, depth);
  rightarr = XCreatePixmapFromBitmapData(display, root_window,
    rightarrow_bits, rightarrow_width, rightarrow_height,
    appdata.fg, appdata.bg, depth);
  uparr = XCreatePixmapFromBitmapData(display, root_window,
    uparrow_bits, uparrow_width, uparrow_height,
    appdata.fg, appdata.bg, depth);
  downarr = XCreatePixmapFromBitmapData(display, root_window,
    downarrow_bits, downarrow_width, downarrow_height,
    appdata.fg, appdata.bg, depth);
  plus = XCreatePixmapFromBitmapData(display, root_window,
    plus_bits, plus_width, plus_height,
    appdata.fg, appdata.bg, depth);
  minus =  XCreatePixmapFromBitmapData(display, root_window,
    minus_bits, minus_width, minus_height,
    appdata.fg, appdata.bg, depth);

  /* Used in the missing panel */
  lrarr = XCreatePixmapFromBitmapData(display, root_window,
    lrarrow_bits, lrarrow_width, lrarrow_height,
    appdata.fg, appdata.bg, depth);
}

void
reset_3d_cmds(xg)
  xgobidata *xg;
{
  Boolean sens = True;

  if (xg->ncols_used < 3)
    sens = False;

  XtVaSetValues(view_menu_btn[ROTATE_MODE],
    XtNsensitive, (Boolean) sens,
    NULL);
  XtVaSetValues(view_menu_btn[GTOUR_MODE],
    XtNsensitive, (Boolean) sens,
    NULL);
  XtVaSetValues(view_menu_btn[CTOUR_MODE],
    XtNsensitive, (Boolean) sens,
    NULL);
}

void
make_file_menu(xg, parent)
  xgobidata *xg;
  Widget parent;
{
  int j;

  static char *file_menu_names[] = {
    "Read ...",
    "Save (extend current file set) ...",
    "Save (create new file set) ...",
    "Print ...",

#ifdef XPLORE
    "XploRe (pass variables) ...",
    "XploRe (pass projection) ...",
#endif

    "Exit",
  };

  file_menu_cmd = XtVaCreateManagedWidget("Command",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "File",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(file_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    file_menu_cmd, "FileMenu");

  file_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, file_menu_cmd,
    NULL);
  if (mono) set_mono(file_menu);

  for (j=0; j<NFILEBTNS; j++)
  {
    file_menu_btn[j] = XtVaCreateWidget("Command",
      smeBSBObjectClass, file_menu,
      XtNlabel, (String) file_menu_names[j],
      NULL);
    if (mono) set_mono(file_menu_btn[j]);

#ifdef XPLORE
    /* Add a line after the 3rd and 5th entries */
    if (j == 3 || j == 5)
#else
    /* Add a line after the 3rd and 4th entries */
    if (j == 3 || j == 4)
#endif

      (void) XtVaCreateManagedWidget("Line",
          smeLineObjectClass, file_menu,
          NULL);
  }

#ifdef XPLORE
  /* Initially make the XploRe buttons insensitive. */
  XtVaSetValues(file_menu_btn[4],
     XtNsensitive, False,
     NULL);
  XtVaSetValues(file_menu_btn[5],
     XtNsensitive, False,
     NULL);
#endif

  XtManageChildren(file_menu_btn, NFILEBTNS);

  XtAddCallback(file_menu_btn[0], XtNcallback,
    (XtCallbackProc) open_import_xgobi_popup_cback, (XtPointer) xg);
  XtAddCallback(file_menu_btn[1], XtNcallback,
    (XtCallbackProc) open_extend_xgobi_popup_cback, (XtPointer) xg);
  XtAddCallback(file_menu_btn[2], XtNcallback,
    (XtCallbackProc) open_new_xgobi_popup_cback, (XtPointer) xg);
  XtAddCallback(file_menu_btn[3], XtNcallback,
    (XtCallbackProc) print_panel_cback, (XtPointer) xg);

#ifdef XPLORE
  XtAddCallback(file_menu_btn[4], XtNcallback,
    (XtCallbackProc) pass_data_xplore_cback, (XtPointer) xg);
  XtAddCallback(file_menu_btn[5], XtNcallback,
    (XtCallbackProc) pass_projection_xplore_cback, (XtPointer) xg);
#endif

/* I probably need a variable to handle this -- how do I
 * know whether I was called as a function or I'm running
 * as a standalone xgobi?
*/
/*
  if (parent)
    XtAddCallback(EXIT, XtNcallback,
      (XtCallbackProc) exit_panel_cback, (XtPointer) xg);
  else
*/
    XtAddCallback(EXIT, XtNcallback,
      (XtCallbackProc) exit_solo_cback, (XtPointer) xg);
}

void
reset_plot_mode(mode, xg)
  Cardinal mode;
  xgobidata *xg;
{
/*
 * Rotation and grand tour do not work when there are fewer
 * than three columns.
*/
  Boolean threeD = True;

  if (xg->ncols_used < 3)
    threeD = False;

  switch (mode) {
   case DOTPLOT_MODE:
    dotplot_on(xg);
    break;
   case XYPLOT_MODE:
    xyplot_on(xg);
    break;
   case ROTATE_MODE:
    if (threeD)
      rotate_on(xg);
    break;
   case GTOUR_MODE:
    if (threeD)
      grand_tour_on(xg);
    break;
   case CTOUR_MODE:
    if (threeD)
      corr_tour_on(xg);
    break;
   case SCALE_MODE:
    scaling_on(xg);
    break;
   case BRUSH_MODE:
    brush_on(xg);
    break;
   case IDENTIFY_MODE:
    identify_on(xg);
    break;
   case LINEEDIT_MODE:
    line_editor_on(xg);
    break;
   case MOVEPTS_MODE:
    move_points_on(xg);
    break;
  }
}

/* ARGSUSED */
XtCallbackProc
view_menu_cback(w, xg, callback_data)
/*
 * Set the xgobi mode for plots and interaction
*/
  Widget w;
  xgobidata *xg;
  caddr_t callback_data;
{
  int j;

  xg->prev_plot_mode = xg->plot_mode;
  for (j=0; j<NVIEWBTNS; j++)
  {
    if (view_menu_btn[j] == w)
    {
      xg->plot_mode = j;
      break;
    }
  }
  XtVaSetValues(view_menu_cmd,
    XtNlabel, (String) view_menu_labelname[xg->plot_mode],
    NULL);

  if (xg->plot_mode != xg->prev_plot_mode) {
    /* turn off previous mode */
    reset_plot_mode(xg->prev_plot_mode, xg);
    /* turn on new mode */
    reset_plot_mode(xg->plot_mode, xg);
  }
}

/*ARGSUSED*/
XtActionProc
SetPlotMode(w, event, params, nparams)
  Widget w;
  XEvent *event;
  String *params;
  Cardinal nparams;
{
  extern xgobidata xgobi;
  xgobidata *xg = &xgobi;
  int pmode;

  pmode = atoi(params[0]);
  if (pmode != xg->plot_mode) {
    xg->prev_plot_mode = xg->plot_mode;
    xg->plot_mode = pmode;

    /* turn off previous mode */
    reset_plot_mode(xg->prev_plot_mode, xg);
    /* turn on new mode */
    reset_plot_mode(xg->plot_mode, xg);
  }

  XtVaSetValues(view_menu_cmd,
    XtNlabel, (String) view_menu_labelname[xg->plot_mode],
    NULL);

}

void
make_view_menu(xg, parent)
  xgobidata *xg;
  Widget parent;
{
  int j, k;
  Dimension width, maxwidth;
  int longest = 0;

  static char *view_menu_accel[] = {
    "d", "x", "r", "g", "c", "s", "b", "i", "l", "m",
  };
  static char *view_menu_fullname[] = {
    "DotPlot",
    "XYPlot",
    "Rotation",
    "Grand Tour",
    "Correlation Tour",
    "Scale",
    "Brush",
    "Identify",
    "Line Editing",
    "Move Points",
  };
  char *accelerators;
  accelerators = XtMalloc(512 * sizeof(char));

  sprintf(accelerators,
    "<Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)\n\
     <Key>%s:SetPlotMode(%d)",
     view_menu_accel[DOTPLOT_MODE], DOTPLOT_MODE,
     view_menu_accel[XYPLOT_MODE], XYPLOT_MODE,
     view_menu_accel[ROTATE_MODE], ROTATE_MODE,
     view_menu_accel[GTOUR_MODE], GTOUR_MODE,
     view_menu_accel[CTOUR_MODE], CTOUR_MODE,
     view_menu_accel[SCALE_MODE], SCALE_MODE,
     view_menu_accel[BRUSH_MODE], BRUSH_MODE,
     view_menu_accel[IDENTIFY_MODE], IDENTIFY_MODE,
     view_menu_accel[LINEEDIT_MODE], LINEEDIT_MODE,
     view_menu_accel[MOVEPTS_MODE], MOVEPTS_MODE);

  maxwidth = 0;
  longest = k = 0;
  for (k=0; k<NVIEWBTNS; k++)
  {
    width = XTextWidth(appdata.font, view_menu_labelname[k],
        strlen(view_menu_labelname[k]) + 2*ASCII_TEXT_BORDER_WIDTH);
    if (width > maxwidth) {
      maxwidth = width;
      longest = k;
    }
  }

  xg->plot_mode = xg->prev_plot_mode = XYPLOT_MODE;
  view_menu_cmd = XtVaCreateManagedWidget("Command",
    menuButtonWidgetClass, parent,
    /* Create the widget using the longest label */
    XtNlabel, (String) view_menu_labelname[longest],
    XtNwidth, maxwidth,
    XtNresize, False,
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(view_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    view_menu_cmd, "ViewMenu");

  view_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, view_menu_cmd,
    XtNinput, True,
    XtNaccelerators, XtParseAcceleratorTable(accelerators),
    NULL);
  if (mono) set_mono(view_menu);

  for (j=0; j<NVIEWBTNS; j++) {
    view_menu_btn[j] = XtVaCreateWidget("Command",
      smeBSBObjectClass, view_menu,
      XtNlabel, (String) view_menu_fullname[j],
      NULL);
    if (mono) set_mono(view_menu_btn[j]);

    XtAddCallback(view_menu_btn[j], XtNcallback,
      (XtCallbackProc) view_menu_cback, (XtPointer) xg);

    /* Add a line after the 5th entry */
    if (j == 4)
      (void) XtVaCreateManagedWidget("Line",
          smeLineObjectClass, view_menu,
          NULL);
  }

  XtManageChildren(view_menu_btn, NVIEWBTNS);
/* Now reset the mode */
  XtVaSetValues(view_menu_cmd,
    XtNlabel, (String) view_menu_labelname[XYPLOT_MODE],
    NULL);

  XtInstallAccelerators(xg->form0, view_menu);

  XtFree((char *) accelerators);
}

void
set_display_menu_marks(xg)
  xgobidata *xg;
{
  if (xg->is_axes)
    XtVaSetValues(display_menu_btn[ADDAXES],
      XtNleftBitmap, (Pixmap) menu_mark,
      NULL);
  else
    XtVaSetValues(display_menu_btn[ADDAXES],
      XtNleftBitmap, (Pixmap) None,
      NULL);

  if (xg->is_axes_centered)
    XtVaSetValues(display_menu_btn[CENTERAXES],
      XtNleftBitmap, (Pixmap) menu_mark,
      NULL);
  else
    XtVaSetValues(display_menu_btn[CENTERAXES],
      XtNleftBitmap, (Pixmap) None,
      NULL);

  if (xg->plot_the_points)
    XtVaSetValues(display_menu_btn[SHOWPOINTS],
      XtNleftBitmap, (Pixmap) menu_mark,
      NULL);
  else
    XtVaSetValues(display_menu_btn[SHOWPOINTS],
      XtNleftBitmap, (Pixmap) None,
      NULL);

  if (xg->plot_the_arrows)
    XtVaSetValues(display_menu_btn[SHOWARROWS],
      XtNleftBitmap, (Pixmap) menu_mark,
      NULL);
  else
    XtVaSetValues(display_menu_btn[SHOWARROWS],
      XtNleftBitmap, (Pixmap) None,
      NULL);

  if (xg->connect_the_points)
    XtVaSetValues(display_menu_btn[SHOWLINES],
      XtNleftBitmap, (Pixmap) menu_mark,
      NULL);
  else
    XtVaSetValues(display_menu_btn[SHOWLINES],
      XtNleftBitmap, (Pixmap) None,
      NULL);

  if (xg->carry_vars)
    XtVaSetValues(display_menu_btn[CARRYVARS],
      XtNleftBitmap, (Pixmap) menu_mark,
      NULL);
  else
    XtVaSetValues(display_menu_btn[CARRYVARS],
      XtNleftBitmap, (Pixmap) None,
      NULL);
}

/* ARGSUSED */
static XtCallbackProc
display_menu_cback(w, xg, callback_data)
  Widget w;
  xgobidata *xg;
  XtPointer callback_data;
{
  int btn;

  for (btn=0; btn<NDISPLAYBTNS; btn++)
    if (display_menu_btn[btn] == w)
      break;

  switch (btn) {
    case ADDAXES :
      xg->is_axes = !xg->is_axes;
      plot_once(xg);
      break;
    case CENTERAXES :
      xg->is_axes_centered = !xg->is_axes_centered;
      plot_once(xg);
      break;
    case SHOWPOINTS :
      xg->plot_the_points = !xg->plot_the_points;
      plot_once(xg);
      break;
    case SHOWLINES :  /* undirected lines */
      xg->connect_the_points = !xg->connect_the_points;

      if (xg->connect_the_points)
        xg->plot_the_arrows = False;

      /*
       * Set this to 1 in case there are line colors.
      */
      xg->got_new_paint = True;
      plot_once(xg);
      break;

    case SHOWARROWS : /* directed lines */
      xg->plot_the_arrows = !xg->plot_the_arrows;

      if (xg->plot_the_arrows)
        xg->connect_the_points = False;

      xg->got_new_paint = True;
      plot_once(xg);
      break;
    case CARRYVARS :
      xg->carry_vars = !xg->carry_vars;
      break;
  }

  /*
   * Show/don't show all the lines. Make sure the duplicate
   * toggle on the line editor panel has the right value.
  */
  set_showlines(xg->connect_the_points || xg->plot_the_arrows);

  set_display_menu_marks(xg);
}


static void
make_display_menu(xg, parent)
  xgobidata *xg;
  Widget parent;
{
  int k;

  static char *display_menu_name[] = {
    "Add axes to plot",
    "Center axes in 3D+ modes",
    "Plot the points",
    "Show undirected lines",
    "Show directed lines",
    "Carry variables between views",
  };

  display_menu_cmd = XtVaCreateManagedWidget("Command",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "Display",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(display_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    display_menu_cmd, "DisplayOptions");

  display_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, display_menu_cmd,
    XtNinput, True,
    NULL);
  if (mono) set_mono(display_menu);

  for (k=0; k<NDISPLAYBTNS; k++)
  {
    display_menu_btn[k] = XtVaCreateWidget("Command",
      smeBSBObjectClass, display_menu,
      XtNleftMargin, (Dimension) 24,
      XtNleftBitmap, menu_mark,
      XtNlabel, (String) display_menu_name[k],
      NULL);
    if (mono) set_mono(display_menu_btn[k]);

    XtAddCallback(display_menu_btn[k], XtNcallback,
      (XtCallbackProc) display_menu_cback, (XtPointer) xg);

    /* Add a line after the 5th entry */
    if (k == 4)
      (void) XtVaCreateManagedWidget("Line",
          smeLineObjectClass, display_menu,
          NULL);
  }

  XtManageChildren(display_menu_btn, NDISPLAYBTNS);
}

void
turn_on_xyplotting(xg)
  xgobidata *xg;
{
  XtCallCallbacks(view_menu_btn[XYPLOT_MODE], XtNcallback, (XtPointer) xg);
}

void
turn_off_cprof_plotting(xg)
  xgobidata *xg;
{
  XtCallCallbacks(tool_menu_btn[PARCOORD_BTN], XtNcallback, (XtPointer) xg);
}

void
set_sens_missing_menu_btns(Boolean sens) {
  XtSetSensitive(tool_menu_btn[LAUNCH_MISSING_BTN], sens);
  XtSetSensitive(tool_menu_btn[IMPUTE_BTN], sens);
}

void
make_tool_menu(xg, parent)
  xgobidata *xg;
  Widget parent;
{
  int j;

static char *tool_menu_fullname[] = {
  "Clone XGobi",
  "Smooth ...",
  "Subset Data ...",
  "Jitter ...",
  "Parallel Coord Plot ...",
  "Variable List ...",
  "Case List ...",

#ifdef XPLORE
  "Start XploRe ...",
  "Stop XploRe ...",
#endif

  "Launch Missing Data XGobi ...",
  "Impute Missing Values ...",
};

  tool_menu_cmd = XtVaCreateManagedWidget("ToolMenuButton",
    menuButtonWidgetClass, parent,
    XtNlabel, (String) "Tools",
    XtNmenuName, (String) "Menu",
    NULL);
  if (mono) set_mono(tool_menu_cmd);
  add_menupb_help(&xg->nhelpids.menupb,
    tool_menu_cmd, "ToolMenu");

  tool_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, tool_menu_cmd,
    XtNinput, True,
    NULL);
  if (mono) set_mono(tool_menu);

  for (j=0; j<NTOOLBTNS; j++)
  {
    tool_menu_btn[j] = XtVaCreateWidget("Command",
      smeBSBObjectClass, tool_menu,
      XtNlabel, (String) tool_menu_fullname[j],
      NULL);
    if (mono) set_mono(tool_menu_btn[j]);

    /* Add some lines ... */

#ifdef XPLORE
    if (j == 8)
#else
    if (j == 6)
#endif

      (void) XtVaCreateManagedWidget("Line",
          smeLineObjectClass, tool_menu,
          NULL);
  }
  set_sens_missing_menu_btns(xg->missing_values_present);

/*
  if (!xg->missing_values_present) {
    XtSetSensitive(tool_menu_btn[LAUNCH_MISSING_BTN], False);
    XtSetSensitive(tool_menu_btn[IMPUTE_BTN], False);
  }
*/

  XtAddCallback(tool_menu_btn[CLONE_BTN], XtNcallback,
    (XtCallbackProc) clone_xgobi_cback, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[JITTER_BTN], XtNcallback,
    (XtCallbackProc) open_jitter_popup_cback, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[LAUNCH_MISSING_BTN], XtNcallback,
    (XtCallbackProc) launch_missing_cback, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[IMPUTE_BTN], XtNcallback,
    (XtCallbackProc) open_imputation_popup_cback, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[SMOOTH_BTN], XtNcallback,
    (XtCallbackProc) open_smooth_popup_cback, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[PARCOORD_BTN], XtNcallback,
    (XtCallbackProc) cprof_plot_cback, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[SUBSET_BTN], XtNcallback,
    (XtCallbackProc) subset_panel_cback, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[VARLIST_BTN], XtNcallback,
    (XtCallbackProc) PopupVarlist, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[CASELIST_BTN], XtNcallback,
    (XtCallbackProc) PopupCaselist, (XtPointer) xg);

#ifdef XPLORE
  XtAddCallback(tool_menu_btn[XPLORE_BTN], XtNcallback,
    (XtCallbackProc) start_xplore_cback, (XtPointer) xg);
  XtAddCallback(tool_menu_btn[XPLORE_END_BTN], XtNcallback,
    (XtCallbackProc) stop_xplore_cback, (XtPointer) xg);
#endif

  /*
   * If a .nlinkable file is used, then subsetting
   * is to be disabled.
  */
  XtVaSetValues(tool_menu_btn[SUBSET_BTN],
    XtNsensitive, (xg->nlinkable == xg->nrows),
    NULL);

#ifdef XPLORE
   XtVaSetValues(tool_menu_btn[XPLORE_END_BTN],
     XtNsensitive, False,
     NULL);
#endif

  /*
   * If there's no missing data, disable the 'missing' buttons.
   * Ditto if this is already the missing values xgobi.
  */
  if (!xg->missing_values_present || xg->is_missing_values_xgobi) {
    XtVaSetValues(tool_menu_btn[LAUNCH_MISSING_BTN],
      XtNsensitive, False,
      NULL);
    XtVaSetValues(tool_menu_btn[IMPUTE_BTN],
      XtNsensitive, False,
      NULL);
  }

  XtManageChildren(tool_menu_btn, NTOOLBTNS);
}

void active_xplore_buttons ()

{
#ifdef XPLORE

   XtVaSetValues(tool_menu_btn[XPLORE_BTN], /* Start XploRe */
     XtNsensitive, False,
     NULL);

   XtVaSetValues(tool_menu_btn[XPLORE_END_BTN], /* End XploRe */
     XtNsensitive, True,
     NULL);

   XtVaSetValues(file_menu_btn[4], /* XploRe (pass variables) */
     XtNsensitive, True,
     NULL);

   XtVaSetValues(file_menu_btn[5], /* XploRe (pass projection) */
     XtNsensitive, True,
     NULL);

#endif
}

void inactive_xplore_buttons ()

{
#ifdef XPLORE

   XtVaSetValues(tool_menu_btn[XPLORE_BTN], /* Start XploRe */
     XtNsensitive, True,
     NULL);

   XtVaSetValues(tool_menu_btn[XPLORE_END_BTN], /* End XploRe */
     XtNsensitive, False,
     NULL);

   XtVaSetValues(file_menu_btn[4], /* XploRe (pass variables) */
     XtNsensitive, False,
     NULL);

   XtVaSetValues(file_menu_btn[5], /* XploRe (pass projection) */
     XtNsensitive, False,
     NULL);

#endif
}

void
make_widgets(xg)
  xgobidata *xg;
{
  Widget info_menu_cmd, info_menu, info_menu_btn[2];

  xg->form0 = XtVaCreateManagedWidget("Form0",
    formWidgetClass, xg->shell,
    NULL);
  if (mono) set_mono(xg->form0);

/*
 * Define main_panel, the main control panel
*/
  main_panel = XtVaCreateManagedWidget("MainPanel",
    boxWidgetClass, xg->form0,
    XtNorientation, (XtOrientation) XtorientHorizontal,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainLeft,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtChainTop,
    NULL);
  if (mono) set_mono(main_panel);

  make_file_menu(xg, main_panel);
  make_view_menu(xg, main_panel);
  make_tool_menu(xg, main_panel);
  make_display_menu(xg, main_panel);

  info_menu_cmd = XtVaCreateManagedWidget("MenuButton",
    menuButtonWidgetClass, main_panel,
    XtNlabel, (String) "Info",
    XtNmenuName, (String) "Menu",
    /*XtNfromHoriz, IO,*/
    NULL);
  if (mono) set_mono(info_menu_cmd);

/* Build the info menu right here */
  info_menu = XtVaCreatePopupShell("Menu",
    simpleMenuWidgetClass, info_menu_cmd,
    NULL);
  info_menu_btn[0] = XtVaCreateManagedWidget("Command",
    smeBSBObjectClass, info_menu,
    XtNlabel, (String) "About XGobi ... ",
    NULL);
  XtAddCallback(info_menu_btn[0], XtNcallback,
    (XtCallbackProc) about_xgobi_cback, (XtPointer) xg);
  info_menu_btn[1] = XtVaCreateManagedWidget("Command",
    smeBSBObjectClass, info_menu,
    XtNlabel, (String) "About help ... ",
    NULL);
  XtAddCallback(info_menu_btn[1], XtNcallback,
    (XtCallbackProc) help_cback, (XtPointer) xg);
/* End of info menu */

/*
 * Paned widget to help users adjust the plot window and the
 * variable selection panel.
*/
  form1 = XtVaCreateManagedWidget("Form1",
    panedWidgetClass, xg->form0,
    XtNfromVert, (Widget) main_panel,
    XtNleft, (XtEdgeType) XtChainLeft,
    XtNright, (XtEdgeType) XtChainRight,
    XtNtop, (XtEdgeType) XtChainTop,
    XtNbottom, (XtEdgeType) XtRubber,
    XtNorientation, (XtOrientation) XtorientHorizontal,
    NULL);
  if (mono) set_mono(form1);

  xg->box0 = XtVaCreateManagedWidget("Box0",
    formWidgetClass, form1,
    XtNmin, 5,
    NULL);
  if (mono) set_mono(xg->box0);

  xg->box1 = XtVaCreateManagedWidget("Box1",
    formWidgetClass, form1,
    XtNmin, 5,
    NULL);
  if (mono) set_mono(xg->box1);

  xg->box2 = XtVaCreateManagedWidget("Box2",
    formWidgetClass, form1,
    XtNmin, 5,
    NULL);
  if (mono) set_mono(xg->box2);
}

#undef NDISPLAYBTNS
#undef NFILEBTNS
#undef NTOOLBTNS
