/*
 * Copyright(c) 1995,1996 by Gennady B. Sorokopud (gena@NetVision.net.il)
 *
 * This software can be freely redistributed and modified for 
 * non-commercial purposes as long as above copyright
 * message and this permission notice appear in all
 * copies of distributed source code and included as separate file
 * in binary distribution.
 *
 * Any commercial use of this software requires author's permission.
 *
 * This software is provided "as is" without expressed or implied
 * warranty of any kind.
 * Under no circumstances is the author responsible for the proper
 * functioning of this software, nor does the author assume any
 * responsibility for damages incurred with its use.
 *
 */

/* $Id: choose_folder.h,v 2.0 1997/09/23 15:54:45 gena Exp $
 */
#ifndef CHOOSE_FOLDER_H
#define CHOOSE_FOLDER_H

#include <fl_edit.h>
#include <dialogs.h>

extern struct _mail_folder *choose_folder();
extern struct _mail_folder *pup_choose_folder(FL_FORM *form);
extern struct _mail_folder *create_folder(char *name, int ftype);
extern struct _mail_folder *create_subfolder(struct _mail_folder *pfolder, char *name);
extern void about();
extern void help(int chapter);
typedef void (*addr_dbl_cb)(struct _mail_addr *addr, int type, int data);
#define TO_TYPE  1
#define CC_TYPE  2
#define BCC_TYPE 3
#define	NN_TYPE  4
extern struct _mail_addr *addr_book(int *addr_type, addr_dbl_cb callback, int data);
extern struct _mail_addr *find_alias(char *name);
extern struct _mail_addr *expand_addr_list(struct _mail_msg *msg, struct _mail_addr *addr);
extern void mailrc_import_aliases(char *fname);
extern void pine_import_aliases(char *fname);
extern int mod_addr(struct _mail_addr *oldadr, int *type);
extern int save_book();
extern int load_book(char *name);
extern struct _abook_entry * add_book(struct _mail_addr *new_addr , int ask);
extern int close_abook(FL_FORM *form, void *data);
extern void add_msg_addr(struct _mail_msg *msg);
extern void addr_book_set_placement(int x, int y);
extern void set_el_size();
extern void restore_fonts();
extern void restore_charsets();
extern void sign_edit();
extern void folder_conf(struct _mail_folder *folder);
extern void message_conf(struct _mail_msg *msg);
extern void rules_conf();
extern void search_msgs();
extern void log_win();
extern void log_close_fd();
extern void log_str();
extern struct _mime_msg *compose_attachment(struct _mime_msg *omime);
extern void PGP_Timer_Call(FL_OBJECT *obj, long param);
extern void load_signatures();
extern void keymap_conf();
extern int load_keymap();

/* init forms */

extern void choose_init();
extern void pop_account_init();
extern void search_init();
extern void inc_init();
extern void log_init();

#endif
