
/* png.h - header file for png reference library

   libpng 1.0 beta 4 - version 0.90
   January 10, 1997

   Note: This is a beta version.  It reads and writes valid files
   on the platforms I have, and has had a wide testing program.
   You may have to modify the includes below to get it to work on
   your system, and you may have to supply the correct compiler
   flags in the makefile, if you can't find a makefile suitable for
   your operating system/compiler combination.  Read the libpng.txt
   for more information, and how to contact the authors if you have any
   problems, or if you want your compiler/platform to be supported
   in the next official libpng release.

   See libpng.txt for more information.

   Copyright (c) 1995, 1996, 1997 Guy Eric Schalnat, Group 42, Inc.
   Contributing Authors:
      Sam Bushnell
      Andreas Dilger
      Dave Martindale
      Guy Eric Schalnat
      Paul Schmidt
      Tim Wegner

   The contributing authors would like to thank all those who helped
   with testing, bug fixes, and patience.  You know who you are.  This
   wouldn't have been possible without all of you.

   Thanks to Frank J. T. Wojcik for helping with the documentation

   The PNG Reference Library is supplied "AS IS". The Contributing Authors
   and Group 42, Inc. disclaim all warranties, expressed or implied,
   including, without limitation, the warranties of merchantability and of
   fitness for any purpose. The Contributing Authors and Group 42, Inc.
   assume no liability for direct, indirect, incidental, special, exemplary,
   or consequential damages, which may result from the use of the PNG
   Reference Library, even if advised of the possibility of such damage.

   Permission is hereby granted to use, copy, modify, and distribute this
   source code, or portions hereof, for any purpose, without fee, subject
   to the following restrictions:
   1. The origin of this source code must not be misrepresented.
   2. Altered versions must be plainly marked as such and must not be
      misrepresented as being the original source.
   3. This Copyright notice may not be removed or altered from any source or
      altered source distribution.

   The Contributing Authors and Group 42, Inc. specifically permit, without
   fee, and encourage the use of this source code as a component to
   supporting the PNG file format in commercial products. If you use this
   source code in a product, acknowledgment is not required but would be
   appreciated.
   */

#ifndef _PNG_H
#define _PNG_H

#ifdef __cplusplus
extern "C" {
#endif

/* This is not the place to learn how to use libpng.  The file libpng.txt
   describes how to use libpng, and the file example.c summarizes it
   with some code to build around.  This file is useful for looking
   at the actual function definitions and structure components. */

/* include the compression library's header */
#include "zlib.h"

/* include all user configurable info */
#include "pngconf.h"

/* This file is arranged in several sections.  The first section details
   the functions most users will use.  The third section describes the
   stub files that users will most likely need to change.  The last
   section contains functions used internally by the code.  */

/* version information for png.h - this should match the version
   number in png.c */
#define PNG_LIBPNG_VER_STRING "0.90"
/* careful here.  I wanted to use 090, but that would be octal.  Version
   1.0 will be 100 here, etc. */
#define PNG_LIBPNG_VER 90

/* variables defined in png.c - only it needs to define PNG_NO_EXTERN */
#ifndef PNG_NO_EXTERN
/* version information for c files, stored in png.c. This better match
   the version above. */
extern char png_libpng_ver[];
#endif

/* three color definitions.  The order of the red, green, and blue, (and the
   exact size) is not important, although the size of the fields need to
   be png_byte or png_uint_16 (as defined below).  */
typedef struct png_color_struct
{
   png_byte red;
   png_byte green;
   png_byte blue;
} png_color;
typedef png_color       FAR *    png_colorp;
typedef png_color       FAR * FAR * png_colorpp;

typedef struct png_color_16_struct
{
   png_byte index; /* used for palette files */
   png_uint_16 red; /* for use in red green blue files */
   png_uint_16 green;
   png_uint_16 blue;
   png_uint_16 gray; /* for use in grayscale files */
} png_color_16;
typedef png_color_16    FAR *    png_color_16p;
typedef png_color_16    FAR * FAR * png_color_16pp;

typedef struct png_color_8_struct
{
   png_byte red; /* for use in red green blue files */
   png_byte green;
   png_byte blue;
   png_byte gray; /* for use in grayscale files */
   png_byte alpha; /* for alpha channel files */
} png_color_8;
typedef png_color_8     FAR *    png_color_8p;
typedef png_color_8     FAR * FAR * png_color_8pp;

/* png_text holds the text in a png file, and whether they are compressed
   or not.  If compression is -1, the text is not compressed.  */
typedef struct png_text_struct
{
   int compression; /* compression value, -1 if uncompressed */
   png_charp key; /* keyword */
   png_charp text; /* comment */
   png_uint_32 text_length; /* length of text field */
} png_text;
typedef png_text        FAR *    png_textp;
typedef png_text        FAR * FAR * png_textpp;

/* png_time is a way to hold the time in an machine independent way.
   Two conversions are provided, both from time_t and struct tm.  There
   is no portable way to convert to either of these structures, as far
   as I know.  If you know of a portable way, send it to me. */
typedef struct png_time_struct
{
   png_uint_16 year; /* full year, as in, 1995 */
   png_byte month; /* month of year, 1 - 12 */
   png_byte day; /* day of month, 1 - 31 */
   png_byte hour; /* hour of day, 0 - 23 */
   png_byte minute; /* minute of hour, 0 - 59 */
   png_byte second; /* second of minute, 0 - 60 (for leap seconds) */
} png_time;
typedef png_time        FAR *    png_timep;
typedef png_time        FAR * FAR * png_timepp;

/* png_info is a structure that holds the information in a png file.
   If you are reading the file, This structure will tell you what is
   in the png file.  If you are writing the file, fill in the information
   you want to put into the png file, then call png_write_info().
   The names chosen should be very close to the PNG specification, so
   consult that document for information about the meaning of each field. */
typedef struct png_info_struct
{
   /* the following are necessary for every png file */
   png_uint_32 width; /* with of file */
   png_uint_32 height; /* height of file */
   png_uint_32 valid; /* the PNG_INFO_ defines, OR'd together */
   png_uint_32 rowbytes; /* bytes needed for untransformed row */
   png_colorp palette; /* palette of file */
   png_uint_16 num_palette; /* number of values in palette */
   png_uint_16 num_trans; /* number of trans values */
   png_byte bit_depth; /* 1, 2, 4, 8, or 16 */
   png_byte color_type; /* use the PNG_COLOR_TYPE_ defines */
   png_byte compression_type; /* must be 0 */
   png_byte filter_type; /* must be 0 */
   png_byte interlace_type; /* 0 for non-interlaced, 1 for interlaced */
   /* the following is informational only on read, and not used on
      writes */
   png_byte channels; /* number of channels of data per pixel */
   png_byte pixel_depth; /* number of bits per pixel */
   png_byte spare_byte;  /* To align the data, and for future use */
   png_byte signature[8]; /* Signature read from start of file */

   /* the rest are optional.  If you are reading, check the valid
      field to see if the information in these are valid.  If you
      are writing, set the valid field to those chunks you want
      written, and initialize the appropriate fields below */
#if defined(PNG_READ_gAMA_SUPPORTED) || defined(PNG_WRITE_gAMA_SUPPORTED)
   float gamma; /* gamma value of file, if gAMA chunk is valid */
#endif
#if defined(PNG_READ_tEXt_SUPPORTED) || defined(PNG_WRITE_tEXt_SUPPORTED) || \
    defined(PNG_READ_zTXt_SUPPORTED) || defined(PNG_WRITE_zTXt_SUPPORTED)
   int num_text; /* number of comments */
   int max_text; /* size of text array */
   png_textp text; /* array of comments */
#endif
#if defined(PNG_READ_tIME_SUPPORTED) || defined(PNG_WRITE_tIME_SUPPORTED)
   png_time mod_time; /* modification time */
#endif
#if defined(PNG_READ_sBIT_SUPPORTED) || defined(PNG_WRITE_sBIT_SUPPORTED)
   png_color_8 sig_bit; /* significant bits */
#endif
#if defined(PNG_READ_tRNS_SUPPORTED) || defined(PNG_WRITE_tRNS_SUPPORTED)
   png_bytep trans; /* tRNS values for palette image */
   png_color_16 trans_values; /* tRNS values for non-palette image */
#endif
#if defined(PNG_READ_bKGD_SUPPORTED) || defined(PNG_WRITE_bKGD_SUPPORTED)
   png_color_16 background; /* background color of image */
#endif
#if defined(PNG_READ_oFFs_SUPPORTED) || defined(PNG_WRITE_oFFs_SUPPORTED)
   png_uint_32 x_offset; /* x offset on page */
   png_uint_32 y_offset; /* y offset on page */
   png_byte offset_unit_type; /* offset units type */
#endif
#if defined(PNG_READ_pHYs_SUPPORTED) || defined(PNG_WRITE_pHYs_SUPPORTED)
   png_uint_32 x_pixels_per_unit; /* x resolution */
   png_uint_32 y_pixels_per_unit; /* y resolution */
   png_byte phys_unit_type; /* resolution type */
#endif
#if defined(PNG_READ_hIST_SUPPORTED) || defined(PNG_WRITE_hIST_SUPPORTED)
   png_uint_16p hist; /* histogram of palette usage */
#endif
#if defined(PNG_READ_cHRM_SUPPORTED) || defined(PNG_WRITE_cHRM_SUPPORTED)
   float x_white; /* cHRM chunk values */
   float y_white;
   float x_red;
   float y_red;
   float x_green;
   float y_green;
   float x_blue;
   float y_blue;
#endif
} png_info;
typedef png_info        FAR *    png_infop;
typedef png_info        FAR * FAR * png_infopp;

#define PNG_RESOLUTION_UNKNOWN 0
#define PNG_RESOLUTION_METER   1
#define PNG_RESOLUTION_LAST    2

#define PNG_OFFSET_PIXEL       0
#define PNG_OFFSET_MICROMETER  1
#define PNG_OFFSET_LAST        2

/* these describe the color_type field in png_info */

/* color type masks */
#define PNG_COLOR_MASK_PALETTE 1
#define PNG_COLOR_MASK_COLOR   2
#define PNG_COLOR_MASK_ALPHA   4

/* color types.  Note that not all combinations are legal */
#define PNG_COLOR_TYPE_GRAY 0
#define PNG_COLOR_TYPE_PALETTE \
   (PNG_COLOR_MASK_COLOR | PNG_COLOR_MASK_PALETTE)
#define PNG_COLOR_TYPE_RGB (PNG_COLOR_MASK_COLOR)
#define PNG_COLOR_TYPE_RGB_ALPHA \
   (PNG_COLOR_MASK_COLOR | PNG_COLOR_MASK_ALPHA)
#define PNG_COLOR_TYPE_GRAY_ALPHA (PNG_COLOR_MASK_ALPHA)

/* These determine if a chunks information is present in a read operation, or
   if the chunk should be written in a write operation.  */
#define PNG_INFO_gAMA 0x0001
#define PNG_INFO_sBIT 0x0002
#define PNG_INFO_cHRM 0x0004
#define PNG_INFO_PLTE 0x0008
#define PNG_INFO_tRNS 0x0010
#define PNG_INFO_bKGD 0x0020
#define PNG_INFO_hIST 0x0040
#define PNG_INFO_pHYs 0x0080
#define PNG_INFO_oFFs 0x0100
#define PNG_INFO_tIME 0x0200

/* this is used for the transformation routines, as some of them
   change these values for the row.  It also should enable using
   the routines for other uses. */
typedef struct png_row_info_struct
{
   png_uint_32 width; /* width of row */
   png_uint_32 rowbytes; /* number of bytes in row */
   png_byte color_type; /* color type of row */
   png_byte bit_depth; /* bit depth of row */
   png_byte channels; /* number of channels (1, 2, 3, or 4) */
   png_byte pixel_depth; /* bits per pixel (depth * channels) */
} png_row_info;

typedef png_row_info    FAR *    png_row_infop;
typedef png_row_info    FAR * FAR * png_row_infopp;

/* These are the function types for the I/O functions, and the functions which
 * modify the default I/O functions to user I/O functions.  The png_error_ptr
 * type should match that of user supplied warning and error functions, while
 * the png_rw_ptr type should match that of the user read/write data functions.
 */
typedef struct png_struct_def png_struct;
typedef png_struct FAR * png_structp;

typedef void (*png_error_ptr) PNGARG((png_structp, png_const_charp));
typedef void (*png_rw_ptr) PNGARG((png_structp, png_bytep, png_uint_32));
typedef void (*png_flush_ptr) PNGARG((png_structp));
#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
typedef void (*png_progressive_info_ptr) PNGARG((png_structp, png_infop));
typedef void (*png_progressive_end_ptr) PNGARG((png_structp, png_infop));
typedef void (*png_progressive_row_ptr) PNGARG((png_structp, png_bytep,
   png_uint_32, int));
#endif

/* The structure that holds the information to read and write png files.
   The only people who need to care about what is inside of this are the
   people who will be modifying the library for their own special needs.
   */

struct png_struct_def
{
   jmp_buf jmpbuf; /* used in png_error */

   png_error_ptr error_fn;    /* Function for printing errors and aborting */
   png_error_ptr warning_fn;  /* Function for printing warnings */
   png_voidp error_ptr;       /* user supplied struct for error functions */
   png_rw_ptr write_data_fn;  /* Function for writing output data */
   png_rw_ptr read_data_fn;   /* Function for reading input data */
   png_voidp io_ptr;  /* Pointer to user supplied struct for I/O functions */

   png_uint_32 mode; /* used to determine where we are in the png file */
   png_uint_32 flags;  /* flags indicating various things to libpng */
   png_uint_32 transformations; /* which transformations to perform */

   z_stream zstream; /* pointer to decompression structure (below) */
   png_bytep zbuf; /* buffer for zlib */
   png_uint_32 zbuf_size; /* size of zbuf */
   int zlib_level; /* holds zlib compression level */
   int zlib_method; /* holds zlib compression method */
   int zlib_window_bits; /* holds zlib compression window bits */
   int zlib_mem_level; /* holds zlib compression memory level */
   int zlib_strategy; /* holds zlib compression strategy */

   png_uint_32 width; /* width of file */
   png_uint_32 height; /* height of file */
   png_uint_32 num_rows; /* number of rows in current pass */
   png_uint_32 rowbytes; /* size of row in bytes */
   png_uint_32 usr_width; /* width of row at start of write */
   png_uint_32 iwidth; /* interlaced width */
   png_uint_32 irowbytes; /* interlaced rowbytes */
   png_uint_32 row_number; /* current row in pass */
   png_bytep prev_row; /* place to save previous (unfiltered) row */
   png_bytep row_buf; /* place to save current (unfiltered) row */
   png_bytep sub_row;  /* place to save "sub" row when filtering */
   png_bytep up_row;   /* place to save "up" row when filtering */
   png_bytep avg_row;  /* place to save "avg" row when filtering */
   png_bytep paeth_row; /* place to save "Paeth" row when filtering */
   png_row_info row_info; /* used for transformation routines */

   png_uint_32 idat_size; /* current idat size for read */
   png_uint_32 crc; /* current crc value */
   png_colorp palette; /* files palette */
   png_uint_16 num_palette; /* number of entries in palette */
   png_uint_16 num_trans; /* number of transparency values */
   png_byte chunk_name[5]; /* name of current chunk being processed + '\0' */
   png_byte compression; /* file compression type (currently only '0' used) */
   png_byte filter; /* file filter type (currently only '0' used) */
   png_byte interlaced; /* file interlace type (currently only '0' and '1') */
   png_byte pass; /* current interlace pass (0 - 6) */
   png_byte do_filter; /* zero if not row filtering, non-zero if filtering */
   png_byte color_type; /* color type of file */
   png_byte bit_depth; /* bit depth of file */
   png_byte usr_bit_depth; /* bit depth of users row */
   png_byte pixel_depth; /* number of bits per pixel */
   png_byte channels; /* number of channels in file */
   png_byte usr_channels; /* channels at start of write */
   png_byte sig_bytes; /* signature bytes read/written from start of file */


#if defined(PNG_READ_FILLER_SUPPORTED) || defined(PNG_WRITE_FILLER_SUPPORTED)
   png_byte filler; /* filler byte to be used for 32-bit frame buffers */
#endif
#if defined(PNG_READ_BACKGROUND_SUPPORTED)
   png_byte background_gamma_type;
   float background_gamma;
   png_color_16 background; /* background color, gamma corrected for screen */
#if defined(PNG_READ_GAMMA_SUPPORTED)
   png_color_16 background_1; /* background normalized to gamma 1.0 */
#endif
#endif
#if defined(PNG_WRITE_FLUSH_SUPPORTED)
   png_flush_ptr output_flush_fn;/* Function for flushing output */
   png_uint_32 flush_dist;  /* how many rows apart to flush, 0 for no flush */
   png_uint_32 flush_rows;  /* number of rows written since last flush */
#endif /* PNG_WRITE_FLUSH_SUPPORTED */
#if defined(PNG_READ_GAMMA_SUPPORTED)
   int gamma_shift; /* amount of shift for 16 bit gammas */
   float gamma; /* file gamma value */
   float display_gamma; /* display gamma value */
#endif
#if defined(PNG_READ_GAMMA_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   png_bytep gamma_table; /* gamma table for 8 bit depth files */
   png_bytep gamma_from_1; /* converts from 1.0 to screen */
   png_bytep gamma_to_1; /* converts from file to 1.0 */
   png_uint_16pp gamma_16_table; /* gamma table for 16 bit depth files */
   png_uint_16pp gamma_16_from_1; /* converts from 1.0 to screen */
   png_uint_16pp gamma_16_to_1; /* converts from file to 1.0 */
#endif
#if defined(PNG_READ_GAMMA_SUPPORTED) || defined (PNG_READ_sBIT_SUPPORTED)
   png_color_8 sig_bit; /* significant bits in file */
#endif
#if defined(PNG_READ_tRNS_SUPPORTED) || defined(PNG_READ_BACKGROUND_SUPPORTED)
   png_bytep trans; /* transparency values for paletted files */
   png_color_16 trans_values; /* transparency values for non-paletted files */
#endif
#if defined(PNG_READ_SHIFT_SUPPORTED) || defined(PNG_WRITE_SHIFT_SUPPORTED)
   png_color_8 shift; /* shift for significant bit tranformation */
#endif
#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
   png_progressive_info_ptr info_fn;
   png_progressive_row_ptr row_fn;
   png_progressive_end_ptr end_fn;
   png_bytep save_buffer_ptr;
   png_bytep save_buffer;
   png_bytep current_buffer_ptr;
   png_bytep current_buffer;
   png_uint_32 push_length;
   png_uint_32 skip_length;
   png_uint_32 save_buffer_size;
   png_uint_32 save_buffer_max;
   png_uint_32 buffer_size;
   png_uint_32 current_buffer_size;
   int process_mode;
   int cur_palette;
#if defined(PNG_READ_tEXt_SUPPORTED) || defined(PNG_READ_zTXt_SUPPORTED)
   png_uint_32 current_text_size;
   png_uint_32 current_text_left;
   png_charp current_text;
   png_charp current_text_ptr;
#endif
#if defined(__TURBOC__) && !defined(_Windows) && !defined(__FLAT__)
/* for the Borland special 64K segment handler */
   png_bytepp offset_table_ptr;
   png_bytep offset_table;
   png_uint_16 offset_table_number;
   png_uint_16 offset_table_count;
   png_uint_16 offset_table_count_free;
#endif
#endif /* PNG_PROGRESSIVE_READ_SUPPORTED */
#if defined(PNG_READ_DITHER_SUPPORTED)
   png_bytep palette_lookup; /* lookup table for dithering */
   png_bytep dither_index; /* index translation for palette files */
   png_uint_16p hist; /* histogram */
#endif
};

typedef png_struct      FAR * FAR * png_structpp;

/* Here are the function definitions most commonly used.  This is not
   the place to find out how to use libpng.  See libpng.txt for the
   full explanation, see example.c for the summary.  This just provides
   a simple one line of the use of each function. */

/* Tell lib we have already handled the first <num_bytes> magic bytes.
   Handling more than 8 bytes from the beginning of the file is an error. */
extern void png_set_sig_bytes PNGARG((png_structp png_ptr, int num_bytes));

/* Check sig[start] through sig[start + num_to_check] to see if it's a PNG
   file.  Returns zero if the supplied bytes match the 8-byte PNG signature,
   and non-zero otherwise.  Having num_to_check == 0 or start > 7 will
   always fail (ie return non-zero). */
extern int png_sig_cmp PNGARG((png_bytep sig, int start, int num_to_check));

/* (Obsolete) signature checking function.  This is the same as calling
   png_check_sig(sig, n) := !png_sig_cmp(sig, 0, n).  To be removed in a
   future version. */
extern int png_check_sig PNGARG((png_bytep sig, int num));

/* Allocate and initialize png structure for reading, and any other memory. */
extern png_structp png_create_read_struct PNGARG((png_const_charp user_png_ver,
   voidp error_ptr, png_error_ptr error_fn, png_error_ptr warn_fn));
 
/* initialize png structure for reading, and allocate any other memory (old) */
extern void png_read_init PNGARG((png_structp png_ptr));

/* allocate and initialize png structure for reading, and any other memory */
extern png_structp png_create_write_struct
   PNGARG((png_const_charp user_png_ver, voidp error_ptr,
   png_error_ptr error_fn, png_error_ptr warn_fn));

/* initialize png structure for writing, and allocate any other memory (old) */
extern void png_write_init PNGARG((png_structp png_ptr));

/* allocate and initialize the info structure */
extern png_infop png_create_info_struct PNGARG((png_structp png_ptr));

/* initialize the info structure (old interface) */
extern void png_info_init PNGARG((png_infop info_ptr));

/* Writes all the png information before the image. */
extern void png_write_info PNGARG((png_structp png_ptr, png_infop info_ptr));

/* read the information before the actual image data. */
extern void png_read_info PNGARG((png_structp png_ptr, png_infop info_ptr));

#if defined(PNG_WRITE_tIME_SUPPORTED)
/* convert from a struct tm to png_time */
extern void png_convert_from_struct_tm PNGARG((png_timep ptime,
   struct tm FAR * ttime));

/* convert from time_t to png_time.  Uses gmtime() */
extern void png_convert_from_time_t PNGARG((png_timep ptime, time_t ttime));
#endif

#if defined(PNG_READ_EXPAND_SUPPORTED)
/* Expand the data to 24 bit RGB, or 8 bit Grayscale,
   with alpha if necessary. */
extern void png_set_expand PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_BGR_SUPPORTED) || defined(PNG_WRITE_BGR_SUPPORTED)
/* Use blue, green, red order for pixels. */
extern void png_set_bgr PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_GRAY_TO_RGB_SUPPORTED)
/* Expand the grayscale to 24 bit RGB if necessary. */
extern void png_set_gray_to_rgb PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_RGB_TO_GRAY_SUPPORTED)
/* Reduce RGB to grayscale. (Not yet implemented) */
extern void png_set_rgb_to_gray PNGARG((png_structp png_ptr));
#endif

extern void png_build_grayscale_palette PNGARG((int bit_depth,
   png_colorp palette));

#if defined(PNG_READ_FILLER_SUPPORTED) || defined(PNG_WRITE_FILLER_SUPPORTED)
#define PNG_FILLER_BEFORE 0
#define PNG_FILLER_AFTER 1
/* Add a filler byte to rgb images. */
extern void png_set_filler PNGARG((png_structp png_ptr, png_byte filler,
   int flags));

/* Old way of doing this, still supported through 1.x for backwards
   compatability, but should not be used in new code. */

/* Add a filler byte to rgb images after the colors. */
extern void png_set_rgbx PNGARG((png_structp png_ptr));

/* Add a filler byte to rgb images before the colors. */
extern void png_set_xrgb PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_SWAP_SUPPORTED) || defined(PNG_WRITE_SWAP_SUPPORTED)
/* Swap bytes in 16 bit depth files. */
extern void png_set_swap PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_PACK_SUPPORTED) || defined(PNG_WRITE_PACK_SUPPORTED)
/* Use 1 byte per pixel in 1, 2, or 4 bit depth files. */
extern void png_set_packing PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_SHIFT_SUPPORTED) || defined(PNG_WRITE_SHIFT_SUPPORTED)
/* Converts files to legal bit depths. */
extern void png_set_shift PNGARG((png_structp png_ptr,
   png_color_8p true_bits));
#endif

#if defined(PNG_READ_INTERLACING_SUPPORTED) || \
    defined(PNG_WRITE_INTERLACING_SUPPORTED)
/* Have the code handle the interlacing.  Returns the number of passes. */
extern int png_set_interlace_handling PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_INVERT_SUPPORTED) || defined(PNG_WRITE_INVERT_SUPPORTED)
/* Invert monocrome files */
extern void png_set_invert_mono PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_BACKGROUND_SUPPORTED)
/* Handle alpha and tRNS by replacing with a background color. */
#define PNG_BACKGROUND_GAMMA_UNKNOWN 0
#define PNG_BACKGROUND_GAMMA_SCREEN  1
#define PNG_BACKGROUND_GAMMA_FILE    2
#define PNG_BACKGROUND_GAMMA_UNIQUE  3
extern void png_set_background PNGARG((png_structp png_ptr,
   png_color_16p background_color, int background_gamma_code,
   int need_expand, double background_gamma));
#endif

#if defined(PNG_READ_16_TO_8_SUPPORTED)
/* strip the second byte of information from a 16 bit depth file. */
extern void png_set_strip_16 PNGARG((png_structp png_ptr));
#endif

#if defined(PNG_READ_DITHER_SUPPORTED)
/* Turn on dithering, and reduce the palette to the number of colors available. */
extern void png_set_dither PNGARG((png_structp png_ptr, png_colorp palette,
   int num_palette, int maximum_colors, png_uint_16p histogram,
   int full_dither));
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED)
/* Handle gamma correction. */
extern void png_set_gamma PNGARG((png_structp png_ptr, double screen_gamma,
   double default_file_gamma));
#endif

#if defined(PNG_WRITE_FLUSH_SUPPORTED)
/* Set how many lines between output flushes - 0 for no flushing */
extern void png_set_flush PNGARG((png_structp png_ptr, int nrows));

/* Flush the current PNG output buffer */
extern void png_write_flush PNGARG((png_structp png_ptr));
#endif /* PNG_WRITE_FLUSH_SUPPORTED */

/* optional update palette with requested transformations */
extern void png_start_read_image PNGARG((png_structp png_ptr));

/* optional call to update the users info structure */
extern void png_read_update_info PNGARG((png_structp png_ptr,
   png_infop info_ptr));

/* read a one or more rows of image data.*/
extern void png_read_rows PNGARG((png_structp png_ptr,
   png_bytepp row,
   png_bytepp display_row, png_uint_32 num_rows));

/* read a row of data.*/
extern void png_read_row PNGARG((png_structp png_ptr,
   png_bytep row,
   png_bytep display_row));

/* read the whole image into memory at once. */
extern void png_read_image PNGARG((png_structp png_ptr,
   png_bytepp image));

/* write a row of image data */
extern void png_write_row PNGARG((png_structp png_ptr,
   png_bytep row));

/* write a few rows of image data */
extern void png_write_rows PNGARG((png_structp png_ptr,
   png_bytepp row,
   png_uint_32 num_rows));

/* write the image data */
extern void png_write_image PNGARG((png_structp png_ptr, png_bytepp image));

/* writes the end of the png file. */
extern void png_write_end PNGARG((png_structp png_ptr, png_infop info_ptr));

/* read the end of the png file. */
extern void png_read_end PNGARG((png_structp png_ptr, png_infop info_ptr));

/* free any memory associated with the info_struct */
extern void png_destroy_info_struct PNGARG((png_structp png_ptr,
   png_infopp info_ptr_ptr));

/* free any memory associated with the png_struct and the info_structs */
extern void png_destroy_read_struct PNGARG((png_structpp png_ptr_ptr,
   png_infopp info_ptr_ptr, png_infopp end_info_ptr_ptr));

/* free all memory used by the read (old method) */
extern void png_read_destroy PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_infop end_info_ptr));

/* free any memory associated with the png_struct and the info_structs */
extern void png_destroy_write_struct PNGARG((png_structpp png_ptr_ptr,
   png_infopp info_ptr_ptr));

/* free any memory used in png struct */
extern void png_write_destroy PNGARG((png_structp png_ptr));

/* set the libpng method of handling chunk CRC errors */
extern void png_set_crc_action PNGARG((png_structp png_ptr, int crit_action,
   int ancil_action));

/* Values for png_set_crc_action() to say how to handle CRC errors in
   ancillary and critical chunks, and whether to use the data contained
   therein.  Note that it is impossible to "discard" data in a critical
   chunk.  For versions prior to 0.90, the action was always error/quit,
   whereas in version 0.90, the action for CRC errors in ancillary
   chunks is warn/discard.

        value                       action:critical     action:ancillary
 */
#define PNG_CRC_DEFAULT       0  /* error/quit          warn/discard data */
#define PNG_CRC_ERROR_QUIT    1  /* error/quit          error/quit        */
#define PNG_CRC_WARN_DISCARD  2  /* (INVALID)           warn/discard data */
#define PNG_CRC_WARN_USE      3  /* warn/use data       warn/use data     */
#define PNG_CRC_QUIET_USE     4  /* quiet/use data      quiet/use data    */
#define PNG_CRC_NO_CHANGE     5  /* use current value   use current value */

/* These functions give the user control over the scan-line filtering
   in libpng and the compression methods used by zlib.  These functions are
   mainly useful for testing, as the defaults should work with most users.
   Those users who are tight on memory, or are wanting faster performance
   at the expense of compression can modify them.  See the compression
   library header file for an explination of the compression functions */

/* set the filtering method(s) used by libpng */
extern void png_set_filter PNGARG((png_structp png_ptr, int method,
   int filters));

/* Flags for png_set_filter() to say which filters to use.  The flags
   are chosen so that they don't conflict with real filter types, in case they
   are supplied instead of the #defined constants.
 */
#define PNG_NO_FILTERS     0x00
#define PNG_FILTER_NONE    0x08
#define PNG_FILTER_SUB     0x10
#define PNG_FILTER_UP      0x20
#define PNG_FILTER_AVG     0x40
#define PNG_FILTER_PAETH   0x80
#define PNG_ALL_FILTERS (PNG_FILTER_NONE | PNG_FILTER_SUB | PNG_FILTER_UP | \
                         PNG_FILTER_AVG | PNG_FILTER_PAETH)

extern void png_set_compression_level PNGARG((png_structp png_ptr,
   int level));

extern void png_set_compression_mem_level PNGARG((png_structp png_ptr,
   int mem_level));

extern void png_set_compression_strategy PNGARG((png_structp png_ptr,
   int strategy));

extern void png_set_compression_window_bits PNGARG((png_structp png_ptr,
   int window_bits));

extern void png_set_compression_method PNGARG((png_structp png_ptr,
   int method));

/* These next functions are called for input/output, memory, and error
   handling.  They are in the file pngrio.c, pngwio.c, and pngerror.c,
   and call standard C I/O routines such as fread(), fwrite(), and
   fprintf().  These functions can be made to use other I/O routines
   at run time for those applications that need to handle I/O in a
   different manner by calling png_set_???_fn().  See libpng.txt for
   more information */

/* Write the data to whatever output you are using. */
extern void png_write_data PNGARG((png_structp png_ptr, png_bytep data,
   png_uint_32 length));

/* Read data from whatever input you are using */
extern void png_read_data PNGARG((png_structp png_ptr, png_bytep data,
   png_uint_32 length));

/* Initialize the input/output for the png file to the default functions. */
extern void png_init_io PNGARG((png_structp png_ptr, FILE *fp));

/* Replace the (error and abort), and warning functions with user
   supplied functions.  If no messages are to be printed you must still
   write and use replacement functions. The replacement error_fn should
   still do a longjmp to the last setjmp location if you are using this
   method of error handling.  If error_fn or warning_fn is NULL, the
   default function will be used. */
extern void png_set_error_fn PNGARG((png_structp png_ptr, png_voidp error_ptr,
   png_error_ptr error_fn, png_error_ptr warning_fn));

/* Return the user pointer associated with the error functions */
extern png_voidp png_get_error_ptr PNGARG((png_structp png_ptr));

/* Replace the default data output functions with a user supplied one(s).
   If buffered output is not used, then output_flush_fn can be set to NULL.
   If PNG_WRITE_FLUSH_SUPPORTED is not defined at libpng compile time
   output_flush_fn will be ignored (and thus can be NULL). */
extern void png_set_write_fn PNGARG((png_structp png_ptr, png_voidp io_ptr,
   png_rw_ptr write_data_fn, png_flush_ptr output_flush_fn));

/* Replace the default data input function with a user supplied one. */
extern void png_set_read_fn PNGARG((png_structp png_ptr, png_voidp io_ptr,
   png_rw_ptr read_data_fn));

/* Return the user pointer associated with the I/O functions */
extern png_voidp png_get_io_ptr PNGARG((png_structp png_ptr));

#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
/* Replace the default push model read functions */
extern void png_set_push_fn PNGARG((png_structp png_ptr, png_voidp push_ptr,
   png_progressive_info_ptr info_fn, png_progressive_row_ptr row_fn,
   png_progressive_end_ptr end_fn));

/* returns the user pointer associated with the push read functions */
extern png_voidp png_get_progressive_ptr PNGARG((png_structp png_ptr));
#endif /* PNG_PROGRESSIVE_READ_SUPPORTED */

extern png_voidp png_malloc PNGARG((png_structp png_ptr,
   png_uint_32 size));

/* free's a pointer allocated by png_malloc() */
extern void png_free PNGARG((png_structp png_ptr, png_voidp ptr));

/* Fatal error in libpng - can't continue */ 
extern void png_error PNGARG((png_structp png_ptr, png_const_charp error));

/* Non-fatal error in libpng.  Can continue, but may have a problem. */
extern void png_warning PNGARG((png_structp png_ptr, png_const_charp message));

/* These next functions are used internally in the code.  If you use
   them, make sure you read and understand the png spec.  More information
   about them can be found in the files where the functions are.
   Feel free to move any of these outside the PNG_INTERNAL define if
   you just need a few of them, but if you need access to more, you should
   define PNG_INTERNAL inside your code, so everyone who includes png.h
   won't get yet another definition the compiler has to deal with. */

#if defined(PNG_INTERNAL)

/* Various modes of operation.  Note that after an init, mode is set to
   zero automatically when the structure is created. */
#define PNG_BEFORE_IHDR       0x00
#define PNG_HAVE_IHDR         0x01
#define PNG_HAVE_PLTE         0x02
#define PNG_HAVE_IDAT         0x04
#define PNG_AFTER_IDAT        0x08
#define PNG_HAVE_IEND         0x10

/* push model modes */
#define PNG_READ_SIG_MODE   0
#define PNG_READ_CHUNK_MODE 1
#define PNG_READ_IDAT_MODE  2
#define PNG_READ_END_MODE   3
#define PNG_SKIP_MODE       4
#define PNG_READ_tEXt_MODE  5
#define PNG_READ_zTXt_MODE  6
#define PNG_READ_DONE_MODE  7
#define PNG_ERROR_MODE      8

/* defines for the transformations the PNG library does on the image data */
#define PNG_BGR                0x0001
#define PNG_INTERLACE          0x0002
#define PNG_PACK               0x0004
#define PNG_SHIFT              0x0008
#define PNG_SWAP_BYTES         0x0010
#define PNG_INVERT_MONO        0x0020
#define PNG_DITHER             0x0040
#define PNG_BACKGROUND         0x0080
#define PNG_BACKGROUND_EXPAND  0x0100
#define PNG_RGB_TO_GRAY        0x0200
#define PNG_16_TO_8            0x0400
#define PNG_RGBA               0x0800
#define PNG_EXPAND             0x1000
#define PNG_GAMMA              0x2000
#define PNG_GRAY_TO_RGB        0x4000
#define PNG_FILLER             0x8000

/* flags for png_create_struct */
#define PNG_STRUCT_PNG   0x0001
#define PNG_STRUCT_INFO  0x0002

/* flags for the png_ptr->flags rather than declaring a bye for each one */
#define PNG_FLAG_ZLIB_CUSTOM_STRATEGY     0x0001
#define PNG_FLAG_ZLIB_CUSTOM_LEVEL        0x0002
#define PNG_FLAG_ZLIB_CUSTOM_MEM_LEVEL    0x0004
#define PNG_FLAG_ZLIB_CUSTOM_WINDOW_BITS  0x0008
#define PNG_FLAG_ZLIB_CUSTOM_METHOD       0x0010
#define PNG_FLAG_ZLIB_FINISHED            0x0020
#define PNG_FLAG_ROW_INIT                 0x0040
#define PNG_FLAG_FILLER_AFTER             0x0080
#define PNG_FLAG_CRC_ANCILLARY_USE        0x0100
#define PNG_FLAG_CRC_ANCILLARY_NOWARN     0x0200
#define PNG_FLAG_CRC_CRITICAL_USE         0x0400
#define PNG_FLAG_CRC_CRITICAL_IGNORE      0x0800
#define PNG_FLAG_FREE_PALETTE             0x1000
#define PNG_FLAG_FREE_TRANS               0x2000
#define PNG_FLAG_FREE_HIST                0x4000
#define PNG_FLAG_HAVE_CHUNK_HEADER        0x8000
#define PNG_FLAG_WROTE_tIME              0x10000

#define PNG_FLAG_CRC_ANCILLARY_MASK (PNG_FLAG_CRC_ANCILLARY_USE | \
                                     PNG_FLAG_CRC_ANCILLARY_NOWARN)

#define PNG_FLAG_CRC_CRITICAL_MASK  (PNG_FLAG_CRC_CRITICAL_USE | \
                                     PNG_FLAG_CRC_CRITICAL_IGNORE)

#define PNG_FLAG_CRC_MASK           (PNG_FLAG_CRC_ANCILLARY_MASK | \
                                     PNG_FLAG_CRC_CRITICAL_MASK)

/* save typing and make code easier to understand */
#define PNG_COLOR_DIST(c1, c2) (abs((int)((c1).red) - (int)((c2).red)) + \
   abs((int)((c1).green) - (int)((c2).green)) + \
   abs((int)((c1).blue) - (int)((c2).blue)))

/* variables defined in png.c - only it needs to define PNG_NO_EXTERN */
#ifndef PNG_NO_EXTERN
/* place to hold the signiture string for a png file. */
extern png_byte FARDATA png_sig[];

/* version information for c files, stored in png.c. */
extern char png_libpng_ver[];

/* constant strings for known chunk types.  If you need to add a chunk,
   add a string holding the name here.  See png.c for more details.  We
   can't selectively include these, since we still check for chunk in the
   wrong locations with these labels. */
extern png_byte FARDATA png_IHDR[];
extern png_byte FARDATA png_IDAT[];
extern png_byte FARDATA png_IEND[];
extern png_byte FARDATA png_PLTE[];
extern png_byte FARDATA png_gAMA[];
extern png_byte FARDATA png_sBIT[];
extern png_byte FARDATA png_cHRM[];
extern png_byte FARDATA png_tRNS[];
extern png_byte FARDATA png_bKGD[];
extern png_byte FARDATA png_hIST[];
extern png_byte FARDATA png_tEXt[];
extern png_byte FARDATA png_zTXt[];
extern png_byte FARDATA png_pHYs[];
extern png_byte FARDATA png_oFFs[];
extern png_byte FARDATA png_tIME[];
/* Structures to facilitate easy interlacing.  See png.c for more details */
extern int FARDATA png_pass_start[];
extern int FARDATA png_pass_inc[];
extern int FARDATA png_pass_ystart[];
extern int FARDATA png_pass_yinc[];
/* these are not currently used.  If you need them, see png.c
extern int FARDATA png_pass_width[];
extern int FARDATA png_pass_height[];
*/
extern int FARDATA png_pass_mask[];
extern int FARDATA png_pass_dsp_mask[];

#endif /* PNG_NO_EXTERN */

/* allocate memory for an internal libpng struct */
extern png_voidp png_create_struct PNGARG((int type));

/* free memory from internal libpng struct */
extern void png_destroy_struct PNGARG((png_voidp struct_ptr));

/* free any memory that info_ptr points to and reset struct. */
extern void png_info_destroy PNGARG((png_structp png_ptr,
   png_infop info_ptr));

/* Function to allocate memory for zlib. */
extern voidpf png_zalloc PNGARG((voidpf png_ptr, uInt items, uInt size));

/* function to free memory for zlib */
extern void png_zfree PNGARG((voidpf png_ptr, voidpf ptr));

/* reset the CRC variable */
extern void png_reset_crc PNGARG((png_structp png_ptr));

/* read bytes into buf, and update png_ptr->crc */
extern void png_crc_read PNGARG((png_structp png_ptr, png_bytep buf,
   png_uint_32 length));

/* read "skip" bytes, read the file crc, and (optionally) verify png_ptr->crc */
extern int png_crc_finish PNGARG((png_structp png_ptr, png_uint_32 skip));

/* read the CRC from the file and compare it to the libpng calculated CRC */
extern int png_crc_error PNGARG((png_structp png_ptr));

/* calculate the crc over a section of data.  Note that while we
   are passing in a 32 bit value for length, on 16 bit machines, you
   would need to use huge pointers to access all that data.  See the
   code in png.c for more information. */
extern void png_calculate_crc PNGARG((png_structp png_ptr, png_bytep ptr,
   png_uint_32 length));

#if defined(PNG_WRITE_FLUSH_SUPPORTED)
extern void png_flush PNGARG((png_structp png_ptr));
#endif

/* place a 32 bit number into a buffer in png byte order.  We work
   with unsigned numbers for convenience, you may have to cast
   signed numbers (if you use any, most png data is unsigned). */
extern void png_save_uint_32 PNGARG((png_bytep buf, png_uint_32 i));

/* place a 16 bit number into a buffer in png byte order */
extern void png_save_uint_16 PNGARG((png_bytep buf, png_uint_16 i));

/* write a 32 bit number */
extern void png_write_uint_32 PNGARG((png_structp png_ptr, png_uint_32 i));

/* write a 16 bit number */
extern void png_write_uint_16 PNGARG((png_structp png_ptr, png_uint_16 i));

/* Write a png chunk.  */
extern void png_write_chunk PNGARG((png_structp png_ptr, png_bytep chunk_name,
   png_bytep data, png_uint_32 length));

/* Write the start of a png chunk. */
extern void png_write_chunk_start PNGARG((png_structp png_ptr, png_bytep chunk_name,
   png_uint_32 length));

/* write the data of a png chunk started with png_write_chunk_start(). */
extern void png_write_chunk_data PNGARG((png_structp png_ptr, png_bytep data,
   png_uint_32 length));

/* finish a chunk started with png_write_chunk_start() */
extern void png_write_chunk_end PNGARG((png_structp png_ptr));

/* simple function to write the signiture */
extern void png_write_sig PNGARG((png_structp png_ptr));

/* write various chunks */

/* Write the IHDR chunk, and update the png_struct with the necessary
   information. */
extern void png_write_IHDR PNGARG((png_structp png_ptr, png_uint_32 width,
   png_uint_32 height,
   int bit_depth, int color_type, int compression_type, int filter_type,
   int interlace_type));

extern void png_write_PLTE PNGARG((png_structp png_ptr, png_colorp palette,
   png_uint_32 number));

extern void png_write_IDAT PNGARG((png_structp png_ptr, png_bytep data,
   png_uint_32 length));

extern void png_write_IEND PNGARG((png_structp png_ptr));

#if defined(PNG_WRITE_gAMA_SUPPORTED)
extern void png_write_gAMA PNGARG((png_structp png_ptr, double gamma));
#endif

#if defined(PNG_WRITE_sBIT_SUPPORTED)
extern void png_write_sBIT PNGARG((png_structp png_ptr, png_color_8p sbit,
   int color_type));
#endif

#if defined(PNG_WRITE_cHRM_SUPPORTED)
extern void png_write_cHRM PNGARG((png_structp png_ptr,
   double white_x, double white_y,
   double red_x, double red_y, double green_x, double green_y,
   double blue_x, double blue_y));
#endif

#if defined(PNG_WRITE_tRNS_SUPPORTED)
extern void png_write_tRNS PNGARG((png_structp png_ptr, png_bytep trans,
   png_color_16p values, int number, int color_type));
#endif

#if defined(PNG_WRITE_bKGD_SUPPORTED)
extern void png_write_bKGD PNGARG((png_structp png_ptr, png_color_16p values,
   int color_type));
#endif

#if defined(PNG_WRITE_hIST_SUPPORTED)
extern void png_write_hIST PNGARG((png_structp png_ptr, png_uint_16p hist,
   int number));
#endif

#if defined(PNG_WRITE_tEXt_SUPPORTED) || defined(PNG_WRITE_zTXt_SUPPORTED)
extern int png_check_keyword PNGARG((png_structp png_ptr, png_charpp key));
#endif

#if defined(PNG_WRITE_tEXt_SUPPORTED)
extern void png_write_tEXt PNGARG((png_structp png_ptr, png_charp key,
   png_charp text, png_uint_32 text_len));
#endif

#if defined(PNG_WRITE_zTXt_SUPPORTED)
extern void png_write_zTXt PNGARG((png_structp png_ptr, png_charp key,
   png_charp text, png_uint_32 text_len, int compression));
#endif

#if defined(PNG_WRITE_pHYs_SUPPORTED)
extern void png_write_pHYs PNGARG((png_structp png_ptr,
   png_uint_32 x_pixels_per_unit,
   png_uint_32 y_pixels_per_unit,
   int unit_type));
#endif

#if defined(PNG_WRITE_oFFs_SUPPORTED)
extern void png_write_oFFs PNGARG((png_structp png_ptr,
   png_uint_32 x_offset,
   png_uint_32 y_offset,
   int unit_type));
#endif

#if defined(PNG_WRITE_tIME_SUPPORTED)
extern void png_write_tIME PNGARG((png_structp png_ptr, png_timep mod_time));
#endif

/* Internal use only.   Called when finished processing a row of data */
extern void png_write_finish_row PNGARG((png_structp png_ptr));

/* Internal use only.   Called before first row of data */
extern void png_write_start_row PNGARG((png_structp png_ptr));

/* callbacks for png chunks */
extern void png_read_IHDR PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 width, png_uint_32 height, int bit_depth,
   int color_type, int compression_type, int filter_type,
   int interlace_type));

extern void png_read_PLTE PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_colorp palette, int num));

#if defined(PNG_READ_gAMA_SUPPORTED)
extern void png_read_gAMA PNGARG((png_structp png_ptr, png_infop info_ptr,
   double gamma));
#endif

#if defined(PNG_READ_sBIT_SUPPORTED)
extern void png_read_sBIT PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_color_8p sig_bit));
#endif

#if defined(PNG_READ_cHRM_SUPPORTED)
extern void png_read_cHRM PNGARG((png_structp png_ptr, png_infop info_ptr,
   double white_x, double white_y, double red_x, double red_y,
   double green_x, double green_y, double blue_x, double blue_y));
#endif

#if defined(PNG_READ_tRNS_SUPPORTED)
extern void png_read_tRNS PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_bytep trans, int num_trans,   png_color_16p trans_values));
#endif

#if defined(PNG_READ_bKGD_SUPPORTED)
extern void png_read_bKGD PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_color_16p background));
#endif

#if defined(PNG_READ_hIST_SUPPORTED)
extern void png_read_hIST PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_16p hist));
#endif

#if defined(PNG_READ_pHYs_SUPPORTED)
extern void png_read_pHYs PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 res_x, png_uint_32 res_y, int unit_type));
#endif

#if defined(PNG_READ_oFFs_SUPPORTED)
extern void png_read_oFFs PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 offset_x, png_uint_32 offset_y, int unit_type));
#endif

#if defined(PNG_READ_tIME_SUPPORTED)
extern void png_read_tIME PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_timep mod_time));
#endif

#if defined(PNG_READ_tEXt_SUPPORTED)
extern void png_read_tEXt PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_charp key, png_charp text, png_uint_32 text_len));
#endif

#if defined(PNG_READ_zTXt_SUPPORTED)
extern void png_read_zTXt PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_charp key, png_charp text, png_uint_32 text_len, int compression));
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED)
void
png_build_gamma_table PNGARG((png_structp png_ptr));
#endif

/* combine a row of data, dealing with alpha, etc. if requested */
extern void png_combine_row PNGARG((png_structp png_ptr, png_bytep row,
   int mask));

#if defined(PNG_READ_INTERLACING_SUPPORTED)
/* expand an interlaced row */
extern void png_do_read_interlace PNGARG((png_row_infop row_info,
   png_bytep row, int pass));
#endif

#if defined(PNG_WRITE_INTERLACING_SUPPORTED)
/* grab pixels out of a row for an interlaced pass */
extern void png_do_write_interlace PNGARG((png_row_infop row_info,
   png_bytep row, int pass));
#endif

/* unfilter a row */
extern void png_read_filter_row PNGARG((png_structp png_ptr,
   png_row_infop row_info, png_bytep row, png_bytep prev_row, int filter));
/* choose the best filter to use and filter the row data */
extern void png_write_find_filter PNGARG((png_structp png_ptr,
   png_row_infop row_info));
/* write out the filtered row */
extern void png_write_filtered_row PNGARG((png_structp png_ptr,
   png_bytep filtered_row));
/* finish a row while reading, dealing with interlacing passes, etc. */
extern void png_read_finish_row PNGARG((png_structp png_ptr));
/* initialize the row buffers, etc. */
extern void png_read_start_row PNGARG((png_structp png_ptr));
/* optional call to update the users info structure */
extern void png_read_transform_info PNGARG((png_structp png_ptr,
   png_infop info_ptr));

/* these are the functions that do the transformations */
#if defined(PNG_READ_FILLER_SUPPORTED)
extern void png_do_read_filler PNGARG((png_row_infop row_info,
   png_bytep row, png_byte filler, png_uint_32 filler_loc));
#endif

#if defined(PNG_WRITE_FILLER_SUPPORTED)
extern void png_do_write_filler PNGARG((png_row_infop row_info,
   png_bytep row, png_uint_32 filler_loc));
#endif

#if defined(PNG_READ_SWAP_SUPPORTED) || defined(PNG_WRITE_SWAP_SUPPORTED)
extern void png_do_swap PNGARG((png_row_infop row_info, png_bytep row));
#endif

#if defined(PNG_READ_RGB_TO_GRAY_SUPPORTED)
extern void png_do_rgb_to_gray PNGARG((png_row_infop row_info, png_bytep row));
#endif

#if defined(PNG_READ_GRAY_TO_RGB_SUPPORTED)
extern void png_do_gray_to_rgb PNGARG((png_row_infop row_info, png_bytep row));
#endif

#if defined(PNG_READ_PACK_SUPPORTED)
extern void png_do_unpack PNGARG((png_row_infop row_info, png_bytep row));
#endif

#if defined(PNG_READ_SHIFT_SUPPORTED)
extern void png_do_unshift PNGARG((png_row_infop row_info, png_bytep row,
   png_color_8p sig_bits));
#endif

#if defined(PNG_READ_INVERT_SUPPORTED) || defined(PNG_WRITE_INVERT_SUPPORTED)
extern void png_do_invert PNGARG((png_row_infop row_info, png_bytep row));
#endif

#if defined(PNG_READ_16_TO_8_SUPPORTED)
extern void png_do_chop PNGARG((png_row_infop row_info, png_bytep row));
#endif

#if defined(PNG_READ_DITHER_SUPPORTED)
extern void png_do_dither PNGARG((png_row_infop row_info,
   png_bytep row, png_bytep palette_lookup, png_bytep dither_lookup));
#  if defined(PNG_CORRECT_PALETTE_SUPPORTED)
extern void png_correct_palette PNGARG((png_structp png_ptr,
   png_colorp palette, int num_palette));
#  endif
#endif

#if defined(PNG_READ_BGR_SUPPORTED) || defined(PNG_WRITE_BGR_SUPPORTED)
extern void png_do_bgr PNGARG((png_row_infop row_info, png_bytep row));
#endif

#if defined(PNG_WRITE_PACK_SUPPORTED)
extern void png_do_pack PNGARG((png_row_infop row_info,
   png_bytep row, png_byte bit_depth));
#endif

#if defined(PNG_WRITE_SHIFT_SUPPORTED)
extern void png_do_shift PNGARG((png_row_infop row_info, png_bytep row,
   png_color_8p bit_depth));
#endif

#if defined(PNG_READ_BACKGROUND_SUPPORTED)
extern void png_do_background PNGARG((png_row_infop row_info, png_bytep row,
   png_color_16p trans_values, png_color_16p background,
   png_color_16p background_1,
   png_bytep gamma_table, png_bytep gamma_from_1, png_bytep gamma_to_1,
   png_uint_16pp gamma_16, png_uint_16pp gamma_16_from_1,
   png_uint_16pp gamma_16_to_1, int gamma_shift));
#endif

#if defined(PNG_READ_GAMMA_SUPPORTED)
extern void png_do_gamma PNGARG((png_row_infop row_info, png_bytep row,
   png_bytep gamma_table, png_uint_16pp gamma_16_table,
   int gamma_shift));
#endif

#if defined(PNG_READ_EXPAND_SUPPORTED)
extern void png_do_expand_palette PNGARG((png_row_infop row_info,
   png_bytep row, png_colorp palette, png_bytep trans, int num_trans));
extern void png_do_expand PNGARG((png_row_infop row_info,
   png_bytep row, png_color_16p trans_value));
#endif

/* unpack 16 and 32 bit values from a string */
extern png_uint_32 png_get_uint_32 PNGARG((png_bytep buf));
extern png_uint_16 png_get_uint_16 PNGARG((png_bytep buf));

/* the following decodes the appropriate chunks, and does error correction,
   then calls the appropriate callback for the chunk if it is valid */

/* decode the IHDR chunk */
extern void png_handle_IHDR PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
extern void png_handle_PLTE PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
extern void png_handle_IEND PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#if defined(PNG_READ_gAMA_SUPPORTED)
extern void png_handle_gAMA PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_sBIT_SUPPORTED)
extern void png_handle_sBIT PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_cHRM_SUPPORTED)
extern void png_handle_cHRM PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_tRNS_SUPPORTED)
extern void png_handle_tRNS PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_bKGD_SUPPORTED)
extern void png_handle_bKGD PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_hIST_SUPPORTED)
extern void png_handle_hIST PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_pHYs_SUPPORTED)
extern void png_handle_pHYs PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_oFFs_SUPPORTED)
extern void png_handle_oFFs PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_tIME_SUPPORTED)
extern void png_handle_tIME PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_tEXt_SUPPORTED)
extern void png_handle_tEXt PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

#if defined(PNG_READ_zTXt_SUPPORTED)
extern void png_handle_zTXt PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
#endif

extern void png_handle_unknown PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));

extern void png_check_chunk_name PNGARG((png_structp png_ptr,
   png_bytep chunk_name));

/* handle the transformations for reading and writing */
extern void png_do_read_transformations PNGARG((png_structp png_ptr));
extern void png_do_write_transformations PNGARG((png_structp png_ptr));

extern void png_init_read_transformations PNGARG((png_structp png_ptr));

#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
extern void png_push_read_chunk PNGARG((png_structp png_ptr, png_infop info_ptr));
extern void png_push_read_sig PNGARG((png_structp png_ptr, png_infop info_ptr));
extern void png_push_check_crc PNGARG((png_structp png_ptr));
extern void png_push_crc_skip PNGARG((png_structp png_ptr, png_uint_32 length));
extern void png_push_skip PNGARG((png_structp png_ptr));
extern void png_push_fill_buffer PNGARG((png_structp png_ptr, png_bytep buffer,
   png_uint_32 length));
extern void png_push_save_buffer PNGARG((png_structp png_ptr));
extern void png_push_restore_buffer PNGARG((png_structp png_ptr, png_bytep buffer,
   png_uint_32 buffer_length));
extern void png_push_read_IDAT PNGARG((png_structp png_ptr));
extern void png_process_IDAT_data PNGARG((png_structp png_ptr,
   png_bytep buffer, png_uint_32 buffer_length));
extern void png_push_process_row PNGARG((png_structp png_ptr));
extern void png_push_handle_PLTE PNGARG((png_structp png_ptr,
   png_uint_32 length));
extern void png_push_handle_tRNS PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
extern void png_push_handle_hIST PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
extern void png_push_handle_unknown PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
extern void png_push_have_info PNGARG((png_structp png_ptr, png_infop info_ptr));
extern void png_push_have_end PNGARG((png_structp png_ptr, png_infop info_ptr));
extern void png_push_have_row PNGARG((png_structp png_ptr, png_bytep row));
extern void png_push_read_end PNGARG((png_structp png_ptr, png_infop info_ptr));
extern void png_process_some_data PNGARG((png_structp png_ptr,
   png_infop info_ptr));
extern void png_read_push_finish_row PNGARG((png_structp png_ptr));
#if defined(PNG_READ_tEXt_SUPPORTED)
extern void png_push_handle_tEXt PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
extern void png_push_read_tEXt PNGARG((png_structp png_ptr, png_infop info_ptr));
#endif
#if defined(PNG_READ_zTXt_SUPPORTED)
extern void png_push_handle_zTXt PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_uint_32 length));
extern void png_push_read_zTXt PNGARG((png_structp png_ptr, png_infop info_ptr));
#endif

#endif /* PNG_PROGRESSIVE_READ_SUPPORTED */

#endif /* PNG_INTERNAL */

#ifdef PNG_PROGRESSIVE_READ_SUPPORTED
extern void png_process_data PNGARG((png_structp png_ptr, png_infop info_ptr,
   png_bytep buffer, png_uint_32 buffer_size));
extern void png_set_progressive_read_fn PNGARG((png_structp png_ptr,
   png_voidp progressive_ptr,
   png_progressive_info_ptr info_fn, png_progressive_row_ptr row_fn,
   png_progressive_end_ptr end_fn));
extern void png_progressive_combine_row PNGARG((png_structp png_ptr,
   png_bytep old_row, png_bytep new_row));
#endif /* PNG_PROGRESSIVE_READ_SUPPORTED */

#if defined(USE_FAR_KEYWORD)  /* memory model independent fns */
extern void *far_to_near PNGARG((png_structp png_ptr,png_voidp ptr,int check));
#endif /* defined(USE_FAR_KEYWORD) */

#ifdef __cplusplus
}
#endif

/* do not put anything past this line */
#endif /* _PNG_H */
