#include "../cthugha.h"
#include "../display.h"
#include "../disp-sys.h"

#include <vga.h>
#include <vgagl.h>


int screen_modes_normal[] = {			/* allowed modes */
    G320x200x256,		/* 0 */
    G320x240x256,		/* 1 */
    G320x400x256,		/* 2 */
    G360x480x256,		/* 3 */
    G640x480x256,		/* 4 */
    G800x600x256,		/* 5  here it starts getting tiny */
    G1024x768x256,		/* 6 */
    G1280x1024x256,		/* 7 */
    G1600x1200x256,		/* 8  only for completeness */
};
int nr_screen_modes_normal = sizeof(screen_modes_normal) / sizeof(int);

int screen_modes_rgb[] = {
    G320x200x16M32,
    G640x480x16M32,
    G800x600x16M32,
    G1024x768x16M32,
    G1280x1024x16M32,
};
int nr_screen_modes_rgb = sizeof(screen_modes_rgb) / sizeof(int);

#define screen_modes screen_modes_normal
#define nr_screen_modes nr_screen_modes_normal

static GraphicsContext display_screen_context;
static GraphicsContext display_virtual_context;

static int display_copybox = 0;		/* use copybox. Not available
					   at some screen-modes */

int display_syncwait = 0;

char display_font[ 256 * 8 * 8 ];

int init_display_sys() {
    return 0;
}


int init_graph_mode_sys() {
    vga_modeinfo * mi;

    if ( (display_mode >= nr_screen_modes) || (display_mode < 0))
	display_mode = 0;

    /* create screen-context */
    vga_setmode(screen_modes[ display_mode ]);
    gl_setcontextvga(screen_modes[ display_mode ]);

    gl_getcontext(&display_screen_context);
/*    gl_enablepageflipping( &display_screen_context);  */
    /* direct display only in 320x200 */
    if ( (display_mode != 0) || (bpp != 8))
	display_direct = 0;

    mi = vga_getmodeinfo(screen_modes[ display_mode ]);

    /* can't use copybox if screen-mode is planar 256 colors */
    display_copybox = (mi->flags & 4) ? 0 : 1;
     
    /* prepare font */
    gl_expandfont(8,8,255, gl_font8x8, display_font);
    gl_setfont( 8,8, display_font);
    gl_setwritemode( WRITEMODE_MASKED);

    /* create context for drawing in memory */
    gl_setcontextvgavirtual(screen_modes[ display_mode ]);
    gl_getcontext(&display_virtual_context);
/*    gl_enablepageflipping( &display_virtual_context);  */

    bypp = BYTESPERPIXEL;
    bpp = BITSPERPIXEL;
    disp_size.x = WIDTH;
    disp_size.y = HEIGHT;
    bytes_per_line = BYTEWIDTH;
    switch(bypp) {
    case 1:
	draw_mode = DM_direct;
	colormapped = 1;
	break;
    case 4:
	draw_mode = DM_mapped4;
	colormapped = 0;
	red_mask = 0xff; red_shift = 0;
	green_mask = 0xff00; green_shift = 8;
	blue_mask = 0xff0000; blue_shift = 16;
	break;
    default:
	printfee("Only 1 and 4 bytes/pixel are supported\n");
	return 1;
    }

    if ( (disp_size.x < BUFF_WIDTH) || (disp_size.y < BUFF_HEIGHT) ) {
	exit_graph_mode();
	printfe("Screen must not be smaller than buffer.");
	return 1;
    }

    return 0;
}

int exit_graph_mode_sys() {
    vga_setmode(TEXT);
    return 0;
}


int disp_clear_box_sys(int x, int y, int width, int height) {
    gl_fillbox(x, y, width, height, 0);
    return 0;
}

int disp_copy_box_sys(int x, int y, int width, int height, 
		      int destx, int desty) {

    gl_copybox(x, y, width, height,  destx, desty);

    return 0;
}
char * pre_draw_sys() {
    if( display_direct )
	gl_setcontext( &display_screen_context);
    else
	gl_setcontext( &display_virtual_context);

    return VBUF;
}


int disp_copy_sys(int clear) {
    if( display_syncwait )
	vga_waitretrace();

    /* copy virtual screen to physical screen */
    if( !display_direct) {
	if( clear || !display_copybox)		/* draw full screen */
	    gl_copyscreen( &display_screen_context);
	else {					/* or only a part */
	    gl_setcontext( &display_screen_context);
	    gl_copyboxfromcontext( &display_virtual_context,
				  SCREEN_OFFSET_X, SCREEN_OFFSET_Y,
				  draw_size.x, draw_size.y,
				  SCREEN_OFFSET_X, SCREEN_OFFSET_Y);
	}
    }
    return 0;
}





/*
 * display text
 */
int display_print_string_sys(int x,int y,char* text, int color) {
    static int last_color = 0;

    if(colormapped)
	color = 255 - color;

    if(color != last_color)
	gl_colorfont(8,8, color, display_font);
    last_color = color;

    if( (y>=0) && (y <= HEIGHT-8) )
	gl_writen(x,y, min(strlen(text), WIDTH/8), text);
    return 0;
}

int display_sync_sys() {
    return 0;
}
