#include "../cthugha.h"
#include "../keys.h"

#include <stdio.h>
#include <string.h>
#include <ncurses.h>
#include <signal.h>

int key_esc = 1;		/* disable/enable ESC-key. When enable it 
				   sometimes happens that when pressing
				   functions keys or cursor keys cthugha
				   only get the leading ESC and quits. */

 
int translate_key(int key) {

    switch(key) {
    case 0:	case -1:	return CK_NONE;
    case 27:			return (key_esc ? CK_ESC : CK_NONE);
    case KEY_F(1): 		return CK_FKT(1);
    case KEY_F(2):		return CK_FKT(2);
    case KEY_F(3):		return CK_FKT(3);
    case KEY_F(4):		return CK_FKT(4);
    case KEY_F(5):		return CK_FKT(5);
    case KEY_F(6):		return CK_FKT(6);
    case KEY_F(7):		return CK_FKT(7);
    case KEY_F(8):		return CK_FKT(8);

    case KEY_UP:		return CK_UP;
    case KEY_DOWN:		return CK_DOWN;
    case KEY_PPAGE:		return CK_PGUP;
    case KEY_NPAGE:		return CK_PGDN;
    case KEY_HOME:		return CK_HOME;
    case KEY_END:		return CK_END;
    case KEY_RIGHT:		return CK_RIGHT;
    case KEY_LEFT:		return CK_LEFT;

    case KEY_PRINT:		return CK_PRINT;
	
    case 8:			
    case KEY_BACKSPACE:		return CK_BACK;

    case 10: case 13:		return CK_ENTER;

    default:			return key; 
    }
}

/* Now I'm using ncurses to read from the keyboard 
   In version 0.1 I used vga_getkey, but getch is much better.
   There is a 1 sec. delay when only ESC is pressed. 
   */

int getkey() {
    static int next_key = CK_NONE;
    int key;

    key = next_key;
    next_key = getch();

    if( (key == 27) && (next_key > 0)) {
	/* seems like an unrecognized special key. skip everything still 
	 waiting */
	while( (next_key = getch()) > 0);

	return CK_OTHER;
    }

    if( key == KEY_SUSPEND) {			/* suspend (^Z) */
	raise(SIGTSTP);
	return CK_NONE;
    }

    return translate_key( key );
}



