/*
 * X-Mame video specifics code
 *
 */
#define __XDEP_C_

/*
 * Include files.
 */

#include "xmame.h"
#include "driver.h"
#include "sound.h" /* for rearming the timer */

#ifndef svgalib

#include <X11/cursorfont.h>

static int	scaling;
static int      black_pen;
static Cursor   cursor;

static XVisualInfo	 myvisual;

/* function prototypes */
int osd_snapshot(void);
struct osd_bitmap *osd_create_bitmap (int width, int height);
void osd_free_bitmap (struct osd_bitmap *bitmap);
void osd_clearbitmap(struct osd_bitmap *bitmap);
int osd_init_pen(int totalcolors,const unsigned char *palette, unsigned char *pens);

/* devices.c for trakball geometry evaluation */
extern int trak_display_height;
extern int trak_display_width;

/*
 * makes a snapshot of screen when F12 is pressed.
 *
 * store it in xpm pixmap format
 * save in users'home dir as gamename-XXX.xpm ( XXX equals to #snapshot )
 * 
 */

int osd_snapshot(void)
{
#ifdef HAS_XPM
	char name[1024];
	FILE *f;
	int res;
	XpmAttributes *xpmattr;
	do
	{
		sprintf(name,"%s/%s-snap%03d.xpm",getenv("HOME"),Machine->gamedrv->name,snapshot_no);
		/* avoid overwriting of existing files */
		if ((f = fopen(name,"rb")) != 0)
		{
			fclose(f);
			snapshot_no++;
		}
	} while (f != 0);
	/* set propper colormap */
	xpmattr=calloc(1,sizeof(XpmAttributes));
	if ( ! xpmattr ) { 
		fprintf(stderr,"calloc() Failed in osd_snapshot\n");
		return (OSD_NOT_OK);
	}
	xpmattr->valuemask	= XpmColormap;
	xpmattr->colormap	= colormap;	/* set my own colormap */
	res = XpmWriteFileFromImage(display,name,image,0,xpmattr);
	free(xpmattr);				/* cleanup task */
	if ( res != XpmSuccess ) {
		fprintf(stderr,"Failed to save snapshot %s\n",name);
		return (OSD_NOT_OK);
	} else {
		fprintf(stderr,"Saved snapshot as %s\n",name);
		/* wait until key released */
		while( osd_key_pressed(OSD_KEY_F12) );
		return (OSD_OK);
	}
#else
	fprintf(stderr,"Sorry: XPM library not included. Cannot make snapshot\n");
	return (OSD_NOT_OK);
#endif
}

#endif /* ndef svaglib */

struct osd_bitmap *osd_create_bitmap (int width, int height)
{
    struct osd_bitmap  	*my_bitmap;
    int 		i;
    unsigned char  	*bm;
    if (Machine->orientation & ORIENTATION_SWAP_XY) {
	i=width;
	width=height;
	height=i;
    }
    if ((my_bitmap = (struct osd_bitmap *)malloc (sizeof (struct osd_bitmap) + (height) * sizeof (byte *))) != NULL) {
        my_bitmap->width = width;
        my_bitmap->height = height;

        if ((bm = (unsigned char *)malloc (width * height * sizeof(unsigned char) + 1)) == NULL) {
            free (my_bitmap);
            return (NULL);
        }
        for (i = 0;i < height;i++) { my_bitmap->line[i] = &bm[i * width]; }

        my_bitmap->_private = bm;
    }
    return (my_bitmap);
}

void osd_free_bitmap (struct osd_bitmap *bitmap)
{
	if (bitmap) {
		free (bitmap->_private);
		free (bitmap);
		bitmap = NULL;
	}
}

void osd_clearbitmap(struct osd_bitmap *bitmap)
{
        int i;
        for (i = 0;i < bitmap->height;i++)
#ifdef svgalib
                memset(bitmap->line[i],0,bitmap->width);
#else 
                memset(bitmap->line[i],black_pen,bitmap->width);
	XClearWindow(display,window);
#endif
}

#ifndef svgalib
/*
 * Create a display screen, or window, large enough to accomodate a bitmap
 * of the given dimensions. I don't do any test here (640x480 will just do
 * for now) but one could e.g. open a window of the exact dimensions
 * provided. Return 0 if the display was set up successfully, nonzero
 * otherwise.
 *
 * Added: let osd_create_display allocate the actual display buffer. This
 * seems a bit dirty, but is more or less essential for X implementations
 * to avoid a lengthy memcpy().
 */

/* following routine traps missused MIT-SHM if not available */
int test_mit_shm(Display *display, XErrorEvent *error) {
	char msg[256];
	unsigned char ret=error->error_code;
	XGetErrorText(display,ret,msg,256);
	/* if MIT-SHM request failed, note and continue */
	if (error->error_code == BadAccess ) { mit_shm_avail=0; return 0; }
	/* else unspected error code: notify and exit */
	fprintf(stderr,"Unspected X Error %d: %s\n",ret,msg );
	exit(1);
	return 0; /* DCC blames... */
}


struct osd_bitmap *osd_create_display (int width, int height,int totalcolors,
	const unsigned char *palette,unsigned char *pens,int attributes)
{
	int 		 myscreen;
	XEvent		 event;
  	XSizeHints 	 hints;
  	XWMHints 	 wm_hints;
	Status		 result;
	int		 xsize,ysize;
	int              i,j,k;
	extern char 	*title;
	xpixel		= (unsigned long *) NULL;
	scaling	= ( (heightscale+widthscale) > 2 );
	/* Allocate the bitmap and set the image width and height. */
	if (! (bitmap=osd_create_bitmap(width,height)) ) return (NULL);
	if (Machine->orientation & ORIENTATION_SWAP_XY) {
	    xsize		= height * widthscale;
	    ysize		= width * heightscale;
	}else {
	    xsize		= width * widthscale;
	    ysize		= height * heightscale;
	}

	/* Open the display. */

	display = XOpenDisplay (displayname);
  	if(!display) {
  		fprintf (stderr,"OSD ERROR: failed to open the display.\n");
  		return (NULL);
  	}

  	screen 	 = DefaultScreenOfDisplay (display);
	myscreen = DefaultScreen(display);
	gc	 = DefaultGCOfScreen (screen);
	cursor   = XCreateFontCursor(display,XC_trek);
	if(use_trakball) {
	    trak_display_width = DisplayWidth(display,XDefaultScreen(display)) / 2;
	    trak_display_height = DisplayHeight(display,XDefaultScreen(display)) / 2;
	}

	/* test for available 8bit bitmaps resources */
	/* if not 8bit pseudocolor found, try to get any supported True color */
	/* set update display func properly */
	result 	 = XMatchVisualInfo(display,myscreen,8,PseudoColor,&myvisual);
	if ( ! result || force_truecolor ) {
	    force_truecolor=1;
	    fprintf(stderr,"8bit depth PseudoColor X-Visual not available :-( \n");
	    /* fprintf(stderr,"Force scaling to perform double buffering\n"); */
	    scaling=1;
	    /* test for a 8bpp environment */
	    result = XMatchVisualInfo(display,myscreen,8,TrueColor,&myvisual);
	    if (result) { fprintf(stderr,"Using 8bpp TrueColor X-Visual Resource\n"); goto sigue;}
	    /* test for a 16bpp environment */
	    result = XMatchVisualInfo(display,myscreen,16,TrueColor,&myvisual);
	    if (result) { fprintf(stderr,"Using 16bpp TrueColor X-Visual Resource\n"); goto sigue;}
	    /* test for a 24bpp environment */
	    result = XMatchVisualInfo(display,myscreen,24,TrueColor,&myvisual);
	    if (result) { fprintf(stderr,"Using 24bpp TrueColor X-Visual Resource\n"); goto sigue;}
	    /* test for a 32bpp environment */
	    result = XMatchVisualInfo(display,myscreen,32,TrueColor,&myvisual);
	    if (result) { fprintf(stderr,"Using 32bpp TrueColor X-Visual Resource\n"); goto sigue;}
	    /*if arrives here means an error :-) */
	    fprintf(stderr,"Cannot find any supported X-Visual resource\n");
	    return (NULL);
	} else fprintf(stderr,"Using 8bpp PseudoColor Visual. Good!\n");

sigue:  /* sorry, sorry, sorry, ........... */

	/* look for available Mitshm extensions */
	if (mit_shm_avail != -1 ) {
		mit_shm_avail	= 0;
#ifdef USE_MITSHM
	    /* get XExtensions to be if mit shared memory is available */
	    result 	= XQueryExtension(display,"MIT-SHM",&i,&j,&k);
	    if ( ! result) fprintf(stderr,"X-Server Doesn't support MIT-SHM extension\n");
	    else 	       mit_shm_avail = 1;
#endif
	} else mit_shm_avail=0; /* has been user-disabled */

	/* Create the window. No buttons, no fancy stuff. */
  	window = XCreateSimpleWindow (display, 
			RootWindowOfScreen (screen), 
			0, 
			0,
			xsize,
  		    	ysize, 
		  	0, 
			WhitePixelOfScreen(screen), 
			BlackPixelOfScreen(screen)
			);
  	if (!window) {
  		fprintf(stderr,"OSD ERROR: failed in XCreateSimpleWindow().\n");
  		return (NULL);
	}
	/* now get a color map structure */
	if ( force_truecolor && use_private_cmap ){
	    fprintf(stderr,"Private ColorMap use disabled in TrueColor mode\n");
	    use_private_cmap=0;
	}
	if ( ! use_private_cmap ) colormap = DefaultColormapOfScreen(screen);
	else {
	    colormap = XCreateColormap(display,window,myvisual.visual,AllocNone);
	    XSetWindowColormap(display,window,colormap);
	    fprintf(stderr,"Using private color map\n");
	}

	/*  Placement hints etc. */

	hints.flags	= PSize | PMinSize | PMaxSize;
 	hints.min_width	= hints.max_width = hints.base_width = xsize;
 	hints.min_height= hints.max_height = hints.base_height = ysize;

	wm_hints.input	= TRUE;
	wm_hints.flags	= InputHint;

	XSetWMHints 		(display, window, &wm_hints);
	XSetWMNormalHints 	(display, window, &hints);
	XStoreName 		(display, window, title);

	XDefineCursor(display,window,cursor);

#ifdef X11_JOYSTICK
	if(use_joystick) x11_joystick_init(); /* in devices.c */
#endif
	/* now initialize color tables */
	osd_init_pen(totalcolors,palette,pens);
	/* Map and expose the window. */
	if( use_mouse || use_trakball) {
	    /* grabb the pointer and query MotionNotify events */
	    XSelectInput(display, 
			 window, 
			 FocusChangeMask   | ExposureMask | 
			 KeyPressMask      | KeyReleaseMask | 
			 EnterWindowMask   | LeaveWindowMask |
			 PointerMotionMask | ButtonMotionMask |
			 ButtonPressMask   | ButtonReleaseMask
			);
	    XGrabPointer(display,
			 window, /* RootWindow(display,DefaultScreen(display)), */
			 False,
			 PointerMotionMask | ButtonMotionMask |
			 ButtonPressMask   | ButtonReleaseMask | 
			 EnterWindowMask   | LeaveWindowMask ,
			 GrabModeAsync, GrabModeAsync,
			 None, cursor, CurrentTime );
	} else {
	    XSelectInput(display, 
			 window, 
			 FocusChangeMask | ExposureMask | 
			 KeyPressMask | KeyReleaseMask
			 );
	}
	XMapRaised     (display, window);
	XClearWindow   (display, window);
	XAutoRepeatOff (display);  /* should be a command line option */
	XWindowEvent   (display, window, ExposureMask, &event);

#ifdef USE_MITSHM
	if ( mit_shm_avail ) {
	    /* Create a MITSHM image. */

	    XSetErrorHandler( test_mit_shm );

	    /* CS: scaling changes requested image size */
	    image = XShmCreateImage (display, 
				myvisual.visual ,
				myvisual.depth,
       			    	ZPixmap, 
				NULL, 
				&shm_info, 
				xsize, 
				ysize);
  	    if (!image) {
  		fprintf (stderr,"OSD ERROR: failed in XShmCreateImage().\n");
		mit_shm_avail=0;
		goto mit_shm_failed;
	    }
	    shm_info.shmid = shmget ( IPC_PRIVATE, 
				      image->bytes_per_line * image->height, 
				      (IPC_CREAT | 0777) );
	    if ( shm_info.shmid < 0) {
		    fprintf (stderr,"OSD ERROR: failed to create MITSHM block.\n");
		    return (NULL);
	    }

	    /* And allocate the bitmap buffer. */
            /* new pen color code force double buffering in every cases */
  	    scaled_buffer_ptr = (byte *)(image->data = shm_info.shmaddr = 
			(char *) shmat ( shm_info.shmid,0 ,0));
  	    buffer_ptr = (byte *)bitmap->_private; 

  	    if (!buffer_ptr || !scaled_buffer_ptr) {
    	    	    fprintf (stderr,"OSD ERROR: failed to allocate MITSHM bitmap buffer.\n");
    		    return (NULL);
  	    }

	    shm_info.readOnly = FALSE;

	    /* Attach the MITSHM block. this will cause an exception if */
	    /* MIT-SHM is not available. so trap it and process         */

	    fprintf(stderr,"MIT-SHM Extension Available. trying to use...");

	    if(!XShmAttach (display, &shm_info)) {
  		    fprintf (stderr,"OSD ERROR: failed to attach MITSHM block.\n");
  		    return (NULL);
	    }
	    XSync(display,False); /* be sure to get request processed */
	    sleep(2); /* enought time to notify error if any */
#ifdef USE_TIMER
	    /* agh!! sleep() disables timer alarm. have to re-arm */
	    if (play_sound) start_timer();
#endif
	    XSetErrorHandler( None ); /* Restore error handler to default */
	    if ( ! mit_shm_avail ) {
		fprintf (stderr," failed.\nReverting to normal XPutImage() mode\n");
		if (scaling) { shmdt((char *)scaled_buffer_ptr); free(buffer_ptr); }
		else 	     shmdt((char *)buffer_ptr);
		goto mit_shm_failed; /* AAAAAAAAAAAGGGGGGGGGGGHHHHHHHHH!!! */
	    } 
	    fprintf(stderr,"Success.\nUsing Shared Memory Features to speed up\n");

	} else { /* Not MITSHM Allocate a bitmap buffer. */
mit_shm_failed:  	/** AAGGGGGGHHHHH !!!! (again) */
#endif
  	    buffer_ptr = (byte *)bitmap->_private;
  	    scaled_buffer_ptr = (byte *) malloc ( 4 * xsize * ysize );
  	    if (!buffer_ptr || !scaled_buffer_ptr) {
    		fprintf (stderr,"OSD ERROR: failed to allocate bitmap buffer.\n");
    		return (NULL);
	    }
 	    /* CS: Ximage is allocated against our new image if scaling active */
  	    image = XCreateImage ( display, 
			myvisual.visual , 
			myvisual.depth, 
			ZPixmap, 
			0, 
			(char *) scaled_buffer_ptr, 
			xsize, ysize,
			(myvisual.depth==8)?8:32, 
			0);
  	    if (!image) {
    		fprintf (stderr,"OSD ERROR: could not create image.\n");
    		return (NULL);
  	    }
#ifdef USE_MITSHM
	}/* end of not MITSHM */
#endif
	/* call to routine to set update_display_func properly */
	if ( eval_update_display_func() == OSD_NOT_OK ) return (NULL); 
	/* 
	   and now clear screen to black. ( should be done by default, but
	   some stupid servers has BlackWindowOfScreen set to White 
	*/
	osd_clearbitmap(bitmap);
	return (bitmap);
}

/*
 * Shut down the display.
 */

void osd_close_display (void)
{
	int		i;
	unsigned long	l;

	if (display && window) {
		/* ungrab the pointer and clean trakball routines */
		sysdep_trakball_close();
#ifdef USE_MITSHM
		if (mit_shm_avail) {
        	    XShmDetach (display, &shm_info);	/* Detach the SHM. */
      		    if (shm_info.shmaddr) shmdt (shm_info.shmaddr);
      		    if (shm_info.shmid >= 0) shmctl (shm_info.shmid, IPC_RMID, 0);
		} else {
#endif
		/* Memory will be deallocated shortly (== buffer_ptr). */
#ifdef USE_MITSHM
		}
#endif

		/* Destroy the image and free the colors. */
		if (image) {
    			XDestroyImage (image);
			/* CS: scaling hack means scaled_buffer_ptr is auto-freed, so... */
   			if (scaling) free(buffer_ptr);
   		}
    		for (i = 0; i < MAX_PENS; i++) {
			if (xpixel[i] != BlackPixelOfScreen(screen) ) {
				l = (unsigned long) xpixel[i];
      				XFreeColors (display, colormap, &l, 1, 0);
       			}
  		}
		if (use_private_cmap) XFreeColormap(display,colormap);
  		if (display) {
  			XAutoRepeatOn (display);
  			XFlush (display); /* send all events to sync; */
  			XCloseDisplay (display);
  		}
	}
	if (xpixel) {
		free (xpixel);
		xpixel = NULL;
	}

}

/*
 * Set the screen colors using the given palette.
 *
 */

int osd_init_pen(int totalcolors,const unsigned char *palette, unsigned char *pens) {
	XColor color;
	int i,j;
	/* by default, black pen is set to zero */
	black_pen=0;
	/* initialize pixel array */
	if ((xpixel = (unsigned long *) malloc (sizeof (unsigned long) * MAX_PENS)) == NULL) {
		fprintf (stderr,"OSD ERROR: failed to allocate pixel index table.\n");
		return (OSD_NOT_OK);
	    }
       /* now allocate pallete color */
       xpixel[0] = BlackPixelOfScreen(screen) ;
       for(i=0;i<totalcolors;i++) pens[i]=0;
       if (totalcolors>256) {
           fprintf(stderr, "Warning: More than 256 colors (%d) are needed for this emulation\n", totalcolors);
           totalcolors=256;
       }
       if (totalcolors==256) j=0; else j=1;
       /* and allocate color cells */ 
       for (i=0; i < totalcolors; i++) {
	  xpixel[i+j] = BlackPixelOfScreen(screen) ;
          color.flags = (DoRed | DoGreen | DoBlue);
	  color.pixel = i+j;
	  color.red   = palette[3*i]   << 8; 
	  color.green = palette[3*i+1] << 8; 
	  color.blue  = palette[3*i+2] << 8; 
	  if (XAllocColor (display,colormap,&color)) xpixel[i+j] = color.pixel;
          pens[i] = i+j;
       }
       for (i=0; i < totalcolors; i++) {
	  if ( xpixel[i+j]==BlackPixelOfScreen(screen) ) { 
		black_pen=i; 
		/* fprintf(stderr,"Black color assigned to pen %d\n",i); */
		return OSD_OK; 
	  }
       }
       fprintf(stderr,"Warning: black color doesn't match any pen\n");
       return (OSD_OK);
}

void osd_modify_pen(int pen, unsigned char red,unsigned char green,unsigned char blue) 
{
	XColor		color;
	/* free previously allocated color */
	XFreeColors (display, colormap, &xpixel[pen], 1, 0);
	/* Translate VGA 0-63 values of new color to X 0-65536 values. */
	color.flags	= (DoRed | DoGreen | DoBlue);
	color.red	= 256 * (int) red;
	color.green	= 256 * (int) green;
	color.blue	= 256 * (int) blue;
	/* allocate new color and assign it to pen index */
	if (XAllocColor (display,colormap,&color)) xpixel[pen] = color.pixel;
	return;
}

void osd_get_pen(int pen, unsigned char *red,unsigned char *green,unsigned char *blue)
{
	XColor		color;
	/* query pen index and set colors aproppiately */
	color.pixel=xpixel[pen];
	XQueryColor(display,colormap,&color);
	*red   = color.red  >> 8;
	*green = color.green >> 8;
	*blue  = color.blue >> 8;
	return;
}

#endif /* ndef svgalib */

#define MAXPIXELS 100000
unsigned char * pixel[MAXPIXELS];
int p_index=-1;

INLINE void osd_draw_pixel (int x, int y, int col)
{
	unsigned char *address;


	if (x<0 || x >= bitmap->width)
		return;
	if (y<0 || y >= bitmap->height)
		return;
	address=&(bitmap->line[y][x]);
	*address=(unsigned char)col;
	if (p_index<MAXPIXELS-1) {
		p_index++;
		pixel[p_index]=address;
	}
}

extern int vector_updates;

int osd_update_vectors (int *x_res, int *y_res, int step)
{
	int i;
	unsigned char bg;

	if (Machine->orientation & ORIENTATION_SWAP_XY)
	{
		*y_res=bitmap->width;
		*x_res=bitmap->height;
	}
	else
	{
		*x_res=bitmap->width;
		*y_res=bitmap->height;
	}

	/* Clear the old bitmap. Delete pixel for pixel, this is
           faster than memset. */
	bg=Machine->pens[0];
	for (i=p_index; i>=0; i--)
	{
		*(pixel[i])=bg;
	}
	p_index=-1;

	return 0;
}

void osd_draw_to (int x2, int y2, int col)
{
	int orientation;
	int dx,dy,cx,cy,sx,sy;
	static int x1,y1;

#if 0
	if (errorlog)
		fprintf(errorlog,
		"line:%d,%d nach %d,%d color %d\n",
		 x1,y1,x2,y2,col);
#endif

	orientation = Machine->orientation;

	if (orientation != ORIENTATION_DEFAULT)
	{
		if (orientation & ORIENTATION_SWAP_XY)
		{
			int temp;
			temp = x2;
			x2 = y2;
			y2 = temp;
		}
		if (orientation & ORIENTATION_FLIP_X)
			x2 = bitmap->width-1-x2;
		if (orientation & ORIENTATION_FLIP_Y)
			y2 = bitmap->height-1-y2;
	}

	if (col<0)
	{
		x1=x2;
		y1=y2;
		return;
	} else
		col=Machine->gfx[0]->colortable[col];


	dx=abs(x1-x2);
	dy=abs(y1-y2);

	sx = ((x1 <= x2) ? 1 : -1);
	sy = ((y1 <= y2) ? 1 : -1);
	cx=dx/2;
	cy=dy/2;

	if (dx>=dy)
	{
		for (;;)
		{
			osd_draw_pixel(x1,y1,col);
/*			if (use_anti_alias)
				osd_draw_pixel(x1,y1+1,col); */
			if (x1 == x2) break;
			x1+=sx;
			cx-=dy;
			if (cx < 0)
			{
				y1+=sy;
				cx+=dx;
			}
		 }
	}
	else
	{
		for (;;)
		{
			osd_draw_pixel(x1,y1,col);
/*			if (use_anti_alias)
				osd_draw_pixel(x1+1,y1,col); */
			if (y1 == y2) break;
			y1+=sy;
			cy-=dx;
			if (cy < 0)
			{
				x1+=sx;
				cy+=dy;
			}
		}
	}
}
