#include "xmame.h"

#define OPT_INT 0
#define OPT_STR 1

struct _cmdline_opts {
	char *optname; 		/* option name */
	int type; 		/* OPT_INTEGER OPT_STRING */
	int more_args; 		/* 0 or number of args */
	void *pointer;		/* address of involving variable */
	char *defvalue;		/* dirty trick to store integer or char */
	int min;		/* min value if integer */
	int max;		/* max value if string */
	int malloc_size;	/* need to allocate space for char * */
	void (*special)(int argc,char *argv[]); /* if special handling needed */
};

struct _cmdline_opts config_opts[] = {
 { "play_sound",OPT_INT,1,(void *)&play_sound, (char *)0, 0, 1, 0, 0 },
 { "dontuse_fm_synth",OPT_INT,1,(void *)&No_FM, (char *)1, 0, 1, 0, 0 },
 { "use_mouse",OPT_INT,1,(void *)&use_mouse, (char *)0, 0, 1, 0, 0 },
 { "use_joystick",OPT_INT,1,(void *)&use_joystick, (char *)0, 0, 1, 0, 0 },
 { "swap_joyaxis",OPT_INT,1,(void *)&swapjoyaxis, (char *)0, 0, 1, 0, 0 },
 { "use_trakball",OPT_INT,1,(void *)&use_trakball, (char *)0, 0, 1, 0, 0 },
 { "frameskip",OPT_INT,1,(void *)&frameskip, (char *)0, 0, 3, 0, 0 },
 { "joyfilter",OPT_INT,1,(void *)&joyfilter, (char *)5, 1, 100, 0, 0 },
 { "widthscale",OPT_INT,1,(void *)&widthscale, (char *)1, 1, 5, 0, 0 },
 { "heightscale",OPT_INT,1,(void *)&heightscale, (char *)1, 1, 5, 0, 0 },
 { "force_truecolor",OPT_INT,1,(void *)&force_truecolor, (char *)0, 0, 1, 0, 0},
 { "use_xsync",OPT_INT,1,(void *)&use_xsync, (char *)1, 0, 1, 0, 0 },
 { "private_cmap",OPT_INT,1,(void *)&use_private_cmap, (char *)1, 0, 1, 0, 0 },
 { "use_mitshm",OPT_INT,1,(void *)&mit_shm_avail, (char *)-1, -1, 1, 0, 0 },
 { "towns_pad_name",OPT_STR,1,(void *)&towns_pad_dev,"/dev/pad00", 0, 1,80, 0 },
 { "default_game",OPT_STR,1,(void *)&mamedir, "pacman", 0, 1, 80, 0 },
 { "x11joyname",OPT_STR,1,(void *)&x11joyname, "Joystick", 0, 1, 80, 0 },
 { "mamedir",OPT_STR,1,(void *)&mamedir, "/usr/games/mame/lib", 0, 1, 80, 0 },
 { "audiodevice",OPT_STR,1,(void *)&audiodevice, "/dev/dsp", 0, 1, 80, 0 },
 { "display",OPT_STR,1,(void *)&audiodevice, ":0.0", 0, 1, 80, 0 },
 { "mapkey",OPT_STR,1,(void *)0, (char *)0, 0, 1, 0, do_mapkey },
 { "samplefreq",OPT_INT,1,(void *)&audio_sample_freq,(char *)22050,1,88200,0,0},
 { "timerfreq",OPT_INT,1,(void *)&audio_timer_freq, (char *)50, 1, 100, 0, 0 },
 { "videomode",OPT_INT,1,(void *)&video_mode, (char *)0, 0, 3, 0, 0 },
 { ""          , OPT_INT, 0, (void *)0,           (char *)0, 0, 0, 0, 0 }
};

/*
 * check for existence of ${HOME}/xmame/xmamerc
 * if found parse it, else try global MAMERC #defined file
 */
int parse_xmamerc_file()
{
	int i;
        struct passwd   *pw;
        FILE            *file;
        int             lineno;
        char            buffer[2048];

        /* locate user's home directory */
        pw=getpwuid(getuid());
        if(!pw) { 
                fprintf(stderr,"Who are you? Not found in passwd database!!\n");
                return (OSD_NOT_OK);
        }
        sprintf(buffer,"%s/xmame/xmamerc",pw->pw_dir);
        /* try to open file. If so parse it */
        if ( (file=fopen(buffer,"r")) == (FILE *) NULL) {
            fprintf(stderr,"File %s not found.\n",buffer);
            /* No user config found - trying global file */
            strcpy(buffer, MAMERC );
            if ( (file=fopen(buffer,"r")) == (FILE *) NULL) {
               fprintf(stderr,"File %s not found. Skipping ...\n",buffer);
               return (OSD_OK);
            }
        }
        lineno=0;
        while(fgets( buffer,2047,file) ) {
            char *p;
            char *(q[5]);
            int i,j;
            lineno++;
            /* skip comments */
            if ( ( p=strchr(buffer,'#') ) ) *p='\0';
            /* scan for words */
            for(i=0;i<5;i++) q[i]=(char *)NULL;
            for(i=0,j=0,p=buffer; *p; p++ ) {
                if ( isspace(*p) ) { *p='\0'; j=0; }
                else               { if(!j++) q[i++]=p; }
            }   /* end of stripping words ( for i=0 )*/
            /* test for wrong number of args */
            if ( i==0 ) continue; /* empty line */
            if ( i!=2 ) { 
                fprintf(stderr,"Line %d: wrong number of parameters \n",lineno);
                fclose(file);
                return (OSD_NOT_OK);
            }
	    /* and now parse command line parameters */
	    for(i=0; config_opts[i].optname[0]; i++) {
		int tmp;
		if (strcasecmp(q[0],config_opts[i].optname) continue;
		swtch(config_opts[i].type) {
		    /* integer related variable */
		    case OPT_INT:
			if (! config_opts[i].more_args) {
			    /* no need more args: just simply set to default */
			    ( * (int *)config_opts[i].pointer) = (int)config_opts[i].defvalue;
			} else {
			    /* get arg, test and if ok set to it */
			    tmp=atoi(q[1]);
			    if ( (tmp<config_opts[i].min) || 
			         (tmp>config_opts[i].max) ) {
				fprintf(stderr,"Line %d: Invalid value for %s\n",lineno,q[0]);
				fclose(file);
				return (OSD_NOT_OK);
			    } else ( *(int *)config_opts[i].pointer) = (int)config_opts[i].defvalue;
			}
		    case OPT_STR:
		    /* string related variable */
		}
	    }
	    if ( ! config_opts[i].optname[0] ) {
                /* if arrives here means unrecognized command line */
                fprintf(stderr,"Line %d: unknown command %s\n",lineno,q[0]);
                fclose(file);
                return (OSD_NOT_OK);
	    }
        } /* while */
        fclose(file);
        return (OSD_OK);
}


