#!/bin/sh

# Fix permissions of Quake2 files
#
# You should run this as root

# main setuid quake2 binary
# if you are only using dedicated server, quake2 does NOT need to be setuid
chown root quake2 || (echo "Unable to change owner of quake2 to root"; exit 1)
chmod 4711 quake2 || (echo "Unable to change modes of quake2 to 4711"; exit 1)

# ref_soft and ref_gl renderers
# must be owned by root and only r/w by root, another other perms is a
# security violation
chown root ref_soft.so || (echo "Unable to change owner of ref_soft.so to root"; exit 1)
chmod 755 ref_soft.so || (echo "Unable to change modes of ref_soft.so to 755"; exit 1)
chown root ref_gl.so || (echo "Unable to change owner of ref_gl.so to root"; exit 1)
chmod 755 ref_gl.so || (echo "Unable to change modes of ref_gl.so to 755"; exit 1)

# ref_softx requires no special permissions, just make it read/execute
chown root ref_softx.so || (echo "Unable to change owner of ref_softx.so to root"; exit 1)
chmod 755 ref_softx.so || (echo "Unable to change modes of ref_softx.so to 755"; exit 1)

# gamei386.so in baseq2 doens't require perms either, we don't touch it here
# but it must be read/execute by user running quake2 binary
# root is given up before loading the game library, even in dedicated mode
